/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.entryimport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class EntryImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log logger = LogFactory.getLog(EntryImportPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnresetfile", "download", "btn_upload"});
        Image fileLabel = (Image)this.getControl("btnupload");
        fileLabel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"filepanel"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "download": {
                this.showDownloadForm();
                break;
            }
            case "btnresetfile": {
                this.deleteUploadFile();
                break;
            }
            case "btn_upload": {
                this.uploadAndReturnData();
            }
        }
    }

    private void parseExcel(UploadEvent evt, final List<Map<String, String>> returnData, final List<Integer> dataIndexes, final StringBuffer errorInfo) throws Exception {
        String url = (String)evt.getUrls()[0];
        final HashMap title = new HashMap();
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream inputStream = service.getInputStream(url);
        final ArrayList mustInputIndexes = new ArrayList();
        final String billEntryId = (String)this.getView().getFormShowParameter().getCustomParam("BillEntryId");
        final String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        new ExcelReader().read(inputStream, new SheetHandler(){

            public void handleRow(SheetHandler.ParsedRow row) {
                if (row.getRowNum() == 0) {
                    if (row.isEmpty() || !row.get(Integer.valueOf(0)).equalsIgnoreCase(billEntryId) && !row.get(Integer.valueOf(0)).split(" # ")[1].equalsIgnoreCase(billEntryId) && !row.get(Integer.valueOf(0)).split(" # ")[1].equals(billFormId) && !row.get(Integer.valueOf(1)).split(" # ")[1].equalsIgnoreCase(billEntryId)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u683c\u5f0f\u9519\u8bef, \u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"EntryImportPlugin_0", (String)"tmc-fl-formplugin", (Object[])new Object[0]));
                    }
                } else if (row.getRowNum() == 2) {
                    Map rowTitle = row.getData();
                    rowTitle.forEach((index, titleName) -> {
                        if (titleName.startsWith("*")) {
                            mustInputIndexes.add(index);
                        }
                        String titleStr = titleName;
                        if (titleName.contains(" # ")) {
                            titleStr = titleName.split(" # ")[1];
                        }
                        title.put(index, titleStr);
                    });
                } else if (row.getRowNum() > 1 && !row.isEmpty() && row.getRowNum() != 3) {
                    dataIndexes.add(row.getRowNum());
                    for (Integer index2 : mustInputIndexes) {
                        if (row.get(index2) != null && !"".equals(row.get(index2))) continue;
                        String entryImport_02 = String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u586b\u5199, \u8bf7\u8865\u5145\u5b8c\u6574\u3002 \n", (String)"EntryImportPlugin_1", (String)"tmc-fl-formplugin", (Object[])new Object[0]), row.getRowNum() + 1);
                        errorInfo.append(entryImport_02);
                        break;
                    }
                    HashMap dataRow = new HashMap();
                    dataRow.put("excelrow", row.getRowNum() + 1 + "");
                    if (title.size() > 0) {
                        for (Map.Entry entry : title.entrySet()) {
                            dataRow.put(entry.getValue(), row.get((Integer)entry.getKey()));
                        }
                        returnData.add(dataRow);
                    }
                }
            }
        });
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        ArrayList<Integer> dataIndexes = new ArrayList<Integer>();
        StringBuffer errorInfo = new StringBuffer();
        ArrayList<Map<String, String>> returnData = new ArrayList<Map<String, String>>();
        String url = (String)evt.getUrls()[0];
        try {
            this.parseExcel(evt, returnData, dataIndexes, errorInfo);
            if (returnData.size() < 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", (String)"EntryImportPlugin_2", (String)"tmc-fl-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
                return;
            }
            for (int i = dataIndexes.size() - 1; i > 0; --i) {
                if ((Integer)dataIndexes.get(i) - (Integer)dataIndexes.get(i - 1) > 1) continue;
                dataIndexes.remove(i);
            }
            if (dataIndexes.size() >= 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u4e3a\u7a7a\u7684\u6570\u636e\u884c, \u8bf7\u5220\u9664\u540e\u518d\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"EntryImportPlugin_3", (String)"tmc-fl-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u6709\u8bef, \u8bf7\u68c0\u67e5\u3002", (String)"EntryImportPlugin_4", (String)"tmc-fl-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            logger.error("EntryImport >>> " + e.getMessage());
            return;
        }
        if (errorInfo.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u6709\u8bef, \u8bf7\u68c0\u67e5\u3002", (String)"EntryImportPlugin_4", (String)"tmc-fl-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filepanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadpanel"});
            this.getModel().setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            this.getModel().setValue("filepath", (Object)url);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_upload"});
            String dataStr = SerializationUtils.toJsonString(returnData);
            this.getPageCache().put("rowDatas", dataStr);
            logger.info("EntryImport >> " + dataStr);
        }
    }

    private void showDownloadForm() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("BillFormId");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_downloadtemplate");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("BillFormId", (Object)billFormId);
        showParameter.setCustomParam("TemplateType", (Object)"IMPT");
        this.getView().showForm(showParameter);
    }

    private void deleteUploadFile() {
        this.getModel().setValue("filename", (Object)"");
        this.getModel().setValue("filepath", (Object)"");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"filepanel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"uploadpanel"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
    }

    private void uploadAndReturnData() {
        String dataStr = this.getPageCache().get("rowDatas");
        List rowDatas = (List)SerializationUtils.fromJsonString((String)dataStr, List.class);
        Object importMethod = this.getModel().getValue("imptmethod");
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("imptmethod", importMethod);
        returnData.put("rowDatas", rowDatas);
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
        this.getView().close();
    }
}

