/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.rentpay;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;

public class RentPayBillEdit
extends AbstractBillPlugIn {
    private final String[] FIELDS_PLAN = new String[]{"paydate", "startrevdate", "endrevdate", "rentamt", "principal", "intamt", "taxrate", "taxamt", "excludetaxamt", "residueamt", "payacct", "notes", "executestatus"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.loadPayPlan(this.loadRentPlans());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initRentPayPlan();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("save")) {
            // empty if block
        }
    }

    private void initRentPayPlan() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject contractBill = (DynamicObject)model.getValue("loancontractbill");
        if (null == contractBill) {
            return;
        }
        DynamicObjectCollection rentPlans = this.loadRentPlans();
        if (!TmcDataServiceHelper.isFromDatabase((DynamicObject)this.getModel().getDataEntity())) {
            this.setPayInfo(rentPlans);
            this.shareAmtInPro("amount", "e_repayamount");
            this.setInstCalc(contractBill);
            this.shareAmtInPro("instamt", "e_actintamt");
        }
        BigDecimal rentAmt = contractBill.getBigDecimal("totalamt");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"rentamt", (Object)rentAmt);
        this.loadPayPlan(rentPlans);
        this.getModel().setDataChanged(false);
    }

    private void loadPayPlan(DynamicObjectCollection rentPlans) {
        if (null == rentPlans) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entry_rentplan");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry_rentplan");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        for (int rowIndex = 0; rowIndex < rentPlans.size(); ++rowIndex) {
            DynamicObject rentPlan = (DynamicObject)rentPlans.get(rowIndex);
            model.createNewEntryRow("entry_rentplan");
            for (String field : this.FIELDS_PLAN) {
                if (StringUtils.equals((CharSequence)field, (CharSequence)"rentamt")) {
                    model.setValue("e_rentamt", (Object)rentPlan.getBigDecimal("rentamt"), rowIndex);
                    continue;
                }
                model.setValue(field, rentPlan.get(field), rowIndex);
            }
            if (null == bizDate || bizDate.compareTo(rentPlan.getDate("paydate")) != 0) continue;
            entryGrid.setRowBackcolor("#fcf0c7", new int[]{rowIndex});
        }
        model.batchCreateNewEntryRow("entry_rentplan", vs);
        this.getView().updateView("entry_rentplan");
    }

    private void setPayInfo(DynamicObjectCollection rentPlans) {
        if (null == rentPlans) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Optional<DynamicObject> firstPlan = rentPlans.stream().filter(v -> ExecuteStatusEnum.isUnExecuted((String)v.getString("executestatus"))).findFirst();
        if (firstPlan.isPresent()) {
            DynamicObject rentPlan = firstPlan.get();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"bizdate", (Object)rentPlan.getDate("paydate"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"amount", (Object)rentPlan.getBigDecimal("principal"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"totalamt", (Object)rentPlan.getBigDecimal("rentamt"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"instamt", (Object)rentPlan.getBigDecimal("intamt"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"accountbank", (Object)rentPlan.get("payacct"));
        }
    }

    private void setInstCalc(DynamicObject contractBill) {
        DynamicObject contract = QueryServiceHelper.queryOne((String)"fl_leasecontractbill", (String)"startinterestrate", (QFilter[])new QFilter("ID", "=", contractBill.getPkValue()).toArray());
        BigDecimal startInstRate = contract.getBigDecimal("startinterestrate");
        String isPayInst = EmptyUtil.isEmpty((BigDecimal)startInstRate) ? "0" : "1";
        int rowCount = this.getModel().getEntryRowCount("loans");
        for (int i = 0; i < rowCount; ++i) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_ispayinst", (Object)isPayInst, (int)i);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_combineinst", (Object)isPayInst, (int)i);
        }
    }

    private void shareAmtInPro(String amountField, String shareField) {
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        BigDecimal rePayAbleAmt = loans.stream().map(v -> v.getBigDecimal("e_repayableamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue(amountField);
        int rowCount = this.getModel().getEntryRowCount("loans");
        BigDecimal sharedAmt = BigDecimal.ZERO;
        for (int rowIndex = 0; rowIndex < rowCount - 1; ++rowIndex) {
            BigDecimal payAmt = (BigDecimal)this.getModel().getValue("e_repayableamount", rowIndex);
            BigDecimal shareAmt = payAmt.multiply(totalAmt).divide(rePayAbleAmt, totalAmt.scale(), RoundingMode.HALF_UP);
            this.getModel().setValue(shareField, (Object)shareAmt, rowIndex);
            sharedAmt = sharedAmt.add(shareAmt);
        }
        this.getModel().setValue(shareField, (Object)totalAmt.subtract(sharedAmt), rowCount - 1);
    }

    private DynamicObjectCollection loadRentPlans() {
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (null == contractBill) {
            return null;
        }
        QFilter filter = new QFilter("ID", "=", contractBill.getPkValue());
        String queryFields = Arrays.stream(this.FIELDS_PLAN).map(v -> String.format("%s.%s as %s", "entry_rentplan", v, v)).collect(Collectors.joining(","));
        DynamicObjectCollection rentPlans = QueryServiceHelper.query((String)"fl_leasecontractbill", (String)queryFields, (QFilter[])filter.toArray());
        rentPlans.sort(Comparator.comparing(r -> r.getDate("paydate")));
        return rentPlans;
    }
}

