/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.rentplan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;
import kd.tmc.fl.formplugin.resource.FlFormResourceEnum;
import org.apache.commons.lang3.tuple.Pair;

public class RentPlanBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String[] PLAN_FIELDS = new String[]{"contract", "paydate", "startrevdate", "endrevdate", "rentamt", "principal", "intamt", "taxrate", "taxamt", "payacct", "notes"};
    private static final String[] INST_FIELDS = new String[]{"intamt", "taxrate", "taxamt"};

    public void registerListener(EventObject e) {
        BasedataEdit payAcct;
        super.registerListener(e);
        TextEdit contract = (TextEdit)this.getControl("contract");
        if (EmptyUtil.isNoEmpty((Object)contract)) {
            contract.addClickListener((ClickListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(payAcct = (BasedataEdit)this.getControl("payacct")))) {
            payAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initModelData();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"payacct")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (null == org) {
                this.getView().showTipNotification(FlFormResourceEnum.RentPlanBillEdit_19.loadKDString());
                evt.setCancel(true);
                return;
            }
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (null == currency) {
                this.getView().showTipNotification(FlFormResourceEnum.RentPlanBillEdit_20.loadKDString());
                evt.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("acctclassify", "=", (Object)"B");
            filter.and("acctstatus", "!=", (Object)"closed");
            filter.and(TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id")));
            filter.and(new QFilter("currency.fbasedataid.id", "=", currency.getPkValue()));
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey().toLowerCase();
        if (StringUtils.equals((CharSequence)"contract", (CharSequence)key)) {
            this.openContractBill();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (EmptyUtil.isNoEmpty((Object)e.getValue())) {
            switch (key) {
                case "startrevdate": {
                    this.validateStartRevDate(e);
                    break;
                }
                case "endrevdate": {
                    this.validateEndRevDate(e);
                    break;
                }
                case "principal": {
                    this.validatePrinciple(e);
                    break;
                }
                case "intamt": {
                    this.validateInstAmt(e);
                    break;
                }
                case "taxamt": {
                    this.validateTaxAmt(e);
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_rentplan");
        ChangeData[] valSet = e.getChangeSet();
        switch (propName) {
            case "rentamt": {
                for (ChangeData val : valSet) {
                    this.rentAmtChgEvt(val.getRowIndex());
                }
                break;
            }
            case "principal": {
                for (ChangeData val : valSet) {
                    this.calcInstAmt(val.getRowIndex());
                }
                break;
            }
            case "intamt": {
                for (ChangeData val : valSet) {
                    this.instAmtChgEvt(val.getRowIndex());
                }
                break;
            }
            case "taxrate": {
                for (ChangeData val : valSet) {
                    this.calcTaxAmt(val.getRowIndex());
                }
                break;
            }
            case "taxamt": {
                this.taxAmtChgEvt(rowIndex);
                break;
            }
            case "totalamt": {
                this.rebuildRentPlan();
                break;
            }
            case "startinterestrate": {
                this.setEnablePlan(true);
                break;
            }
            case "endrevdate": {
                this.endRevDateChgEvt();
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String propName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"entry_rentplan")) {
            this.calcTotalAmt();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if (StringUtils.equals((CharSequence)entryProp.getName(), (CharSequence)"entry_rentplan") && !this.getView().getFormShowParameter().getCustomParams().containsKey("openHistoryId")) {
            int[] rowIndexArr;
            for (int rowIndex : rowIndexArr = e.getRowIndexs()) {
                String executeStatus = (String)this.getModel().getValue("executestatus", rowIndex);
                if (!ExecuteStatusEnum.isExecuted((String)executeStatus)) continue;
                this.getView().showTipNotification(FlFormResourceEnum.RentPlanBillEdit_18.loadKDString());
                e.setCancel(true);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String propName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"entry_rentplan")) {
            if (EmptyUtil.isEmpty((String)this.getPageCache().get("importflag"))) {
                DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("accountbank");
                int rowCount = this.getModel().getEntryRowCount("entry_rentplan");
                this.getModel().setValue("payacct", (Object)bankAcct, rowCount - 1);
                if (rowCount > 1) {
                    int rowIndex = e.getInsertRow() == -1 ? rowCount - 1 : e.getInsertRow();
                    Date lastEndRevDate = (Date)this.getModel().getValue("endrevdate", rowIndex - 1);
                    Date startRevDate = EmptyUtil.isNoEmpty((Object)lastEndRevDate) ? DateUtils.getNextDay((Date)lastEndRevDate, (int)1) : null;
                    Date endDate = (Date)this.getModel().getValue("enddate");
                    if (null != startRevDate && startRevDate.compareTo(endDate) > 0) {
                        startRevDate = null;
                    }
                    this.getModel().setValue("startrevdate", (Object)startRevDate, rowIndex);
                    BigDecimal lastTaxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex - 1);
                    this.getModel().setValue("taxrate", (Object)lastTaxRate, rowIndex);
                    BigDecimal lastPrincipal = (BigDecimal)this.getModel().getValue("principal", rowIndex - 1);
                    this.getModel().setValue("principal", (Object)lastPrincipal, rowIndex);
                }
            } else {
                this.getPageCache().remove("importflag");
            }
            this.calcTotalAmt();
            this.setEnablePlan(false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("contract".equals(event.getActionId()) && EmptyUtil.isNoEmpty((Object)event.getReturnData())) {
            ListSelectedRow selectedRow = ((ListSelectedRowCollection)event.getReturnData()).get(0);
            ((IBillModel)this.getModel()).load(selectedRow.getPrimaryKeyValue());
            String billNo = selectedRow.getBillNo();
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"contract", (Object)billNo);
            this.setEnablePlan(false);
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.setEnablePlan(false);
    }

    private void initModelData() {
        this.setEnablePlan(false);
        String formId = this.getView().getFormShowParameter().getFormId();
        boolean fromDatabase = TmcDataServiceHelper.isFromDatabase((DynamicObject)this.getModel().getDataEntity());
        if (StringUtils.equals((CharSequence)formId, (CharSequence)"fl_payplanbill") && fromDatabase) {
            String billNo = (String)this.getModel().getValue("billno");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"contract", (Object)billNo);
        }
    }

    private void setEnablePlan(boolean isClearData) {
        int rowCount = this.getModel().getEntryRowCount("entry_rentplan");
        BigDecimal startInstRate = this.getInterestRate();
        boolean isZeroRate = EmptyUtil.isEmpty((BigDecimal)startInstRate);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String executeStatus = (String)this.getModel().getValue("executestatus", rowIndex);
            boolean isUnExecuted = ExecuteStatusEnum.isUnExecuted((String)executeStatus);
            if (isUnExecuted) {
                this.getView().setEnable(Boolean.valueOf(!isZeroRate), rowIndex, INST_FIELDS);
                this.getView().setEnable(Boolean.valueOf(!isZeroRate), rowIndex, new String[]{"principal"});
                if (isClearData) {
                    this.getModel().setValue("rentamt", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("principal", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("intamt", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("taxamt", (Object)BigDecimal.ZERO, rowIndex);
                    this.getModel().setValue("excludetaxamt", (Object)BigDecimal.ZERO, rowIndex);
                }
            } else {
                String formId = this.getView().getFormShowParameter().getFormId();
                if (!"fl_leasecontractbill_init".equals(formId)) {
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, PLAN_FIELDS);
                }
            }
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isZeroRate ? 1 : 0) != 0, (String[])INST_FIELDS);
        }
        boolean isRentPlan = StringUtils.equals((CharSequence)this.getView().getFormShowParameter().getFormId(), (CharSequence)"fl_payplanbill");
        TextEdit contractEdit = (TextEdit)this.getControl("contract");
        if (EmptyUtil.isNoEmpty((Object)contractEdit)) {
            contractEdit.setMustInput(isRentPlan);
        }
    }

    private void endRevDateChgEvt() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_rentplan");
        Date endRevDate = (Date)this.getModel().getValue("endrevdate", rowIndex);
        if (EmptyUtil.isNoEmpty((Object)endRevDate)) {
            this.getModel().setValue("paydate", (Object)endRevDate);
        }
    }

    private void rentAmtChgEvt(int rowIndex) {
        this.calcTotalAmt();
        BigDecimal startInstRate = this.getInterestRate();
        boolean isZeroRate = EmptyUtil.isEmpty((BigDecimal)startInstRate);
        if (isZeroRate) {
            this.instAmtChgEvt(rowIndex);
        }
        this.calcInstAmt(rowIndex);
    }

    private void calcTotalAmt() {
        String entityId = this.getView().getEntityId();
        if (!StringUtils.equals((CharSequence)entityId, (CharSequence)"fl_contract_apply")) {
            BigDecimal totalAmt = this.getSum("rentamt");
            this.getModel().setValue("totalamt", (Object)totalAmt);
        }
    }

    private void calcInstAmt(int rowIndex) {
        BigDecimal rentAmt = (BigDecimal)this.getModel().getValue("rentamt", rowIndex);
        BigDecimal principal = (BigDecimal)this.getModel().getValue("principal", rowIndex);
        this.getModel().setValue("intamt", (Object)rentAmt.subtract(principal), rowIndex);
        this.calcTaxAmt(rowIndex);
    }

    private void instAmtChgEvt(int rowIndex) {
        BigDecimal rentAmt = (BigDecimal)this.getModel().getValue("rentamt", rowIndex);
        BigDecimal instAmt = (BigDecimal)this.getModel().getValue("intamt", rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"principal", (Object)rentAmt.subtract(instAmt), (int)rowIndex);
        this.calcTaxAmt(rowIndex);
    }

    private void calcTaxAmt(int rowIndex) {
        BigDecimal intAmt = (BigDecimal)this.getModel().getValue("intamt", rowIndex);
        BigDecimal taxRate = BigDecimal.valueOf(0.01).multiply((BigDecimal)this.getModel().getValue("taxrate", rowIndex));
        BigDecimal taxAmt = intAmt.multiply(taxRate).divide(taxRate.add(BigDecimal.ONE), 2, RoundingMode.HALF_UP);
        this.getModel().setValue("taxamt", (Object)taxAmt, rowIndex);
        this.taxAmtChgEvt(rowIndex);
    }

    private void taxAmtChgEvt(int rowIndex) {
        BigDecimal intAmt = (BigDecimal)this.getModel().getValue("intamt", rowIndex);
        BigDecimal taxAmt = (BigDecimal)this.getModel().getValue("taxamt", rowIndex);
        this.getModel().setValue("excludetaxamt", (Object)intAmt.subtract(taxAmt), rowIndex);
    }

    private void rebuildRentPlan() {
        BigDecimal residueAmt = (BigDecimal)this.getModel().getValue("totalamt");
        int rowCount = this.getModel().getEntryRowCount("entry_rentplan");
        for (int index = 0; index < rowCount; ++index) {
            BigDecimal rentAmt = (BigDecimal)this.getModel().getValue("rentamt", index);
            residueAmt = residueAmt.subtract(rentAmt);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"residueamt", (Object)residueAmt, (int)index);
        }
    }

    private void validateStartRevDate(BeforeFieldPostBackEvent e) {
        DynamicObject lastRow;
        Date lastEndRevDate;
        IDataModel model = this.getModel();
        Object newValue = e.getValue();
        int rowIndex = model.getEntryCurrentRowIndex("entry_rentplan");
        String fmtStr = ((DateEdit)this.getControl("startrevdate")).getFormatString();
        Date startRevDate = DateUtils.stringToDate((String)newValue.toString(), (String)fmtStr);
        String errorMsg = "";
        if (!((Boolean)this.validateDateArea().getLeft()).booleanValue()) {
            errorMsg = (String)this.validateDateArea().getRight();
        }
        if (EmptyUtil.isEmpty((String)errorMsg) && this.isNotInValidDate(startRevDate)) {
            errorMsg = FlFormResourceEnum.RentPlanBillEdit_4.loadKDString();
        }
        if (EmptyUtil.isEmpty((String)errorMsg) && rowIndex > 0 && null != (lastEndRevDate = (lastRow = model.getEntryRowEntity("entry_rentplan", rowIndex - 1)).getDate("endrevdate")) && lastEndRevDate.compareTo(startRevDate) >= 0) {
            errorMsg = FlFormResourceEnum.RentPlanBillEdit_5.loadKDString();
        }
        DynamicObject currentRow = model.getEntryRowEntity("entry_rentplan", rowIndex);
        Date endRevDate = currentRow.getDate("endrevdate");
        if (EmptyUtil.isEmpty((String)errorMsg) && null != endRevDate && endRevDate.compareTo(startRevDate) <= 0) {
            errorMsg = FlFormResourceEnum.RentPlanBillEdit_6.loadKDString();
        }
        this.addValidateTip(errorMsg, e);
    }

    private void validateEndRevDate(BeforeFieldPostBackEvent e) {
        DynamicObject nextRow;
        Date nextStartRevDate;
        Object newValue = e.getValue();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_rentplan");
        String fmtStr = ((DateEdit)this.getControl("endrevdate")).getFormatString();
        Date endRevDate = DateUtils.stringToDate((String)newValue.toString(), (String)fmtStr);
        String errorMsg = "";
        if (!((Boolean)this.validateDateArea().getLeft()).booleanValue()) {
            errorMsg = (String)this.validateDateArea().getRight();
        }
        if (EmptyUtil.isEmpty((String)errorMsg) && this.isNotInValidDate(endRevDate)) {
            errorMsg = FlFormResourceEnum.RentPlanBillEdit_7.loadKDString();
        }
        DynamicObject currentRow = this.getModel().getEntryRowEntity("entry_rentplan", rowIndex);
        Date startRevDate = currentRow.getDate("startrevdate");
        if (EmptyUtil.isEmpty((String)errorMsg) && null != startRevDate && startRevDate.compareTo(endRevDate) >= 0) {
            errorMsg = FlFormResourceEnum.RentPlanBillEdit_8.loadKDString();
        }
        int rowCount = this.getModel().getEntryRowCount("entry_rentplan");
        if (EmptyUtil.isEmpty((String)errorMsg) && rowCount > rowIndex + 1 && null != (nextStartRevDate = (nextRow = this.getModel().getEntryRowEntity("entry_rentplan", rowIndex + 1)).getDate("startrevdate")) && nextStartRevDate.compareTo(endRevDate) <= 0) {
            errorMsg = FlFormResourceEnum.RentPlanBillEdit_10.loadKDString();
        }
        this.addValidateTip(errorMsg, e);
    }

    private void validatePrinciple(BeforeFieldPostBackEvent e) {
        BigDecimal principal = this.getSum("principal");
        BigDecimal oldValue = (BigDecimal)this.getModel().getValue("principal", e.getRowIndex());
        BigDecimal newValue = new BigDecimal(e.getValue().toString());
        principal = principal.subtract(oldValue).add(newValue);
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        String errorMsg = "";
        if (principal.compareTo(amount) > 0) {
            errorMsg = FlFormResourceEnum.RentPlanBillEdit_11.loadKDString();
            this.getView().updateView(((Control)e.getSource()).getKey(), this.getModel().getEntryCurrentRowIndex("entry_rentplan"));
        }
        BigDecimal rentAmt = (BigDecimal)this.getModel().getValue("rentamt");
        if (EmptyUtil.isEmpty((String)errorMsg) && rentAmt.compareTo(newValue) < 0) {
            errorMsg = FlFormResourceEnum.RentPlanBillEdit_14.loadKDString();
        }
        this.addValidateTip(errorMsg, e);
    }

    private void validateInstAmt(BeforeFieldPostBackEvent e) {
        BigDecimal newInstAmt = new BigDecimal(e.getValue().toString());
        BigDecimal rentAmt = (BigDecimal)this.getModel().getValue("rentamt");
        if (rentAmt.compareTo(newInstAmt) < 0) {
            this.getView().showTipNotification(FlFormResourceEnum.RentPlanBillEdit_12.loadKDString());
            e.setCancel(true);
            this.getView().updateView(((Control)e.getSource()).getKey(), this.getModel().getEntryCurrentRowIndex("entry_rentplan"));
        }
    }

    private void validateTaxAmt(BeforeFieldPostBackEvent e) {
        BigDecimal intAmt;
        BigDecimal newTaxAmt = new BigDecimal(e.getValue().toString());
        if (newTaxAmt.compareTo(intAmt = (BigDecimal)this.getModel().getValue("intamt", e.getRowIndex())) > 0) {
            this.getView().showTipNotification(FlFormResourceEnum.RentPlanBillEdit_13.loadKDString());
            e.setCancel(true);
            this.getView().updateView(((Control)e.getSource()).getKey(), this.getModel().getEntryCurrentRowIndex("entry_rentplan"));
        }
    }

    private void addValidateTip(String errorMsg, BeforeFieldPostBackEvent e) {
        if (EmptyUtil.isNoEmpty((String)errorMsg)) {
            e.setCancel(true);
            this.getView().showTipNotification(errorMsg);
            this.getView().updateView(((Control)e.getSource()).getKey(), e.getRowIndex());
        }
    }

    private boolean isNotInValidDate(Date date) {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        return startDate.compareTo(date) > 0 || endDate.compareTo(date) < 0;
    }

    private Pair<Boolean, String> validateDateArea() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (null == startDate) {
            return Pair.of((Object)false, (Object)FlFormResourceEnum.RentPlanBillEdit_16.loadKDString());
        }
        if (null == endDate) {
            return Pair.of((Object)false, (Object)FlFormResourceEnum.RentPlanBillEdit_17.loadKDString());
        }
        return Pair.of((Object)true, (Object)"");
    }

    private void openContractBill() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"fl_leasecontractbill", (boolean)false, (int)0, (boolean)true);
        parameter.getListFilterParameter().getQFilters().add(this.getContractFilter());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "contract"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private BigDecimal getSum(String fieldName) {
        DynamicObjectCollection rentPlans = this.getModel().getEntryEntity("entry_rentplan");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rentPlans)) {
            return rentPlans.stream().map(v -> v.getBigDecimal(fieldName)).filter(EmptyUtil::isNoEmpty).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    private QFilter getContractFilter() {
        String appId = this.getView().getFormShowParameter().getAppId();
        long currUserId = RequestContext.get().getCurrUserId();
        String entityName = this.getModel().getDataEntityType().getName();
        List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
        QFilter filter = new QFilter("org", "in", (Object)orgIdSet);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            filter.and("org", "=", org.getPkValue());
        }
        filter.and("loantype", "=", (Object)"finlease");
        return filter;
    }

    private BigDecimal getInterestRate() {
        String entityId = this.getView().getEntityId();
        String rateField = StringUtils.equals((CharSequence)entityId, (CharSequence)"fl_contract_apply") ? "interestrate" : "startinterestrate";
        return (BigDecimal)this.getModel().getValue(rateField);
    }
}

