/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.transform;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.FinanceLeaseTypeEnum;
import kd.tmc.fl.formplugin.resource.FlFormResourceEnum;

public class ContractTransformApplyEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"leaseholdtype", "leasehold"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object loanContractBillId = customParams.get("loancontractbill");
        if (EmptyUtil.isNoEmpty(loanContractBillId)) {
            this.initByLoanContract(loanContractBillId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.finProductChgEvt();
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"term")) {
            this.checkTerm(e);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"enddate")) {
            this.checkEndDate(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "enddate": {
                this.endDateChgEvt();
                break;
            }
            case "term": {
                this.termChgEvt();
                break;
            }
            case "loancontractbill": {
                this.initByLoanContract(null);
                break;
            }
            case "leaseholdtype": {
                this.getModel().setValue("leasehold", (Object)"");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"leaseholdtypeid", (Object)0);
                break;
            }
            case "leasehold": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"leaseholdid", (Object)0);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"leaseholdtype")) {
            this.showLeaseholdTypeList();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"leasehold")) {
            this.showLeaseholdList();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        List<String> clickFields = Arrays.asList("leaseholdtype", "leasehold");
        if (EmptyUtil.isNoEmpty((Object)returnData) && clickFields.contains(actionId)) {
            ListSelectedRowCollection selected = (ListSelectedRowCollection)event.getReturnData();
            String selectName = selected.get(0).getName();
            Object selectId = selected.get(0).getPrimaryKeyValue();
            this.getModel().setValue(actionId, (Object)selectName);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)(actionId + "id"), (Object)selectId);
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)"leasehold")) {
                DynamicObject realCard = QueryServiceHelper.queryOne((String)"fa_card_real_base", (String)"assetamount,unit", (QFilter[])new QFilter[]{new QFilter("id", "=", selectId)});
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"assetcount", (Object)realCard.get("assetamount"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"unit", (Object)realCard.get("unit"));
            }
        }
    }

    private void checkTerm(BeforeFieldPostBackEvent e) {
        Object value = e.getValue();
        if (!TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) {
            e.setCancel(true);
            this.getView().updateView("term");
        }
    }

    private void checkEndDate(BeforeFieldPostBackEvent e) {
        Object value = e.getValue();
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (EmptyUtil.isEmpty((Object)value) || EmptyUtil.isEmpty((Object)startDate)) {
            return;
        }
        String fmtStr = ((DateEdit)this.getControl("enddate")).getFormatString();
        Date endDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        if (startDate.after(endDate)) {
            e.setCancel(true);
            this.getView().showErrorNotification(FlFormResourceEnum.ContractTransformApplyEdit_0.loadKDString());
            this.getView().updateView("enddate");
        }
    }

    private void endDateChgEvt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        String term = "";
        if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((Object)endDate)) {
            term = DateUtils.getDiff_ymd((Date)startDate, (Date)endDate);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)term);
    }

    private void termChgEvt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        String term = (String)this.getModel().getValue("term");
        Date endDate = null;
        if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((String)term)) {
            endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
    }

    private void initByLoanContract(Object contractId) {
        DynamicObject contractBill;
        if (EmptyUtil.isEmpty((Object)contractId)) {
            contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
            Object object = contractId = EmptyUtil.isNoEmpty((DynamicObject)contractBill) ? contractBill.getPkValue() : null;
        }
        if (EmptyUtil.isNoEmpty((Object)contractId)) {
            contractBill = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)"fl_leasecontractbill");
            this.fillLeaseHoldInfo(contractBill);
            this.fillPayPlanEntry(contractBill);
        } else {
            this.clearContractInfo();
        }
    }

    private void clearContractInfo() {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("leaseholdtype", null);
        valueMap.put("leaseholdtypeid", null);
        valueMap.put("leasehold", null);
        valueMap.put("leaseholdid", null);
        valueMap.put("repurchaseamt", null);
        valueMap.put("assetcount", null);
        valueMap.put("unit", null);
        valueMap.put("repurchase", null);
        valueMap.put("issyncdraw", null);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), valueMap);
        this.getModel().deleteEntryData("entry_rentplan");
        this.getModel().setDataChanged(false);
    }

    private void fillLeaseHoldInfo(DynamicObject contractBill) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("leaseholdtype", contractBill.get("leaseholdtype"));
        valueMap.put("leaseholdtypeid", contractBill.get("leaseholdtypeid"));
        valueMap.put("leasehold", contractBill.get("leasehold"));
        valueMap.put("leaseholdid", contractBill.get("leaseholdid"));
        valueMap.put("repurchaseamt", contractBill.get("repurchaseamt"));
        valueMap.put("assetcount", contractBill.get("assetcount"));
        valueMap.put("unit", contractBill.get("unit"));
        valueMap.put("repurchase", contractBill.get("repurchase"));
        valueMap.put("issyncdraw", contractBill.get("issyncdraw"));
        valueMap.put("address", contractBill.get("address"));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), valueMap);
    }

    private void fillPayPlanEntry(DynamicObject contractBill) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection planEntry = contractBill.getDynamicObjectCollection("entry_rentplan");
        TableValueSetter vs = this.getTableValueSetter();
        for (DynamicObject entry : planEntry) {
            vs.addRow(new Object[]{entry.get("paydate"), entry.get("startrevdate"), entry.get("endrevdate"), entry.get("rentamt"), entry.get("principal"), entry.get("intamt"), entry.get("taxrate"), entry.get("taxamt"), entry.get("excludetaxamt"), entry.get("residueamt"), entry.getDynamicObject("payacct").getPkValue(), entry.getString("executestatus"), entry.get("notes")});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entry_rentplan", vs);
        model.endInit();
        this.getView().updateView("entry_rentplan");
        model.setDataChanged(false);
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("paydate", new Object[0]);
        vs.addField("startrevdate", new Object[0]);
        vs.addField("endrevdate", new Object[0]);
        vs.addField("rentamt", new Object[0]);
        vs.addField("principal", new Object[0]);
        vs.addField("intamt", new Object[0]);
        vs.addField("taxrate", new Object[0]);
        vs.addField("taxamt", new Object[0]);
        vs.addField("excludetaxamt", new Object[0]);
        vs.addField("residueamt", new Object[0]);
        vs.addField("payacct", new Object[0]);
        vs.addField("executestatus", new Object[0]);
        vs.addField("notes", new Object[0]);
        return vs;
    }

    private void showLeaseholdTypeList() {
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"fa_assetcategory", (boolean)false, (int)2, (boolean)true);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "leaseholdtype"));
        showParam.setSelectedRow(this.getModel().getValue("leaseholdtypeid"));
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("enable", "=", (Object)"1");
        showParam.getListFilterParameter().getQFilters().add(filter);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        showParam.setUseOrgId(org.getLong("ID"));
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void showLeaseholdList() {
        DynamicObject org;
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"fa_card_real_base", (boolean)false, (int)2, (boolean)true);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "leasehold"));
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Object leaseholdTypeId = this.getModel().getValue("leaseholdtypeid");
        if (EmptyUtil.isNoEmpty((Object)leaseholdTypeId)) {
            filter.and("assetcat", "=", leaseholdTypeId);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(org = (DynamicObject)this.getModel().getValue("org")))) {
            filter.and("org", "=", org.getPkValue());
        }
        showParam.getListFilterParameter().getQFilters().add(filter);
        showParam.setSelectedRow(this.getModel().getValue("leaseholdid"));
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void finProductChgEvt() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        if (EmptyUtil.isNoEmpty((DynamicObject)finProduct)) {
            String finLeaseType = finProduct.getString("financeleasetype");
            boolean isLeaseBackNoSale = FinanceLeaseTypeEnum.isLeaseBackNoSale((String)finLeaseType);
            this.getView().setEnable(Boolean.valueOf(!isLeaseBackNoSale), new String[]{"repurchase"});
        }
    }
}

