/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.common.helper;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.resources.FlCommonResourceEnum;

public class LeaseFeeHelper {
    public static DynamicObjectCollection getFeeBills(Set<Long> billIds, Date feeDate) {
        QFilter filter = new QFilter("entry.srcbillid", "in", billIds).and("sharetype", "=", (Object)ShareTypeEnum.INTEREST.getValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("paydate", "<=", (Object)feeDate);
        DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,paydate,currency,sharetype,entry.feedetailamt", (QFilter[])new QFilter[]{filter});
        return feeBills;
    }

    public static BigDecimal getFeeAmount(long contractId, Date expireDate, long currencyId, long orgId) {
        Map<String, BigDecimal> feeAmountMap = LeaseFeeHelper.getFeeAmountMap(contractId, expireDate, currencyId, orgId);
        return feeAmountMap.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static Map<String, BigDecimal> getFeeAmountMap(long contractId, Date expireDate, long currencyId, long orgId) {
        DynamicObjectCollection contractBills = LeaseFeeHelper.getPayPlans(contractId);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)contractBills)) {
            return new HashMap<String, BigDecimal>();
        }
        Date payDate = contractBills.parallelStream().map(o -> o.getDate("entry_rentplan.paydate")).max(Comparator.comparing(x -> x)).orElse(expireDate);
        expireDate = payDate.after(expireDate) ? payDate : expireDate;
        DynamicObjectCollection feeBills = LeaseFeeHelper.getFeeBills(Collections.singleton(contractId), expireDate);
        if (EmptyUtil.isNoEmpty((Long)currencyId) && EmptyUtil.isNoEmpty((Long)orgId)) {
            return LeaseFeeHelper.getRateAmount(feeBills, currencyId, orgId);
        }
        return feeBills.parallelStream().collect(Collectors.toMap(o -> DateUtils.formatString((Date)o.getDate("paydate"), (String)"yyyyMMdd"), o1 -> o1.getBigDecimal("entry.feedetailamt"), (v1, v2) -> v1.add((BigDecimal)v2)));
    }

    private static Map<String, BigDecimal> getRateAmount(DynamicObjectCollection feeBills, long bizCurrencyId, long orgId) {
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>();
        DynamicObject bizCurrencyObj = TmcDataServiceHelper.loadSingleFromCache((Object)bizCurrencyId, (String)"bd_currency", (String)"id,amtprecision,name");
        HashMap<String, BigDecimal> payDateAmtMap = new HashMap<String, BigDecimal>(feeBills.size());
        for (DynamicObject freeBill : feeBills) {
            BigDecimal rate = BigDecimal.ONE;
            BigDecimal payAmt = freeBill.getBigDecimal("entry.feedetailamt");
            Long currencyId = freeBill.getLong("currency");
            if (!currencyId.equals(bizCurrencyId) && EmptyUtil.isEmpty((BigDecimal)(rate = (BigDecimal)rateMap.get(currencyId)))) {
                rate = LeaseFeeHelper.getRate(orgId, currencyId, bizCurrencyId);
                if (rate == null) {
                    DynamicObject feeCurrencyObj = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"id,name");
                    throw new KDBizException(FlCommonResourceEnum.LeaseFeeHelper_0.loadKDString(feeCurrencyObj.getString("name"), bizCurrencyObj.getString("name")));
                }
                rateMap.put(currencyId, rate);
            }
            BigDecimal feeAmt = payAmt.multiply(rate);
            String key = DateUtils.formatString((Date)freeBill.getDate("paydate"), (String)"yyyyMMdd");
            payDateAmtMap.put(key, payDateAmtMap.getOrDefault(key, BigDecimal.ZERO).add(feeAmt));
        }
        return payDateAmtMap;
    }

    private static BigDecimal getRate(Long orgId, Long sCurrencyId, Long tCurrencyId) {
        Long standardExRateTableId = TmcBusinessBaseHelper.getExchageTableId((Long)orgId);
        if (EmptyUtil.isNoEmpty((Long)standardExRateTableId)) {
            return BaseDataServiceHelper.getExchangeRate((Long)standardExRateTableId, (Long)sCurrencyId, (Long)tCurrencyId, (Date)new Date());
        }
        return null;
    }

    public static DynamicObjectCollection getPayPlans(long contractId) {
        DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"fl_leasecontractbill", (String)"repurchaseamt,entry_rentplan.paydate,entry_rentplan.rentamt,entry_rentplan.principal,entry_rentplan.intamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)contractId)}, (String)"entry_rentplan.paydate");
        return contractBills;
    }

    public static BigDecimal getPayPlanAmount(long contractId) {
        DynamicObjectCollection payPlans = LeaseFeeHelper.getPayPlans(contractId);
        BigDecimal payPlanAmount = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payPlans)) {
            payPlanAmount = payPlans.parallelStream().map(o -> o.getBigDecimal("entry_rentplan.intamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            payPlanAmount = payPlanAmount.add(((DynamicObject)payPlans.get(0)).getBigDecimal("repurchaseamt"));
        }
        return payPlanAmount;
    }
}

