/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ShareFrequencyEnum;
import kd.tmc.fbp.common.helper.CostShareServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.bean.LeaseShareInfo;
import kd.tmc.fl.common.bean.RenPayFeeInfo;
import kd.tmc.fl.common.helper.LeaseFeeHelper;
import kd.tmc.fl.common.resources.FlCommonResourceEnum;
import org.apache.commons.lang3.tuple.Pair;

public class LeaseFeeShareHelper {
    private static final BigDecimal maxYtm = new BigDecimal("0.5");
    private static final BigDecimal minYtm = new BigDecimal("-0.5");
    private static final int maxCount = 200;
    private static final Log logger = LogFactory.getLog(LeaseFeeShareHelper.class);

    public static List<LeaseShareInfo> getLeaseShareDetails(DynamicObject bill, Map<String, BigDecimal> feeAmountMap) {
        long conBillId = bill.getDynamicObject("conbillno").getLong("id");
        BigDecimal suretyAmount = LeaseFeeShareHelper.getSuretyAmount(conBillId);
        BigDecimal beginFreeAmt = feeAmountMap.entrySet().stream().filter(o -> bill.getDate("bizdate").compareTo(DateUtils.stringToDate((String)((String)o.getKey()), (String)"yyyyMMdd")) >= 0).map(o -> (BigDecimal)o.getValue()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        logger.info("beginFreeAmt\uff1a{}\uff0csuretyAmount\uff1a{}", (Object)beginFreeAmt, (Object)beginFreeAmt);
        feeAmountMap.entrySet().removeIf(o -> DateUtils.stringToDate((String)((String)o.getKey()), (String)"yyyyMMdd").compareTo(bill.getDate("bizdate")) <= 0);
        List<LeaseShareInfo> hasVoucherFeeshreInfos = LeaseFeeShareHelper.getHasVoucherFeeshreInfos(bill);
        LeaseShareInfo lastFeeInfo = EmptyUtil.isNoEmpty(hasVoucherFeeshreInfos) ? hasVoucherFeeshreInfos.get(hasVoucherFeeshreInfos.size() - 1) : null;
        List<RenPayFeeInfo> leaseFeeShares = LeaseFeeShareHelper.getLeaseFeeShares(feeAmountMap, suretyAmount, conBillId);
        leaseFeeShares = LeaseFeeShareHelper.getChangeRenPayFeeInfo(leaseFeeShares, hasVoucherFeeshreInfos);
        BasisEnum basisEnum = BasisEnum.getEnum((String)bill.getString("basis"));
        Date startDate = lastFeeInfo != null ? DateUtils.getNextDay((Date)lastFeeInfo.getEndDate(), (int)1) : bill.getDate("bizdate");
        RenPayFeeInfo renPayFeeInfo = leaseFeeShares.stream().sorted(Comparator.comparing(o -> DateUtils.stringToDate((String)o.getPayDate(), (String)"yyyyMMdd"), Comparator.reverseOrder())).findFirst().orElse(null);
        Date expireDate = EmptyUtil.isNoEmpty((Object)renPayFeeInfo) && DateUtils.stringToDate((String)renPayFeeInfo.getPayDate(), (String)"yyyyMMdd").after(bill.getDate("expiredate")) ? DateUtils.stringToDate((String)renPayFeeInfo.getPayDate(), (String)"yyyyMMdd") : bill.getDate("expiredate");
        List<LeaseShareInfo> leaseShareInfos = LeaseFeeShareHelper.getLeaseShareInfos(leaseFeeShares, startDate, expireDate, basisEnum);
        DynamicObject currency = bill.getDynamicObject("currency");
        BigDecimal beginCostAmt = lastFeeInfo != null ? lastFeeInfo.getEndcostamt() : bill.getBigDecimal("amount").subtract(beginFreeAmt).subtract(suretyAmount);
        logger.info("beginCostAmt:{}", (Object)beginCostAmt);
        leaseShareInfos = LeaseFeeShareHelper.calculateYtm(leaseShareInfos, beginCostAmt, currency.getInt("amtprecision"));
        leaseShareInfos = LeaseFeeShareHelper.calculateSuretyAmt(leaseShareInfos, suretyAmount);
        leaseShareInfos = LeaseFeeShareHelper.getLeaseShareInfoPeriod(leaseShareInfos, startDate, expireDate, bill.getString("sharefrequency"));
        leaseShareInfos.addAll(hasVoucherFeeshreInfos);
        return LeaseFeeShareHelper.getInfoComTaildiff(leaseShareInfos, bill.getBigDecimal("feeamount"), currency.getInt("amtprecision"));
    }

    private static List<LeaseShareInfo> calculateSuretyAmt(List<LeaseShareInfo> leaseShareInfos, BigDecimal suretyAmout) {
        if (EmptyUtil.isEmpty(leaseShareInfos)) {
            return leaseShareInfos;
        }
        BigDecimal irr = leaseShareInfos.get(0).getYtm();
        long sumDays = leaseShareInfos.parallelStream().map(o -> o.getDays()).count();
        double rate = Math.pow(1.0 + irr.doubleValue(), -((double)sumDays) / 365.0);
        BigDecimal suretyBeginAmount = suretyAmout.multiply(BigDecimal.valueOf(rate));
        rate = Math.pow(1.0 + irr.doubleValue(), 0.0027397260273972603) - 1.0;
        for (LeaseShareInfo leaseShareInfo : leaseShareInfos) {
            BigDecimal guaIncomeAmt = suretyBeginAmount.multiply(BigDecimal.valueOf(rate));
            leaseShareInfo.setGuaincomeamt(guaIncomeAmt);
            suretyBeginAmount = suretyBeginAmount.add(guaIncomeAmt);
            leaseShareInfo.setGuabalanceamt(suretyBeginAmount);
        }
        return leaseShareInfos;
    }

    private static List<LeaseShareInfo> getHasVoucherFeeshreInfos(DynamicObject bill) {
        DynamicObjectCollection entryColls = bill.getDynamicObjectCollection("entryentity");
        List lockEntry = entryColls.parallelStream().filter(e -> e.getBoolean("e_islock")).sorted(Comparator.comparing(o -> o.getDate("e_enddate"))).collect(Collectors.toList());
        ArrayList<LeaseShareInfo> infos = new ArrayList<LeaseShareInfo>(lockEntry.size());
        LeaseShareInfo info = null;
        BigDecimal irr = bill.getBigDecimal("irr");
        for (DynamicObject entryColl : lockEntry) {
            info = new LeaseShareInfo();
            info.setYtm(irr);
            info.setStartDate(entryColl.getDate("e_startdate"));
            info.setEndDate(entryColl.getDate("e_enddate"));
            info.setDays(entryColl.getInt("e_day"));
            info.setBegincostamt(entryColl.getBigDecimal("e_begincostamt"));
            info.setCurfeeamt(entryColl.getBigDecimal("e_curfeeamt"));
            info.setCurguaamt(entryColl.getBigDecimal("e_curguaamt"));
            info.setCurrepurchaseamt(entryColl.getBigDecimal("e_currepurchaseamt"));
            info.setRentamt(entryColl.getBigDecimal("e_rentamt"));
            info.setPrincipal(entryColl.getBigDecimal("e_principal"));
            info.setIntamt(entryColl.getBigDecimal("e_intamt"));
            info.setAccrualinterest(entryColl.getBigDecimal("e_accrualinterest"));
            info.setRepayamt(entryColl.getBigDecimal("e_repayamt"));
            info.setEndcostamt(entryColl.getBigDecimal("e_endcostamt"));
            info.setVoucher(entryColl.getBoolean("e_isvoucher"));
            info.setLock(entryColl.getBoolean("e_islock"));
            infos.add(info);
        }
        return infos;
    }

    private static List<LeaseShareInfo> getLeaseShareInfoPeriod(List<LeaseShareInfo> infos, Date startDate, Date endDate, String shareFrequency) {
        List dataLists = CostShareServiceHelper.getDateList((String)"", (Date)startDate, (Date)endDate, (String)shareFrequency);
        ArrayList<LeaseShareInfo> shareInfos = new ArrayList<LeaseShareInfo>(dataLists.size());
        LeaseShareInfo shareInfo = null;
        for (Pair dataList : dataLists) {
            shareInfo = new LeaseShareInfo();
            shareInfo.setStartDate((Date)dataList.getLeft());
            shareInfo.setEndDate((Date)dataList.getRight());
            Iterator<LeaseShareInfo> infoItes = infos.iterator();
            boolean isFirst = true;
            while (infoItes.hasNext()) {
                LeaseShareInfo info = infoItes.next();
                if (info.getStartDate().compareTo((Date)dataList.getLeft()) < 0) continue;
                if (info.getStartDate().compareTo((Date)dataList.getRight()) > 0) break;
                shareInfo.setDays(shareInfo.getDays() + 1);
                shareInfo.setBegincostamt(isFirst ? info.getBegincostamt() : shareInfo.getBegincostamt());
                shareInfo.setCurfeeamt(shareInfo.getCurfeeamt().add(info.getCurfeeamt()));
                shareInfo.setCurguaamt(shareInfo.getCurguaamt().add(info.getCurguaamt()));
                shareInfo.setCurrepurchaseamt(shareInfo.getCurrepurchaseamt().add(info.getCurrepurchaseamt()));
                shareInfo.setRentamt(shareInfo.getRentamt().add(info.getRentamt()));
                shareInfo.setPrincipal(shareInfo.getPrincipal().add(info.getPrincipal()));
                shareInfo.setIntamt(shareInfo.getIntamt().add(info.getIntamt()));
                shareInfo.setAccrualinterest(shareInfo.getAccrualinterest().add(info.getAccrualinterest()));
                shareInfo.setRepayamt(shareInfo.getRepayamt().add(info.getRepayamt()));
                shareInfo.setEndcostamt(info.getEndcostamt());
                shareInfo.setGuaincomeamt(shareInfo.getGuaincomeamt().add(info.getGuaincomeamt()));
                shareInfo.setGuabalanceamt(info.getGuabalanceamt());
                shareInfo.setYtm(info.getYtm());
                infoItes.remove();
                isFirst = false;
            }
            shareInfos.add(shareInfo);
        }
        return shareInfos;
    }

    private static List<LeaseShareInfo> getInfoComTaildiff(List<LeaseShareInfo> shareInfos, BigDecimal totalAmt, int amtPrecision) {
        shareInfos.sort(Comparator.comparing(o -> o.getStartDate()));
        for (LeaseShareInfo info : shareInfos) {
            info.setBegincostamt(info.getBegincostamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setCurfeeamt(info.getCurfeeamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setCurguaamt(info.getCurguaamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setCurrepurchaseamt(info.getCurrepurchaseamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setAccrualinterest(info.getAccrualinterest().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setRepayamt(info.getRepayamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setRentamt(info.getRentamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setPrincipal(info.getPrincipal().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setIntamt(info.getIntamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setEndcostamt(info.getEndcostamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setGuaincomeamt(info.getGuaincomeamt().setScale(amtPrecision, RoundingMode.HALF_UP));
            info.setGuabalanceamt(info.getGuabalanceamt().setScale(amtPrecision, RoundingMode.HALF_UP));
        }
        BigDecimal totalInterestAmt = shareInfos.parallelStream().map(o -> o.getAccrualinterest()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal diffAmount = totalAmt.subtract(totalInterestAmt);
        LeaseShareInfo leaseShareInfo = shareInfos.get(shareInfos.size() - 1);
        leaseShareInfo.setAccrualinterest(leaseShareInfo.getAccrualinterest().add(diffAmount));
        leaseShareInfo.setRepayamt(leaseShareInfo.getRentamt().subtract(leaseShareInfo.getAccrualinterest()));
        leaseShareInfo.setAccrualinterest(leaseShareInfo.getAccrualinterest().setScale(amtPrecision, RoundingMode.HALF_UP));
        leaseShareInfo.setRepayamt(leaseShareInfo.getRepayamt().setScale(amtPrecision, RoundingMode.HALF_UP));
        return shareInfos;
    }

    private static List<LeaseShareInfo> calculateYtm(List<LeaseShareInfo> infos, BigDecimal begincostamt, int amtPrecision) {
        BigDecimal ytm = maxYtm.divide(new BigDecimal("2"));
        BigDecimal minYtmTemp = minYtm;
        BigDecimal maxYtmTemp = maxYtm;
        BigDecimal minAmt = LeaseFeeShareHelper.getMinAmt(amtPrecision);
        boolean isSuccess = false;
        BigDecimal ccbEndAmt = BigDecimal.ZERO;
        for (int i = 0; i < 200; ++i) {
            ccbEndAmt = LeaseFeeShareHelper.getLastEndcostamt(infos, begincostamt, ytm);
            if (ccbEndAmt.setScale(amtPrecision, RoundingMode.HALF_UP).abs().compareTo(minAmt) < 0) {
                isSuccess = true;
                break;
            }
            boolean isLarger = ccbEndAmt.compareTo(BigDecimal.ZERO) > 0;
            minYtmTemp = isLarger ? minYtmTemp : ytm;
            maxYtmTemp = isLarger ? ytm : maxYtmTemp;
            ytm = minYtmTemp.add(maxYtmTemp).divide(new BigDecimal("2")).setScale(11, RoundingMode.HALF_UP);
        }
        if (!isSuccess) {
            logger.info("irr:{}\uff0cccbEndAmt\uff1a{}", (Object)ytm, (Object)ccbEndAmt);
            throw new KDBizException(FlCommonResourceEnum.LeaseFeeShareHelper_0.loadKDString());
        }
        return infos;
    }

    private static BigDecimal getLastEndcostamt(List<LeaseShareInfo> infos, BigDecimal begincostamt, BigDecimal ytm) {
        BigDecimal endcostamt = begincostamt;
        infos = infos.stream().sorted(Comparator.comparing(o -> o.getStartDate())).collect(Collectors.toList());
        for (LeaseShareInfo info : infos) {
            if (info.isVoucher()) {
                endcostamt = info.getEndcostamt();
                continue;
            }
            info.setBegincostamt(endcostamt);
            info.setAccrualinterest(endcostamt.multiply(ytm).multiply(BigDecimal.valueOf(info.getDays())).divide(BigDecimal.valueOf(info.getYearDay()), 11, RoundingMode.HALF_UP));
            info.setYtm(ytm);
            info.setRepayamt(info.getRentamt().subtract(info.getAccrualinterest()));
            endcostamt = info.getBegincostamt().subtract(info.getRepayamt());
            info.setEndcostamt(endcostamt);
        }
        return endcostamt;
    }

    private static List<LeaseShareInfo> getLeaseShareInfos(List<RenPayFeeInfo> leaseFeeShares, Date startDate, Date endDate, BasisEnum basisEnum) {
        List dataLists = CostShareServiceHelper.getDateList((String)"", (Date)startDate, (Date)endDate, (String)ShareFrequencyEnum.DAY.getValue());
        Map rentPayMap = leaseFeeShares.stream().collect(Collectors.toMap(RenPayFeeInfo::getPayDate, Function.identity(), (v1, v2) -> v2));
        ArrayList<LeaseShareInfo> infos = new ArrayList<LeaseShareInfo>(dataLists.size());
        LeaseShareInfo info = null;
        HashMap<Integer, Integer> yearMap = new HashMap<Integer, Integer>();
        for (Pair dataList : dataLists) {
            int year;
            Integer yearDays;
            info = new LeaseShareInfo();
            info.setStartDate((Date)dataList.getLeft());
            info.setEndDate((Date)dataList.getRight());
            int diffDays = TermHelper.getBasis_BetweenDay((Date)((Date)dataList.getLeft()), (Date)DateUtils.getNextDay((Date)((Date)dataList.getRight()), (int)1), (BasisEnum)basisEnum, null);
            info.setDays(diffDays);
            Date feePayDate = DateUtils.getNextDay((Date)((Date)dataList.getLeft()), (int)1);
            RenPayFeeInfo renPayFeeInfo = (RenPayFeeInfo)rentPayMap.get(DateUtils.formatString((Date)feePayDate, (String)"yyyyMMdd"));
            if (renPayFeeInfo != null) {
                info.setCurfeeamt(renPayFeeInfo.getFeeamt());
                info.setCurguaamt(renPayFeeInfo.getGuaamt());
                info.setCurrepurchaseamt(renPayFeeInfo.getRepurchaseamt());
                info.setRentamt(renPayFeeInfo.getRentamt());
                info.setPrincipal(renPayFeeInfo.getPrincipal());
                info.setIntamt(renPayFeeInfo.getIntamt());
            }
            if (EmptyUtil.isEmpty((Integer)(yearDays = (Integer)yearMap.get(year = DateUtils.getYear((Date)info.getStartDate()))))) {
                yearDays = TermHelper.getBasis_YearDay((Date)info.getStartDate(), (Date)info.getStartDate(), (BasisEnum)basisEnum);
                yearMap.put(year, yearDays);
            }
            info.setYearDay(yearDays);
            infos.add(info);
        }
        return infos;
    }

    private static List<RenPayFeeInfo> getLeaseFeeShares(Map<String, BigDecimal> feeAmountMap, BigDecimal suretyAmount, long contractId) {
        DynamicObjectCollection payPlans = LeaseFeeHelper.getPayPlans(contractId);
        BigDecimal repurchaseAmt = EmptyUtil.isNoEmpty((DynamicObjectCollection)payPlans) ? ((DynamicObject)payPlans.get(0)).getBigDecimal("repurchaseamt") : BigDecimal.ZERO;
        ArrayList<RenPayFeeInfo> feeInfos = new ArrayList<RenPayFeeInfo>();
        RenPayFeeInfo feeInfo = null;
        int i = 1;
        for (DynamicObject payPlan : payPlans) {
            feeInfo = new RenPayFeeInfo();
            String payDateStr = DateUtils.formatString((Date)payPlan.getDate("entry_rentplan.paydate"), (String)"yyyyMMdd");
            feeInfo.setPayDate(payDateStr);
            feeInfo.setRentamt(payPlan.getBigDecimal("entry_rentplan.rentamt"));
            feeInfo.setPrincipal(payPlan.getBigDecimal("entry_rentplan.principal"));
            feeInfo.setIntamt(payPlan.getBigDecimal("entry_rentplan.intamt"));
            Date payDate = DateUtils.getDataFormat((Date)payPlan.getDate("entry_rentplan.paydate"), (boolean)false);
            BigDecimal feeAmt = feeAmountMap.entrySet().stream().filter(o -> DateUtils.stringToDate((String)((String)o.getKey()), (String)"yyyyMMdd").compareTo(payDate) < 0).map(o -> (BigDecimal)o.getValue()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            feeInfo.setFeeamt(feeAmt);
            feeAmountMap.entrySet().removeIf(o -> DateUtils.stringToDate((String)((String)o.getKey()), (String)"yyyyMMdd").compareTo(payDate) < 0);
            if (i == payPlans.size()) {
                feeInfo.setRepurchaseamt(repurchaseAmt);
                feeInfo.setGuaamt(suretyAmount.negate());
            }
            feeInfo.setRentamt(feeInfo.getRentamt().add(feeInfo.getFeeamt()).add(feeInfo.getGuaamt()).add(feeInfo.getRepurchaseamt()));
            feeInfos.add(feeInfo);
            ++i;
        }
        return feeInfos;
    }

    private static List<RenPayFeeInfo> getChangeRenPayFeeInfo(List<RenPayFeeInfo> leaseFeeShares, List<LeaseShareInfo> hasVoucherFeeshreInfos) {
        RenPayFeeInfo diffRentPayInfo;
        LeaseShareInfo lastFeeInfo;
        if (EmptyUtil.isEmpty(leaseFeeShares) || EmptyUtil.isEmpty(hasVoucherFeeshreInfos)) {
            return leaseFeeShares;
        }
        LeaseShareInfo leaseShareInfo = lastFeeInfo = EmptyUtil.isNoEmpty(hasVoucherFeeshreInfos) ? hasVoucherFeeshreInfos.get(hasVoucherFeeshreInfos.size() - 1) : null;
        if (lastFeeInfo == null || EmptyUtil.isEmpty((Object)lastFeeInfo.getEndDate())) {
            return leaseFeeShares;
        }
        Date periodEndDate = lastFeeInfo.getEndDate();
        List<RenPayFeeInfo> rentPayLessVoucherDates = leaseFeeShares.parallelStream().filter(o -> periodEndDate.compareTo(DateUtils.stringToDate((String)o.getPayDate(), (String)"yyyyMMdd")) >= 0).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(rentPayLessVoucherDates)) {
            return leaseFeeShares;
        }
        List rentPayLargeVoucherDates = leaseFeeShares.parallelStream().filter(o -> periodEndDate.compareTo(DateUtils.stringToDate((String)o.getPayDate(), (String)"yyyyMMdd")) < 0).sorted(Comparator.comparing(o -> o.getPayDate())).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(rentPayLargeVoucherDates) && (diffRentPayInfo = LeaseFeeShareHelper.getDiffRentPayInfo(rentPayLessVoucherDates, hasVoucherFeeshreInfos)) != null) {
            RenPayFeeInfo renPayFeeInfo = (RenPayFeeInfo)rentPayLargeVoucherDates.get(0);
            renPayFeeInfo.setRentamt(renPayFeeInfo.getRentamt().add(diffRentPayInfo.getRentamt()));
            renPayFeeInfo.setFeeamt(renPayFeeInfo.getFeeamt().add(diffRentPayInfo.getFeeamt()));
            renPayFeeInfo.setPrincipal(renPayFeeInfo.getPrincipal().add(diffRentPayInfo.getPrincipal()));
            renPayFeeInfo.setIntamt(renPayFeeInfo.getIntamt().add(diffRentPayInfo.getIntamt()));
        }
        return leaseFeeShares;
    }

    private static RenPayFeeInfo getDiffRentPayInfo(List<RenPayFeeInfo> payInfos, List<LeaseShareInfo> hasVoucherFeeshreInfos) {
        if (EmptyUtil.isEmpty(payInfos)) {
            return null;
        }
        RenPayFeeInfo info = new RenPayFeeInfo();
        for (RenPayFeeInfo payInfo : payInfos) {
            info.setRentamt(info.getRentamt().add(payInfo.getRentamt()));
            info.setPrincipal(info.getPrincipal().add(payInfo.getPrincipal()));
            info.setIntamt(info.getIntamt().add(payInfo.getIntamt()));
            info.setFeeamt(info.getFeeamt().add(payInfo.getFeeamt()));
        }
        List shareInfos = hasVoucherFeeshreInfos.parallelStream().filter(o -> EmptyUtil.isNoEmpty((BigDecimal)o.getRentamt())).collect(Collectors.toList());
        for (LeaseShareInfo shareInfo : shareInfos) {
            info.setRentamt(info.getRentamt().subtract(shareInfo.getRentamt()));
            info.setPrincipal(info.getPrincipal().subtract(shareInfo.getPrincipal()));
            info.setIntamt(info.getIntamt().subtract(shareInfo.getIntamt()));
            info.setFeeamt(info.getFeeamt().subtract(shareInfo.getCurfeeamt()));
        }
        return info;
    }

    private static BigDecimal getSuretyAmount(long bizId) {
        DynamicObject suretyBill = LeaseFeeShareHelper.loadSuretyBillByDebit(bizId);
        if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) {
            return BigDecimal.ZERO;
        }
        return suretyBill.getBigDecimal("amount");
    }

    public static DynamicObject loadSuretyBillByDebit(Long debitId) {
        QFilter qFilter = new QFilter("entry.debtbillid", "=", (Object)debitId);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)"amount", (QFilter[])new QFilter[]{qFilter});
    }

    public static Set<Long> getVoucherBills(Set<Long> billIds, String billType) {
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("sourcebillid", "in", billIds);
        DynamicObjectCollection daps = QueryServiceHelper.query((String)"ai_daptracker", (String)"id,sourcebillid", (QFilter[])new QFilter[]{filter});
        return daps.parallelStream().map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
    }

    private static BigDecimal getMinAmt(int amtPrecision) {
        BigDecimal mixAmt = new BigDecimal("1");
        return mixAmt.movePointLeft(amtPrecision);
    }
}

