/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentbillHelper {
    public static void cancelReturnGuaranteeUse(DynamicObject[] repayBills) {
        ArrayList<GuaranteeUseReturnBean> returnGuList = new ArrayList<GuaranteeUseReturnBean>(repayBills.length);
        for (DynamicObject repayBill : repayBills) {
            Long lgId = repayBill.getLong("id");
            String billtype = repayBill.getDataEntityType().getName();
            GuaranteeUseReturnBean returnBean = new GuaranteeUseReturnBean();
            returnBean.setReturnBillId(lgId);
            returnBean.setReturnBillType(billtype);
            returnGuList.add(returnBean);
        }
        GuaranteeUseHelper.cancelReturnGuaranteeUse(returnGuList);
    }

    public static void batchCancelReturnCreditLimit(DynamicObject repayBill) {
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>();
        RepaymentbillHelper.buildCreditParamCfm(repayBill, paramList);
        if (paramList.size() > 0) {
            CreditLimitServiceHelper.batchCancelReturnCreditLimit(paramList);
        }
    }

    private static void buildCreditParamCfm(DynamicObject repayBill, List<ReturnCreditLimitInfo> paramList) {
        DynamicObjectCollection entrys = repayBill.getDynamicObjectCollection("loans");
        Set loanIds = entrys.stream().map(o -> o.getDynamicObject("e_loanbill").getPkValue()).collect(Collectors.toSet());
        DynamicObject[] LoanBills = TmcDataServiceHelper.load((String)"fl_receiptbill", (String)String.join((CharSequence)",", "id", "creditlimit", "datasource", "loancontractbill", "banksyndicate_entry", "banksyndicate_entry.e_bankcreditlimit", "banksyndicate_entry.e_shareamount", "drawamount", "currency", "productfactory", "productfactory.isloancommit"), (QFilter[])new QFilter[]{new QFilter("id", "in", loanIds)});
        Set<Object> contractIds = Arrays.stream(LoanBills).filter(o -> EmptyUtil.isEmpty((Object)o.get("creditlimit"))).map(t -> t.getDynamicObject("loancontractbill").getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> contractMap = RepaymentbillHelper.getContractMap(contractIds);
        Long id = null;
        String entityName = null;
        for (DynamicObject loanBill : LoanBills) {
            boolean isReturn = false;
            if (EmptyUtil.isNoEmpty((Object)loanBill.get("creditlimit"))) {
                isReturn = true;
                entityName = "fl_receiptbill";
                id = loanBill.getLong("id");
            } else {
                long loanContract = loanBill.getDynamicObject("loancontractbill").getLong("id");
                if (EmptyUtil.isNoEmpty((Long)loanContract)) {
                    DynamicObject contract = contractMap.get(loanContract);
                    if (EmptyUtil.isNoEmpty((DynamicObject)contract.getDynamicObject("creditlimit"))) {
                        isReturn = true;
                    } else {
                        DynamicObjectCollection bankSyndicateEntry = contract.getDynamicObjectCollection("banksyndicate_entry");
                        List entryCredList = bankSyndicateEntry.stream().filter(o -> o.getDynamicObject("e_creditlimit") != null).collect(Collectors.toList());
                        if (EmptyUtil.isNoEmpty(entryCredList)) {
                            isReturn = true;
                        }
                    }
                    entityName = "fl_leasecontractbill";
                    id = contract.getLong("id");
                }
            }
            DynamicObjectCollection bankSyndicateEntry = loanBill.getDynamicObjectCollection("banksyndicate_entry");
            List entryCredList = bankSyndicateEntry.stream().filter(o -> o.getDynamicObject("e_bankcreditlimit") != null).collect(Collectors.toList());
            if (!isReturn && EmptyUtil.isNoEmpty(entryCredList)) {
                isReturn = true;
                id = loanBill.getLong("id");
                entityName = "fl_receiptbill";
            }
            if (!isReturn) continue;
            ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
            param.setId(id);
            param.setEntityName(entityName);
            param.setPreOccupy(false);
            param.setReturnBillId(id);
            param.setBizBillId(Long.valueOf(repayBill.getLong("id")));
            paramList.add(param);
        }
    }

    private static Map<Long, DynamicObject> getContractMap(Set<Object> contractIds) {
        DynamicObject[] loanConArr;
        HashMap<Long, DynamicObject> loanConMap = new HashMap<Long, DynamicObject>(16);
        if (contractIds == null || contractIds.size() == 0) {
            return loanConMap;
        }
        for (DynamicObject loanCon : loanConArr = TmcDataServiceHelper.load((String)"fl_leasecontractbill", (String)String.join((CharSequence)",", "creditlimit", "notrepayamount", "notdrawamount", "e_shareamount", "e_creditlimit", "iscycleloan"), (QFilter[])new QFilter[]{new QFilter("ID", "in", contractIds)})) {
            loanConMap.put(loanCon.getLong("ID"), loanCon);
        }
        return loanConMap;
    }

    public static BigDecimal getNeedPayAmt(DynamicObject dataEntity) {
        BigDecimal repayAmt = dataEntity.getBigDecimal("amount");
        DynamicObjectCollection loans = dataEntity.getDynamicObjectCollection("loans");
        BigDecimal intAmt = loans.stream().filter(o -> o.getBoolean("e_ispayinst") && o.getBoolean("e_combineinst")).map(o -> o.getBigDecimal("e_actintamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return repayAmt.add(intAmt).subtract(RepaymentbillHelper.getSuretyRepayAmt(dataEntity));
    }

    private static BigDecimal getSuretyRepayAmt(DynamicObject dataEntity) {
        DynamicObjectCollection suretyEntries = null;
        BigDecimal suretyRepayAmt = BigDecimal.ZERO;
        suretyEntries = dataEntity.getDynamicObjectCollection("entry_surety");
        if (dataEntity.getBoolean("issuretyrepay") && EmptyUtil.isNoEmpty((DynamicObjectCollection)suretyEntries)) {
            suretyRepayAmt = ((DynamicObject)suretyEntries.get(0)).getBigDecimal("suretyrepayamt");
        }
        return suretyRepayAmt;
    }
}

