/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.mservice.paywriteback;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;
import kd.tmc.fl.common.enums.ConfirmStatusEnum;
import kd.tmc.fl.mservice.resource.FlMseResourceEnum;

public class ReceiptBillWritebackService
extends AbstractRecBillWriteBackService {
    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        if (!BillStatusEnum.isAudit((String)sourceBill.getString("billstatus"))) {
            throw new KDBizException(FlMseResourceEnum.ReceiptBillWritebackService_0.loadKDString(sourceBill.getString("billno")));
        }
        if (EmptyUtil.isNoEmpty((Object)sourceBill.get("eassrcid"))) {
            throw new KDBizException(FlMseResourceEnum.ReceiptBillWritebackService_1.loadKDString(sourceBill.getString("billno")));
        }
        if (!sourceBill.getBoolean("isrelcash")) {
            throw new KDBizException(FlMseResourceEnum.ReceiptBillWritebackService_2.loadKDString(sourceBill.getString("billno")));
        }
        if (!ConfirmStatusEnum.isYetconfirm((String)sourceBill.getString("confirmstatus"))) {
            throw new KDBizException(FlMseResourceEnum.ReceiptBillWritebackService_3.loadKDString(sourceBill.getString("billno")));
        }
        if (sourceBill.getBoolean("isinit")) {
            throw new KDBizException(FlMseResourceEnum.ReceiptBillWritebackService_4.loadKDString(sourceBill.getString("billno")));
        }
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("payeebillno", (Object)param.getRecBill().getRecBillNo());
        sourceBill.set("recvbill", (Object)param.getRecBill().getRecBillId());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveExecute(param, sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("payeebillno", (Object)"");
        sourceBill.set("recvbill", null);
        this.DBTxBizUpdate(sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        DynamicObject sourceBill = TmcDataServiceHelper.loadSingle((String)"fl_receiptbill", (String)"billno,billstatus,eassrcid,currency,drawamount,eassrcid,isrelcash,confirmstatus,isinit,recvbill,payeebillno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)param.getRecBill().getSourceBillId())});
        return sourceBill;
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("drawamount");
    }
}

