/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.mservice.paywriteback;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;
import kd.tmc.fl.common.helper.RepaymentbillHelper;

public class RentPayBillPayBillWriteBackService
extends AbstractPayBillWriteBackService {
    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject rentPayBill) {
        this.addForwardValid(rentPayBill);
        super.doSaveValidateExecute(param, rentPayBill);
        this.addDefineOpValid(param, rentPayBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject rentPayBill) {
        this.writeBackBizDeal(param, rentPayBill);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.writeBackBizDeal(param, sourceBill);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject rentPayBill) {
        this.reserveWriteBackBizDeal(rentPayBill);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject rentPayBill) {
        this.reserveWriteBackBizDeal(rentPayBill);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject rentPayBill) {
        this.reserveWriteBackBizDeal(rentPayBill);
    }

    private void writeBackBizDeal(PayBillWriteBackParam param, DynamicObject rentPayBill) {
        PayBillWriteBackParam.PayBillInfo payBillInfo = param.getPayBill();
        rentPayBill.set("paybillno", (Object)payBillInfo.getPayBillNo());
        rentPayBill.set("paybill", (Object)payBillInfo.getPayBillId());
        rentPayBill.set("lockpayamt", (Object)payBillInfo.getAmount());
        this.DBTxBizUpdate(rentPayBill);
    }

    private void reserveWriteBackBizDeal(DynamicObject rentPayBill) {
        rentPayBill.set("paybillno", (Object)"");
        rentPayBill.set("paybill", null);
        rentPayBill.set("lockpayamt", (Object)BigDecimal.ZERO);
        this.DBTxBizUpdate(rentPayBill);
    }

    private void addForwardValid(DynamicObject rentPayBill) {
        if (!rentPayBill.getBoolean("isrelcash")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u4ea7\u751f\u73b0\u91d1\u6d41\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"RentPayBillPayBillWriteBackService_0", (String)"tmc-fl-mservice", (Object[])new Object[0]));
        }
        if (rentPayBill.getBoolean("isinit")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5355\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"RentPayBillPayBillWriteBackService_1", (String)"tmc-fl-mservice", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((String)rentPayBill.getString("eassrcid"))) {
            throw new KDBizException(ResManager.loadKDString((String)"EAS\u5347\u7ea7\u8fc7\u6765\u7684\u6570\u636e\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"RentPayBillPayBillWriteBackService_2", (String)"tmc-fl-mservice", (Object[])new Object[0]));
        }
    }

    private void addDefineOpValid(PayBillWriteBackParam param, DynamicObject rentPayBill) {
        DynamicObjectCollection loans = rentPayBill.getDynamicObjectCollection("loans");
        for (int i = 0; i < loans.size(); ++i) {
            DynamicObject instBill;
            BigDecimal downPayAmt;
            QFilter instFilter;
            DynamicObjectCollection instBills;
            DynamicObject entry = (DynamicObject)loans.get(i);
            if (!entry.getBoolean("e_ispayinst") || EmptyUtil.isEmpty((DynamicObjectCollection)(instBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id,billno", (QFilter[])(instFilter = new QFilter("sourcebillid", "=", entry.getDynamicObject("e_loanbill").getPkValue()).and(new QFilter("repaymentid", "=", rentPayBill.getPkValue()))).toArray()))) || !EmptyUtil.isNoEmpty((BigDecimal)(downPayAmt = this.getPayTotalLockAmt((instBill = (DynamicObject)instBills.get(0)).getLong("id")))) || !entry.getBoolean("e_combineinst")) continue;
            PayBillWriteBackOperateEnum operateEnum = PayBillWriteBackOperateEnum.getByValue((String)param.getOperate());
            String operateName = operateEnum != null ? operateEnum.getBridge().loadKDString() : param.getOperate();
            String billNo = rentPayBill.getString("billno");
            String error = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: \u8be5\u4e0a\u6e38\u5bf9\u5e94\u7684\u8fd8\u6b3e\u5355:[%2$s]\u7684\u63d0\u6b3e\u4fe1\u606f\u5206\u5f55\u4e2d\u7684\u7b2c[%3$s]\u884c\u5df2\u7ecf\u52fe\u9009\u4ed8\u606f,\u5e76\u5bf9\u5e94\u7684\u4ed8\u606f\u5355[%4$s]\u5df2\u7ecf\u751f\u6210\u4ed8\u6b3e\u5355,\u4e0d\u80fd\u518d\u52fe\u9009\u5408\u5e76\u5229\u606f\u3002", (String)"RentPayBillPayBillWriteBackService_3", (String)"tmc-fl-mservice", (Object[])new Object[0]), operateName, billNo, i + 1, instBill.getString("billno"));
            throw new KDBizException(error);
        }
    }

    private BigDecimal getPayTotalLockAmt(Long id) {
        Object[] targetBillIds = TmcBotpHelper.getTargetBillIds((String)"cfm_interestbill", (Object)id, (String)"cas_paybill");
        if (EmptyUtil.isEmpty((Object[])targetBillIds)) {
            return BigDecimal.ZERO;
        }
        QFilter filter = new QFilter("id", "in", (Object)targetBillIds).and("billstatus", "not in", Arrays.asList("G", "F"));
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"actpayamt", (QFilter[])filter.toArray());
        return payBills.stream().map(p -> p.getBigDecimal("actpayamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"fl_rentpaybill", (String)"id,isrelcash,isinit,eassrcid,billno,amount,needpayamt,currency,bizdate,paybillno,paybill,lockpayamt,loans,loans.e_ispayinst,loans.e_actintamt,loans.e_combineinst,loans.e_loanbill,issuretyrepay,entry_surety,entry_surety.suretyrepayamt");
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return RepaymentbillHelper.getNeedPayAmt((DynamicObject)sourceBill);
    }
}

