/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.cache.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.cache.ICacheRepository;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;

@Deprecated
public class PageBookCacheImpl
implements ICacheRepository,
Serializable {
    private static final Log logger = LogFactory.getLog(PageBookCacheImpl.class);
    private String pageId;
    private String pageName;
    private String pageDimInx;
    private String callMethod;
    private Set<String> redisKeys;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("FPM.PAGEBOOKCACHE");

    public PageBookCacheImpl(String pageId, String pageName, String callMethod, List<Long> pageDimIds) {
        this.pageId = pageId;
        this.pageName = pageName;
        this.callMethod = callMethod;
        this.pageDimInx = this.getPageDimMarkStr(pageDimIds);
        this.redisKeys = new HashSet<String>(10);
    }

    public PageBookCacheImpl() {
    }

    public void bufferBook(Book book) {
        List cells = book.getSheet().getCellList();
        this.bufferCells(cells);
    }

    public void updateBook(List<Cell> updateCells) {
        Map<Integer, List<Cell>> cellByRowMap = updateCells.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(c -> c.getRow()));
        Set<Map.Entry<Integer, List<Cell>>> entries = cellByRowMap.entrySet();
        for (Map.Entry<Integer, List<Cell>> entry : entries) {
            String redisKey = this.getRedisKey(this.pageId, this.pageDimInx, String.format("%s.row.key", entry.getKey()));
            String rowCellJson = this.getCacheField(redisKey);
            List originCells = FpmSerializeUtil.deserializeList((String)rowCellJson, Cell.class);
            originCells.removeAll((Collection)entry.getValue());
            originCells.addAll((Collection)entry.getValue());
            this.setRedisCache(redisKey, FpmSerializeUtil.serialize((Object)originCells));
        }
        cache.addToSet(this.getRedisKeysCacheKey(this.pageId), this.redisKeys.toArray(new String[0]));
    }

    private String getCacheField(String redisKey) {
        return (String)cache.get(redisKey);
    }

    public Book getBookFormCache() {
        Sheet sheet = new Sheet();
        sheet.setCellList(this.getAllCellFormBook());
        Book book = new Book();
        book.setSheetList(Collections.singletonList(sheet));
        return book;
    }

    public List<Cell> getAllCellFormBook() {
        String allRowRedisKeyJson = (String)cache.get(this.getRedisKey(this.pageId, this.pageDimInx, "all.row.key"));
        cache.addToSet(this.getRedisKeysCacheKey(this.pageId), this.redisKeys.toArray(new String[0]));
        if (EmptyUtil.isEmpty((String)allRowRedisKeyJson)) {
            return null;
        }
        List allRowRedisKeys = FpmSerializeUtil.deserializeList((String)allRowRedisKeyJson, String.class);
        ArrayList<Cell> reportTableCellLst = new ArrayList<Cell>(10);
        for (String allRowRedisKey : allRowRedisKeys) {
            String rowCellsJson = this.getCacheField(allRowRedisKey);
            List cells = FpmSerializeUtil.deserializeList((String)rowCellsJson, Cell.class);
            if (!EmptyUtil.isNoEmpty((Object)cells)) continue;
            reportTableCellLst.addAll(cells);
        }
        return reportTableCellLst;
    }

    public List<Cell> getRowCells(int row) {
        String rowRedisKey = this.getRedisKey(this.pageId, this.pageDimInx, String.format("%s.row.key", row));
        cache.addToSet(this.getRedisKeysCacheKey(this.pageId), this.redisKeys.toArray(new String[0]));
        String cellByRowJson = (String)cache.get(rowRedisKey);
        List cells = FpmSerializeUtil.deserializeList((String)cellByRowJson, Cell.class);
        return cells;
    }

    public Cell getCellByRowAndCol(int row, int col) {
        List<Cell> cells = this.getRowCells(row);
        if (EmptyUtil.isEmpty(cells)) {
            return null;
        }
        Optional<Cell> opCell = cells.stream().filter(Objects::nonNull).filter(c -> c.getCol() == col).findFirst();
        return opCell.map(o -> o).orElseGet(() -> null);
    }

    private String getPageDimMarkStr(List<Long> pageDimIds) {
        return pageDimIds.stream().filter(Objects::nonNull).map(o -> o.toString()).collect(Collectors.joining("_"));
    }

    private void bufferCells(List<Cell> cells) {
        Map<Integer, List<Cell>> groupCellByRow = cells.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(cell -> cell.getRow()));
        Set<Map.Entry<Integer, List<Cell>>> cellByRowEntries = groupCellByRow.entrySet();
        ArrayList<String> rowRedisKeys = new ArrayList<String>(cellByRowEntries.size());
        for (Map.Entry<Integer, List<Cell>> cellByRowEntry : cellByRowEntries) {
            String rowRedisKey = this.getRedisKey(this.pageId, this.pageDimInx, String.format("%s.row.key", cellByRowEntry.getKey()));
            rowRedisKeys.add(rowRedisKey);
            this.setRedisCache(rowRedisKey, FpmSerializeUtil.serialize(cellByRowEntry.getValue()));
        }
        String allRowRedisKey = this.getRedisKey(this.pageId, this.pageDimInx, "all.row.key");
        cache.addToSet(this.getRedisKeysCacheKey(this.pageId), this.redisKeys.toArray(new String[0]));
        this.setRedisCache(allRowRedisKey, FpmSerializeUtil.serialize(rowRedisKeys));
    }

    @Override
    public void setRedisCache(String redisKey, String data) {
        cache.remove(redisKey);
        cache.put(redisKey, (Object)data, CacheKeyUtil.getPageCacheKeyTimeout());
    }

    @Override
    public void destroy() {
        String[] keyS = cache.getSetValues(this.getRedisKeysCacheKey(this.pageId));
        cache.remove(keyS);
        logger.info(String.format("%s \u9875\u9762\u7f13\u5b58\u8fdb\u884c\u91ca\u653e\uff0c\u5171\u91ca\u653ekey\u4e2a\u6570\u4e3a %s\uff0c\u53c2\u6570\u5982\u4e0b\uff1a\n {pageId=%s, redisKeys=%s, date=%s}", this.pageName, this.redisKeys.size(), this.pageId, this.redisKeys, DateUtils.getDate((String)"yyyy-MM-dd HH:mm:ss")));
    }

    @Override
    public String getRedisKey(String pageId, String inx, String mark) {
        String redisKey = ICacheRepository.super.getRedisKey(pageId, inx, mark);
        this.redisKeys.add(redisKey);
        return redisKey;
    }

    private String getRedisKeysCacheKey(String pageId) {
        return String.format("%s.fpm.report.%s.rks.cache", CacheKeyUtil.getAcctId(), pageId);
    }
}

