/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.formplugin.basesetting.ControlWayConfigEdit;
import org.apache.commons.collections.CollectionUtils;

public class BatchSetEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDetailControlBasis();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                this.returnDataToParent();
                break;
            }
        }
    }

    private void returnDataToParent() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)dynamicObject));
        this.getView().invokeOperation("close");
    }

    private void initDetailControlBasis() {
        List dimensionList;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long bodySysPkValue = (Long)formShowParameter.getCustomParam("bodysys");
        if (EmptyUtil.isEmpty((Long)bodySysPkValue)) {
            return;
        }
        DimensionRepository dimensionRepository = new DimensionRepository();
        FundPlanSystem fundPlanSystem = dimensionRepository.loadSystem(bodySysPkValue.longValue());
        if (fundPlanSystem == null || CollectionUtils.isEmpty((Collection)(dimensionList = fundPlanSystem.getDimList()))) {
            return;
        }
        ComboEdit detailControlBasis = (ComboEdit)this.getControl("detailcontrolbasis");
        ArrayList<ComboItem> detailControlBasisComboItemList = new ArrayList<ComboItem>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            MemberType memberType;
            DimensionType dimType = dimension.getDimType();
            if (ControlWayConfigEdit.RULE_OUT_DIMENSION_TYPE.contains(dimType) || dimType.isMetric() || dimType == DimensionType.DETAILDIM && (!dimension.isVisible() || (memberType = dimension.getMemberType()) == MemberType.AMOUNT || memberType == MemberType.DATE)) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(dimension.getName()));
            comboItem.setValue(this.getValue(dimension));
            detailControlBasisComboItemList.add(comboItem);
        }
        detailControlBasis.setComboItems(detailControlBasisComboItemList);
    }

    private String getValue(Dimension dimension) {
        DimensionType dimType = dimension.getDimType();
        StringBuilder sb = new StringBuilder();
        if (DimensionType.DETAILDIM != dimType) {
            sb.append(dimType.getNumber()).append("#").append(dimension.getId());
        } else {
            sb.append(dimension.getDetailDimType().getNumber()).append("#").append(dimension.getId());
        }
        return sb.toString();
    }
}

