/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.IBodySysImportService;
import kd.tmc.fpm.business.task.SystemImportTask;
import kd.tmc.fpm.business.task.result.TaskResult;
import kd.tmc.fpm.formplugin.helper.JobFormInfoHelper;
import org.apache.commons.lang3.StringUtils;

public class BodySysImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String UPLOAD_FILE_NAME = "uploadFileName";
    public static final String BTN_OK = "btnok";
    public static final String ATTACHMENT_PANEL_AP = "attachmentpanelap";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (!Objects.equals(BTN_OK, operateKey)) {
            return;
        }
        if (Objects.isNull(operationResult) || !operationResult.isSuccess()) {
            return;
        }
        String uploadFileName = this.getPageCache().get(UPLOAD_FILE_NAME);
        if (StringUtils.isEmpty((CharSequence)uploadFileName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"BodySysImportPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
        JobFormInfoHelper.dispatch(JobFormInfoHelper.getJobFormInfoParam().setFormView(this.getView()).setTaskClassName(SystemImportTask.class.getName()).setName(ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u5165\u8c03\u5ea6\u4efb\u52a1", (String)"BodySysImportPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).setCaption(ResManager.loadKDString((String)"\u6267\u884c\u4f53\u5bfc\u5165\u8c03\u5ea6\u4efb\u52a1", (String)"BodySysImportPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).addParam(UPLOAD_FILE_NAME, uploadFileName).setCloseCallBack(new CloseCallBack((IFormPlugin)this, UPLOAD_FILE_NAME)));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        TaskResult taskResult = JobFormInfoHelper.parseTaskResult(returnData);
        if (taskResult == null) {
            return;
        }
        if (!taskResult.isSuccess()) {
            this.getView().showErrorNotification(taskResult.getErrorMessage());
            return;
        }
        if (Objects.equals(actionId, UPLOAD_FILE_NAME)) {
            String message = (String)taskResult.getResultInfo("message", String.class);
            IBodySysImportService.Status status = IBodySysImportService.Status.getStatus((String)((String)taskResult.getResultInfo("status", String.class)));
            IListView parentView = (IListView)this.getView().getParentView();
            switch (status) {
                case SUCCESS: {
                    parentView.showSuccessNotification(message);
                    parentView.refresh();
                    this.getView().close();
                    break;
                }
                case SOME_SUCCESS: {
                    parentView.showTipNotification(message);
                    parentView.refresh();
                    this.getView().close();
                    break;
                }
                case FAILED: {
                    this.getView().showErrorNotification(message);
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attach = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL_AP);
        attach.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String uploadFileName = this.getPageCache().get(UPLOAD_FILE_NAME);
        List<String> urls = EmptyUtil.isNoEmpty((String)uploadFileName) ? (List)SerializationUtils.fromJsonString((String)uploadFileName, List.class) : new ArrayList(2);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (EmptyUtil.isNoEmpty(urls)) {
            this.getPageCache().put(UPLOAD_FILE_NAME, SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String uploadFileName = this.getPageCache().get(UPLOAD_FILE_NAME);
        if (EmptyUtil.isEmpty((String)uploadFileName)) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)uploadFileName, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put(UPLOAD_FILE_NAME, SerializationUtils.toJsonString((Object)urls));
    }
}

