/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ControlContext;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.bean.UserAuthModel;
import kd.tmc.fpm.common.enums.ControlIntensityEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.formplugin.basesetting.FpmBaseFilterPlugin;
import kd.tmc.fpm.utils.control.ControlWayUtil;
import kd.tmc.fpm.utils.system.DefaultModelHelper;

public class ControlWayConfigList
extends FpmBaseFilterPlugin {
    private static final String CONTROL_WAY_CONFIG_LIST_TOOLBAR_NEW = "new";
    private static final String CONTROL_WAY_CONFIG_LIST_TOOLBAR_COPY = "copy";
    private static final String CONTROL_WAY_CONFIG_LIST_TOOLBAR_ENABLE = "enable";
    private static final String CONTROL_WAY_CONFIG_LIST_INIT = "CONTROL_WAY_CONFIG_LIST_INIT";
    private static final String CONTROL_WAY_CONFIG_LIST_TREE_ENTITY = "CONTROL_WAY_CONFIG_LIST_TREE_ENTITY";
    private static final String FROM_FILTER = "FROM_FILTER";

    @Override
    protected String getBodySystemProp() {
        return "bodysys";
    }

    public void setFilter(SetFilterEvent e) {
        String property;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Optional<QFilter> first = qFilters.stream().filter(i -> i.getProperty().startsWith("bodysys")).findFirst();
        Long bodySysId = 0L;
        QFilter bodySysFilter = first.orElse(null);
        if (Objects.nonNull(bodySysFilter) && StringUtils.equals((CharSequence)(property = bodySysFilter.getProperty()), (CharSequence)"bodysys.id")) {
            this.getPageCache().put("CONTROL_WAY_CONFIG_BODY_SYS_ID_KEY", bodySysFilter.getValue().toString());
            bodySysId = Long.parseLong(bodySysFilter.getValue().toString());
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        UserAuthModel userAuthModel = ModelHelper.getAuthScopeModelWithCheckManager((String)appId, (String)"fpm_controlwayconfig");
        List systemIds = userAuthModel.getSystemIds();
        List orgIds = userAuthModel.getOrgIds();
        BillList source = (BillList)e.getSource();
        ControlContext context = source.getContext();
        QFilter notAuth = new QFilter("1", "=", (Object)1);
        if (!NumberUtils.equalsZero((Long)bodySysId)) {
            boolean notContains;
            boolean bl = notContains = !systemIds.contains(bodySysId);
            if (notContains) {
                notAuth = new QFilter("1", "!=", (Object)1);
            }
        }
        QFilter orgFilter = new QFilter("entryentity.entry_reportorg", "is null", null).or(new QFilter("entryentity.entry_reportorg", "in", (Object)orgIds));
        notAuth.and(orgFilter);
        String entryEntity = context.getEntryEntity();
        if (StringUtils.equals((CharSequence)this.getPageCache().get(FROM_FILTER), (CharSequence)"N")) {
            entryEntity = StringUtils.equals((CharSequence)this.getPageCache().get(CONTROL_WAY_CONFIG_LIST_TREE_ENTITY), (CharSequence)"Y") ? "treeentryentity" : entryEntity;
        }
        this.getPageCache().put(FROM_FILTER, "N");
        if (StringUtils.equals((CharSequence)entryEntity, (CharSequence)"treeentryentity")) {
            this.getPageCache().put(CONTROL_WAY_CONFIG_LIST_TREE_ENTITY, "Y");
            notAuth.and(new QFilter("treeentryentity.entry_controlintensity", "=", (Object)ControlIntensityEnum.RIGID.getValue()));
        } else {
            this.getPageCache().put(CONTROL_WAY_CONFIG_LIST_TREE_ENTITY, "N");
        }
        qFilters.add(notAuth);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                this.checkBodySysIfNeedCancel(args);
                break;
            }
            case "copy": {
                this.setCopyId();
                break;
            }
            case "enable": {
                if (this.getSelectedRows().size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u542f\u7528\u3002", (String)"ControlWayConfigList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                ListSelectedRow listSelectedRow = this.getSelectedRows().get(0);
                Tuple<Boolean, String> checkBeforeEnable = ControlWayUtil.checkBeforeEnable(listSelectedRow.getPrimaryKeyValue());
                if (((Boolean)checkBeforeEnable.item1).booleanValue()) break;
                this.getView().showConfirm("", (String)checkBeforeEnable.item2, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("save", (IFormPlugin)this));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (callBackId.equals("save")) {
            this.disableThenEnable(result);
        }
    }

    private void disableThenEnable(MessageBoxResult result) {
        if (MessageBoxResult.No.equals((Object)result)) {
            return;
        }
        ListSelectedRow listSelectedRow = this.getSelectedRows().get(0);
        List<Object> needDisablePkIdList = ControlWayUtil.getNeedDisablePkIdList(listSelectedRow.getPrimaryKeyValue());
        OperationResult disable = TmcOperateServiceHelper.execOperate((String)"disable", (String)"fpm_controlwayconfig", (Object[])needDisablePkIdList.toArray(), (OperateOption)OperateOption.create());
        if (disable.isSuccess()) {
            this.getView().invokeOperation(CONTROL_WAY_CONFIG_LIST_TOOLBAR_ENABLE);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterContainerInitEvent filterContainerInitEvent = args.getFilterContainerInitEvent();
        FilterContainer source = (FilterContainer)filterContainerInitEvent.getSource();
        ControlContext context = source.getContext();
        String initFlag = this.getPageCache().get(CONTROL_WAY_CONFIG_LIST_INIT);
        if (StringUtils.isBlank((CharSequence)initFlag)) {
            context.setEntryEntity("fpm_controlwayconfig");
            this.getPageCache().put(CONTROL_WAY_CONFIG_LIST_INIT, "N");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.getPageCache().put(FROM_FILTER, "Y");
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        this.currModelId = this.getPageCache().get("currModelId");
        if (fieldName.startsWith("bodysys")) {
            String appId = this.getView().getFormShowParameter().getAppId();
            List systemIds = ModelHelper.getSystemAuthScopeWithCheckManager((String)appId, (String)"fpm_controlwayconfig");
            args.getQfilters().addAll(Collections.singleton(new QFilter("id", "in", (Object)systemIds).and(new QFilter(CONTROL_WAY_CONFIG_LIST_TOOLBAR_ENABLE, "=", (Object)"1"))));
        } else if (fieldName.startsWith("reporttype") && EmptyUtil.isNoEmpty((Object)this.currModelId)) {
            DynamicObject bodySys = FpmDataServiceHelper.getBodySystemByCache((Long)Long.parseLong(this.currModelId.toString()));
            List reportTypeIdList = bodySys.getDynamicObjectCollection("applyrereportentry").stream().filter(dynamicObject -> StringUtils.equals((CharSequence)CONTROL_WAY_CONFIG_LIST_TOOLBAR_ENABLE, (CharSequence)dynamicObject.getString("rereporttypestatus"))).map(dynamicObject -> dynamicObject.getDynamicObject("rerporttype")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            args.getQfilters().addAll(Collections.singleton(new QFilter("id", "in", reportTypeIdList)));
        }
    }

    @Override
    protected List<ComboItem> initModelItemsList() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        List systemIds = ModelHelper.getSystemAuthScopeWithCheckManager((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_controlwayconfig");
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)systemIds)}, (String)"number");
        if (!CollectionUtils.isEmpty((Collection)colls)) {
            for (DynamicObject model : colls) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(model.getString("name")));
                item.setValue(model.getString("id"));
                items.add(item);
            }
        }
        return items;
    }

    @Override
    protected void initFilterItem(FilterContainerInitArgs args) {
        Long systemId;
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        FilterColumn systemColumn = filterColumns.stream().filter(f -> f.getFieldName().startsWith("bodysys")).findFirst().orElse(null);
        if (systemColumn != null && EmptyUtil.isEmpty((Object)this.currModelId) && EmptyUtil.isNoEmpty((Long)(systemId = DefaultModelHelper.getAnalysisReportDefaultSystemId(this.getView().getFormShowParameter().getAppId(), "fpm_controlwayconfig")))) {
            this.currModelId = systemId;
            this.getPageCache().put("currModelId", this.currModelId.toString());
            systemColumn.setDefaultValue(this.currModelId.toString());
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith("bodysys")) {
                if (this.currModelId != null) {
                    commonFilterColumn.setDefaultValue(this.currModelId.toString());
                }
                commonFilterColumn.setComboItems(this.initModelItemsList());
            }
            if (!fieldName.startsWith("reporttype")) continue;
            commonFilterColumn.setDefaultValue("");
            if (this.currModelId != null) {
                DynamicObject bodySys = FpmDataServiceHelper.getBodySystemByCache((Long)Long.parseLong(this.currModelId.toString()));
                List comboItems = bodySys.getDynamicObjectCollection("applyrereportentry").stream().filter(dynamicObject -> StringUtils.equals((CharSequence)CONTROL_WAY_CONFIG_LIST_TOOLBAR_ENABLE, (CharSequence)dynamicObject.getString("rereporttypestatus"))).map(dynamicObject -> {
                    ComboItem comboItem = new ComboItem();
                    DynamicObject reportType = dynamicObject.getDynamicObject("rerporttype");
                    comboItem.setValue(reportType.getPkValue().toString());
                    comboItem.setCaption(new LocaleString(reportType.getString("name")));
                    return comboItem;
                }).collect(Collectors.toList());
                commonFilterColumn.setComboItems(comboItems);
                continue;
            }
            commonFilterColumn.setComboItems(new ArrayList());
            return;
        }
    }

    private void checkBodySysIfNeedCancel(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String modelId = this.getPageCache().get("CONTROL_WAY_CONFIG_BODY_SYS_ID_KEY");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ControlWayConfigList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            beforeDoOperationEventArgs.setCancel(true);
        }
    }

    private void setCopyId() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow currentSelectedRowInfo = listView.getCurrentSelectedRowInfo();
        this.getPageCache().put("COPY_ID", currentSelectedRowInfo.getPrimaryKeyValue().toString());
    }
}

