/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListCache;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.utils.system.DefaultModelHelper;

public class FpmBaseFilterPlugin
extends AbstractTmcDyncListPlugin {
    private FilterContainerInitArgs initArgs;
    protected Object currModelId = null;
    protected static final String FILTER_MODE = "filterMode";
    protected static final String INIT_FLAG = "init";
    protected static final String INIT_FLAG_TRUE = "true";
    protected static final String BILL_FORM_ID_KEY = "billFormId";
    protected static final String CURRENT_MODEL_ID_KEY = "currModelId";
    protected static final String DEFAULT_CURRENCY_PROPERTY = "currency";
    protected static final String DEFAULT_DIMENSION_PROPERTY = "dimension";
    protected static final String AUTH_BODY_SYSTEM_IDS = "authBodySystemIds";

    protected void fillPageData() {
    }

    protected String getBodySystemProp() {
        String billFormId = ((IListView)this.getView()).getBillFormId();
        if (Arrays.asList("fpm_template", "fpm_template_analysis").contains(billFormId)) {
            return "model";
        }
        if ("fpm_matchrule".equals(billFormId)) {
            return "bodysys";
        }
        return null;
    }

    protected String getCurrencyProp() {
        return DEFAULT_CURRENCY_PROPERTY;
    }

    protected String getDimensionProp() {
        return DEFAULT_DIMENSION_PROPERTY;
    }

    protected String getEntityName() {
        return null;
    }

    public void filterContainerInit(FilterContainerInitEvent event) {
        FilterContainerInitArgs args;
        this.initArgs = args = new FilterContainerInitArgs(event);
        String filterMode = this.getFilterMode();
        if (!Objects.equals(this.getPageCache().get(FILTER_MODE), filterMode)) {
            this.getPageCache().remove(INIT_FLAG);
        }
        this.getPageCache().put(FILTER_MODE, filterMode);
        if (this.getPageCache().get(INIT_FLAG) == null) {
            this.getPageCache().put(INIT_FLAG, INIT_FLAG_TRUE);
            this.initFilterItem(args);
        }
    }

    protected void initFilterItem(FilterContainerInitArgs args) {
        String systemProp = this.getBodySystemProp();
        String currencyProp = this.getCurrencyProp();
        String dimensionProp = this.getDimensionProp();
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        FilterColumn systemColumn = filterColumns.stream().filter(f -> systemProp != null && f.getFieldName().startsWith(systemProp)).findFirst().orElse(null);
        if (systemColumn != null) {
            this.initAuthSystems();
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean lookUp = listShowParameter.isLookUp();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            ArrayList<QFilter> qFilterList;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (systemProp != null && fieldName.startsWith(systemProp)) {
                if (this.currModelId != null) {
                    if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("viewtype"), "f7")) {
                        return;
                    }
                    if (!lookUp) {
                        commonFilterColumn.setDefaultValue(this.currModelId.toString());
                    }
                }
                commonFilterColumn.setComboItems(this.initModelItemsList());
                continue;
            }
            if (fieldName.startsWith(dimensionProp)) {
                commonFilterColumn.setDefaultValue("");
                qFilterList = new ArrayList<QFilter>(2);
                qFilterList.add(new QFilter("enable", "=", (Object)"1"));
                if (this.currModelId == null) {
                    commonFilterColumn.setComboItems(new ArrayList());
                    return;
                }
                qFilterList.add(new QFilter(String.join((CharSequence)".", "bodysystem", "id"), "=", this.currModelId instanceof String ? Long.valueOf((String)this.currModelId) : this.currModelId));
                commonFilterColumn.setComboItems(this.initDimItemsList(qFilterList.toArray(new QFilter[0])));
                continue;
            }
            if (!fieldName.startsWith(currencyProp)) continue;
            commonFilterColumn.setDefaultValue("");
            qFilterList = new ArrayList(2);
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            if (this.currModelId == null) {
                commonFilterColumn.setComboItems(new ArrayList());
                return;
            }
            qFilterList.add(new QFilter("bodysystem.id", "=", (Object)Long.valueOf(this.currModelId.toString())));
            qFilterList.add(new QFilter("dimtype", "=", (Object)DimsionEnums.CURRENCY.getNumber()));
            commonFilterColumn.setComboItems(this.initMemberItemsList(qFilterList.toArray(new QFilter[0])));
        }
    }

    private void initAuthSystems() {
        List authModelIdList = ModelHelper.getAuthModelId();
        this.getPageCache().put(AUTH_BODY_SYSTEM_IDS, SerializationUtils.toJsonString((Object)authModelIdList));
        Long systemId = DefaultModelHelper.getDefaultSystemIfExist(authModelIdList);
        if (EmptyUtil.isNoEmpty((Long)systemId) && EmptyUtil.isEmpty((Object)this.currModelId)) {
            this.currModelId = systemId;
            this.getPageCache().put(CURRENT_MODEL_ID_KEY, this.currModelId.toString());
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        Map filterValue = event.getFilterValues();
        List customFilterList = filterValue.getOrDefault("customfilter", Collections.emptyList());
        String systemProp = this.getBodySystemProp();
        boolean systemIsChanged = Boolean.FALSE;
        String systemCache = this.getPageCache().get(CURRENT_MODEL_ID_KEY);
        for (Map map : customFilterList) {
            String value;
            String fieldName = ((List)map.get("FieldName")).size() > 0 ? ((List)map.get("FieldName")).get(0).toString() : "";
            String string = value = ((List)map.get("Value")).size() > 0 ? ((List)map.get("Value")).get(0).toString() : "";
            if (systemProp == null || !fieldName.startsWith(systemProp) || !EmptyUtil.isNoEmpty((String)value)) continue;
            if (!Objects.equals(value, systemCache)) {
                systemIsChanged = Boolean.TRUE;
            }
            this.currModelId = value;
            this.getPageCache().put(CURRENT_MODEL_ID_KEY, this.currModelId.toString());
            DefaultModelHelper.save(Long.valueOf(value));
        }
        if (systemIsChanged) {
            customFilterList.removeIf(t -> ((List)t.get("FieldName")).size() > 0 && ((List)t.get("FieldName")).get(0).toString().startsWith(this.getDimensionProp()));
        }
        this.initFilterItem(this.initArgs);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        ArrayList<QFilter> qFilterList;
        super.filterContainerBeforeF7Select(args);
        String systemProp = this.getBodySystemProp();
        String currencyProp = this.getCurrencyProp();
        String dimensionProp = this.getDimensionProp();
        this.currModelId = this.getPageCache().get(CURRENT_MODEL_ID_KEY);
        if (this.currModelId == null || StringUtils.isEmpty((Object)this.currModelId.toString())) {
            this.currModelId = "-1";
        }
        String fieldName = args.getFieldName();
        if (systemProp != null && fieldName.startsWith(systemProp)) {
            args.getQfilters().addAll(Collections.singleton(new QFilter("id", "in", this.getAuthBodySystemIds())));
        }
        if (fieldName.startsWith(dimensionProp)) {
            qFilterList = new ArrayList<QFilter>(2);
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            qFilterList.add(new QFilter(String.join((CharSequence)".", "bodysystem", "id"), "=", this.currModelId instanceof String ? Long.valueOf((String)this.currModelId) : this.currModelId));
            args.getQfilters().addAll(qFilterList);
        }
        if (fieldName.startsWith(currencyProp)) {
            qFilterList = new ArrayList(2);
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            qFilterList.add(new QFilter("bodysystem", "=", (Object)Long.valueOf(this.currModelId.toString())));
            qFilterList.add(new QFilter("dimtype", "=", (Object)DimsionEnums.CURRENCY.getNumber()));
            args.getQfilters().addAll(qFilterList);
        }
    }

    protected List<ComboItem> initModelItemsList() {
        String selectFields = String.join((CharSequence)",", "id", "name");
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)selectFields, (QFilter[])new QFilter("id", "in", this.getAuthBodySystemIds()).toArray(), (String)"number");
        return this.createComboItems((List<DynamicObject>)objColl);
    }

    private List<ComboItem> initDimItemsList(QFilter[] qFilterArr) {
        String selectFields = String.join((CharSequence)",", "id", "name", "basedata");
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)"fpm_dimension", (String)selectFields, (QFilter[])qFilterArr);
        List<DynamicObject> finalDataList = this.filterDimItemsList((List<DynamicObject>)objColl);
        return this.createComboItems(finalDataList);
    }

    protected List<ComboItem> initMemberItemsList(QFilter[] qFilterArr) {
        String selectFields = String.join((CharSequence)",", "id", "name");
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])qFilterArr);
        return this.createComboItems((List<DynamicObject>)objColl);
    }

    protected List<ComboItem> createComboItems(List<DynamicObject> objColl) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(objColl.size());
        for (DynamicObject obj : objColl) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(obj.getString("name")));
            item.setValue(obj.getString("id"));
            items.add(item);
        }
        return items;
    }

    protected List<DynamicObject> filterDimItemsList(List<DynamicObject> dbDataList) {
        return dbDataList;
    }

    protected String getFilterMode() {
        ListCache listCache = new ListCache(this.getPageCache());
        Integer filterMode = listCache.getFilterMode().orElse(-1);
        return String.valueOf(filterMode);
    }

    protected List<Long> getAuthBodySystemIds() {
        String systemIds = this.getPageCache().get(AUTH_BODY_SYSTEM_IDS);
        return EmptyUtil.isNoEmpty((String)systemIds) ? (List)SerializationUtils.fromJsonString((String)systemIds, List.class) : new ArrayList(10);
    }
}

