/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.EventObject;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.utils.StringUtils;

public class FpmProgressEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String PROGRESSBAR = "progressbarap";
    public static final String TASK_PERCENT = "task_percent";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR);
            bar.start();
        }
    }

    public void onProgress(ProgressEvent event) {
        String percent;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotBlank((String)(percent = parentView.getPageCache().get(TASK_PERCENT)))) {
            Integer percentInt = Integer.valueOf(percent);
            event.setProgress(percentInt.intValue());
            if (percentInt >= 100 || percentInt == -1) {
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && FpmProgressEdit.inprocess(parentView.getPageCache())) {
            e.setCancel(true);
        }
    }

    public static boolean inprocess(IPageCache pageCache) {
        Integer percentInt;
        String percent = pageCache.get(TASK_PERCENT);
        return StringUtils.isNotBlank((String)percent) && (percentInt = Integer.valueOf(percent)) < 100 && percentInt >= 0;
    }
}

