/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.helper.MatchRuleHelper;
import kd.tmc.fpm.business.mvc.converter.DimensionPOConverter;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MatchRuleConditionEnum;
import kd.tmc.fpm.common.enums.MatchRuleFetchPurposeEnum;
import kd.tmc.fpm.common.enums.MatchRuleLinkEntityEnum;
import kd.tmc.fpm.common.enums.MatchRuleMapRelationEnum;
import kd.tmc.fpm.common.enums.MatchRuleMatchPropEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import org.apache.commons.collections.CollectionUtils;

public class MatchRuleEdit
extends AbstractBasePlugIn {
    private static final String BUSINESS_BILL_FIELD_CACHE_KEY_OLD_VALUE = "BUSINESS_BILL_FIELD_CACHE_KEY_OLD_VALUE";
    private static final String BUSINESS_BILL_FIELD_CACHE_KEY_NEW_VALUE = "BUSINESS_BILL_FIELD_CACHE_KEY_NEW_VALUE";
    private static final String BUSINESS_BILL_FIELD_CHANGE_FLAG = "BUSINESS_BILL_FIELD_CHANGE_FLAG";
    private static final String BUSINESS_BILL_FIELD_CHANGE_FLAG_NO = "N";
    private static final String BUSINESS_BILL_FIELD_CHANGE_FLAG_YES = "Y";
    private static final Comparator<Dimension> DIMENSION_COMPARATOR = Comparator.comparing(DimensionInfoHelper::getScoreByDimensionType);
    private static final String PLAN_REPORT_RULE_DEFAULT_APPLY_COND = "{\"expression\":\"\",\"exprTran\":\"\u5e9f\u5f03\u72b6\u6001 \u7b49\u4e8e \u5426\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"4978T+5P+8KN\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"abandonstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4978T+5SLOFE\",\"value\":\"0\"}],\"baseDataIds\":[],\"lock\":false}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"4978T+5P+8KN\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"abandonstatus\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"4978T+5SLOFE\\\",\\\"value\\\":\\\"0\\\"}],\\\"baseDataIds\\\":[],\\\"lock\\\":false}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"\u5e9f\u5f03\u72b6\u6001 \u7b49\u4e8e \u5426\"},\"exprDesc\":\"\u5e9f\u5f03\u72b6\u6001 \u7b49\u4e8e \u5426\"}";
    private static final String SUPPLEMENT_DEFAULT_ABNORMAL_COND = "{\"expression\":\"\",\"exprTran\":\"\u4f53\u7cfb.\u540d\u79f0 \u4e0d\u7b49\u4e8e %s\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"4CO0LF94V15M\",\"leftBracket\":\"\",\"compareType\":\"83\",\"fieldName\":\"system.name\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"4CO0LF98GH0D\",\"value\":\"%s\"}],\"baseDataIds\":[{\"id\":\"4CO0LF98GGC4\",\"value\":\"%s\"}],\"lock\":false}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"4CO0LF94V15M\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"83\\\",\\\"fieldName\\\":\\\"system.name\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"4CO0LF98GH0D\\\",\\\"value\\\":\\\"%s\\\"}],\\\"baseDataIds\\\":[{\\\"id\\\":\\\"4CO0LF98GGC4\\\",\\\"value\\\":\\\"%s\\\"}],\\\"lock\\\":false}],\\\"forList\\\":false}\",\"initialized\":false,\"exprDesc\":\"\u4f53\u7cfb.\u540d\u79f0 \u4e0d\u7b49\u4e8e %s\",\"localeExprTran\":{\"zh_CN\":\"\u4f53\u7cfb.\u540d\u79f0 \u4e0d\u7b49\u4e8e %s\"}}";
    private MatchRuleHelper matchRuleHelper = new MatchRuleHelper();
    private static final String ENTITY_OBJECT_MODEL_TYPE = "modeltype";
    private static final String ENTITY_OBJECT_BILL_MODEL_TYPE = "BillFormModel";
    private static final String ENTITY_OBJECT_BILL_NUMBER = "number";
    private static final Map<String, Set<String>> SKIP_ENTRY;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initAndAddBeforeF7SelectListenerForF7Model();
        this.addClickListeners(new String[]{"abnormalcondition", "applycondition"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "entry_dimensionmembermap": {
                this.setDimensionMemberCallBack(closedCallBackEvent);
                break;
            }
            case "abnormalcondition_real": {
                this.receiveExpressionSet(closedCallBackEvent, MatchRuleConditionEnum.ABNORMAL_CONDITION);
                break;
            }
            case "applycondition_real": {
                this.receiveExpressionSet(closedCallBackEvent, MatchRuleConditionEnum.APPLY_CONDITION);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "bodysys": {
                this.grabDimensionOrDetailField(e);
                break;
            }
            case "businessbill": {
                this.changeAndResetBusinessBillFieldSelect(e);
                break;
            }
            case "linkentity": {
                this.resetAndChangeBusinessBillFieldSelect(e);
                break;
            }
            case "entry_businessbillfield": {
                this.resetDimensionMemberMap(e);
                this.checkMainAndSecondBusinessBillFileSame();
                this.checkMulitRowsMainOrSecondBusinessBillFieldSame(e);
                Dimension currentDimension = this.getCurrentDimension();
                if (currentDimension.getDimType() == DimensionType.PERIOD) {
                    String newValue;
                    IDataModel model = this.getModel();
                    String billNumber = model.getDataEntity().getDynamicObject("businessbill").getPkValue().toString();
                    int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billNumber);
                    Map allFields = dataEntityType.getAllFields();
                    String matchProp = allFields.get(newValue = e.getChangeSet()[0].getNewValue().toString()) instanceof BasedataProp ? MatchRuleMatchPropEnum.NUMBER.getCode() : "";
                    model.setValue("entry_matchprop", (Object)matchProp, entryCurrentRowIndex);
                    break;
                }
                this.setMatchProp(e);
                break;
            }
            case "entry_secondbusinessbill": {
                this.checkMainAndSecondBusinessBillFileSame();
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("entry_dimensionmembermap", null, entryCurrentRowIndex);
                break;
            }
            case "fetchpurpose": {
                this.triggerBusinessBill(e);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "entry_businessbillfield": {
                this.confirmOrCancle(result);
                break;
            }
            case "bar_save": {
                this.saveDataIfConfirm(result);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "abnormalcondition": {
                this.showAbnormalConditionConfigForm(MatchRuleConditionEnum.ABNORMAL_CONDITION);
                break;
            }
            case "applycondition": {
                this.showAbnormalConditionConfigForm(MatchRuleConditionEnum.APPLY_CONDITION);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "save": {
                if (this.checkEnablExistsAndNotifyCheckSave()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "reset_bar": {
                this.resetDimensionOrDetailField();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String modelId = parentView.getPageCache().get("MATCH_RULE_BODY_SYS_ID_KEY");
            if (Objects.isNull(modelId)) {
                return;
            }
            if (modelId.contains("[")) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)modelId)) {
                return;
            }
            this.getModel().setValue("bodysys", (Object)modelId);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entryEntity;
        QFilter qFilter;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        Object value = model.getValue("bodysys");
        if (Objects.isNull(value)) {
            return;
        }
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"businessbill"});
        }
        DynamicObject bodySys = (DynamicObject)value;
        String businessBill = this.getBusinessBill();
        String enable = (String)model.getValue("enable");
        String selectFields = String.join((CharSequence)",", "id");
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_matchrule", (String)selectFields, (QFilter[])new QFilter[]{qFilter = new QFilter("bodysys", "=", bodySys.getPkValue()).and("businessbill", "=", (Object)businessBill).and(ENTITY_OBJECT_BILL_NUMBER, "=", model.getValue(ENTITY_OBJECT_BILL_NUMBER))});
        if (Objects.nonNull(dynamicObjects) && dynamicObjects.length > 0 && org.apache.commons.lang3.StringUtils.equals((CharSequence)enable, (CharSequence)"1")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"abnormalcondition"});
        }
        if (Objects.nonNull(dynamicObjects) && dynamicObjects.length > 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fetchpurpose"});
        }
        if (CollectionUtils.isEmpty((Collection)(entryEntity = model.getEntryEntity("entryentity")))) {
            this.doGrabDimensionOrDetailField(bodySys);
            return;
        }
        this.setDefaultLinkEntityIfNeed(entryEntity);
        this.initBillBodySelectControl();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            Dimension dimension = this.getDimension(dynamicObject);
            this.setDefaultMatchPropIfNeed(dynamicObject, dimension, i);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)enable)) {
                this.disnableAll(i);
                continue;
            }
            this.disnableEntryField(dimension, i);
        }
    }

    private void setDefaultMatchPropIfNeed(DynamicObject dynamicObject, Dimension dimension, int index) {
        if (!EmptyUtil.isEmpty((String)dynamicObject.getString("entry_matchprop"))) {
            return;
        }
        String matchPropValue = this.getMatchPropValue(dimension);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"entry_matchprop", (Object)matchPropValue, (int)index);
    }

    private void setMatchProp(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (Objects.isNull(changeSet) || changeSet.length == 0) {
            return;
        }
        IDataModel model = this.getModel();
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        Dimension currentDimension = this.getCurrentDimension();
        String matchProp = this.getMatchPropValue(currentDimension);
        model.setValue("entry_matchprop", (Object)matchProp, entryCurrentRowIndex);
    }

    private String getMatchPropValue(Dimension currentDimension) {
        String matchProp = MatchRuleMatchPropEnum.NAME.getCode();
        MemberType memberType = currentDimension.getMemberType();
        if (memberType == MemberType.AMOUNT || memberType == MemberType.DATE) {
            matchProp = "";
        }
        if (currentDimension.getDimType() == DimensionType.PERIOD) {
            matchProp = "";
        }
        if (currentDimension.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
            matchProp = "";
        }
        return matchProp;
    }

    private void resetAndChangeBusinessBillFieldSelect(PropertyChangedArgs e) {
        DynamicObject businessBillObject = (DynamicObject)this.getModel().getValue("businessbill");
        if (Objects.isNull(businessBillObject)) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        String newValue = "";
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            newValue = (String)changeData.getNewValue();
        }
        this.initBillBusinessFieldComboEditControl(businessBillObject.getString(ENTITY_OBJECT_BILL_NUMBER), newValue);
        this.resetBusinessBillFieldSelect();
    }

    private void setDefaultLinkEntityIfNeed(DynamicObjectCollection entryEntity) {
        String businessBill = this.getBusinessBill();
        this.initLinkEntityComboEditControl(businessBill);
        String linkEntity = (String)this.getModel().getValue("linkentity");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBill);
        Map allEntities = dataEntityType.getAllEntities();
        if (Objects.nonNull(allEntities.get(linkEntity))) {
            return;
        }
        DynamicObject dynamicObject = entryEntity.stream().filter(entry -> this.getDimension((DynamicObject)entry).getDetailDimType() == DetailDimType.PLAN_AMOUNT).findFirst().get();
        String entryBusinessBillField = dynamicObject.getString("entry_businessbillfield");
        linkEntity = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entryBusinessBillField)) {
            boolean isEntry = entryBusinessBillField.contains(".");
            Optional<EntityType> first = allEntities.values().stream().filter(entity -> isEntry ? entryBusinessBillField.startsWith(entity.getName()) : BillEntityType.class.isInstance(entity)).findFirst();
            if (first.isPresent()) {
                linkEntity = first.get().getName();
            }
        }
        boolean dataChanged = this.getModel().getDataChanged();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"linkentity", (Object)linkEntity);
        if (!dataChanged) {
            this.getModel().setDataChanged(false);
        }
    }

    private String getBusinessBill() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("businessbill");
        if (Objects.isNull(value)) {
            return "";
        }
        return value.getString(ENTITY_OBJECT_BILL_NUMBER);
    }

    private void checkMulitRowsMainOrSecondBusinessBillFieldSame(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (Objects.isNull(changeSet) || changeSet.length == 0) {
            return;
        }
        Object newValue = changeSet[0].getNewValue();
        String fieldName = e.getProperty().getName();
        this.docheckMulitRowsSame(fieldName, newValue, this.getCurrentRowDynamicObject());
    }

    private boolean docheckMulitRowsSame(String fieldName, Object value, DynamicObject dynamicObject) {
        if (Objects.isNull(value)) {
            return true;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value.toString())) {
            return true;
        }
        DynamicObjectCollection entryEntityCollection = this.getModel().getEntryEntity("entryentity");
        Dimension currentDimension = this.getDimension(dynamicObject);
        StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0e\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u5173\u7cfb\u4e0d\u5141\u8bb8\u51fa\u73b0\u591a\u5bf9\u4e00, \u8bf7\u68c0\u67e5\u3002", (String)"MatchRuleEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        stringBuilder.append("\u3010").append(currentDimension.getName()).append("\u3011");
        boolean showMessage = false;
        for (int i = 0; i < entryEntityCollection.size(); ++i) {
            DynamicObject entryDynamicObject = (DynamicObject)entryEntityCollection.get(i);
            if (dynamicObject == entryDynamicObject || !value.equals(entryDynamicObject.get(fieldName))) continue;
            Dimension dimension = this.getDimension(entryDynamicObject);
            stringBuilder.append("\u3001").append("\u3010").append(dimension.getName()).append("\u3011");
            showMessage = true;
        }
        if (!showMessage) {
            return true;
        }
        stringBuilder.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u914d\u7f6e", (String)"MatchRuleEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().showTipNotification(stringBuilder.toString());
        return false;
    }

    private void disnableAll(int i) {
        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entry_businessbillfield"});
        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entry_secondbusinessbill"});
        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entry_dimensionmembermap"});
        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entry_allowempty"});
        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entry_matchprop"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"businessbill"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"linkentity"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"comment"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"reset_bar"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
    }

    private void saveDataIfConfirm(MessageBoxResult result) {
        if (MessageBoxResult.No.equals((Object)result)) {
            return;
        }
        Object value = this.getModel().getValue("enable");
        this.getModel().setValue("enable", (Object)"0");
        OperationResult operationResult = this.getView().invokeOperation("save");
        if (!operationResult.isSuccess()) {
            this.getModel().setValue("enable", value);
        }
    }

    private boolean checkEnablExistsAndNotifyCheckSave() {
        IDataModel model = this.getModel();
        DynamicObject dynamicObjectBodySys = (DynamicObject)model.getValue("bodysys");
        DynamicObject businessBillObj = (DynamicObject)this.getModel().getValue("businessbill");
        String businessBIll = "";
        String businessBillName = "";
        if (Objects.nonNull(businessBillObj)) {
            businessBIll = businessBillObj.getString(ENTITY_OBJECT_BILL_NUMBER);
            businessBillName = businessBillObj.getString("name");
        }
        String selectFields = String.join((CharSequence)",", "id", "name", ENTITY_OBJECT_BILL_NUMBER);
        QFilter qFilter = new QFilter("bodysys", "=", dynamicObjectBodySys.getPkValue()).and("businessbill", "=", (Object)businessBIll).and("enable", "=", (Object)"1").and(ENTITY_OBJECT_BILL_NUMBER, "!=", model.getValue(ENTITY_OBJECT_BILL_NUMBER));
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_matchrule", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        String enable = (String)model.getValue("enable");
        if (Objects.nonNull(dynamicObjects) && dynamicObjects.length >= 1 && org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)enable)) {
            DynamicObject dynamicObject = dynamicObjects[0];
            String detailMessage = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58\u8bb0\u5f55\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u201c\u7981\u7528\u201d\uff0c\u539f\u56e0\u672c\u4f53\u7cfb\u5df2\u5b58\u5728\u53ef\u7528\u72b6\u6001\u4e0b\u7684\u201c%1$s\u201d\u6240\u5bf9\u5e94\u7684\u6267\u884c\u53d6\u6570\u89c4\u5219\u8bb0\u5f55\u201c%2$s\u201d\uff08%3$s\uff09\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58?", (String)"MatchRuleEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), businessBillName, dynamicObject.getString(ENTITY_OBJECT_BILL_NUMBER), dynamicObject.getString("name"));
            this.getView().showConfirm("", detailMessage, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("bar_save", (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private DynamicObject getDynamicObject(Long id, String entityName) {
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
        if (Objects.isNull(dynamicObject)) {
            dynamicObject = TmcDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        return dynamicObject;
    }

    private void resetDimensionOrDetailField() {
        Object value = this.getModel().getValue("bodysys");
        this.doGrabDimensionOrDetailField((DynamicObject)value);
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, MatchRuleConditionEnum conditionEnum) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        String expression = (String)returnData;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)expression)) {
            this.getModel().setValue(conditionEnum.getRealField(), (Object)"");
            return;
        }
        this.getModel().setValue(conditionEnum.getTagField(), (Object)expression);
        CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)expression, CRCondition.class);
        String description = "";
        if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
            description = filterObj.getExprTran();
        }
        boolean filterConditionEmpty = Objects.isNull(filterObj.getFilterCondition()) || CollectionUtils.isEmpty((Collection)filterObj.getFilterCondition().getFilterRow());
        boolean expressionEmpty = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filterObj.getExpression());
        if (filterConditionEmpty && expressionEmpty) {
            this.getModel().setValue(conditionEnum.getTagField(), (Object)"");
        }
        if (description.length() > 1000) {
            description = description.substring(0, 999);
        }
        this.getModel().setValue(conditionEnum.getField(), (Object)description);
    }

    private void changeAndResetBusinessBillFieldSelect(PropertyChangedArgs e) {
        this.changeBusinessBillFieldSelect(e);
        this.resetBusinessBillFieldSelect();
        this.changeAbnormalCondition();
    }

    private void changeAbnormalCondition() {
        if (null == this.getModel().getValue("businessbill")) {
            return;
        }
        if (null == this.getModel().getValue("bodysys")) {
            return;
        }
        DynamicObject billObj = (DynamicObject)this.getModel().getValue("businessbill");
        DynamicObject system = (DynamicObject)this.getModel().getValue("bodysys");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"fpm_supplement_bill", (CharSequence)billObj.getString(ENTITY_OBJECT_BILL_NUMBER))) {
            String systemName = system.getString("name");
            String systemId = system.getString("id");
            String expression = String.format(SUPPLEMENT_DEFAULT_ABNORMAL_COND, systemName, systemName, systemId, systemName, systemId, systemName, systemName);
            this.getModel().setValue(MatchRuleConditionEnum.ABNORMAL_CONDITION.getTagField(), (Object)expression);
            String formatDesc = "%1$s.%2$s %3$s %4$s";
            this.getModel().setValue(MatchRuleConditionEnum.ABNORMAL_CONDITION.getField(), (Object)String.format(formatDesc, ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"DimensionManagerList_21", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540d\u79f0", (String)"DimensionManagerList_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"MatchRuleEdit_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), systemName));
        } else {
            this.getModel().setValue(MatchRuleConditionEnum.ABNORMAL_CONDITION.getTagField(), null);
            this.getModel().setValue(MatchRuleConditionEnum.ABNORMAL_CONDITION.getField(), null);
        }
    }

    private void resetBusinessBillFieldSelect() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getModel().setValue("entry_businessbillfield", (Object)"", i);
            this.getModel().setValue("entry_secondbusinessbill", (Object)"", i);
        }
    }

    private void showAbnormalConditionConfigForm(MatchRuleConditionEnum conditionEnum) {
        String businessBill = this.getBusinessBill();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)businessBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"MatchRuleEdit_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.fillFields(businessBill, conditionEnum);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_abnormal_condition");
        String conditionJson = (String)this.getModel().getValue(conditionEnum.getTagField());
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", businessBill);
        showParameter.getCustomParams().put("treenodes", this.getPageCache().get(conditionEnum.getRealField()));
        showParameter.setCustomParam("non_fields", (Object)this.getPageCache().get(conditionEnum.getNotFundStrKey()));
        String funcsXML = this.getPageCache().get(conditionEnum.getFunctionTypes());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put(conditionEnum.getFunctionTypes(), funcsXML);
        }
        showParameter.getCustomParams().put(conditionEnum.getFunctionTypes(), funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, conditionEnum.getRealField()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(conditionEnum.getFormCaption());
        if (conditionEnum.isHideAdvancePanel()) {
            showParameter.getCustomParams().put("SHOW_ADVANCE_PANEL", Boolean.FALSE);
        }
        this.getView().showForm(showParameter);
    }

    private void fillFields(String billResource, MatchRuleConditionEnum conditionEnum) {
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)billResource);
        if (srcMainET == null) {
            this.getPageCache().put(conditionEnum.getRealField(), "");
            return;
        }
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)srcMainET);
        option.setReadEntryEntity(false);
        option.setExprType(ExpressionType.Condition);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        String toJson = SerializationUtils.toJsonString((Object)tree);
        this.getPageCache().put(conditionEnum.getRealField(), toJson);
        String nonFdStr = this.getPageCache().get(conditionEnum.getNotFundStrKey());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nonFdStr)) {
            this.getPageCache().put(conditionEnum.getNotFundStrKey(), SerializationUtils.toJsonString((Object)result.getNonFields()));
            return;
        }
        Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
        nonSet.addAll(result.getNonFields());
        this.getPageCache().put(conditionEnum.getNotFundStrKey(), SerializationUtils.toJsonString((Object)nonSet));
    }

    private void setDimensionMemberCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)listSelectedRowCollection)) {
            return;
        }
        IDataModel model = this.getModel();
        ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        model.setValue("entry_dimensionmembermap", listSelectedRow.getPrimaryKeyValue(), entryCurrentRowIndex);
    }

    private void initAndAddBeforeF7SelectListenerForF7Model() {
        this.bodySysF7Model();
        this.dimensionMemberF7Model();
        this.businessBillF7Model();
    }

    private void businessBillF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("businessbill");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter authQFilter = new QFilter(ENTITY_OBJECT_MODEL_TYPE, "=", (Object)ENTITY_OBJECT_BILL_MODEL_TYPE);
            showParameter.getListFilterParameter().setFilter(authQFilter);
        });
    }

    private void dimensionMemberF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("entry_dimensionmembermap");
        IDataModel model = this.getModel();
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object bodySys = model.getValue("bodysys");
            if (bodySys == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"MatchRuleEdit_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject currentRowDynamicObject = this.getCurrentRowDynamicObject();
            String entryBusinessBillField = currentRowDynamicObject.getString("entry_businessbillfield");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entryBusinessBillField)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u3002", (String)"MatchRuleEdit_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Dimension currentDimension = this.getCurrentDimension();
            QFilter qFilter = new QFilter("bodysysmanage", "=", ((DynamicObject)bodySys).getPkValue());
            String businessBill = this.getBusinessBill();
            IDataEntityProperty entryBusinessBillFieldType = this.matchRuleHelper.getFieldType(entryBusinessBillField, businessBill);
            if (BasedataProp.class.isAssignableFrom(entryBusinessBillFieldType.getClass())) {
                String baseEntityId = ((BasedataProp)entryBusinessBillFieldType).getBaseEntityId();
                qFilter.and("bizbasedata", "=", (Object)baseEntityId);
            }
            qFilter.and(new QFilter("dimension", "=", (Object)currentDimension.getId()));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            String entrySecondBusinessBill = currentRowDynamicObject.getString("entry_secondbusinessbill");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entrySecondBusinessBill)) {
                qFilter.and(new QFilter("useassistbasedata", "=", (Object)"1"));
                IDataEntityProperty entrySecondBusinessBillFieldType = this.matchRuleHelper.getFieldType(entrySecondBusinessBill, businessBill);
                if (BasedataProp.class.isAssignableFrom(entrySecondBusinessBillFieldType.getClass())) {
                    String baseEntityId = ((BasedataProp)entrySecondBusinessBillFieldType).getBaseEntityId();
                    qFilter.and("assistbizbasedata", "=", (Object)baseEntityId);
                }
            }
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("entry_dimensionmembermap");
            basedataEdit.setF7BatchFill(false);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "entry_dimensionmembermap"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private Dimension getCurrentDimension() {
        DynamicObject dynamicObject = this.getCurrentRowDynamicObject();
        return this.getDimension(dynamicObject);
    }

    private DynamicObject getCurrentRowDynamicObject() {
        IDataModel model = this.getModel();
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        return dynamicObject;
    }

    private void bodySysF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("bodysys");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter authQFilter = ModelHelper.getAuthQFilter();
            showParameter.getListFilterParameter().setFilter(authQFilter);
        });
    }

    private void confirmOrCancle(MessageBoxResult result) {
        IDataModel model = this.getModel();
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        this.resetFlag();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            model.setValue("entry_businessbillfield", (Object)this.getPageCache().get(BUSINESS_BILL_FIELD_CACHE_KEY_NEW_VALUE), entryCurrentRowIndex);
            model.setValue("entry_dimensionmembermap", (Object)"", entryCurrentRowIndex);
            this.clearPageCacheAndResetFlag();
            return;
        }
        model.setValue("entry_businessbillfield", (Object)this.getPageCache().get(BUSINESS_BILL_FIELD_CACHE_KEY_OLD_VALUE), entryCurrentRowIndex);
        this.clearPageCacheAndResetFlag();
    }

    private void clearPageCacheAndResetFlag() {
        this.getPageCache().remove(BUSINESS_BILL_FIELD_CACHE_KEY_NEW_VALUE);
        this.getPageCache().remove(BUSINESS_BILL_FIELD_CACHE_KEY_OLD_VALUE);
    }

    private void resetFlag() {
        String businessBillFieldChangeFlag = this.getPageCache().get(BUSINESS_BILL_FIELD_CHANGE_FLAG);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)businessBillFieldChangeFlag) && org.apache.commons.lang3.StringUtils.equals((CharSequence)BUSINESS_BILL_FIELD_CHANGE_FLAG_YES, (CharSequence)businessBillFieldChangeFlag)) {
            this.getPageCache().put(BUSINESS_BILL_FIELD_CHANGE_FLAG, BUSINESS_BILL_FIELD_CHANGE_FLAG_NO);
        }
    }

    private void checkMainAndSecondBusinessBillFileSame() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        String businessBillField = dynamicObject.getString("entry_businessbillfield");
        String secondBusinessBillField = dynamicObject.getString("entry_secondbusinessbill");
        Dimension dimension = this.getDimension(dynamicObject);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)businessBillField) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)secondBusinessBillField) && org.apache.commons.lang3.StringUtils.equals((CharSequence)businessBillField, (CharSequence)secondBusinessBillField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u4e0e\u8f85\u52a9\u4e1a\u52a1\u5b57\u6bb5\u9009\u9879\u4e0d\u53ef\u76f8\u540c\u3002", (String)"MatchRuleEdit_6", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dimension.getName()}));
        }
    }

    private void resetDimensionMemberMap(PropertyChangedArgs propertyChangedArgs) {
        IPageCache pageCache;
        String businessBillFieldChangeFlag;
        ChangeData[] changeSet = propertyChangedArgs.getChangeSet();
        Object newValue = null;
        Object oldValue = null;
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            newValue = changeData.getNewValue();
            oldValue = changeData.getOldValue();
        }
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{businessBillFieldChangeFlag = (pageCache = this.getPageCache()).get(BUSINESS_BILL_FIELD_CHANGE_FLAG)}) && org.apache.commons.lang3.StringUtils.equals((CharSequence)businessBillFieldChangeFlag, (CharSequence)BUSINESS_BILL_FIELD_CHANGE_FLAG_NO)) {
            pageCache.remove(BUSINESS_BILL_FIELD_CHANGE_FLAG);
            return;
        }
        DynamicObject currentRowDynamicObject = this.getCurrentRowDynamicObject();
        String entryDimensionMemberMap = currentRowDynamicObject.getString("entry_dimensionmembermap");
        if (Objects.nonNull(oldValue) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entryDimensionMemberMap)) {
            this.getView().showConfirm("", ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u5c06\u6e05\u9664\u5f53\u524d\u6240\u9009\u7ef4\u5ea6\u6210\u5458\u7684\u6620\u5c04\u5173\u7cfb\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MatchRuleEdit_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("entry_businessbillfield", (IFormPlugin)this));
            pageCache.get(BUSINESS_BILL_FIELD_CACHE_KEY_NEW_VALUE);
            pageCache.put(BUSINESS_BILL_FIELD_CACHE_KEY_OLD_VALUE, oldValue.toString());
            pageCache.put(BUSINESS_BILL_FIELD_CACHE_KEY_NEW_VALUE, Objects.isNull(newValue) ? "" : newValue.toString());
            pageCache.put(BUSINESS_BILL_FIELD_CHANGE_FLAG, BUSINESS_BILL_FIELD_CHANGE_FLAG_YES);
        }
    }

    private Dimension getDimension(DynamicObject dynamicObject) {
        long dimesionOrDetailId = (Long)dynamicObject.getDynamicObject("entry_dimensiondetail").getPkValue();
        DimensionType dimensionType = this.getDimensionType(dynamicObject);
        Dimension dimension = this.loadDimension(dimesionOrDetailId, dimensionType);
        return dimension;
    }

    private DimensionType getDimensionType(DynamicObject dynamicObject) {
        String dimesionTypeStrValue = dynamicObject.getString("entry_dimensiontype");
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)dimesionTypeStrValue, (CharSequence)"fpm_detailplanfields") ? DimensionType.DETAILDIM : null;
    }

    private Dimension loadDimension(long dimesionOrDetailId, DimensionType dimensionType) {
        if (dimensionType == DimensionType.DETAILDIM) {
            DynamicObject dynamicObject = this.getDynamicObject(dimesionOrDetailId, "fpm_detailplanfields");
            return this.convertToDetailDimension(dynamicObject);
        }
        DynamicObject mainDimension = this.getDynamicObject(dimesionOrDetailId, "fpm_dimension");
        return DimensionPOConverter.convertToMainDimension((DynamicObject)mainDimension, (List)Collections.EMPTY_LIST);
    }

    private Dimension convertToDetailDimension(DynamicObject detailDimEntry) {
        Dimension dimension = new Dimension();
        dimension.setId(Long.valueOf(detailDimEntry.getLong("id")));
        dimension.setSystemId(Long.valueOf(detailDimEntry.getLong("bodysys.id")));
        dimension.setName(detailDimEntry.getString("name"));
        dimension.setNumber(detailDimEntry.getString("detaildimtype"));
        dimension.setDimType(DimensionType.DETAILDIM);
        dimension.setDetailDimType(DetailDimType.getDimsionByNumber((String)detailDimEntry.getString("detaildimtype")));
        MemberType memberType = MemberType.getDimsionByNumber((String)detailDimEntry.getString("datatype"));
        dimension.setMemberType(memberType);
        if (memberType == MemberType.ENUM) {
            String enumVal = detailDimEntry.getString("option");
            dimension.setMemberValList(Arrays.asList(enumVal.split(",")));
        }
        dimension.setMustInput(detailDimEntry.getBoolean("ismustinput"));
        dimension.setVisible(detailDimEntry.getBoolean("isshow"));
        return dimension;
    }

    private void changeBusinessBillFieldSelect(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        String newValue = "";
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject value = (DynamicObject)changeData.getNewValue();
            if (Objects.isNull(value)) {
                this.resetBusinessBillFieldSelect();
                this.cleanComboItem();
                return;
            }
            newValue = value.getString(ENTITY_OBJECT_BILL_NUMBER);
        }
        this.initLinkEntityComboEditControl(newValue);
        this.getModel().setValue("linkentity", null);
    }

    private void initLinkEntityComboEditControl(String businessBill) {
        ComboEdit linkEntityControl = (ComboEdit)this.getControl("linkentity");
        if (EmptyUtil.isEmpty((String)businessBill)) {
            linkEntityControl.setComboItems(Collections.emptyList());
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBill);
        Map allEntities = dataEntityType.getAllEntities();
        Object fetchPurpose = this.getModel().getValue("fetchpurpose");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(allEntities.size());
        for (Map.Entry entry : allEntities.entrySet()) {
            Set<String> skipEntry;
            EntityType entryValue = (EntityType)entry.getValue();
            if (LinkEntryType.class.isInstance(entry.getValue()) || Objects.equals(fetchPurpose, MatchRuleFetchPurposeEnum.PLAN_REPORT.getCode()) && !BillEntityType.class.isInstance(entryValue) && CollectionUtils.isNotEmpty(skipEntry = SKIP_ENTRY.get(businessBill)) && skipEntry.contains(entryValue.getName())) continue;
            String key = (String)entry.getKey();
            comboItemList.add(new ComboItem(BillEntityType.class.isInstance(entryValue) ? new LocaleString(MatchRuleLinkEntityEnum.BILL_HEAD.getName()) : entryValue.getDisplayName(), key));
        }
        linkEntityControl.setComboItems(comboItemList);
    }

    private void cleanComboItem() {
        ComboEdit businessBillComboEdit = (ComboEdit)this.getControl("entry_businessbillfield");
        ComboEdit secondBusinessBillComboEdit = (ComboEdit)this.getControl("entry_secondbusinessbill");
        businessBillComboEdit.setComboItems(Collections.emptyList());
        secondBusinessBillComboEdit.setComboItems(Collections.emptyList());
    }

    private void grabDimensionOrDetailField(PropertyChangedArgs propertyChangedArgs) {
        ChangeData[] changeSet = propertyChangedArgs.getChangeSet();
        Object newValue = null;
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            newValue = changeData.getNewValue();
        }
        this.doGrabDimensionOrDetailField((DynamicObject)newValue);
    }

    private void doGrabDimensionOrDetailField(DynamicObject newValue) {
        Long bodySysPkValue = Objects.isNull(newValue) ? Long.valueOf(0L) : (Long)newValue.getPkValue();
        List<Dimension> dimensionList = this.getDimensionListByBodySysId(bodySysPkValue);
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        this.initBillBodySelectControl();
        dimensionList.stream().sorted(DIMENSION_COMPARATOR).forEach(this::setDimensionOrDetailFieldAndVisiable);
    }

    private void setDimensionOrDetailFieldAndVisiable(Dimension dimension) {
        if (dimension.getDetailDimType() != null && !dimension.isVisible()) {
            return;
        }
        IDataModel model = this.getModel();
        DimensionType dimType = dimension.getDimType();
        int newEntryRow = model.createNewEntryRow("entryentity");
        String entityCode = dimType == DimensionType.DETAILDIM ? "fpm_detailplanfields" : "fpm_dimension";
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"entry_dimensiontype", (Object)entityCode, (int)newEntryRow);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"entry_dimensiondetail", (Object)dimension.getId().toString(), (int)newEntryRow);
        boolean isPeriod = org.apache.commons.lang3.StringUtils.equals((CharSequence)dimension.getNumber(), (CharSequence)DimsionEnums.PERIOD.getNumber());
        String mapRelation = isPeriod ? MatchRuleMapRelationEnum.CONTAINS.getCode() : MatchRuleMapRelationEnum.EQUALS.getCode();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"entry_maprelation", (Object)mapRelation, (int)newEntryRow);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"entry_matchprop", (Object)this.getMatchPropValue(dimension), (int)newEntryRow);
        this.disnableEntryField(dimension, newEntryRow);
    }

    private void disnableEntryField(Dimension dimension, int newEntryRow) {
        MemberType memberType;
        DimensionType dimType = dimension.getDimType();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)dimension.getNumber(), (CharSequence)DimsionEnums.PERIOD.getNumber()) || dimType == DimensionType.DETAILDIM) {
            this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{"entry_secondbusinessbill"});
        }
        if (!MatchRuleHelper.ALLOW_DIMENSION_MEMBER_MAP_DIMENSION_TYPE_SET.contains(dimType)) {
            this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{"entry_dimensionmembermap"});
        }
        if (MatchRuleHelper.SYSTEM_DEFINE_DIMENSION_DIMENSION_TYPE_SET.contains(dimType) || dimension.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
            this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{"entry_allowempty"});
        }
        if (!MatchRuleHelper.ALLOW_DIMENSION_MEMBER_MAP_DIMENSION_TYPE_SET.contains(dimType)) {
            this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{"entry_matchprop"});
        }
        if ((memberType = dimension.getMemberType()) == MemberType.AMOUNT || memberType == MemberType.DATE) {
            this.getView().setEnable(Boolean.FALSE, newEntryRow, new String[]{"entry_matchprop"});
        }
    }

    private void initBillBodySelectControl() {
        Object value = this.getModel().getValue("bodysys");
        if (Objects.isNull(value)) {
            return;
        }
        String businessBill = this.getBusinessBill();
        String linkEntityType = (String)this.getModel().getValue("linkentity");
        this.initBillBusinessFieldComboEditControl(businessBill, linkEntityType);
    }

    private void initBillBusinessFieldComboEditControl(String businessBill, String linkEntityType) {
        ComboEdit businessBillComboEdit = (ComboEdit)this.getControl("entry_businessbillfield");
        ComboEdit secondBusinessBillComboEdit = (ComboEdit)this.getControl("entry_secondbusinessbill");
        Object value = this.getModel().getValue("bodysys");
        if (Objects.isNull(value)) {
            return;
        }
        if (EmptyUtil.isEmpty((String)businessBill)) {
            businessBillComboEdit.setComboItems(Collections.emptyList());
            secondBusinessBillComboEdit.setComboItems(Collections.emptyList());
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBill);
        Map allEntities = dataEntityType.getAllEntities();
        if (!allEntities.containsKey(linkEntityType)) {
            businessBillComboEdit.setComboItems(Collections.emptyList());
            secondBusinessBillComboEdit.setComboItems(Collections.emptyList());
            return;
        }
        boolean needEntry = !BillEntityType.class.isInstance(allEntities.get(linkEntityType));
        Map entryPropMap = needEntry ? this.getEntryPropMap(dataEntityType, linkEntityType) : Collections.emptyMap();
        Map<String, LocaleString> fieldColumn = this.getFields(businessBill, needEntry);
        Set entryPropSet = dataEntityType.getProperties().stream().filter(property -> EntryProp.class.isAssignableFrom(property.getClass())).map(property -> (EntryProp)property).flatMap(entryProp -> entryProp.getDynamicCollectionItemPropertyType().getProperties().stream()).map(iDataEntityProperty -> iDataEntityProperty.getName()).collect(Collectors.toSet());
        ArrayList<ComboItem> businessBillComboItemList = new ArrayList<ComboItem>(fieldColumn.size());
        ArrayList<ComboItem> secondBusinessBillComboItemList = new ArrayList<ComboItem>(fieldColumn.size());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, LocaleString> entry : fieldColumn.entrySet()) {
            LocaleString displayName = entry.getValue();
            String key = entry.getKey();
            if (entryPropSet.contains(key) && !entryPropMap.containsKey(key)) continue;
            if (entryPropMap.containsKey(key)) {
                EntryProp entryProp2 = (EntryProp)entryPropMap.get(key);
                key = sb.append(entryProp2.getName()).append(".").append(key).toString();
                sb.delete(0, sb.length());
                displayName = this.getFullDisplayName(displayName, entryProp2.getDisplayName(), sb);
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(displayName);
            comboItem.setValue(key);
            businessBillComboItemList.add(comboItem);
            secondBusinessBillComboItemList.add(comboItem);
        }
        businessBillComboEdit.setComboItems(businessBillComboItemList);
        secondBusinessBillComboEdit.setComboItems(secondBusinessBillComboItemList);
    }

    private Map<String, LocaleString> getFields(String businessBill, boolean needEntry) {
        Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)businessBill, (boolean)false, (boolean)true, (String[])new String[0]);
        if (needEntry) {
            return fieldColumn;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBill);
        Set keySet = ((EntityType)dataEntityType.getAllEntities().get(businessBill)).getFields().keySet();
        return fieldColumn.entrySet().stream().filter(entry -> keySet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, EntryProp> getEntryPropMap(MainEntityType dataEntityType, String linkEntityType) {
        HashMap<String, EntryProp> entryPropMap = new HashMap<String, EntryProp>(64);
        List entryPropList = dataEntityType.getProperties().stream().filter(property -> EntryProp.class.isAssignableFrom(property.getClass())).collect(Collectors.toList());
        for (IDataEntityProperty iDataEntityProperty : entryPropList) {
            EntryProp entryProp = (EntryProp)iDataEntityProperty;
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)linkEntityType, (CharSequence)entryProp.getName())) continue;
            entryPropMap.putAll(entryProp.getDynamicCollectionItemPropertyType().getProperties().stream().map(pro -> pro.getName()).collect(Collectors.toMap(name -> name, name -> entryProp)));
            break;
        }
        return entryPropMap;
    }

    private LocaleString getFullDisplayName(LocaleString simpleDisplayName, LocaleString entryDisplayName, StringBuilder sb) {
        sb.delete(0, sb.length());
        LocaleString displayName = LocaleString.fromMap((Map)simpleDisplayName);
        for (Map.Entry localStringEntry : entryDisplayName.entrySet()) {
            String languageType = (String)localStringEntry.getKey();
            String displayNameSimple = (String)displayName.get((Object)languageType);
            displayNameSimple = Objects.isNull(displayNameSimple) ? "" : displayNameSimple;
            displayName.put(languageType, (Object)sb.append((String)localStringEntry.getValue()).append(".").append(displayNameSimple).toString());
            sb.delete(0, sb.length());
        }
        return displayName;
    }

    private List<Dimension> getDimensionListByBodySysId(Long bodySysPkValue) {
        ArrayList dimensionList;
        if (EmptyUtil.isEmpty((Long)bodySysPkValue)) {
            return Collections.emptyList();
        }
        DimensionRepository dimensionRepository = new DimensionRepository();
        FundPlanSystem fundPlanSystem = dimensionRepository.loadSystem(bodySysPkValue.longValue());
        if (fundPlanSystem == null || CollectionUtils.isEmpty((Collection)(dimensionList = fundPlanSystem.getDimList()))) {
            dimensionList = new ArrayList(2);
        }
        return dimensionList.stream().filter(dimension -> dimension.getDimType() != DimensionType.METRIC).collect(Collectors.toList());
    }

    private void triggerBusinessBill(PropertyChangedArgs e) {
        String newValue;
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            this.getModel().setValue("businessbill", null);
            return;
        }
        ChangeData changeData = changeSet[0];
        if (changeData == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(newValue = (String)changeData.getNewValue()))) {
            this.getModel().setValue("businessbill", null);
            return;
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)newValue, (CharSequence)MatchRuleFetchPurposeEnum.PLAN_REPORT.getCode())) {
            this.getModel().setValue("businessbill", (Object)"fpm_inoutcollect");
            this.handleAllowEmpty(false);
            String expression = PLAN_REPORT_RULE_DEFAULT_APPLY_COND;
            this.getModel().setValue(MatchRuleConditionEnum.APPLY_CONDITION.getTagField(), (Object)expression);
            this.getModel().setValue(MatchRuleConditionEnum.APPLY_CONDITION.getField(), (Object)ResManager.loadKDString((String)"\u5e9f\u5f03\u72b6\u6001 \u7b49\u4e8e \u5426", (String)"MatchRuleEdit_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MatchRuleConditionEnum.APPLY_CONDITION.getTagField(), (Object)"");
        this.getModel().setValue(MatchRuleConditionEnum.APPLY_CONDITION.getField(), (Object)"");
        this.handleAllowEmpty(true);
        this.getModel().setValue("businessbill", null);
    }

    private void handleAllowEmpty(boolean executePlan) {
        int i;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (i = 0; i < entryEntity.size(); ++i) {
            this.getModel().setValue("entry_allowempty", (Object)0, i);
            this.getView().setEnable(Boolean.valueOf(executePlan), i, new String[]{"entry_allowempty"});
        }
        if (executePlan) {
            for (i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                Dimension dimension = this.getDimension(dynamicObject);
                this.setDefaultMatchPropIfNeed(dynamicObject, dimension, i);
                this.disnableEntryField(dimension, i);
            }
        }
    }

    static {
        HashMap skipEntry = new HashMap(8);
        HashSet<String> inoutSet = new HashSet<String>(4);
        inoutSet.add("entryentity");
        skipEntry.put("fpm_inoutcollect", inoutSet);
        SKIP_ENTRY = Collections.unmodifiableMap(skipEntry);
    }
}

