/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportValueFormulaTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportVerifyDataRelTypeEnum;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimension;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimensionMember;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReportVerifyRuleEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"checkdimension", "valueformula", "checkeddimension", "valuedformula"});
        BasedataEdit reportType = (BasedataEdit)this.getView().getControl("reporttype");
        reportType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit checkedReportType = (BasedataEdit)this.getView().getControl("checkedreporttype");
        checkedReportType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit template = (BasedataEdit)this.getView().getControl("templaterange");
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimension = (BasedataEdit)this.getView().getControl("dimension");
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimensionMembers = (BasedataEdit)this.getView().getControl("mulmembers");
        dimensionMembers.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String modelId = parentView.getPageCache().get("KEY_MODEL_ID");
        if (null == modelId) {
            return;
        }
        if (modelId.indexOf(91) != -1) {
            String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
            modelId = modelIdArr[0].trim();
        }
        if (!StringUtils.isNumeric((String)modelId)) {
            return;
        }
        this.getModel().setValue("bodysysmanage", (Object)modelId);
    }

    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"bodysysmanage"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"duringdeviation"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"expression"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"enablestr"});
        this.getModel().setValue("enablestr", (Object)BaseEnableEnum.getName((String)String.valueOf(this.getModel().getValue("enable"))));
        if (StringUtils.isEmpty((String)String.valueOf(this.getModel().getValue("valueformula")))) {
            this.getModel().setValue("valueformula", (Object)ReportValueFormulaTypeEnum.PLAN_QUOTA.getName());
        }
        if (StringUtils.isEmpty((String)String.valueOf(this.getModel().getValue("valueformulavalue_tag")))) {
            this.getModel().setValue("valueformulavalue_tag", (Object)ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue());
        }
        if (StringUtils.isEmpty((String)String.valueOf(this.getModel().getValue("valuedformula")))) {
            this.getModel().setValue("valuedformula", (Object)ReportValueFormulaTypeEnum.PLAN_QUOTA.getName());
        }
        if (StringUtils.isEmpty((String)String.valueOf(this.getModel().getValue("valuedformulavalue_tag")))) {
            this.getModel().setValue("valuedformulavalue_tag", (Object)ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue());
        }
        if (OperationStatus.EDIT == (status = this.getView().getFormShowParameter().getStatus())) {
            boolean enable = BaseEnableEnum.ENABLE.getValue().equals(this.getModel().getValue("enable"));
            if (!enable) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"checktype"});
                return;
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap3"});
        }
        this.setOrgDimension();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "reporttype": {
                this.handleBasicReportTypeColumn();
                break;
            }
            case "checktype": {
                String checkType = (String)this.getModel().getValue("checktype");
                if (ReportVerifyCheckTypeEnum.IN_TABLE.getCode().equals(checkType)) {
                    this.getModel().setValue("checkreporttype", null);
                    this.getModel().setValue("checkedreporttype", null);
                    break;
                }
                this.handleBasicReportTypeColumn();
                break;
            }
            case "checkreporttype": 
            case "checkedreporttype": {
                this.handleDuringColumn();
                this.handleExpressValue();
                break;
            }
            case "checkdimensionvalue_tag": {
                break;
            }
            case "valueformula": 
            case "valuedformula": 
            case "checkdimension": 
            case "checkeddimension": 
            case "dataverifyrel": {
                this.handleExpressValue();
                break;
            }
            case "templatecheck": {
                Boolean templateCheck = (Boolean)this.getModel().getValue("templatecheck");
                if (!templateCheck.booleanValue()) break;
                ((MulBasedataEdit)this.getView().getControl("templaterange")).setMustInput(true);
                break;
            }
            case "dimension": {
                this.handleEntityColumnDimensionChanged(e);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "reporttype": {
                this.handleReportTypeBeforeF7Select(evt);
                break;
            }
            case "templaterange": {
                this.handleTemplateBeforeF7Select(evt);
                break;
            }
            case "checkedreporttype": {
                this.handleCheckedDimensionBeforeF7Select(evt);
                break;
            }
            case "dimension": {
                this.handleEntityDimensionBeforeF7Select(evt);
                break;
            }
            case "mulmembers": {
                this.handleEntityDimensionMembersBeforeF7Select(evt);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": {
                boolean success = args.getOperationResult().isSuccess();
                if (!success) break;
                this.getView().setEnable(Boolean.FALSE, new String[]{"checktype"});
                String checkType = (String)this.getModel().getValue("checktype");
                if (ReportVerifyCheckTypeEnum.BETWEEN_TABLE.getCode().equals(checkType)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"reporttype"});
                }
                IFormView parentView = this.getView().getParentView();
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        HashMap<String, Object> params = new HashMap<String, Object>();
        switch (key) {
            case "checkdimension": {
                params.put("entryRow", this.getModel().getValue("checkdimensionvalue_tag"));
                params.put("callbackColumn", "checkdimension");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                List idList = entryEntity.stream().map(item -> {
                    DynamicObject dynamicObject = item.getDynamicObject("dimension");
                    if (dynamicObject == null) {
                        return null;
                    }
                    return dynamicObject.getPkValue();
                }).filter(Objects::nonNull).collect(Collectors.toList());
                params.put("dimensionFilterIds", idList);
                this.createForm("fpm_reportruledimension", "checkdimension", ResManager.loadKDString((String)"\u6821\u9a8c\u7ef4\u5ea6\u53ca\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e", (String)"ReportVerifyRuleEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), params);
                break;
            }
            case "valueformula": {
                DynamicObject systemObject = (DynamicObject)this.getModel().getValue("bodysysmanage");
                if (Objects.nonNull(systemObject)) {
                    params.put("model", systemObject.getPkValue());
                }
                params.put("expression", this.getModel().getValue("valueformulavalue_tag"));
                params.put("expressiondesc", this.getModel().getValue("valueformula"));
                params.put("callbackColumn", "valueformula");
                this.createForm("fpm_valueformulaconfig", "valueformula", ResManager.loadKDString((String)"\u53d6\u503c\u516c\u5f0f\u7f16\u8f91", (String)"ReportVerifyRuleEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), params);
                break;
            }
            case "checkeddimension": {
                Object value = this.getModel().getValue("checkeddimensionvalue_tag");
                params.put("entryRow", value);
                params.put("callbackColumn", "checkeddimension");
                params.put("needClear", this.getPageCache().get("needClear"));
                this.createForm("fpm_reportruledimension", "checkeddimension", ResManager.loadKDString((String)"\u88ab\u6821\u9a8c\u7ef4\u5ea6\u53ca\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e", (String)"ReportVerifyRuleEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), params);
                break;
            }
            case "valuedformula": {
                params.put("expression", this.getModel().getValue("valuedformulavalue_tag"));
                params.put("expressiondesc", this.getModel().getValue("valuedformula"));
                params.put("callbackColumn", "valuedformula");
                this.createForm("fpm_valueformulaconfig", "valuedformula", ResManager.loadKDString((String)"\u53d6\u503c\u516c\u5f0f\u7f16\u8f91", (String)"ReportVerifyRuleEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), params);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "checkdimension": {
                this.handleCheckDimensionCallback(closedCallBackEvent);
                break;
            }
            case "checkeddimension": {
                this.handleCheckedDimensionCallback(closedCallBackEvent);
                break;
            }
            case "valueformula": {
                this.handleCheckValueFormulaCallback(closedCallBackEvent);
                break;
            }
            case "valuedformula": {
                this.handleCheckedValuedFormula(closedCallBackEvent);
                break;
            }
        }
    }

    private void handleCheckedValuedFormula(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (MapUtils.isEmpty((Map)returnData)) {
            return;
        }
        this.getModel().setValue("valuedformula", returnData.get("expressiondesc"));
        this.getModel().setValue("valuedformulavalue_tag", returnData.get("expression"));
    }

    private boolean handleCheckValueFormulaCallback(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (MapUtils.isEmpty((Map)returnData)) {
            return true;
        }
        this.getModel().setValue("valueformula", returnData.get("expressiondesc"));
        this.getModel().setValue("valueformulavalue_tag", returnData.get("expression"));
        return false;
    }

    private boolean handleCheckedDimensionCallback(ClosedCallBackEvent closedCallBackEvent) {
        List<ReportVerifyRuleDimension> paramList = this.getReportVerifyRuleDimensionParams(closedCallBackEvent);
        if (CollectionUtils.isEmpty(paramList)) {
            return true;
        }
        StringBuilder value = this.getMembersName(paramList);
        this.getModel().setValue("checkeddimension", (Object)this.subString(value.toString()));
        this.getModel().setValue("checkeddimensionvalue_tag", (Object)SerializationUtils.toJsonString(paramList));
        return false;
    }

    private void handleCheckDimensionCallback(ClosedCallBackEvent closedCallBackEvent) {
        List<ReportVerifyRuleDimension> paramList = this.getReportVerifyRuleDimensionParams(closedCallBackEvent);
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        StringBuilder value = this.getMembersName(paramList);
        this.getModel().setValue("checkdimension", (Object)this.subString(value.toString()));
        this.getModel().setValue("checkdimensionvalue_tag", (Object)SerializationUtils.toJsonString(paramList));
        boolean clearKey = false;
        Object checkedJsonObj = this.getModel().getValue("checkeddimensionvalue_tag");
        if (EmptyUtil.isNoEmpty((Object)checkedJsonObj)) {
            Set dimensionIdSet = paramList.stream().map(ReportVerifyRuleDimension::getDimensionId).collect(Collectors.toSet());
            List checkedParam = JSON.parseArray((String)String.valueOf(checkedJsonObj), ReportVerifyRuleDimension.class);
            if (CollectionUtils.isEmpty((Collection)checkedParam)) {
                return;
            }
            Iterator iterator = checkedParam.iterator();
            while (iterator.hasNext()) {
                ReportVerifyRuleDimension dimension = (ReportVerifyRuleDimension)iterator.next();
                if (dimensionIdSet.contains(dimension.getDimensionId())) continue;
                iterator.remove();
            }
            if (!CollectionUtils.isEmpty((Collection)checkedParam)) {
                StringBuilder membersName = this.getMembersName(checkedParam);
                this.getModel().setValue("checkeddimension", (Object)this.subString(membersName.toString()));
                this.getModel().setValue("checkeddimensionvalue_tag", (Object)SerializationUtils.toJsonString((Object)checkedParam));
            } else if (!CollectionUtils.isEmpty(paramList)) {
                List<ReportVerifyRuleDimension> returnData = this.getReportVerifyRuleDimensionParams(closedCallBackEvent);
                returnData.forEach(item -> item.setMemberParams(new ArrayList(0)));
                this.getModel().setValue("checkeddimension", null);
                this.getModel().setValue("checkeddimensionvalue_tag", (Object)SerializationUtils.toJsonString(returnData));
            } else {
                clearKey = true;
                this.getModel().setValue("checkeddimension", null);
                this.getModel().setValue("checkeddimensionvalue_tag", null);
            }
        }
        this.getPageCache().put("needClear", String.valueOf(clearKey));
    }

    private void handleEntityDimensionMembersBeforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject system = (DynamicObject)this.getModel().getValue("bodysysmanage");
        if (system == null) {
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        showParam.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("bodysystem", "=", system.getPkValue());
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index);
        DynamicObject dimensionObject = entryRowEntity.getDynamicObject("dimension");
        if (Objects.isNull(dimensionObject)) {
            showParam.setLoadData(false);
            return;
        }
        QFilter numberFilter = new QFilter("dimension", "=", dimensionObject.getPkValue());
        qFilter.and(numberFilter);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("bodysystem", "=", system.getPkValue()));
        qFilters.add(new QFilter("dimtype", "=", dimensionObject.get("number")));
        showParam.getTreeFilterParameter().setQFilters(qFilters);
        showParam.getListFilterParameter().setFilter(qFilter);
    }

    private void handleEntityDimensionBeforeF7Select(BeforeF7SelectEvent evt) {
        List reportVerifyRuleDimensionParams;
        DynamicObject system = (DynamicObject)this.getModel().getValue("bodysysmanage");
        if (system == null) {
            return;
        }
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("bodysystem", "=", system.getPkValue());
        ArrayList<String> numberList = new ArrayList<String>();
        numberList.add(DimsionEnums.METRIC.getNumber());
        numberList.add(DimsionEnums.PERIOD.getNumber());
        qFilter.and("number", "not in", numberList);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            showParam.getListFilterParameter().setFilter(qFilter);
            return;
        }
        List idList = entryEntity.stream().map(item -> {
            DynamicObject dynamicObject = item.getDynamicObject("dimension");
            if (dynamicObject == null) {
                return null;
            }
            return dynamicObject.getPkValue();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Object checkDimension = this.getModel().getValue("checkdimensionvalue_tag");
        Object checkedDimension = this.getModel().getValue("checkeddimensionvalue_tag");
        if (StringUtils.isNotEmpty((String)String.valueOf(checkedDimension))) {
            reportVerifyRuleDimensionParams = JSON.parseArray((String)String.valueOf(checkedDimension), ReportVerifyRuleDimension.class);
            if (!CollectionUtils.isEmpty((Collection)reportVerifyRuleDimensionParams)) {
                List collect = reportVerifyRuleDimensionParams.stream().map(ReportVerifyRuleDimension::getDimensionId).collect(Collectors.toList());
                idList.addAll(collect);
            }
        } else if (StringUtils.isNotEmpty((String)String.valueOf(checkDimension)) && !CollectionUtils.isEmpty((Collection)(reportVerifyRuleDimensionParams = JSON.parseArray((String)String.valueOf(checkDimension), ReportVerifyRuleDimension.class)))) {
            List collect = reportVerifyRuleDimensionParams.stream().map(ReportVerifyRuleDimension::getDimensionId).collect(Collectors.toList());
            idList.addAll(collect);
        }
        QFilter colFilter = new QFilter("id", "not in", idList);
        qFilter.and(colFilter);
        showParam.getListFilterParameter().setFilter(qFilter);
    }

    private void handleDuringColumn() {
        this.getModel().setValue("duringdeviation", (Object)0);
        String checkType = (String)this.getModel().getValue("checktype");
        if (ReportVerifyCheckTypeEnum.BETWEEN_TABLE.getCode().equals(checkType)) {
            String checkedId;
            DynamicObject reportType = (DynamicObject)this.getModel().getValue("checkreporttype");
            DynamicObject checkReportType = (DynamicObject)this.getModel().getValue("checkedreporttype");
            if (Objects.isNull(reportType) || Objects.isNull(checkReportType)) {
                return;
            }
            String id = reportType.get("id").toString();
            if (Objects.equals(id, checkedId = checkReportType.get("id").toString())) {
                this.getModel().setValue("duringdeviation", (Object)-1);
            }
        }
    }

    private void handleExpressValue() {
        DynamicObject reportType = (DynamicObject)this.getModel().getValue("checkreporttype");
        String reportName = "";
        if (Objects.nonNull(reportType)) {
            reportName = reportType.getString("name");
        }
        String checkDimensionDesc = (String)this.getModel().getValue("checkdimension");
        StringBuilder result = new StringBuilder();
        StringBuilder newCheckDimensionDesc = new StringBuilder();
        if (StringUtils.isNotEmpty((String)checkDimensionDesc)) {
            boolean contains = checkDimensionDesc.contains("|");
            if (contains) {
                newCheckDimensionDesc.append("(").append(checkDimensionDesc).append(")");
            } else {
                newCheckDimensionDesc.append(checkDimensionDesc);
            }
        }
        Pair<String, String> duringDesc = this.getDuringDesc();
        String valueFormula = (String)this.getModel().getValue("valueformula");
        if (StringUtils.isNotEmpty((String)reportName)) {
            result.append("(");
            result.append(reportName).append("|");
        }
        result.append((CharSequence)newCheckDimensionDesc).append((String)duringDesc.getLeft());
        if (StringUtils.isNotEmpty((String)reportName)) {
            result.append(")");
        }
        result.append("|").append(valueFormula);
        String dataVerify = ReportVerifyDataRelTypeEnum.getValueByCode((String)String.valueOf(this.getModel().getValue("dataverifyrel")));
        DynamicObject checkedReportType = (DynamicObject)this.getModel().getValue("checkedreporttype");
        String checkedReportName = "";
        if (Objects.nonNull(checkedReportType)) {
            checkedReportName = checkedReportType.getString("name");
        }
        String checkedDimensionDesc = (String)this.getModel().getValue("checkeddimension");
        StringBuilder newCheckedDimensionDesc = new StringBuilder();
        if (StringUtils.isNotEmpty((String)checkedDimensionDesc)) {
            boolean contains = checkedDimensionDesc.contains("|");
            if (contains) {
                newCheckedDimensionDesc.append("(").append(checkedDimensionDesc).append(")");
            } else {
                newCheckedDimensionDesc.append(checkedDimensionDesc);
            }
        }
        String valuedFormula = (String)this.getModel().getValue("valuedformula");
        result.append(dataVerify);
        if (StringUtils.isNotEmpty((String)checkedReportName)) {
            result.append("(");
            result.append(checkedReportName).append("|");
        }
        result.append((CharSequence)newCheckedDimensionDesc).append((String)duringDesc.getRight());
        if (StringUtils.isNotEmpty((String)checkedReportName)) {
            result.append(")");
        }
        result.append("|").append(valuedFormula);
        String expressStr = this.subString(result.toString());
        this.getModel().setValue("expression", (Object)expressStr);
        this.getModel().setValue("expression_tag", (Object)result.toString());
        this.getView().updateView("expression");
    }

    private String subString(String expressStr) {
        if (expressStr.length() > 255) {
            expressStr = expressStr.substring(0, 255);
        }
        return expressStr;
    }

    private Pair<String, String> getDuringDesc() {
        Pair result = Pair.of((Object)"", (Object)"");
        Integer during = (Integer)this.getModel().getValue("duringdeviation");
        if (during == 0) {
            return result;
        }
        if (during < 0) {
            result = Pair.of((Object)ResManager.loadKDString((String)"|\u672c\u671f", (String)"ReportVerifyRuleEdit_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), (Object)ResManager.loadKDString((String)"|%s\u671f", (String)"ReportVerifyRuleEdit_5", (String)"tmc-fpm-formplugin", (Object[])new Object[]{during}));
        }
        return result;
    }

    private void handleBasicReportTypeColumn() {
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue("reporttype");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
        DynamicObject baseDataId = dynamicObject.getDynamicObject("fbasedataid");
        this.getModel().setValue("checkreporttype", baseDataId.getPkValue());
        this.getModel().setValue("checkedreporttype", baseDataId.getPkValue());
    }

    private StringBuilder getMembersName(List<ReportVerifyRuleDimension> paramList) {
        StringBuilder value = new StringBuilder();
        for (ReportVerifyRuleDimension dimensionParam : paramList) {
            List memberParams = dimensionParam.getMemberParams();
            if (CollectionUtils.isEmpty((Collection)memberParams)) continue;
            List<String> nameList = memberParams.stream().map(ReportVerifyRuleDimensionMember::getDimensionMemberName).collect(Collectors.toList());
            nameList.forEach(item -> value.append((String)item).append("+"));
            value.deleteCharAt(value.length() - 1);
            value.append("|");
        }
        if (value.length() > 0) {
            value.deleteCharAt(value.length() - 1);
        }
        return value;
    }

    private List<ReportVerifyRuleDimension> getReportVerifyRuleDimensionParams(ClosedCallBackEvent backEvent) {
        HashMap returnData = (HashMap)backEvent.getReturnData();
        if (MapUtils.isEmpty((Map)returnData)) {
            return new ArrayList<ReportVerifyRuleDimension>(0);
        }
        ArrayList<ReportVerifyRuleDimension> paramList = new ArrayList<ReportVerifyRuleDimension>();
        DynamicObjectCollection dimensionMembers = (DynamicObjectCollection)returnData.get("dimensionMembers");
        for (DynamicObject dimension : dimensionMembers) {
            long pkValue;
            DynamicObject dimensionObject = dimension.getDynamicObject("dimension");
            DynamicObjectCollection dynamicObjectCollection = dimension.getDynamicObjectCollection("mulmembers");
            if (Objects.isNull(dimensionObject) || NumberUtils.equalsZero((Long)(pkValue = dimensionObject.getLong("id")))) continue;
            ReportVerifyRuleDimension dimensionParam = new ReportVerifyRuleDimension();
            dimensionParam.setDimensionId(Long.valueOf(pkValue));
            dimensionParam.setDimensionName(dimensionObject.getString("name"));
            dimensionParam.setDimsionEnums(DimensionType.getDimsionByNumber((String)dimensionObject.getString("basedata")));
            ArrayList<ReportVerifyRuleDimensionMember> memberParams = new ArrayList<ReportVerifyRuleDimensionMember>();
            for (DynamicObject member : dynamicObjectCollection) {
                DynamicObject baseData = member.getDynamicObject("fbasedataid");
                ReportVerifyRuleDimensionMember memberParam = new ReportVerifyRuleDimensionMember();
                memberParam.setDimensionId((Long)dimensionObject.getPkValue());
                memberParam.setDimensionMemberId((Long)baseData.getPkValue());
                memberParam.setDimensionMemberName(baseData.getString("name"));
                memberParams.add(memberParam);
            }
            dimensionParam.setMemberParams(memberParams);
            paramList.add(dimensionParam);
        }
        if (CollectionUtils.isEmpty(paramList)) {
            this.getPageCache().put("needClear", String.valueOf(true));
            this.getModel().setValue("checkdimension", (Object)"");
            this.getModel().setValue("checkdimensionvalue_tag", (Object)"");
            this.getModel().setValue("checkeddimension", (Object)"");
            this.getModel().setValue("checkeddimensionvalue_tag", (Object)"");
        }
        return paramList;
    }

    private void createForm(String formId, String callbackColumn, String caption, Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbackColumn));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParams(params);
        this.getView().showForm(formShowParameter);
    }

    private void setOrgDimension() {
        DynamicObject dynamicObject;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            entryEntity.addNew();
        }
        if (Objects.isNull((dynamicObject = (DynamicObject)entryEntity.get(0)).get("dimension"))) {
            DynamicObject system = (DynamicObject)this.getModel().getValue("bodysysmanage");
            if (Objects.isNull(system)) {
                return;
            }
            DynamicObject tBasedataBiz = QueryServiceHelper.queryOne((String)"fpm_dimension", (String)"id", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", system.getPkValue()).and(new QFilter("basedata", "=", (Object)DimsionEnums.ORG.getNumber()))});
            if (Objects.isNull(tBasedataBiz)) {
                return;
            }
            this.getModel().setValue("dimension", (Object)tBasedataBiz.getLong("id"), 0);
            this.getView().updateView("entryentity");
        }
    }

    private void handleCheckedDimensionBeforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject checkDimension = (DynamicObject)this.getModel().getValue("checkreporttype");
        if (Objects.isNull(checkDimension)) {
            return;
        }
        ArrayList<String> periodTypes = new ArrayList<String>(16);
        PeriodType checkType = PeriodType.getByNumber((String)checkDimension.getString("orgreportcycle"));
        switch (checkType) {
            case DAY: {
                periodTypes.add(PeriodType.DAY.getNumber());
                periodTypes.add(PeriodType.MONTH_WEEK.getNumber());
                periodTypes.add(PeriodType.TEN_DAY.getNumber());
                periodTypes.add(PeriodType.MONTH.getNumber());
                break;
            }
            case TEN_DAY: {
                periodTypes.add(PeriodType.TEN_DAY.getNumber());
                periodTypes.add(PeriodType.MONTH.getNumber());
                periodTypes.add(PeriodType.QUARTER.getNumber());
                periodTypes.add(PeriodType.HALF_YEAR.getNumber());
                periodTypes.add(PeriodType.YEAR.getNumber());
                break;
            }
            case MONTH_WEEK: {
                periodTypes.add(PeriodType.MONTH_WEEK.getNumber());
                periodTypes.add(PeriodType.MONTH.getNumber());
                periodTypes.add(PeriodType.QUARTER.getNumber());
                periodTypes.add(PeriodType.HALF_YEAR.getNumber());
                periodTypes.add(PeriodType.YEAR.getNumber());
                break;
            }
            case MONTH: {
                periodTypes.add(PeriodType.MONTH.getNumber());
                periodTypes.add(PeriodType.QUARTER.getNumber());
                periodTypes.add(PeriodType.HALF_YEAR.getNumber());
                periodTypes.add(PeriodType.YEAR.getNumber());
                break;
            }
            case QUARTER: {
                periodTypes.add(PeriodType.QUARTER.getNumber());
                periodTypes.add(PeriodType.HALF_YEAR.getNumber());
                periodTypes.add(PeriodType.YEAR.getNumber());
                break;
            }
            case HALF_YEAR: {
                periodTypes.add(PeriodType.HALF_YEAR.getNumber());
                periodTypes.add(PeriodType.YEAR.getNumber());
                break;
            }
            case YEAR: {
                periodTypes.add(PeriodType.YEAR.getNumber());
                break;
            }
            case YEAR_WEEK: {
                break;
            }
        }
        DynamicObject system = (DynamicObject)this.getModel().getValue("bodysysmanage");
        if (system == null) {
            return;
        }
        DynamicObjectCollection reportEntry = system.getDynamicObjectCollection("applyrereportentry");
        List reportTypeIds = reportEntry.stream().filter(v -> "enable".equals(v.getString("rereporttypestatus"))).map(v -> v.getDynamicObject("rerporttype").getPkValue()).collect(Collectors.toList());
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("orgreportcycle", "in", periodTypes);
        qFilter.and(new QFilter("id", "in", reportTypeIds));
        showParam.getListFilterParameter().setFilter(qFilter);
    }

    private void handleTemplateBeforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject system = (DynamicObject)this.getModel().getValue("bodysysmanage");
        if (system == null) {
            return;
        }
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("model", "=", system.getPkValue());
        showParam.getListFilterParameter().setFilter(qFilter);
    }

    private void handleReportTypeBeforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject system = (DynamicObject)this.getModel().getValue("bodysysmanage");
        if (system == null) {
            return;
        }
        DynamicObjectCollection reportEntry = system.getDynamicObjectCollection("applyrereportentry");
        List reportTypeIds = reportEntry.stream().filter(v -> "enable".equals(v.getString("rereporttypestatus"))).map(v -> v.getDynamicObject("rerporttype").getPkValue()).collect(Collectors.toList());
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("id", "in", reportTypeIds);
        showParam.getListFilterParameter().setFilter(qFilter);
    }

    private void handleEntityColumnDimensionChanged(PropertyChangedArgs e) {
        Object oldVal;
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newVal = e.getChangeSet()[0].getNewValue();
        if (Objects.equals(newVal, oldVal = e.getChangeSet()[0].getOldValue())) {
            return;
        }
        this.getModel().setValue("mulmembers", null, rowIndex);
    }
}

