/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.bean.SubjectCancelConfig;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;

public class SubjectCancelConfigPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        final long bodySysId = dataEntity.getLong("bodysysid");
        final String flow = dataEntity.getString("flow");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("subjectid");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", (Object)bodySysId).and("flow", "=", (Object)flow)).build();
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        SubjectCancelConfig subjectCancelConfig = this.getSubjectCancelConfig();
        model.setValue("bodysysid", (Object)subjectCancelConfig.getBodySysId());
        model.setValue("flow", (Object)subjectCancelConfig.getFlow());
        List subjectList = subjectCancelConfig.getSubjectList();
        if (CollectionUtils.isEmpty((Collection)subjectList)) {
            return;
        }
        model.deleteEntryData("entryentity");
        for (SubjectCancelConfig.Subject subject : subjectList) {
            int newEntryRow = model.createNewEntryRow("entryentity");
            model.setValue("subjectid", (Object)subject.getId(), newEntryRow);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"confirm")) {
            return;
        }
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)this.getSubjectCancelConfigFromModel()));
        this.getView().close();
    }

    private SubjectCancelConfig getSubjectCancelConfigFromModel() {
        SubjectCancelConfig subjectCancelConfig = new SubjectCancelConfig();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        subjectCancelConfig.setBodySysId(Long.valueOf(dataEntity.getLong("bodysysid")));
        subjectCancelConfig.setFlow(dataEntity.getString("flow"));
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<SubjectCancelConfig.Subject> list = new ArrayList<SubjectCancelConfig.Subject>(dynamicObjectCollection.size());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            DynamicObject subjectDy = dynamicObject.getDynamicObject("subjectid");
            if (EmptyUtil.isEmpty((DynamicObject)subjectDy)) continue;
            SubjectCancelConfig.Subject subject = new SubjectCancelConfig.Subject();
            subject.setId((Long)subjectDy.getPkValue());
            subject.setNumber(subjectDy.getString("number"));
            subject.setName(subjectDy.getString("name"));
            DynamicObject parent = subjectDy.getDynamicObject("parent");
            subject.setParentId(Objects.isNull(parent) ? Long.valueOf(0L) : (Long)parent.getPkValue());
            subject.setSeq(i);
            list.add(subject);
        }
        subjectCancelConfig.setSubjectList(list);
        return subjectCancelConfig;
    }

    private SubjectCancelConfig getSubjectCancelConfig() {
        String subjectCancelConfigJson = (String)this.getView().getFormShowParameter().getCustomParam("SUBJECT_CANCEL_CONFIG");
        if (EmptyUtil.isEmpty((String)subjectCancelConfigJson)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u9875\u9762\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"SubjectCancelConfigPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
        return (SubjectCancelConfig)SerializationUtils.fromJsonString((String)subjectCancelConfigJson, SubjectCancelConfig.class);
    }
}

