/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.basesetting;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fpm.common.bean.CurrencyMapConfig;

public class SummaryParamBatchSetPlugin
extends AbstractBasePlugIn {
    private static final String BTN_OK = "confirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"currencymapcase"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "currencymapcase": {
                this.showCurrencyMapConfigForm();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long bodySysId = (Long)formShowParameter.getCustomParam("bodysysid");
        this.getModel().setValue("bodysysid", (Object)bodySysId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)BTN_OK)) {
            return;
        }
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)this.getModel().getDataEntity()));
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (!StringUtils.equals((CharSequence)actionId, (CharSequence)"currencymapcase")) {
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        this.setCurrencyMapCase(returnData);
    }

    private void setCurrencyMapCase(Object returnData) {
        if (!String.class.isInstance(returnData)) {
            return;
        }
        String currencyMapConfigJson = (String)returnData;
        CurrencyMapConfig currencyMapConfig = (CurrencyMapConfig)SerializationUtils.fromJsonString((String)currencyMapConfigJson, CurrencyMapConfig.class);
        this.getModel().setValue("currencymapcase", (Object)String.join((CharSequence)":", currencyMapConfig.getNumber(), currencyMapConfig.getName()));
        this.getModel().setValue("currencymapcasereal_tag", (Object)currencyMapConfigJson);
    }

    private void showCurrencyMapConfigForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fpm_currencymapconfig");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long bodySysId = dataEntity.getLong("bodysysid");
        CurrencyMapConfig currencyMapConfig = new CurrencyMapConfig(bodySysId);
        if (!StringUtils.isEmpty((CharSequence)dataEntity.getString("currencymapcase"))) {
            currencyMapConfig = (CurrencyMapConfig)SerializationUtils.fromJsonString((String)dataEntity.getString("currencymapcasereal_tag"), CurrencyMapConfig.class);
        }
        formShowParameter.setCustomParam("CURRENCY_MAP_CONFIG", (Object)SerializationUtils.toJsonString((Object)currencyMapConfig));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "currencymapcase"));
        this.getView().showForm(formShowParameter);
    }
}

