/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.collet.plan;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;

public class ExecSmartCollectPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ExecSmartCollectPlugin.class);
    private static final String HEAD_SOURCEBILL = "sourcebill";
    private static final String HEAD_ORGRANGE = "orgrange";
    private static final String OP_CONFIRM = "confirm";
    private static final String BTN_OK = "btnok";
    private static final String SCHEMEID = "schemeId";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey().toLowerCase();
        if (BTN_OK.equals(key)) {
            OperateOption option = OperateOption.create();
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Object schemeId = fsp.getCustomParam(SCHEMEID);
            if (schemeId != null) {
                option.setVariableValue(SCHEMEID, schemeId.toString());
            }
            this.getView().invokeOperation(OP_CONFIRM, option);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object schemeId = fsp.getCustomParam(SCHEMEID);
        if (schemeId != null) {
            DynamicObject scheme = TmcDataServiceHelper.loadSingle((Object)schemeId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_smartcollect"));
            this.getModel().setValue(HEAD_SOURCEBILL, (Object)scheme.getDynamicObject(HEAD_SOURCEBILL).getString("number"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{HEAD_SOURCEBILL});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgRangeF7 = (BasedataEdit)this.getView().getControl(HEAD_ORGRANGE);
        orgRangeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject sourceBill = this.getModel().getDataEntity().getDynamicObject(HEAD_SOURCEBILL);
            if (EmptyUtil.isEmpty((DynamicObject)sourceBill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u3002", (String)"ExecSmartCollectPlugin_02", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String sourceBillNum = sourceBill.getString("number");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sourceBillNum);
            String mainOrg = dataEntityType.getMainOrg();
            MainOrgProp mainOrgProp = (MainOrgProp)dataEntityType.findProperty(mainOrg);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("orgFuncId", (Object)mainOrgProp.getOrgFunc());
            HasPermOrgResult userPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)mainOrgProp.getOrgFunc(), (String)dataEntityType.getAppId(), (String)sourceBillNum, (String)"47150e89000000ac");
            QFilter qFilter = new QFilter("status", "=", (Object)BillStatus.AUDITED.getNumber()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            if (!userPermOrgResult.hasAllOrgPerm()) {
                qFilter.and("id", "in", (Object)userPermOrgResult.getHasPermOrgs());
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit sourcebillF7 = (BasedataEdit)this.getView().getControl(HEAD_SOURCEBILL);
        sourcebillF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject[] smartCollectPlans = TmcDataServiceHelper.load((String)"fpm_smartcollect", (String)HEAD_SOURCEBILL, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            Set billNumbers = Arrays.stream(smartCollectPlans).filter(Objects::nonNull).map(o -> o.getDynamicObject(HEAD_SOURCEBILL).getString("number")).collect(Collectors.toSet());
            if (billNumbers.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u667a\u80fd\u91c7\u96c6\u65b9\u6848\uff0c\u7136\u540e\u6267\u884c\u667a\u80fd\u91c7\u96c6\u3002", (String)"ExecSmartCollectPlugin_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("number", "in", billNumbers);
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (OP_CONFIRM.equals(operateKey) && evt.getOperationResult().isSuccess()) {
            logger.info(String.format("%s \u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u540e\u53f0\u6293\u53d6\u7b26\u5408\u91c7\u96c6\u6761\u4ef6\u7684\u6570\u636e\u4e2d...", operateKey));
            String sourceBill = this.getModel().getDataEntity().getDynamicObject(HEAD_SOURCEBILL).getString("number");
            String billName = MetadataServiceHelper.getDataEntityType((String)sourceBill).getDisplayName().getLocaleValue();
            String tipMsg = String.format(ResManager.loadKDString((String)"\u5df2\u4ece\u201c%s\u201d\u6293\u53d6\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u751f\u6210\u6536\u652f\u8ba1\u5212\u91c7\u96c6\u5355\u3002\u8bf7\u7a0d\u540e\u67e5\u8be2\u3002", (String)"ExecSmartCollectPlugin_04", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), billName);
            this.getView().showTipNotification(tipMsg);
        }
    }
}

