/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.collet.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.helper.SchemeGatherHelper;
import kd.tmc.fpm.common.enums.DataSyncStrategyEnum;
import kd.tmc.fpm.common.enums.GetValueTypeEnum;
import kd.tmc.fpm.common.enums.MatchRuleLinkEntityEnum;
import kd.tmc.fpm.common.property.InOutPlanCollectProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.formplugin.helper.ExpressionFormHelper;

public class SmartCollectPlanPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"applycondition", "getvaluedesc", "entry_syncopname"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgRangeF7 = (BasedataEdit)this.getView().getControl("org");
        orgRangeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String mainOrg;
            DynamicObject sourceBill = this.getModel().getDataEntity().getDynamicObject("sourcebill");
            Optional<DynamicObject> sourceBillOp = Optional.ofNullable(sourceBill);
            if (!sourceBillOp.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u3002", (String)"SmartCollectPlanPlugin_06", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String sourceBillEntityId = sourceBillOp.get().getString("number");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sourceBillEntityId);
            MainOrgProp mainOrgProp = (MainOrgProp)dataEntityType.findProperty(mainOrg = dataEntityType.getMainOrg());
            if (EmptyUtil.isEmpty((Object)mainOrgProp)) {
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("orgFuncId", (Object)mainOrgProp.getOrgFunc());
            HasPermOrgResult userPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)mainOrgProp.getOrgFunc(), (String)dataEntityType.getAppId(), (String)sourceBillEntityId, (String)"47150e89000000ac");
            if (!userPermOrgResult.hasAllOrgPerm()) {
                QFilter filter = new QFilter("id", "in", (Object)userPermOrgResult.getHasPermOrgs());
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctr = (Control)evt.getSource();
        switch (key = ctr.getKey()) {
            case "applycondition": {
                String applyCondition = ResManager.loadKDString((String)"\u9002\u7528\u6761\u4ef6", (String)"SmartCollectPlanPlugin_02", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                this.openExpressionForm("saveapplycondition_tag", null, applyCondition, "saveapplycondition_tag", false, true, false);
                break;
            }
            case "getvaluedesc": {
                int index = this.getModel().getEntryCurrentRowIndex("entry_fieldmapping");
                DynamicObject fieldMappingEntry = this.getModel().getEntryRowEntity("entry_fieldmapping", index);
                String valType = fieldMappingEntry.getString("valtype");
                if (!GetValueTypeEnum.CALC_FORMULA.getValue().equals(valType)) break;
                this.openFormulaForm();
                break;
            }
            case "entry_syncopname": {
                DynamicObject sourceEntityType = (DynamicObject)this.getModel().getValue("sourcebill");
                if (EmptyUtil.isEmpty((DynamicObject)sourceEntityType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u3002", (String)"SmartCollectPlanPlugin_06", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int currSelectRow = this.getModel().getEntryCurrentRowIndex("entry_syncstrategy");
                String opKeyStr = (String)this.getModel().getValue("entry_syncopkey", currSelectRow);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("fpm_billoperation");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_OP"));
                List opList = EntityMetadataCache.getDataEntityOperate((String)sourceEntityType.getString("number"));
                for (Map opMap : opList) {
                    Map name = (Map)opMap.get("name");
                    opMap.put("name", name.get(Lang.get().toString()));
                }
                showParameter.getCustomParams().put("operator", opList);
                if (EmptyUtil.isNotEmpty((CharSequence)opKeyStr)) {
                    String[] selectedKeyArr = opKeyStr.split(",");
                    showParameter.getCustomParams().put("operator_selected", Arrays.asList(selectedKeyArr));
                }
                this.getView().showForm(showParameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate op = (AbstractOperate)evt.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            boolean cancel = this.existMoreThan3LevelFieldInApplyFilter();
            cancel = cancel || this.mappingEntryCheck();
            evt.setCancel(cancel);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPage();
        int strategyCnt = this.getModel().getEntryRowCount("entry_syncstrategy");
        if (strategyCnt == 0) {
            this.getModel().batchCreateNewEntryRow("entry_syncstrategy", 2);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"entry_strategy", (Object)DataSyncStrategyEnum.UPDATE.getValue(), (int)0);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"entry_strategy", (Object)DataSyncStrategyEnum.DISCARD.getValue(), (int)1);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changedata = e.getChangeSet()[0];
        Object newValue = changedata.getNewValue();
        int row = 0;
        switch (propName) {
            case "sourcebill": {
                if (newValue == null) break;
                DynamicObject sourceBillDy = (DynamicObject)newValue;
                this.getModel().setValue("linkentity", null);
                this.initLinkEntity(sourceBillDy.getString("number"));
                this.initTargetBillFieldIntoEntry();
                this.getModel().setValue("applycondition", null);
                this.getModel().setValue("saveapplycondition", null);
                this.getModel().setValue("saveapplycondition_tag", null);
                break;
            }
            case "valtype": {
                row = this.getModel().getEntryCurrentRowIndex("entry_fieldmapping");
                this.getModel().setValue("sourcefieldsave", null, row);
                this.getModel().setValue("getvaluedesc", null, row);
                this.getModel().setValue("getvaluesave", null, row);
                this.getModel().setValue("getvaluesave_tag", null, row);
                boolean enableSync = (Boolean)this.getModel().getValue("sync", row);
                this.updateSyncPropStatus((String)newValue, null, enableSync, row);
                break;
            }
            case "sync": {
                row = this.getModel().getEntryCurrentRowIndex("entry_fieldmapping");
                String valueType = (String)this.getModel().getValue("valtype", row);
                Object val = this.getModel().getValue("sourcefieldsave", row);
                this.updateSyncPropStatus(valueType, val, (Boolean)newValue, row);
                break;
            }
            case "entry_syncopname": {
                if (!EmptyUtil.isEmpty((String)((String)newValue))) break;
                row = this.getModel().getEntryCurrentRowIndex("entry_syncstrategy");
                this.getModel().setValue("entry_syncopkey", null, row);
                break;
            }
            case "judgeunique": {
                List enableUniqueJudgeFields = this.getModel().getEntryEntity("entry_fieldmapping").stream().filter(Objects::nonNull).filter(o -> o.getBoolean("judgeunique")).collect(Collectors.toList());
                row = this.getModel().getEntryCurrentRowIndex("entry_fieldmapping");
                if (enableUniqueJudgeFields.size() > 5) {
                    this.getModel().setValue("judgeunique", (Object)Boolean.FALSE, row);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e95\u4e2a\u5b57\u6bb5\u4f5c\u4e3a\u201c\u6570\u636e\u5224\u65ad\u89c4\u5219\u552f\u4e00\u503c\u201d\u3002", (String)"SmartCollectPlanPlugin_07", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                }
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry_fieldmapping", row);
                String targetBill = Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("targetbill")).map(o -> o.getString("number")).orElseGet(() -> null);
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)targetBill);
                IDataEntityProperty property = mainEntityType.findProperty(rowEntity.getString("targetfieldprop"));
                if (!(property instanceof MulBasedataProp)) break;
                this.getModel().setValue("judgeunique", (Object)Boolean.FALSE, row);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5224\u65ad\u89c4\u5219\u552f\u4e00\u503c\u4e0d\u652f\u6301\u591a\u9009\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"SmartCollectPlanPlugin_08", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "linkentity": {
                this.initTargetBillFieldIntoEntry();
                this.getModel().setValue("applycondition", null);
                this.getModel().setValue("saveapplycondition", null);
                this.getModel().setValue("saveapplycondition_tag", null);
                this.initSourceBillDownBox(newValue == null ? null : newValue.toString());
                break;
            }
            case "sourcefieldsave": {
                row = this.getModel().getEntryCurrentRowIndex("entry_fieldmapping");
                String valueType = (String)this.getModel().getValue("valtype", row);
                boolean isSync = (Boolean)this.getModel().getValue("sync", row);
                this.updateSyncPropStatus(valueType, newValue, isSync, row);
            }
        }
    }

    private void updateSyncPropStatus(String valType, Object val, boolean sync, int row) {
        boolean sourceIdProp;
        boolean isFormula = GetValueTypeEnum.CALC_FORMULA.getValue().equals(valType);
        boolean isSourceField = GetValueTypeEnum.SOURCE_FIELD.getValue().equals(valType);
        boolean isConst = GetValueTypeEnum.CONSTANT.getValue().equals(valType);
        boolean valIsEmpty = EmptyUtil.isEmpty((Object)val);
        boolean billDisable = !this.getModel().getDataEntity().getBoolean("enable");
        boolean isAddNew = this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW;
        boolean enableSync = !(!isFormula && valIsEmpty || !isAddNew && !billDisable);
        boolean enableSyncProp = enableSync && sync && isFormula;
        this.getView().setEnable(Boolean.valueOf(enableSyncProp), row, new String[]{"syncprop"});
        this.getView().setEnable(Boolean.valueOf(enableSync), row, new String[]{"sync"});
        String currTargetProp = (String)this.getModel().getValue("targetfieldprop", row);
        boolean bl = sourceIdProp = "sourcebillid".equals(currTargetProp) || "sourcebillentryid".equals(currTargetProp);
        if (sourceIdProp) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"judgeunique", (Object)true, (int)row);
            this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"judgeunique"});
        }
        if (isConst || isSourceField && valIsEmpty) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"sync", (Object)false, (int)row);
        }
        if (isSourceField && sync) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"syncprop", (Object)val, (int)row);
        }
        if (!sync) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"syncprop", null, (int)row);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "CALLBACK_BYCONDITION": {
                String condition = Optional.ofNullable(evt.getReturnData()).map(Objects::toString).orElseGet(() -> null);
                if (StringUtils.isBlank((CharSequence)condition)) break;
                CRValByConditions byCondi = (CRValByConditions)SerializationUtils.fromJsonString((String)condition, CRValByConditions.class);
                this.getModel().setValue("getvaluesave_tag", (Object)condition);
                this.getModel().setValue("getvaluedesc", (Object)this.cutStr(byCondi.getDescription(), 1024));
                break;
            }
            case "CALLBACK_FORMULA": {
                String formula = Optional.ofNullable(evt.getReturnData()).map(Objects::toString).orElseGet(() -> null);
                if (EmptyUtil.isBlank((CharSequence)formula)) break;
                this.getModel().setValue("getvaluesave_tag", (Object)formula);
                CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formula, CRFormula.class);
                this.getModel().setValue("getvaluedesc", (Object)this.cutStr(crFormula.getExprDesc(), 1024));
                break;
            }
            case "saveapplycondition_tag": {
                ExpressionFromHelper.dealCallbackOfCloseForm((ClosedCallBackEvent)evt, (String)"applycondition", (String)"saveapplycondition_tag", (AbstractFormPlugin)this);
                break;
            }
            case "CALLBACK_OP": {
                Map returnData = (Map)evt.getReturnData();
                if (EmptyUtil.isEmpty((Object)returnData)) {
                    return;
                }
                String opKeyStr = (String)returnData.get("key");
                String opNameStr = (String)returnData.get("name");
                if (opKeyStr.length() > 2000 || opNameStr.length() > 2000) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6570\u91cf\u8fc7\u591a\uff0c\u6587\u672c\u957f\u5ea6\u5e94\u5c0f\u4e8e\u7b49\u4e8e2000\u3002\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SmartCollectPlanPlugin_12", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entry_syncstrategy");
                this.getModel().setValue("entry_syncopkey", (Object)opKeyStr, rowIndex);
                this.getModel().setValue("entry_syncopname", (Object)opNameStr, rowIndex);
            }
        }
    }

    private void initLinkEntity(String billNumber) {
        ComboEdit linkEntityControl = (ComboEdit)this.getControl("linkentity");
        if (EmptyUtil.isEmpty((String)billNumber)) {
            linkEntityControl.setComboItems(Collections.emptyList());
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        Map allEntities = dataEntityType.getAllEntities();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(allEntities.size());
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType entryValue = (EntityType)entry.getValue();
            if (LinkEntryType.class.isInstance(entry.getValue()) || SubEntryType.class.isInstance(entry.getValue())) continue;
            String key = (String)entry.getKey();
            comboItemList.add(new ComboItem(BillEntityType.class.isInstance(entryValue) ? new LocaleString(MatchRuleLinkEntityEnum.BILL_HEAD.getName()) : entryValue.getDisplayName(), key));
        }
        linkEntityControl.setComboItems(comboItemList);
    }

    private void initPage() {
        DynamicObject sourceBillDy;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"targetbill", (Object)"fpm_inoutcollect");
        int entryRowCount = this.getModel().getEntryRowCount("entry_fieldmapping");
        boolean enable = dataEntity.getBoolean("enable");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (entryRowCount == 0) {
            this.initTargetBillFieldIntoEntry();
        } else if (!enable || OperationStatus.ADDNEW == status) {
            this.fillTargetBillNewFieldIntoEntry();
            this.fixedEntryFieldFeatures();
        }
        if (OperationStatus.ADDNEW != status) {
            this.renameTargetFieldDesc(Collections.singletonList("currency"));
        }
        if ((sourceBillDy = dataEntity.getDynamicObject("sourcebill")) != null) {
            this.initLinkEntity(sourceBillDy.getString("number"));
            this.initSourceBillDownBox(dataEntity.getString("linkentity"));
        }
        if (OperationStatus.EDIT == status) {
            if (enable) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", "targetbill", "applycondition", "remark", "entry_fieldmapping", "entry_applyorg", "sync", "entry_syncimm", "entry_syncopkey", "entry_syncopname", "entry_syncstrategy", "entryup", "entrydown", "addrow", "delrow"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"name", "targetbill", "applycondition", "remark", "entry_fieldmapping", "entry_applyorg", "sync", "entry_syncimm", "entry_syncopkey", "entry_syncopname", "entry_syncstrategy", "entryup", "entrydown", "addrow", "delrow"});
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "sourcebill", "linkentity"});
        }
    }

    private void fixedEntryFieldFeatures() {
        DynamicObjectCollection fieldMappingEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("entry_fieldmapping");
        String billNumber = this.getModel().getDataEntity().getDynamicObject("targetbill").getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        for (int index = 0; index < fieldMappingEntrys.size(); ++index) {
            DynamicObject entry = (DynamicObject)fieldMappingEntrys.get(index);
            String targetField = entry.getString("targetfieldprop");
            IDataEntityProperty fieldProp = dataEntityType.findProperty(targetField);
            boolean isIntercept = false;
            if (fieldProp instanceof TextProp) {
                isIntercept = true;
            }
            this.getView().setEnable(Boolean.valueOf(isIntercept), index, new String[]{"isintercept"});
            String valueType = entry.getString("valtype");
            boolean isSync = entry.getBoolean("sync");
            Object val = entry.get("sourcefieldsave");
            this.updateSyncPropStatus(valueType, val, isSync, index);
            if (!InOutPlanCollectProp.CONST_VAL_PROPS.contains(targetField)) continue;
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"valtype", "sourcefieldsave", "judgeunique", "sync"});
        }
    }

    private void initTargetBillFieldIntoEntry() {
        String billNumber = this.getModel().getDataEntity().getDynamicObject("targetbill").getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        Map allEntities = dataEntityType.getAllEntities();
        Map<String, LocaleString> billAllPropMaps = this.getBillAllProps(allEntities, this.getExcludeProp());
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billNumber);
        if (EmptyUtil.isNoEmpty(billAllPropMaps)) {
            List<String> props = billAllPropMaps.entrySet().stream().filter(Objects::nonNull).sorted((a, b) -> {
                Boolean abool = this.isMustInput(mainEntityType, (String)a.getKey());
                Boolean bbool = this.isMustInput(mainEntityType, (String)b.getKey());
                return bbool.compareTo(abool);
            }).map(Map.Entry::getKey).filter(o -> !o.equals("opusertype") && !o.equals("opusername")).collect(Collectors.toList());
            props.add("opusertype");
            props.add("opusername");
            this.getModel().deleteEntryData("entry_fieldmapping");
            this.insertFieldMappingEntryRow(props, billAllPropMaps, mainEntityType);
        }
    }

    private void fillTargetBillNewFieldIntoEntry() {
        String billNumber = this.getModel().getDataEntity().getDynamicObject("targetbill").getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        Map allEntities = dataEntityType.getAllEntities();
        Map<String, LocaleString> billAllPropMaps = this.getBillAllProps(allEntities, this.getExcludeProp());
        if (EmptyUtil.isNoEmpty(billAllPropMaps)) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billNumber);
            DynamicObjectCollection dbFieldMappingEntry = this.getModel().getDataEntity().getDynamicObjectCollection("entry_fieldmapping");
            Set dbTargetFieldSet = dbFieldMappingEntry.stream().map(mapping -> mapping.getString("targetfieldprop")).collect(Collectors.toSet());
            List<String> props = billAllPropMaps.entrySet().stream().filter(Objects::nonNull).filter(o -> !dbTargetFieldSet.contains(o.getKey())).sorted((a, b) -> {
                Boolean abool = this.isMustInput(mainEntityType, (String)a.getKey());
                Boolean bbool = this.isMustInput(mainEntityType, (String)b.getKey());
                return bbool.compareTo(abool);
            }).map(Map.Entry::getKey).collect(Collectors.toList());
            this.insertFieldMappingEntryRow(props, billAllPropMaps, mainEntityType);
        }
    }

    private void insertFieldMappingEntryRow(List<String> props, Map<String, LocaleString> billAllPropMaps, MainEntityType mainEntityType) {
        if (EmptyUtil.isEmpty(props)) {
            return;
        }
        DynamicObjectCollection fieldMappingEntry = this.getModel().getDataEntity().getDynamicObjectCollection("entry_fieldmapping");
        int index = fieldMappingEntry.size();
        this.getModel().batchCreateNewEntryRow("entry_fieldmapping", props.size());
        for (String prop : props) {
            LocaleString displayName = billAllPropMaps.get(prop);
            IDataEntityProperty fieldProp = mainEntityType.findProperty(prop);
            boolean mustInput = false;
            if (fieldProp instanceof BasedataProp) {
                mustInput = ((BasedataProp)fieldProp).isMustInput();
            } else if (fieldProp instanceof FieldProp) {
                mustInput = ((FieldProp)fieldProp).isMustInput();
            }
            if (InOutPlanCollectProp.CONST_VAL_PROPS.contains(prop) || InOutPlanCollectProp.LINK_VAL_PROP.contains(prop)) {
                mustInput = false;
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"mustinput", (Object)mustInput, (int)index);
            boolean isIntercept = fieldProp instanceof TextProp;
            this.getView().setEnable(Boolean.valueOf(isIntercept), index, new String[]{"isintercept"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"isintercept", (Object)false, (int)index);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"targetfielddesc", (Object)displayName, (int)index);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"targetfieldprop", (Object)prop, (int)index);
            if (InOutPlanCollectProp.CONST_VAL_PROPS.contains(prop)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"valtype", (Object)GetValueTypeEnum.SOURCE_FIELD.getValue(), (int)index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"valtype", "sourcefieldsave", "judgeunique", "sync"});
            }
            this.updateSyncPropStatus(GetValueTypeEnum.SOURCE_FIELD.getValue(), null, false, index);
            ++index;
        }
    }

    private Set<String> getExcludeProp() {
        HashSet<String> excludeProps = new HashSet<String>(10);
        excludeProps.add("creator");
        excludeProps.add("modifier");
        excludeProps.add("auditdate");
        excludeProps.add("createtime");
        excludeProps.add("modifytime");
        excludeProps.add("datasource");
        excludeProps.add("sourceapp");
        excludeProps.add("sourcebill");
        excludeProps.add("sourcebillnumber");
        excludeProps.add("sourcebillentryid");
        excludeProps.add("abandonstatus");
        excludeProps.add("abandonreason");
        excludeProps.add("batchno");
        excludeProps.add("approvalbillno");
        excludeProps.add("approvalbillid");
        excludeProps.add("crontemplateid");
        excludeProps.add("auditor");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sourcebill = dataEntity.getDynamicObject("sourcebill");
        if (EmptyUtil.isNoEmpty((DynamicObject)sourcebill)) {
            String billNumber = sourcebill.getString("number");
            String linkEntity = dataEntity.getString("linkentity");
            IDataEntityProperty property = MetadataServiceHelper.getDataEntityType((String)billNumber).findProperty(linkEntity);
            if (linkEntity != null && property instanceof EntryProp) {
                excludeProps.remove("sourcebillentryid");
            }
        }
        return excludeProps;
    }

    private Map<String, LocaleString> getBillAllProps(Map<String, EntityType> allEntities, Set<String> excludeBillFields) {
        Set<Map.Entry<String, EntityType>> entries = allEntities.entrySet();
        HashMap<String, LocaleString> billAllFields = new HashMap<String, LocaleString>(16);
        for (Map.Entry<String, EntityType> entry : entries) {
            EntityType entityType = entry.getValue();
            if (LinkEntryType.class.isInstance(entityType) || EntryType.class.isInstance(entityType)) continue;
            Map fields = entityType.getFields();
            for (Map.Entry fieldPropEntry : fields.entrySet()) {
                String fieldName = ((IDataEntityProperty)fieldPropEntry.getValue()).getDisplayName().toString();
                String fieldProp = (String)fieldPropEntry.getKey();
                if (excludeBillFields.contains(fieldProp)) continue;
                billAllFields.put(fieldProp, new LocaleString(fieldName));
            }
        }
        return billAllFields;
    }

    public void openExpressionForm(String fieldSign, Integer row, String fromTitle, String callbackId, boolean showAdvancePanel, boolean showBasePanel, boolean showOpBtn) {
        String funcsXML;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String sourceBillId = Optional.ofNullable(dataEntity.getDynamicObject("sourcebill")).map(o -> o.getString("number")).orElseGet(() -> null);
        if (EmptyUtil.isEmpty((String)sourceBillId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u7c7b\u578b\u3002", (String)"SmartCollectPlanPlugin_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String linkEntity = dataEntity.getString("linkentity");
        if (EmptyUtil.isEmpty((String)linkEntity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u6570\u5173\u8054\u5b9e\u4f53\u3002", (String)"SmartCollectPlanPlugin_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String conditionJson = null;
        if (row != null) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry_fieldmapping", row.intValue());
            conditionJson = rowEntity.getString(fieldSign);
        } else {
            conditionJson = dataEntity.getString(fieldSign);
        }
        String cacheKey = String.format("%s:%s:%s", this.getView().getPageId(), sourceBillId, linkEntity);
        String fieldNodesJson = ExpressionFormHelper.getSourceBillFieldNode(sourceBillId, cacheKey, this, linkEntity);
        conditionJson = EmptyUtil.isNoEmpty((String)conditionJson) ? conditionJson : fieldNodesJson;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_abnormal_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", sourceBillId);
        showParameter.getCustomParams().put("treenodes", fieldNodesJson);
        showParameter.getCustomParams().put("SHOW_ADVANCE_PANEL", showAdvancePanel);
        showParameter.getCustomParams().put("SHOW_BASE_PANEL", showBasePanel);
        showParameter.getCustomParams().put("SHOW_OP_BTN", showOpBtn);
        showParameter.getCustomParams().put("FORM_TITLE", fromTitle);
        HashSet<String> selectedEntryEntities = new HashSet<String>(2, 1.0f);
        selectedEntryEntities.add(sourceBillId);
        selectedEntryEntities.add(linkEntity);
        showParameter.getCustomParams().put("SELECTABLE_ENTRY_ENTITY", selectedEntryEntities);
        if (!showAdvancePanel) {
            StyleCss css = new StyleCss();
            css.setWidth("780px");
            css.setHeight("300px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
        }
        if (StringUtils.isBlank((CharSequence)(funcsXML = this.getView().getPageCache().get("functiontypes")))) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getView().getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbackId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void openFormulaForm() {
        int row = this.getModel().getEntryCurrentRowIndex("entry_fieldmapping");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String sourceBillId = Optional.ofNullable(dataEntity.getDynamicObject("sourcebill")).map(o -> o.getString("number")).orElseGet(() -> null);
        if (EmptyUtil.isEmpty((String)sourceBillId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u7c7b\u578b\u3002", (String)"SmartCollectPlanPlugin_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String linkEntity = dataEntity.getString("linkentity");
        if (EmptyUtil.isEmpty((String)linkEntity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u6570\u5173\u8054\u5b9e\u4f53\u3002", (String)"SmartCollectPlanPlugin_14", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry_fieldmapping", row);
        String formula = rowEntity.getString("getvaluesave_tag");
        if (EmptyUtil.isEmpty((String)formula)) {
            formula = SerializationUtils.toJsonString((Object)new CRFormula());
        }
        showParameter.getCustomParams().put("formula", formula);
        showParameter.getCustomParams().put("entitynumber", sourceBillId);
        String cacheKey = String.format("%s:%s:%s", this.getView().getPageId(), sourceBillId, linkEntity);
        String fieldNodes = ExpressionFormHelper.getSourceBillFieldNode(sourceBillId, cacheKey, this, linkEntity);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = this.getView().getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getView().getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_FORMULA"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private boolean isMustInput(MainEntityType mainEntityType, String prop) {
        IDataEntityProperty fieldProp = mainEntityType.findProperty(prop);
        boolean mustInput = false;
        if (fieldProp instanceof BasedataProp) {
            mustInput = ((BasedataProp)fieldProp).isMustInput();
        } else if (fieldProp instanceof FieldProp) {
            mustInput = ((FieldProp)fieldProp).isMustInput();
        }
        return mustInput;
    }

    private void initSourceBillDownBox(String linkEntity) {
        List<ComboItem> comboItems = this.getComboItemList(linkEntity);
        ComboEdit sourcebillCombo = (ComboEdit)this.getControl("sourcefieldsave");
        ComboEdit syncOpNameCombo = (ComboEdit)this.getControl("syncprop");
        sourcebillCombo.setComboItems(comboItems);
        syncOpNameCombo.setComboItems(comboItems);
    }

    private List<ComboItem> getComboItemList(String linkEntity) {
        if (EmptyUtil.isEmpty((String)linkEntity)) {
            return new ArrayList<ComboItem>(0);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String sourcebillNumber = dataEntity.getDynamicObject("sourcebill").getString("number");
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)sourcebillNumber);
        boolean isEntrys = sourceMainType.findProperty(linkEntity) instanceof EntryProp;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry entityTypeEntry : sourceMainType.getAllEntities().entrySet()) {
            if (LinkEntryType.class.isInstance(entityTypeEntry.getValue())) continue;
            if (BillEntityType.class.isInstance(entityTypeEntry.getValue())) {
                EntityType entityType = (EntityType)entityTypeEntry.getValue();
                for (Map.Entry propertyEntry : entityType.getFields().entrySet()) {
                    String fieldName = ((IDataEntityProperty)propertyEntry.getValue()).getDisplayName().toString();
                    String fieldProp = (String)propertyEntry.getKey();
                    ComboItem combo = new ComboItem(new LocaleString(fieldName), fieldProp);
                    comboItems.add(combo);
                }
            }
            String entryNumber = (String)entityTypeEntry.getKey();
            if (!isEntrys || !linkEntity.equals(entryNumber)) continue;
            EntityType entityType = (EntityType)entityTypeEntry.getValue();
            String entryName = entityType.getDisplayName().getLocaleValue();
            for (Map.Entry propertyEntry : entityType.getFields().entrySet()) {
                String fieldName = ((IDataEntityProperty)propertyEntry.getValue()).getDisplayName().toString();
                fieldName = String.format("%s.%s", entryName, fieldName);
                String fieldProp = (String)propertyEntry.getKey();
                ComboItem combo = new ComboItem(new LocaleString(fieldName), fieldProp);
                comboItems.add(combo);
            }
        }
        return comboItems;
    }

    private String cutStr(String descript, int range) {
        if (EmptyUtil.isEmpty((String)descript)) {
            return "";
        }
        if (descript.length() > range) {
            descript = descript.substring(0, range);
        }
        return descript;
    }

    private boolean mappingEntryCheck() {
        Set isWriteSet;
        boolean isCancle = false;
        DynamicObjectCollection fieldMappingItems = this.getModel().getEntryEntity("entry_fieldmapping");
        fieldMappingItems.stream().filter(Objects::nonNull).filter(o -> {
            String valType = o.getString("valtype");
            return GetValueTypeEnum.compare((GetValueTypeEnum)GetValueTypeEnum.CONSTANT, (String)valType);
        }).forEach(o -> {
            String constantVal = o.getString("getvaluedesc");
            o.set("getvaluesave_tag", (Object)constantVal);
        });
        Optional<DynamicObject> anyOp = fieldMappingItems.stream().filter(Objects::nonNull).filter(o -> o.getBoolean("judgeunique")).findAny();
        boolean isSelUniqueField = anyOp.isPresent();
        if (!isSelUniqueField) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u4e2d\u7684\u5b57\u6bb5\u4f5c\u4e3a\u6570\u636e\u5224\u65ad\u89c4\u5219\u7684\u552f\u4e00\u503c\u3002", (String)"SmartCollectPlanPlugin_05", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            isCancle = true;
        }
        if ((anyOp = fieldMappingItems.stream().filter(Objects::nonNull).filter(o -> o.getBoolean("judgeunique")).filter(o -> {
            String targetFieldProp = o.getString("targetfieldprop");
            return !InOutPlanCollectProp.DEFAULT_FIELD_MAPPING_JUDGE_UNIQUE_TARGET_PROPS.contains(targetFieldProp);
        }).filter(o -> {
            String express = this.getFieldMappingExpress((DynamicObject)o);
            return EmptyUtil.isEmpty((String)express);
        }).findAny()).isPresent()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u6bb5\u3010%s\u3011\u4f5c\u4e3a\u6570\u636e\u552f\u4e00\u6027\u5224\u65ad\u5b57\u6bb5\u65f6\uff0c\u6e90\u5355\u5b57\u6bb5\u6216\u53d6\u503c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u5168\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"SmartCollectPlanPlugin_13", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), anyOp.get().getString("targetfielddesc")));
            isCancle = true;
        }
        if ((isWriteSet = fieldMappingItems.stream().filter(Objects::nonNull).filter(o -> o.getBoolean("mustinput")).map(item -> {
            String express = this.getFieldMappingExpress((DynamicObject)item);
            return EmptyUtil.isNoEmpty((String)express);
        }).collect(Collectors.toSet())).contains(Boolean.FALSE)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u5f55\u5b57\u6bb5\u672a\u8bbe\u7f6e\u8868\u8fbe\u5f0f\u3002", (String)"SmartCollectPlanPlugin_09", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            isCancle = true;
        }
        DynamicObject targetBillObj = this.getModel().getDataEntity().getDynamicObject("targetbill");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)targetBillObj.getString("number"));
        Map allFields = dataEntityType.getAllFields();
        ArrayList<String> errMessageList = new ArrayList<String>(fieldMappingItems.size());
        for (DynamicObject fieldMappingItem : fieldMappingItems) {
            boolean noneMatch;
            List comboItems;
            String targetFieldProp;
            IDataEntityProperty iDataEntityProperty;
            String valType = fieldMappingItem.getString("valtype");
            if (!GetValueTypeEnum.compare((GetValueTypeEnum)GetValueTypeEnum.CONSTANT, (String)valType) || (iDataEntityProperty = (IDataEntityProperty)allFields.get(targetFieldProp = fieldMappingItem.getString("targetfieldprop"))) == null) continue;
            LocaleString displayName = iDataEntityProperty.getDisplayName();
            String value = fieldMappingItem.getString("getvaluedesc");
            if (!(iDataEntityProperty instanceof ComboProp) || CollectionUtils.isEmpty((Collection)(comboItems = ((ComboProp)iDataEntityProperty).getComboItems())) || !(noneMatch = comboItems.stream().noneMatch(item -> StringUtils.equals((CharSequence)item.getValue(), (CharSequence)value)))) continue;
            errMessageList.add(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u6bb5\u201c%1$s\u201d\u6240\u8bbe\u7f6e\u7684\u5e38\u91cf\u53d6\u503c\u8868\u8fbe\u5f0f\u65e0\u6cd5\u5339\u914d\u5bf9\u5e94\u201c\u4e0b\u62c9\u503c\u201d\uff0c\u8bf7\u68c0\u67e5\u53d6\u503c\u8868\u8fbe\u5f0f\u914d\u7f6e\u3002", (String)"SmartCollectPlanPlugin_15", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), displayName.getLocaleValue()));
        }
        if (errMessageList.size() > 0) {
            isCancle = true;
            this.showErrMessage(errMessageList);
        }
        isCancle = isCancle || this.existMoreThan3LevelFieldInCalcFormula(fieldMappingItems);
        return isCancle;
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElse(""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    private void renameTargetFieldDesc(List<String> targetFieldProps) {
        if (EmptyUtil.isEmpty(targetFieldProps)) {
            return;
        }
        String billNumber = this.getModel().getDataEntity().getDynamicObject("targetbill").getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        Map allEntities = dataEntityType.getAllEntities();
        Map<String, LocaleString> billAllPropMaps = this.getBillAllProps(allEntities, this.getExcludeProp());
        DynamicObjectCollection fieldMappingDyColl = this.getModel().getDataEntity().getDynamicObjectCollection("entry_fieldmapping");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)fieldMappingDyColl)) {
            return;
        }
        HashMap<String, Integer> fieldMappingIndexMap = new HashMap<String, Integer>(fieldMappingDyColl.size());
        for (int i = 0; i < fieldMappingDyColl.size(); ++i) {
            DynamicObject fieldMapping = (DynamicObject)fieldMappingDyColl.get(i);
            fieldMappingIndexMap.put(fieldMapping.getString("targetfieldprop"), i);
        }
        for (String targetFieldProp : targetFieldProps) {
            if (!billAllPropMaps.containsKey(targetFieldProp) || !fieldMappingIndexMap.containsKey(targetFieldProp)) continue;
            LocaleString displayName = billAllPropMaps.get(targetFieldProp);
            int index = (Integer)fieldMappingIndexMap.get(targetFieldProp);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"targetfielddesc", (Object)displayName, (int)index);
        }
    }

    private String getFieldMappingExpress(DynamicObject fieldMapping) {
        String express;
        GetValueTypeEnum valueTypeEnum = GetValueTypeEnum.getValueTypeEnum((String)fieldMapping.getString("valtype"));
        switch (valueTypeEnum) {
            case CONSTANT: {
                express = fieldMapping.getString("getvaluesave_tag");
                break;
            }
            case CALC_FORMULA: {
                express = fieldMapping.getString("getvaluesave_tag");
                if (!EmptyUtil.isNoEmpty((String)express)) break;
                CRFormula formula = (CRFormula)FpmSerializeUtil.deserialize((String)express, CRFormula.class);
                express = formula.getExpression();
                break;
            }
            default: {
                express = fieldMapping.getString("sourcefieldsave");
            }
        }
        return express;
    }

    private boolean existMoreThan3LevelFieldInApplyFilter() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sourceBillDy = dataEntity.getDynamicObject("sourcebill");
        String sourceBillId = sourceBillDy.getString("number");
        Map fieldMappingRelation = SchemeGatherHelper.getFieldMappingRelation((String)sourceBillId);
        String formula = dataEntity.getString("saveapplycondition_tag");
        CRCondition applyFilter = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
        List filterFiledRows = applyFilter.getFilterCondition().getFilterRow();
        for (SimpleFilterRow filterFiledRow : filterFiledRows) {
            String fieldName = filterFiledRow.getFieldName();
            if (!this.existMoreThan3LevelField(fieldName, fieldMappingRelation)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u9002\u7528\u6761\u4ef6\u4e2d\u5206\u5f55\u5c5e\u6027\u53ea\u652f\u6301\u3010\u5206\u5f55.\u57fa\u7840\u8d44\u6599.\u57fa\u7840\u5c5e\u6027\u3011\u4e09\u7ea7\u683c\u5f0f\uff0c\u8bf7\u4fee\u6539\uff01", (String)"SmartCollectPlanPlugin_16", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean existMoreThan3LevelFieldInCalcFormula(DynamicObjectCollection fieldMappingItems) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sourceBillDy = dataEntity.getDynamicObject("sourcebill");
        String sourceBillId = sourceBillDy.getString("number");
        Map fieldMappingRelation = SchemeGatherHelper.getFieldMappingRelation((String)sourceBillId);
        for (DynamicObject fieldMapping : fieldMappingItems) {
            String[] exprVariables;
            String express;
            GetValueTypeEnum valueTypeEnum;
            if (fieldMapping == null || (valueTypeEnum = GetValueTypeEnum.getValueTypeEnum((String)fieldMapping.getString("valtype"))) != GetValueTypeEnum.CALC_FORMULA || EmptyUtil.isEmpty((String)(express = this.getFieldMappingExpress(fieldMapping)))) continue;
            for (String fieldName : exprVariables = CalcExprParser.getExprVariables((String)express)) {
                if (!this.existMoreThan3LevelField(fieldName, fieldMappingRelation)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u76ee\u6807\u5b57\u6bb5\u3010%1$s\u3011\u53d6\u503c\u8868\u8fbe\u5f0f\uff0c\u5206\u5f55\u5c5e\u6027\u53ea\u652f\u6301\u3010\u5206\u5f55.\u57fa\u7840\u8d44\u6599.\u57fa\u7840\u5c5e\u6027\u3011\u4e09\u7ea7\u683c\u5f0f\uff0c\u4e0d\u53ef\u9009\u62e9\u3010%2$s\u3011\u8868\u8fbe\u5f0f\uff01", (String)"SmartCollectPlanPlugin_17", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), fieldMapping.getString("targetfielddesc"), fieldName));
                return true;
            }
        }
        return false;
    }

    private boolean existMoreThan3LevelField(String fieldId, Map<String, String> fieldMappingRelation) {
        String[] splitFieldIdArr = fieldId.split("\\.");
        if (splitFieldIdArr.length == 0) {
            return false;
        }
        String entryId = fieldMappingRelation.get(splitFieldIdArr[0]);
        if (EmptyUtil.isNoEmpty((String)entryId)) {
            return splitFieldIdArr.length > 2;
        }
        return false;
    }
}

