/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GlobalConfigOperationEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initConfig();
        this.changeParam();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        if ("startmutilsync".equals(key)) {
            if (!Boolean.parseBoolean(newValue.toString())) {
                this.getModel().setValue("startmutilquery", (Object)false);
            }
            this.changeParam();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("testcon".equals(key)) {
            this.saveConfig();
            this.initConfig();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("saveop".equals(operateKey)) {
            this.saveConfig();
            this.initConfig();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"GlobalConfigOperationEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
        if ("refresh".equals(operateKey)) {
            this.getView().showLoading(new LocaleString(""));
            this.initConfig();
            this.getView().hideLoading();
        } else if ("testcon".equals(operateKey)) {
            boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
            String message = afterDoOperationEventArgs.getOperationResult().getMessage();
            if (success) {
                this.getView().showSuccessNotification(message);
            } else {
                this.getView().showErrorNotification(message);
            }
        }
    }

    private void initConfig() {
        Container container = (Container)this.getControl("conentpanel");
        List groupControls = container.getItems();
        ArrayList<String> groups = new ArrayList<String>(groupControls.size());
        for (Control groupControl : groupControls) {
            DynamicObject[] item = (DynamicObject[])groupControl;
            groups.add(item.getKey());
        }
        String selectProp = String.join((CharSequence)",", "id", "number", "name", "configgroup", "configkey", "configvalue");
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"fpm_global_config", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("configgroup", "in", groups)});
        if (configs == null || configs.length == 0) {
            return;
        }
        for (DynamicObject config : configs) {
            String keyProp = config.getString("configkey");
            String value = config.getString("configvalue");
            this.getModel().setValue(keyProp, (Object)value);
        }
        Map configMap = Arrays.stream(configs).collect(Collectors.toMap(k -> k.getString("number"), Function.identity()));
        this.getView().getPageCache().put("configMap", SerializationUtils.serializeToBase64(configMap));
    }

    private void saveConfig() {
        String configMapJson = this.getView().getPageCache().get("configMap");
        Map configMap = null;
        if (!StringUtils.isEmpty((CharSequence)configMapJson)) {
            configMap = (Map)SerializationUtils.deSerializeFromBase64((String)configMapJson);
        }
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
        Set<String> propertiesNameSet = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        Container container = (Container)this.getControl("conentpanel");
        List groupControls = container.getItems();
        HashMap<String, String[]> groupMap = new HashMap<String, String[]>(groupControls.size());
        for (Control groupControl : groupControls) {
            Container item = (Container)groupControl;
            String groupName = item.getKey();
            List values = item.getItems();
            List<String> fieldName = this.findFieldName(propertiesNameSet, values);
            groupMap.put(groupName, fieldName.toArray(new String[0]));
        }
        ArrayList<DynamicObject> saveConfigs = new ArrayList<DynamicObject>(groupMap.size());
        ArrayList<DynamicObject> updateConfigs = new ArrayList<DynamicObject>(groupMap.size());
        for (Map.Entry group : groupMap.entrySet()) {
            String[] configKeys;
            String groupKey = (String)group.getKey();
            for (String configKey : configKeys = (String[])group.getValue()) {
                DynamicObject dynamicObject;
                Long id = null;
                String number = groupKey + configKey;
                if (Objects.nonNull(configMap) && Objects.nonNull(dynamicObject = (DynamicObject)configMap.get(number))) {
                    id = dynamicObject.getLong("id");
                }
                DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)"fpm_global_config");
                config.set("id", id);
                config.set("number", (Object)number);
                config.set("configgroup", (Object)groupKey);
                config.set("configkey", (Object)configKey);
                config.set("configvalue", this.getModel().getValue(configKey));
                config.set("status", (Object)"C");
                config.set("enable", (Object)"1");
                if (Objects.isNull(id)) {
                    saveConfigs.add(config);
                    continue;
                }
                updateConfigs.add(config);
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveConfigs.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])updateConfigs.toArray(new DynamicObject[0]));
    }

    private List<String> findFieldName(Set<String> propertiesNameSet, List<Control> values) {
        ArrayList<String> valueList = new ArrayList<String>(16);
        for (Control value : values) {
            if (value instanceof Container) {
                List items = ((Container)value).getItems();
                List<String> fieldName = this.findFieldName(propertiesNameSet, items);
                if (CollectionUtils.isEmpty(fieldName)) continue;
                valueList.addAll(fieldName);
                continue;
            }
            String valueControlName = value.getKey();
            if (!propertiesNameSet.contains(valueControlName)) continue;
            valueList.add(valueControlName);
        }
        return valueList;
    }

    private void changeParam() {
        boolean startQuery = Boolean.parseBoolean(this.getModel().getValue("startmutilsync").toString());
        if (startQuery) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"startmutilquery"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"startmutilquery"});
        }
    }
}

