/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fpm.common.enums.DimMemberFromEnum;
import kd.tmc.fpm.common.enums.DimensionRelEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;

public class DimensionEditPlugin
extends AbstractBasePlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"status", (Object)"C");
        OperationStatus status = fsp.getStatus();
        if (OperationStatus.EDIT == status) {
            DynamicObject bodysystem = this.getSystem();
            String basedata = (String)this.getModel().getValue("basedata");
            if (basedata == null) {
                return;
            }
            DimsionEnums dimEnums = DimsionEnums.getDimsionByNumber((String)basedata);
            if (DimsionEnums.ORG.getNumber().equals(dimEnums.getNumber())) {
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl("basedatabiz");
                basedataEdit.setMustInput(true);
                ArrayList<Long> tBodySystemList = new ArrayList<Long>();
                DynamicObjectCollection tBodySystems = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"org.id", (QFilter[])new QFilter[]{new QFilter("id", "=", bodysystem.getPkValue())});
                for (DynamicObject tBodySystem : tBodySystems) {
                    tBodySystemList.add(tBodySystem.getLong("org.id"));
                }
                QFilter tQFilter = new QFilter("bodysystem", "=", bodysystem.getPkValue()).and(new QFilter("dimtype", "=", (Object)dimEnums.getNumber()));
                tQFilter.and("sourceid", "not in", tBodySystemList);
                if (QueryServiceHelper.exists((String)"fpm_member", (QFilter[])new QFilter[]{tQFilter})) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"basedatabiz"});
                }
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"basedata"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"memberfrom"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"dimensionrel"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"relbasedata"});
        } else if (OperationStatus.ADDNEW == status) {
            Map customParams = fsp.getCustomParams();
            Object modelId = customParams.get("bodysystem");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"bodysystem", modelId);
            this.getView().setEnable(Boolean.FALSE, new String[]{"basedatabiz"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            String memberFrom = (String)this.getModel().getValue("memberfrom");
            if (DimMemberFromEnum.CUSTOM.getCode().equals(memberFrom)) {
                ((BasedataEdit)this.getControl("relbasedata")).setMustInput(Boolean.FALSE.booleanValue());
                this.getModel().setValue("relbasedata", (Object)"");
                this.getModel().setValue("basedatabiz", (Object)"");
                this.getModel().setValue("basedata", (Object)DimsionEnums.CUSTOM.getNumber());
            } else {
                ((BasedataEdit)this.getControl("relbasedata")).setMustInput(Boolean.TRUE.booleanValue());
                this.getModel().setValue("relbasedata", (Object)"bos_org");
                this.getModel().setValue("basedatabiz", (Object)"08");
                this.getModel().setValue("name", (Object)DimsionEnums.COMPANY.getName());
                this.getModel().setValue("number", (Object)DimsionEnums.COMPANY.getNumber());
                this.getModel().setValue("basedata", (Object)DimsionEnums.COMPANY.getNumber());
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "memberfrom": {
                if (DimMemberFromEnum.CUSTOM.getCode().equals(newValue)) {
                    ((TextEdit)this.getControl("number")).setMustInput(true);
                    ((BasedataEdit)this.getControl("relbasedata")).setMustInput(Boolean.FALSE.booleanValue());
                    this.getModel().setValue("basedata", (Object)DimsionEnums.CUSTOM.getNumber());
                    this.getModel().setValue("relbasedata", (Object)"");
                    this.getModel().setValue("basedatabiz", (Object)"");
                    this.getModel().setValue("name", (Object)new LocaleString());
                    this.getModel().setValue("number", (Object)"");
                    break;
                }
                ((TextEdit)this.getControl("number")).setMustInput(false);
                ((BasedataEdit)this.getControl("relbasedata")).setMustInput(Boolean.TRUE.booleanValue());
                this.getModel().setValue("relbasedata", (Object)"bos_org");
                this.getModel().setValue("basedatabiz", (Object)"08");
                this.getModel().setValue("name", (Object)DimsionEnums.COMPANY.getName());
                this.getModel().setValue("number", (Object)DimsionEnums.COMPANY.getNumber());
                this.getModel().setValue("basedata", (Object)DimsionEnums.COMPANY.getNumber());
                break;
            }
            case "relbasedata": {
                if (Objects.isNull(newValue)) break;
                DynamicObject bosEntity = (DynamicObject)newValue;
                String number = bosEntity.getString("number");
                if ("bos_org".equals(number)) {
                    this.getModel().setValue("basedatabiz", (Object)"08");
                    this.getModel().setValue("name", (Object)DimsionEnums.COMPANY.getName());
                    this.getModel().setValue("number", (Object)DimsionEnums.COMPANY.getNumber());
                    this.getModel().setValue("basedata", (Object)DimsionEnums.COMPANY.getNumber());
                    break;
                }
                if ("bd_settlementtype".equals(number)) {
                    this.getModel().setValue("basedatabiz", (Object)"");
                    this.getModel().setValue("name", (Object)DimsionEnums.SETLTMENT.getName());
                    this.getModel().setValue("number", (Object)DimsionEnums.SETLTMENT.getNumber());
                    this.getModel().setValue("basedata", (Object)DimsionEnums.SETLTMENT.getNumber());
                    break;
                }
                this.getModel().setValue("basedatabiz", (Object)"");
                this.getModel().setValue("name", (Object)new LocaleString(bosEntity.getString("name")));
                this.getModel().setValue("number", (Object)number);
                this.getModel().setValue("basedata", (Object)DimsionEnums.CUSTOM.getNumber());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.handleCustomColumn();
                break;
            }
        }
    }

    private void handleCustomColumn() {
        boolean mainDim;
        Object currentDimType = this.getModel().getValue("basedata");
        if (Objects.nonNull(currentDimType) && (mainDim = DimsionEnums.isMainDim((String)currentDimType.toString()))) {
            return;
        }
        Object dimRel = this.getModel().getValue("dimensionrel");
        if (Objects.nonNull(dimRel)) {
            return;
        }
        DynamicObject system = this.getSystem();
        QFilter qFilters = new QFilter("bodysystem", "=", system.getPkValue());
        qFilters.and(new QFilter("dimensionrel", "!=", (Object)""));
        qFilters.and(new QFilter("dimensionrel", "!=", (Object)" "));
        qFilters.and(new QFilter("dimensionrel", "is not null", null));
        String prop = String.join((CharSequence)",", "basedata", "dimensionrel");
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_dimension", (String)prop, (QFilter[])new QFilter[]{qFilters});
        List otherDim = Arrays.stream(load).filter(item -> !DimsionEnums.isMainDim((String)item.getString("basedata"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(otherDim)) {
            this.getModel().setValue("dimensionrel", (Object)DimensionRelEnum.CUSTOM_1.getCode());
            return;
        }
        ArrayList<String> customs = new ArrayList<String>();
        customs.add(DimensionRelEnum.CUSTOM_1.getCode());
        customs.add(DimensionRelEnum.CUSTOM_2.getCode());
        customs.add(DimensionRelEnum.CUSTOM_3.getCode());
        List loadCustom = Arrays.stream(load).map(item -> item.getString("dimensionrel")).collect(Collectors.toList());
        customs.removeAll(loadCustom);
        if (CollectionUtils.isEmpty(customs)) {
            return;
        }
        this.getModel().setValue("dimensionrel", customs.get(0));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null) {
            return;
        }
        String operateKey = e.getOperateKey();
        if (e.getOperationResult().getValidateResult().isSuccess()) {
            if ("save".equals(operateKey)) {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DimensionEditPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_confirm", "bar_cancel"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "bar_confirm": {
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (!OperationStatus.EDIT.equals((Object)status)) break;
                this.getView().close();
                break;
            }
        }
    }

    private DynamicObject getSystem() {
        return this.getModel().getDataEntity().getDynamicObject("bodysystem");
    }
}

