/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.helper.FpmHelper;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class DimensionF7Plugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String SEARCH_MEMBER = "searchmember";
    private static final String TREE_VIEW = "treeview";

    public void initialize() {
        super.initialize();
        TreeView viewTree = (TreeView)this.getControl(TREE_VIEW);
        viewTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.getPageCache().put("extSelect", "true");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search searchMember = (Search)this.getControl(SEARCH_MEMBER);
        searchMember.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bodySystemId = null;
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        QFilter bodySystemFilter = FpmHelper.containQFilterByKey((List)qFilters, (String)"bodysystem");
        if (bodySystemFilter != null) {
            DynamicObject query = QueryServiceHelper.queryOne((String)"fpm_member", (String)"bodysystem", (QFilter[])new QFilter[]{bodySystemFilter});
            if (query != null) {
                bodySystemId = query.get("bodysystem");
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bodysystem"});
            }
        } else {
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_bodysysmanage", (QFilter[])new QFilter[0], (String)"createtime asc", (int)1);
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                bodySystemId = ids.get(0);
            }
        }
        if (EmptyUtil.isEmpty(bodySystemId) && !EmptyUtil.isEmpty((Object)(bodySystemId = formShowParameter.getCustomParam("bodysystem")))) {
            bodySystemId = Long.parseLong(bodySystemId.toString());
        }
        FpmAssertUtil.isNotNull((Object)bodySystemId, (String)ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u4f53\u7cfb\u3002", (String)"DimensionF7Plugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("bodysystem", bodySystemId);
        this.getModel().setValue("iscontainnow", (Object)true);
        this.getPageCache().put("bodysystem", String.valueOf(bodySystemId));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.removeDimTypeFilter();
    }

    private void removeDimTypeFilter() {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        QFilter notInDimTypeFilter = FpmHelper.getQFilterByKeyAndCp((List)qFilters, (String)"dimtype", (String)"not in");
        qFilters.remove(notInDimTypeFilter);
        this.getPageCache().remove("notdimtype");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.removeDimTypeFilter();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        switch (fieldKey) {
            case "bodysystem": {
                if (Objects.isNull(newValue)) {
                    String systemId = this.getPageCache().get("bodysystem");
                    this.getModel().setValue("bodysystem", (Object)Long.parseLong(systemId));
                    break;
                }
                if (newValue instanceof DynamicObject) {
                    long id = ((DynamicObject)newValue).getLong("id");
                    this.getPageCache().put("bodysystem", String.valueOf(id));
                }
                this.forceRefreshTree();
                break;
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        this.searchMember(evt.getText());
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        this.removeDimTypeFilter();
    }

    private void forceRefreshTree() {
        ITreeListView treeListView = this.getTreeListView();
        if (treeListView == null) {
            return;
        }
        TreeNode tRefreshTreeNode = this.getTreeModel().getRoot();
        tRefreshTreeNode.setChildren(null);
        this.getTreeListView().getTreeView().queryTreeNodeChildren(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
        List rootChildren = tRefreshTreeNode.getChildren();
        if (rootChildren != null && rootChildren.size() > 0) {
            tRefreshTreeNode = (TreeNode)rootChildren.get(0);
        }
        this.getTreeListView().getTreeView().treeNodeClick(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
    }

    private void searchMember(String text) {
        BillList billList = (BillList)this.getControl("billlistap");
        QFilter qFilter = new QFilter("name", "like", (Object)("%" + text + "%"));
        qFilter.or(new QFilter("number", "like", (Object)("%" + text + "%")));
        billList.getQueryFilterParameter().getQFilters().add(qFilter);
        billList.refresh();
    }
}

