/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.opservice.basesetting.SummaryConfigSyncService;
import kd.tmc.fpm.business.task.DimMemberImportTask;
import kd.tmc.fpm.business.task.ReportImportDataClickTask;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.bean.TreeDataSelectedPluginParam;
import kd.tmc.fpm.common.enums.BeginOrEndMarkEnum;
import kd.tmc.fpm.common.enums.DimMemberFromEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.common.enums.TreeDataSelectedType;
import kd.tmc.fpm.common.enums.WaysEnum;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import kd.tmc.fpm.common.property.MemberManagerListProp;
import kd.tmc.fpm.common.result.TreeDataSelectedNode;
import kd.tmc.fpm.common.result.TreeDataSelectedReturnData;
import kd.tmc.fpm.common.utils.GlobalIdUtil;
import kd.tmc.fpm.formplugin.dimmanager.DimManagerInfo;
import kd.tmc.fpm.formplugin.dimmanager.DimensionInfo;
import kd.tmc.fpm.formplugin.dimmanager.ModelInfo;
import kd.tmc.fpm.formplugin.helper.CronGenerateHelper;
import kd.tmc.fpm.formplugin.helper.MemberManagerListHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MemberManagerListPlugin
extends AbstractTreeListPlugin {
    public static final Integer MAX_DIMENSION_CUSTOM_SIZE = 3;
    private DimManagerInfo dimInfo = null;
    private static final String CLICKTITLE_SUBJECT1 = "clicktitle_subject1";
    private static final String CLICKTITLE_SUBJECT2 = "clicktitle_subject2";
    private static final String CLICKTITLE_SUBJECT3 = "clicktitle_subject3";
    private static final String CACHE_FORCE_REFRESH_TREE_FLAG = "forceRefreshTreeFlag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CLICKTITLE_SUBJECT1, CLICKTITLE_SUBJECT2, CLICKTITLE_SUBJECT3});
        this.addItemClickListeners(MemberManagerListProp.ALLBTNKEYS);
        this.addItemClickListeners(new String[]{"btnnew", "btnedit", "btndel", "btn_disable", "btn_enable"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        IFormView iFormView = this.getView();
        if (iFormView instanceof ListView && Objects.equals(((ListView)iFormView).getBillFormId(), "fpm_member_default")) {
            ArrayList<String> dimType = new ArrayList<String>();
            dimType.add(DimsionEnums.SUBJECT.getNumber());
            dimType.add(DimsionEnums.METRIC.getNumber());
            e.getQFilters().add(new QFilter("dimtype", "not in", dimType));
        }
        e.setOrderBy(String.join((CharSequence)",", "sortcode"));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String modelId = this.getPageCache().get("bodysystem");
        if (EmptyUtil.isEmpty((String)modelId)) {
            return;
        }
        this.showNotifyFlex(modelId);
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        this.dimInfo = null;
        this.getPageCache().remove("dimInfo");
        this.dimInfo = this.getDimManagerInfo();
        if (this.dimInfo == null || this.dimInfo.getModel() == null) {
            return;
        }
        this.showNotifyFlex(this.dimInfo.getModel().getId());
    }

    private void showNotifyFlex(String bodySystemId) {
        IListView view = (IListView)this.getView();
        String billFormId = view.getBillFormId();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean lookUp = listShowParameter.isLookUp();
        if (!Objects.equals(billFormId, DimsionEnums.SUBJECT.getMetadata()) || lookUp) {
            return;
        }
        long bodySysId = Long.parseLong(bodySystemId);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"notifyflexpanel"});
        String prop = String.join((CharSequence)",", "id", "number", "name", "ways", "linksubject.id", "linksubject.number", "linksubject.name");
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_member", (String)prop, (QFilter[])new QFilter[]{new QFilter("bodysysmanage", "=", (Object)bodySysId), new QFilter("beginorendmark", "=", (Object)BeginOrEndMarkEnum.END_TERM.getValue())});
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            return;
        }
        Map<String, List<DynamicObject>> endSubjectGroupMap = queryResult.stream().filter(item -> EmptyUtil.isNoEmpty((String)item.getString("linksubject.number"))).collect(Collectors.groupingBy(i -> i.getString("linksubject.number")));
        List<Object> repeatInfo = new ArrayList(1);
        for (Map.Entry<String, List<DynamicObject>> enSubjectMapEntry : endSubjectGroupMap.entrySet()) {
            List<DynamicObject> endSubjects = enSubjectMapEntry.getValue();
            int linkEndSubjectNum = endSubjects.size();
            if (linkEndSubjectNum <= 1) continue;
            repeatInfo = endSubjects;
            break;
        }
        if (CollectionUtils.isEmpty(repeatInfo) || repeatInfo.size() <= 1) {
            return;
        }
        HashMap<String, String> clickValueMap = new HashMap<String, String>(3);
        DynamicObject beginObj = (DynamicObject)repeatInfo.get(0);
        Label beginLabel = (Label)this.getView().getControl(CLICKTITLE_SUBJECT1);
        String beginName = "\u201c" + beginObj.getString("linksubject.number") + beginObj.getString("linksubject.name") + "\u201d";
        beginLabel.setText(beginName);
        clickValueMap.put(CLICKTITLE_SUBJECT1, String.valueOf(beginObj.getLong("linksubject.id")));
        int index = 2;
        for (DynamicObject dynamicObject : repeatInfo) {
            if (index > 3) break;
            String clickName = "clicktitle_subject" + index;
            Label endLabel = (Label)this.getView().getControl(clickName);
            String endName = "\u201c" + dynamicObject.getString("number") + dynamicObject.getString("name") + "\u201d";
            endLabel.setText(endName);
            clickValueMap.put(clickName, String.valueOf(dynamicObject.getLong("id")));
            ++index;
        }
        this.getPageCache().put(clickValueMap);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"notifyflexpanel"});
        this.getView().updateView("notifyflexpanel");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        super.beforeItemClick(evt);
        switch (key = evt.getItemKey()) {
            case "tblrefresh": {
                this.refreshTree();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "clicktitle_subject1": 
            case "clicktitle_subject2": 
            case "clicktitle_subject3": {
                String pkId = this.getPageCache().get(key);
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setPkId((Object)pkId);
                showParameter.setFormId("fpm_membersubject");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        this.dimInfo = this.getDimManagerInfo();
        if (this.dimInfo.getModel() == null || this.dimInfo.getModel().getId() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimensionManagerList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setDimension();
        switch (key = evt.getItemKey()) {
            case "btn_addmember": {
                this.setMemberId();
                this.addNewMember(key);
                break;
            }
            case "btn_sysimport": {
                this.systemImport();
                break;
            }
            case "btn_batchadd": {
                this.batchAddDim();
                break;
            }
            case "btn_disable": {
                Object[] selectedIds = this.getSelectedIds(false);
                if (selectedIds == null || this.dimInfo.getDimension() == null) break;
                List<Long> allChildNodeID = this.getAllChildNodeID(selectedIds);
                if (Arrays.asList("Subjects", "Period").contains(this.dimInfo.getDimension().getNumber()) && allChildNodeID.size() > selectedIds.length) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disabledimconfirm", (IFormPlugin)this);
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u7981\u7528\u6240\u9009\u201c%1$s\u201d\u53ca\u5176\u4e0b\u7ea7\u6240\u6709%2$s\u6210\u5458\u4fe1\u606f\u3002", (String)"DimensionMemberEdit_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), this.dimInfo.getDimension().getName(), this.dimInfo.getDimension().getName()), MessageBoxOptions.OKCancel, confirmCallBacks);
                    break;
                }
                this.getView().invokeOperation("disable");
                break;
            }
        }
        this.cacheDimManagerInfo();
    }

    public void treeToolbarClick(EventObject e) {
        String key;
        super.treeToolbarClick(e);
        this.dimInfo = this.getDimManagerInfo();
        if (this.dimInfo.getModel() == null || this.dimInfo.getModel().getId() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimensionManagerList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key = ((Control)e.getSource()).getKey()) {
            case "btnnew": {
                this.addNewDim();
                break;
            }
            case "btnedit": {
                this.editDim();
                break;
            }
            case "btndel": {
                if (this.dimInfo.getDimension() == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"DimensionManagerList_30", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.checkDim()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u6267\u884c\u6570\u636e\uff0c\u518d\u70b9\u51fb\u201c\u5220\u9664\u201d\u6309\u94ae\u3002", (String)"MemberManagerListPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"MemberManagerListPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callBackId", (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("callBackId") && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.delDim();
        } else if (Objects.equals("syncsumconfig", callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.dimInfo = this.getDimManagerInfo();
            String systemId = this.dimInfo.getModel().getId();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systemId", systemId);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            operateOption.setVariableValue("currentId", EmptyUtil.isEmpty((Object)pkValue) ? "" : pkValue.toString());
            SummaryConfigSyncService summaryConfigSyncService = new SummaryConfigSyncService();
            summaryConfigSyncService.setOperationResult(new OperationResult());
            summaryConfigSyncService.setOperationVariable(operateOption.getVariables());
            summaryConfigSyncService.process(null);
            CronGenerateHelper.showMessage(this.getView(), summaryConfigSyncService.getOperationResult());
        } else if (callBackId.equals("disabledimconfirm") && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("disable");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "disable": 
            case "enable": 
            case "delete": {
                this.addAllMemberIntoSelectedList(args);
            }
        }
    }

    private void addAllMemberIntoSelectedList(BeforeDoOperationEventArgs args) {
        this.dimInfo = this.getDimManagerInfo();
        this.setDimension();
        String dimType = this.dimInfo.getDimension().getNumber();
        List<Long> allMemberIdList = DimsionEnums.PERIOD.getNumber().equals(dimType) ? this.getReportTypeAllPeriodNodeID(this.getSelectedIds(false)) : this.getAllChildNodeID(this.getSelectedIds(false));
        if (allMemberIdList.size() < 1) {
            return;
        }
        args.getListSelectedData().clear();
        for (Long memberId : allMemberIdList) {
            args.getListSelectedData().add((Object)new ListSelectedRow((Object)memberId));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "dimmap": {
                if (!args.getOperationResult().isSuccess()) break;
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setFormId("bos_list");
                listShowParameter.setBillFormId("fpm_dimensionmember");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "syncsumconfig": {
                this.dimInfo = this.getDimManagerInfo();
                String systemId = this.dimInfo.getModel().getId();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systemId", systemId);
                SummaryConfigSyncService summaryConfigSyncService = new SummaryConfigSyncService();
                summaryConfigSyncService.setOperationResult(new OperationResult());
                summaryConfigSyncService.setOperationVariable(operateOption.getVariables());
                summaryConfigSyncService.process(null);
                CronGenerateHelper.showMessage(this.getView(), summaryConfigSyncService.getOperationResult());
                break;
            }
            case "delete": {
                if (!args.getOperationResult().isSuccess()) break;
                if (FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
                    OperationServiceHelper.executeOperate((String)"syncdim_mdd", (String)"fpm_dimension", (Object[])new Object[]{Long.valueOf(this.dimInfo.getDimension().getId())}, (OperateOption)OperateOption.create());
                }
                this.refreshMember();
                break;
            }
            case "enable": {
                if (args.getOperationResult().isSuccess()) {
                    this.refreshMember();
                }
            }
            case "disable": {
                if (!args.getOperationResult().isSuccess()) break;
                this.refreshMember();
            }
        }
    }

    private List<Long> getAllChildNodeID(Object[] parentIDs) {
        List<Long> childItems = new ArrayList<Long>();
        if (parentIDs != null) {
            this.dimInfo = this.getDimManagerInfo();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "parent"), (QFilter[])new QFilter("bodysystem", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId())).and("dimtype", "=", (Object)this.dimInfo.getDimension().getNumber()).and("id", "not in", (Object)parentIDs).toArray());
            for (Object parentID : parentIDs) {
                childItems.add(Long.valueOf(parentID.toString()));
                childItems.addAll(this.getChildNodeID(col, Long.valueOf(parentID.toString())));
            }
            childItems = childItems.stream().distinct().collect(Collectors.toList());
        }
        return childItems;
    }

    private List<Long> getChildNodeID(DynamicObjectCollection col, Long parentID) {
        ArrayList<Long> childItems = new ArrayList<Long>();
        for (DynamicObject dynamicObject : col) {
            if (parentID.compareTo(dynamicObject.getLong("parent")) != 0 || parentID.compareTo(dynamicObject.getLong("id")) == 0) continue;
            Long par1 = dynamicObject.getLong("id");
            childItems.add(par1);
            childItems.addAll(this.getChildNodeID(col, par1));
        }
        return childItems;
    }

    private List<Long> getReportTypeAllPeriodNodeID(Object[] periodIds) {
        List<Long> allPeriodIds = new ArrayList<Long>(0);
        if (EmptyUtil.isNoEmpty((Object[])periodIds)) {
            this.dimInfo = this.getDimManagerInfo();
            DynamicObjectCollection periodDyColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "reporttype.id"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)periodIds)});
            Set reportTypeIdSet = periodDyColl.stream().map(dy -> dy.getLong("reporttype.id")).collect(Collectors.toSet());
            if (!reportTypeIdSet.isEmpty()) {
                List allPeriodPKs = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter("bodysystem", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId())).and("dimension", "=", (Object)Long.valueOf(this.dimInfo.getDimension().getId())).and("reporttype.id", "in", reportTypeIdSet).toArray(), null, (int)-1);
                allPeriodIds = allPeriodPKs.stream().map(pk -> (Long)pk).collect(Collectors.toList());
            }
        }
        return allPeriodIds;
    }

    private boolean checkDim() {
        TreeNode tRefreshTreeNode = this.getTreeModel().getRoot();
        TreeView treeview = (TreeView)this.getControl("treeview");
        if (treeview.getTreeState().getFocusNodeId() != null) {
            TreeNode tFocusDimNode = tRefreshTreeNode.getTreeNode(treeview.getTreeState().getFocusNodeId(), 99);
            if (!tRefreshTreeNode.getId().equals(tFocusDimNode.getParentid())) {
                return true;
            }
        }
        return false;
    }

    private void delDim() {
        OperationResult result;
        block21: {
            this.dimInfo = this.getDimManagerInfo();
            String dimensionNumber = this.dimInfo.getDimension().getNumber();
            DimsionEnums dimEnums = DimsionEnums.getDimsionByNumber((String)dimensionNumber);
            if (dimEnums == DimsionEnums.ORG || dimEnums == DimsionEnums.PERIOD || dimEnums == DimsionEnums.CURRENCY) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u4e3a\u56fa\u5b9a\u7ef4\u5ea6\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DimensionManagerList_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), dimEnums.getName()));
                return;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("bodysystem", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId())), new QFilter("dimension", "=", (Object)Long.valueOf(this.dimInfo.getDimension().getId())), new QFilter("dimtype", "=", (Object)dimEnums.getNumber())};
            List deleteItems = QueryServiceHelper.queryPrimaryKeys((String)dimEnums.getMetadata(), (QFilter[])qFilters, null, (int)-1);
            result = null;
            try (TXHandle h = TX.requiresNew((String)"delete");){
                if (EmptyUtil.isNoEmpty((Object)deleteItems)) {
                    try {
                        result = TmcOperateServiceHelper.execOperate((String)"delete", (String)this.getSelectDimName(), (Object[])deleteItems.toArray(new Object[0]), (OperateOption)OperateOption.create());
                    }
                    catch (Exception e) {
                        h.markRollback();
                        this.getView().showErrorNotification(e.getMessage());
                    }
                } else {
                    result = new OperationResult();
                    result.setSuccess(Boolean.TRUE.booleanValue());
                }
                if (result == null || !result.isSuccess()) break block21;
                try {
                    result = null;
                    long dimId = Long.parseLong(this.dimInfo.getDimension().getId());
                    result = TmcOperateServiceHelper.execOperate((String)"delete", (String)"fpm_dimension", (Object[])new Object[]{dimId}, (OperateOption)OperateOption.create());
                    if (result != null && result.isSuccess()) {
                        h.setRollback(false);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                    this.getView().showErrorNotification(e.getMessage());
                }
            }
        }
        if (result != null && result.isSuccess()) {
            this.refreshTree();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void editDim() {
        String id = "";
        if (this.dimInfo.getDimension() == null) {
            TreeView treeview = (TreeView)this.getControl("treeview");
            TreeView.TreeState state = treeview.getTreeState();
            Map focusNode = state.getFocusNode();
            if (focusNode == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"DimensionManagerList_30", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            String dimensionId = focusNode.get("id").toString();
            id = this.getDimensionId(dimensionId.substring(dimensionId.indexOf("/") + 1, dimensionId.indexOf("#")));
        } else if (this.checkDim()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u82e5\u9700\u8981\u4fee\u6539\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\uff0c\u8bf7\u5728\u53f3\u4fa7\u5217\u8868\u4e2d\u70b9\u51fb\u76f8\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u94fe\u63a5\u8fdb\u884c\u4fee\u6539\u3002", (String)"MemberManagerListPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        id = StringUtils.isNotBlank((CharSequence)id) ? id : this.dimInfo.getDimension().getId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("fpm_dimension");
        baseShowParameter.setPkId((Object)id);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6-\u4fee\u6539", (String)"DimensionManagerList_27", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
        baseShowParameter.setCustomParam("bodysystem", (Object)this.dimInfo.getModel().getId());
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editdimclose"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void addNewDim() {
        boolean exists;
        QFilter qFilters = new QFilter("bodysystem", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId()));
        qFilters.and(new QFilter("dimensionrel", "!=", (Object)""));
        qFilters.and(new QFilter("dimensionrel", "!=", (Object)" "));
        qFilters.and(new QFilter("dimensionrel", "is not null", null));
        boolean bl = exists = TmcDataServiceHelper.load((String)"fpm_dimension", (String)"basedata", (QFilter[])new QFilter[]{qFilters}).length >= MAX_DIMENSION_CUSTOM_SIZE;
        if (!exists) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("fpm_dimension");
            showParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6-\u65b0\u589e", (String)"DimensionManagerList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("bodysystem", (Object)this.dimInfo.getModel().getId());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.ADDNEW);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addDimCloseBack");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9664\u4e86\u9884\u7f6e\u7684\u7f16\u62a5\u4e3b\u4f53\u3001\u671f\u95f4\u3001\u5e01\u79cd\u7ef4\u5ea6\uff0c\u5f53\u524d\u7cfb\u7edf\u6700\u591a\u53ef\u65b0\u589e3\u4e2a\u7ef4\u5ea6\u3002\u4f53\u7cfb\u5185\u5df2\u65b0\u589e3\u4e2a\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u518d\u65b0\u589e\u7ef4\u5ea6\u3002", (String)"DimensionManagerList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void systemImport() {
        this.dimInfo = this.getDimManagerInfo();
        if (Objects.isNull(this.dimInfo.getDimension())) {
            TreeNode root = this.getTreeModel().getRoot();
            if (root == null) {
                return;
            }
            String rootId = ((TreeNode)root.getChildren().get(0)).getId();
            String dimensionId = this.getDimensionId(rootId.substring(rootId.indexOf("/") + 1, rootId.indexOf("#")));
            this.dimInfo.setDimension(dimensionId);
            this.cacheDimManagerInfo();
        }
        DimsionEnums dimEnums = DimsionEnums.getDimsionByNumber((String)this.dimInfo.getDimension().getNumber());
        TreeDataSelectedPluginParam pluginData = this.getTreeDataParam(dimEnums);
        FormShowParameter showParameter = new FormShowParameter();
        String memberFrom = this.dimInfo.getDimension().getMemberFrom();
        if (StringUtils.isEmpty((CharSequence)memberFrom)) {
            showParameter.setFormId(dimEnums.getImportMatedata());
        } else if (DimMemberFromEnum.BASE_INFO == DimMemberFromEnum.valueOf((String)memberFrom) && DimsionEnums.CUSTOM == dimEnums) {
            showParameter.setFormId("fpm_baseinfoimport");
            pluginData.setTitle(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u7cfb\u7edf\u5bfc\u5165", (String)"DimensionManagerList_34", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), this.dimInfo.getDimension().getName()));
        } else {
            showParameter.setFormId(dimEnums.getImportMatedata());
        }
        showParameter.setAppId("fpm");
        showParameter.setCustomParam(TreeDataSelectedPluginParam.class.getName(), (Object)JSON.toJSONString((Object)pluginData));
        showParameter.setCustomParam("dimensionId", (Object)this.dimInfo.getDimension().getId());
        showParameter.setCustomParam("number", (Object)this.dimInfo.getDimension().getNumber());
        showParameter.setCustomParam("bodysystem", (Object)this.dimInfo.getModel().getId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshMemberCloseBack"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeDataSelectedPluginParam getTreeDataParam(DimsionEnums dimEnums) {
        TreeDataSelectedPluginParam pluginData = new TreeDataSelectedPluginParam();
        QFilter rightFilter = new QFilter("bodysystem", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId())).and(new QFilter("dimtype", "=", (Object)this.dimInfo.getDimension().getNumber()));
        DynamicObjectCollection tMembers = QueryServiceHelper.query((String)"fpm_member", (String)"id,sourceid,enable", (QFilter[])new QFilter[]{rightFilter});
        ArrayList<Long> sourceIds = new ArrayList<Long>(tMembers.size());
        ArrayList<Long> memIds = new ArrayList<Long>(tMembers.size());
        for (DynamicObject tMember : tMembers) {
            sourceIds.add(tMember.getLong("sourceid"));
            if (!tMember.getBoolean("enable")) continue;
            memIds.add(tMember.getLong("id"));
        }
        if (DimsionEnums.ORG.getNumber().equals(dimEnums.getNumber())) {
            this.updateTreeDataParamByOrg(pluginData);
        } else if (DimsionEnums.COMPANY.getNumber().equals(dimEnums.getNumber())) {
            this.updateTreeDataParamByCompany(pluginData);
        } else if (DimsionEnums.CURRENCY.getNumber().equals(dimEnums.getNumber())) {
            this.updateTreeDataParamByCurrency(pluginData);
        } else if (DimsionEnums.SETLTMENT.getNumber().equals(dimEnums.getNumber())) {
            this.updateTreeDataParamBySettlement(pluginData);
        } else if (DimsionEnums.SUBJECT.getNumber().equals(dimEnums.getNumber())) {
            this.updateTreeDataParamBySubject(pluginData);
        } else if (DimsionEnums.CUSTOM.getNumber().equals(dimEnums.getNumber())) {
            this.updateTreeDataParamByCustom(pluginData);
        }
        pluginData.setRightTreeEntityName("fpm_member");
        pluginData.getRightTreeProp().setParentIdPropName("parent.id");
        pluginData.setRightPkList(memIds);
        pluginData.setRightSourcePkList(sourceIds);
        pluginData.setTitle(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), dimEnums.getName()));
        return pluginData;
    }

    private void updateTreeDataParamBySubject(TreeDataSelectedPluginParam pluginData) {
        QFilter leftQFilter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C").and("ctrlstrategy", "!=", (Object)"7");
        DynamicObject bodySysManager = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"id,number,org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId()))});
        if (Objects.nonNull(bodySysManager)) {
            Object org = bodySysManager.get("org");
            Long orgId = org == null ? 0L : Long.parseLong(org.toString());
            leftQFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"cas_fundflowitem", (Long)orgId));
        }
        pluginData.setLeftTreeEntityName("cas_fundflowitem");
        pluginData.getLeftTreeProp().setParentIdPropName("parent.id");
        pluginData.getLeftTreeProp().setIdPropName("id");
        pluginData.getLeftTreeProp().setNumberPropName("number");
        pluginData.getLeftTreeProp().setNamePropName("name");
        pluginData.setLeftTreeQFilterStr(leftQFilter.toSerializedString());
        pluginData.setTreeDataSelectedType(TreeDataSelectedType.SETPARENT);
        pluginData.setOriginalDataRemoveFlag(Boolean.valueOf(false));
    }

    private void updateTreeDataParamByCustom(TreeDataSelectedPluginParam pluginData) {
        QFilter leftQFilter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        pluginData.setLeftTreeEntityName(this.dimInfo.getDimension().getRelBaseData());
        pluginData.getLeftTreeProp().setParentIdPropName("parent.id");
        pluginData.getLeftTreeProp().setIdPropName("id");
        pluginData.getLeftTreeProp().setNumberPropName("number");
        pluginData.getLeftTreeProp().setNamePropName("name");
        pluginData.setLeftTreeQFilterStr(leftQFilter.toSerializedString());
        pluginData.setTreeDataSelectedType(TreeDataSelectedType.SETPARENT);
        pluginData.setOriginalDataRemoveFlag(Boolean.valueOf(false));
    }

    private void updateTreeDataParamBySettlement(TreeDataSelectedPluginParam pluginData) {
        QFilter leftQFilter = new QFilter("enable", "=", (Object)"1");
        pluginData.setLeftTreeEntityName("bd_settlementtype");
        pluginData.getLeftTreeProp().setParentIdPropName("");
        pluginData.getLeftTreeProp().setLongNumberPropName("");
        pluginData.getLeftTreeProp().setIsLeafPropName("");
        pluginData.getLeftTreeProp().setLevelPropName("");
        pluginData.getLeftTreeProp().setIdPropName("id");
        pluginData.getLeftTreeProp().setNumberPropName("number");
        pluginData.getLeftTreeProp().setNamePropName("name");
        pluginData.setLeftTreeQFilterStr(leftQFilter.toSerializedString());
        pluginData.setTreeDataSelectedType(TreeDataSelectedType.NOTREESTRU);
        pluginData.setOriginalDataRemoveFlag(Boolean.valueOf(false));
    }

    private void updateTreeDataParamByCurrency(TreeDataSelectedPluginParam pluginData) {
        QFilter leftQFilter = new QFilter("enable", "=", (Object)"1");
        pluginData.setLeftTreeEntityName("bd_currency");
        pluginData.getLeftTreeProp().setParentIdPropName("");
        pluginData.getLeftTreeProp().setLongNumberPropName("");
        pluginData.getLeftTreeProp().setIsLeafPropName("");
        pluginData.getLeftTreeProp().setLevelPropName("");
        pluginData.getLeftTreeProp().setIdPropName("id");
        pluginData.getLeftTreeProp().setNumberPropName("number");
        pluginData.getLeftTreeProp().setNamePropName("name");
        pluginData.setLeftTreeQFilterStr(leftQFilter.toSerializedString());
        pluginData.setTreeDataSelectedType(TreeDataSelectedType.NOTREESTRU);
        pluginData.setOriginalDataRemoveFlag(Boolean.valueOf(false));
    }

    private void updateTreeDataParamByCompany(TreeDataSelectedPluginParam pluginData) {
        String viewTreetype = "08";
        String viewNumber = "08";
        QFilter qFilter = new QFilter("org.enable", "=", (Object)"1");
        qFilter.and("view.treetype", "=", (Object)viewTreetype);
        qFilter.and("view.number", "=", (Object)viewNumber);
        QFilter leftQFilter = qFilter.and("isfreeze", "!=", (Object)"1");
        pluginData.setLeftTreeEntityName("bos_org_structure");
        pluginData.getLeftTreeProp().setParentIdPropName("parent.id");
        pluginData.getLeftTreeProp().setIdPropName("org.id");
        pluginData.getLeftTreeProp().setNumberPropName("org.number");
        pluginData.getLeftTreeProp().setNamePropName("org.name");
        pluginData.setLeftTreeQFilterStr(leftQFilter.toSerializedString());
        pluginData.setTreeDataSelectedType(TreeDataSelectedType.NOTREESTRU);
        pluginData.setOriginalDataRemoveFlag(Boolean.valueOf(false));
    }

    private void updateTreeDataParamByOrg(TreeDataSelectedPluginParam pluginData) {
        String caporgtreetype = "08";
        DynamicObject tBasedataBiz = BusinessDataServiceHelper.loadSingle((String)"fpm_dimension", (String)"basedatabiz", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId())).and(new QFilter("basedata", "=", (Object)this.dimInfo.getDimension().getNumber()))});
        if (tBasedataBiz != null && tBasedataBiz.getDynamicObject("basedatabiz") != null && tBasedataBiz.getDynamicObject("basedatabiz").getString("fnumber") != null) {
            caporgtreetype = tBasedataBiz.getDynamicObject("basedatabiz").getString("fnumber");
        }
        QFilter qFilter = new QFilter("org.enable", "=", (Object)"1");
        qFilter.and("view.treetype", "=", (Object)caporgtreetype);
        QFilter leftQFilter = qFilter.and("isfreeze", "!=", (Object)"1");
        pluginData.setLeftTreeEntityName("bos_org_structure");
        pluginData.getLeftTreeProp().setParentIdPropName("parent.id");
        pluginData.getLeftTreeProp().setIdPropName("org.id");
        pluginData.getLeftTreeProp().setNumberPropName("org.number");
        pluginData.getLeftTreeProp().setNamePropName("org.name");
        pluginData.setLeftTreeQFilterStr(leftQFilter.toSerializedString());
        pluginData.setTreeDataSelectedType(TreeDataSelectedType.SETPARENT);
        pluginData.setOriginalDataRemoveFlag(Boolean.valueOf(false));
    }

    private Object[] getSelectedIds(boolean showMsg) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MemberManagerListPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            }
            return null;
        }
        return selectedRows.getPrimaryKeyValues();
    }

    private void batchAddDim() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_period_batchadd");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("bodysystem", (Object)this.dimInfo.getModel().getId());
        showParameter.setCustomParam("dimensionId", (Object)this.dimInfo.getDimension().getId());
        showParameter.setStatus(OperationStatus.ADDNEW);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batchaddperiod");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void addNewMember(String key) {
        BaseShowParameter showParameter = new BaseShowParameter();
        if (this.dimInfo.getMember() != null) {
            showParameter.setCustomParam("id", (Object)this.dimInfo.getMember().getId());
            showParameter.setCustomParam("level", (Object)String.valueOf(this.dimInfo.getMember().getLevel() + 1));
        }
        showParameter.setCustomParam("dimensionName", (Object)this.dimInfo.getDimension().getName());
        showParameter.setCustomParam("memberKey", (Object)this.dimInfo.getDimension().getMembermodel());
        showParameter.setCustomParam("bodysystem", (Object)this.dimInfo.getModel().getId());
        DimsionEnums dimsionByNumber = DimsionEnums.getDimsionByNumber((String)this.dimInfo.getDimension().getNumber());
        showParameter.setCustomParam("dimensionNumber", (Object)dimsionByNumber.getNumber());
        showParameter.setCustomParam("isSysDim", (Object)(this.dimInfo.getDimension().isSysDimension() ? "1" : "0"));
        showParameter.setCustomParam("dimensionId", (Object)this.dimInfo.getDimension().getId());
        showParameter.setCustomParam("addcontinue", (Object)"0");
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), this.dimInfo.getDimension().getName()));
        if (DimsionEnums.SUBJECT.getNumber().equals(this.dimInfo.getDimension().getNumber())) {
            showParameter.setFormId(DimsionEnums.SUBJECT.getMetadata());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            ITreeModel tm = this.getTreeModel();
            Object node = tm.getCurrentNodeId();
            DynamicObject treeNode = null;
            String nodeid = node.toString().substring(node.toString().lastIndexOf("#") + 1);
            if (!tm.getRoot().getId().equals(node)) {
                QFilter tQFilter = new QFilter("bodysystem", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId())).and(new QFilter("dimtype", "=", (Object)this.dimInfo.getDimension().getNumber())).and("id", "=", (Object)Long.valueOf(nodeid));
                treeNode = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id,number,ways,name,enable", (QFilter[])new QFilter[]{tQFilter});
                if (treeNode != null) {
                    String ways = treeNode.getString("ways");
                    if (WaysEnum.DETAILED_REPORT.getValue().equals(ways)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u79d1\u76ee\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u79d1\u76ee\u3002%2$s\u79d1\u76ee\u586b\u62a5\u65b9\u5f0f\u4e3a\u201c\u660e\u7ec6\u586b\u62a5\u201d\uff0c\u9ed8\u8ba4\u5df2\u662f\u53f6\u5b50\u8282\u70b9\u79d1\u76ee\u3002", (String)"SubjectMemberTreePlugin_02", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), treeNode.getString("name"), treeNode.getString("name")));
                        return;
                    }
                    if ("0".equals(treeNode.getString("enable"))) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5f53\u524d\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u6682\u4e0d\u53ef\u65b0\u589e\u4e0b\u7ea7\u79d1\u76ee\u3002", (String)"SubjectMemberTreePlugin_03", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), treeNode.getString("name")));
                        return;
                    }
                }
                this.getView().getPageCache().put("cache_subjectmember_id", treeNode == null ? null : treeNode.getString("id"));
            }
        } else {
            showParameter.setFormId("fpm_member_default");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshMemberCloseBack"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void refreshMemberNew(ClosedCallBackEvent evt) {
        Object tReturnData = evt.getReturnData();
        if (Objects.isNull(tReturnData)) {
            return;
        }
        if (!(tReturnData instanceof TreeDataSelectedReturnData)) {
            this.refreshMember();
            this.syncSummaryConfigIfNeed();
            return;
        }
        TreeDataSelectedReturnData returnData = (TreeDataSelectedReturnData)tReturnData;
        this.dimInfo = this.getDimManagerInfo();
        String memberkey = this.dimInfo.getDimension().getNumber();
        DimsionEnums dimEnums = DimsionEnums.getDimsionByNumber((String)memberkey);
        String metadata = dimEnums.getMetadata();
        OperationResult execOperate = null;
        if (DimsionEnums.ORG == dimEnums) {
            this.memberAsyncImport(returnData);
            return;
        }
        List<DynamicObject> needSaveDynamicObjectLists = this.nodeToDynamicObjectList(returnData);
        if (CollectionUtils.isEmpty(needSaveDynamicObjectLists)) {
            return;
        }
        if (DimsionEnums.COMPANY.getNumber().equals(memberkey)) {
            execOperate = OperationServiceHelper.executeOperate((String)"savecompany", (String)metadata, (DynamicObject[])needSaveDynamicObjectLists.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        } else if (DimsionEnums.SUBJECT.getNumber().equals(memberkey)) {
            execOperate = OperationServiceHelper.executeOperate((String)"savesubject", (String)metadata, (DynamicObject[])needSaveDynamicObjectLists.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        if (execOperate == null || execOperate.isSuccess()) {
            execOperate = OperationServiceHelper.executeOperate((String)"save", (String)metadata, (DynamicObject[])needSaveDynamicObjectLists.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        if (!execOperate.isSuccess()) {
            ValidateResultCollection tValidateResult = execOperate.getValidateResult();
            ArrayList errorMsgs = new ArrayList();
            tValidateResult.getValidateErrors().forEach(ValidateResult2 -> ValidateResult2.getAllErrorInfo().forEach(OperateErrorInfo2 -> {
                String[] errMsg = OperateErrorInfo2.getMessage().split(":");
                if (errMsg.length > 1) {
                    errorMsgs.add(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011%2$s", (String)"DimensionManagerList_28", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMsg[0], errMsg[1].trim()));
                } else {
                    errorMsgs.add(OperateErrorInfo2.getMessage());
                }
            }));
            if (errorMsgs.size() > 0) {
                this.getView().showMessage(errorMsgs.stream().reduce((a, b) -> a + "\n" + b).orElse(""));
            }
        } else {
            for (Object pkId : execOperate.getSuccessPkIds()) {
                OperationServiceHelper.executeOperate((String)"submitop", (String)metadata, (Object[])new Object[]{pkId}, (OperateOption)OperateOption.create());
            }
            if (FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
                OperationServiceHelper.executeOperate((String)"syncdim_mdd", (String)"fpm_dimension", (Object[])new Object[]{Long.valueOf(this.dimInfo.getDimension().getId())}, (OperateOption)OperateOption.create());
            }
            this.refreshMember();
        }
        this.syncSummaryConfigIfNeed();
    }

    private List<DynamicObject> nodeToDynamicObjectList(TreeDataSelectedReturnData returnData) {
        DynamicObject parent;
        Long realId;
        ArrayList<DynamicObject> newMemberList = new ArrayList<DynamicObject>(0);
        List tRightNodeList = returnData.getRightNodeList().stream().filter(TreeDataSelectedNode::isNew).collect(Collectors.toList());
        if (tRightNodeList.size() < 1) {
            return newMemberList;
        }
        this.dimInfo = this.getDimManagerInfo();
        String modelId = this.dimInfo.getModel().getId();
        String memberkey = this.dimInfo.getDimension().getNumber();
        DimsionEnums dimEnums = DimsionEnums.getDimsionByNumber((String)memberkey);
        String metadata = dimEnums.getMetadata();
        DynamicObject bodysystem = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(modelId), (String)"fpm_bodysysmanage");
        Map<Object, Object> bosOrgMap = Collections.emptyMap();
        Map<Object, Object> tFundFlowMap = Collections.emptyMap();
        DynamicObject bodySysManager = null;
        if (DimsionEnums.ORG.getNumber().equals(memberkey) || DimsionEnums.COMPANY.getNumber().equals(memberkey)) {
            DynamicObject[] bosOrgs = BusinessDataServiceHelper.load((Object[])tRightNodeList.stream().map(item -> Long.valueOf(item.getId())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
            bosOrgMap = Arrays.stream(bosOrgs).collect(Collectors.toMap(item -> item.getPkValue().toString(), Function.identity(), (key1, key2) -> key2));
        } else if (DimsionEnums.SUBJECT.getNumber().equals(memberkey)) {
            bodySysManager = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"id,number,org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(modelId))});
            DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"cas_fundflowitem", (String)"id,direction", (QFilter[])new QFilter[]{new QFilter("id", "in", tRightNodeList.stream().map(item -> Long.valueOf(item.getId())).collect(Collectors.toList()))});
            tFundFlowMap = queryResult.stream().collect(Collectors.toMap(item -> item.getString("id"), Function.identity(), (key1, key2) -> key2));
        }
        String userId = RequestContext.get().getUserId();
        Date curTime = new Date();
        long[] newIDArr = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)metadata).getAlias(), (int)tRightNodeList.size());
        Deque newIdQueue = Arrays.stream(newIDArr).boxed().collect(Collectors.toCollection(LinkedList::new));
        HashMap<Long, Long> realIdMap = new HashMap<Long, Long>(newIdQueue.size());
        for (TreeDataSelectedNode tRightNode : tRightNodeList) {
            DynamicObject treeMem = BusinessDataServiceHelper.newDynamicObject((String)metadata);
            realId = (Long)newIdQueue.poll();
            treeMem.set("id", (Object)realId);
            realIdMap.put(Long.valueOf(tRightNode.getId()), realId);
            treeMem.set("number", (Object)tRightNode.getNumber());
            treeMem.set("name", (Object)tRightNode.getName());
            treeMem.set("fullname", (Object)tRightNode.getName());
            treeMem.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            treeMem.set("creator", (Object)userId);
            treeMem.set("enable", (Object)"1");
            treeMem.set("modifier", (Object)userId);
            treeMem.set("masterid", (Object)Long.valueOf(tRightNode.getId()));
            treeMem.set("createtime", (Object)curTime);
            treeMem.set("modifytime", (Object)curTime);
            treeMem.set("bodysystem", (Object)bodysystem);
            treeMem.set("dimtype", (Object)dimEnums.getNumber());
            treeMem.set("serial", (Object)System.nanoTime());
            if (DimsionEnums.ORG.getNumber().equals(memberkey) || DimsionEnums.SUBJECT.getNumber().equals(memberkey)) {
                treeMem.set("level", (Object)tRightNode.getLevel());
                treeMem.set("isleaf", (Object)tRightNode.isLeaf());
                if (tRightNode.getParentId() != null && tRightNode.getParentId().length() > 0) {
                    parent = BusinessDataServiceHelper.newDynamicObject((String)metadata);
                    parent.set("id", (Object)Long.valueOf(tRightNode.getParentId()));
                    treeMem.set("parent", (Object)parent);
                    treeMem.set("sourceparentid", (Object)Long.valueOf(tRightNode.getParentId()));
                }
                if (DimsionEnums.ORG.getNumber().equals(memberkey)) {
                    treeMem.set("caporg", bosOrgMap.get(tRightNode.getId()));
                }
            } else {
                treeMem.set("level", (Object)1);
                treeMem.set("isleaf", (Object)Boolean.TRUE);
                treeMem.set("sumtype", (Object)MemberSumEnum.PLUS.getCode());
            }
            treeMem.set("sourceid", (Object)Long.valueOf(tRightNode.getId()));
            treeMem.set("dimension", (Object)Long.valueOf(this.dimInfo.getDimension().getId()));
            if (DimsionEnums.COMPANY.getNumber().equals(memberkey)) {
                treeMem.set("relcaporg", bosOrgMap.get(tRightNode.getId()));
            } else if (DimsionEnums.SUBJECT.getNumber().equals(memberkey)) {
                DynamicObject fundflowitem;
                treeMem.set("bodysysmanage", (Object)bodysystem);
                if (Objects.nonNull(bodySysManager)) {
                    treeMem.set("org", bodySysManager.get("org"));
                }
                if ((fundflowitem = (DynamicObject)tFundFlowMap.get(tRightNode.getId())) != null) {
                    treeMem.set("flow", (Object)fundflowitem.getString("direction"));
                }
                if (tRightNode.isLeaf()) {
                    treeMem.set("ways", (Object)WaysEnum.MANUAL_INPUT.getValue());
                } else {
                    treeMem.set("ways", (Object)WaysEnum.SUMMARY_ITEM.getValue());
                }
            }
            newMemberList.add(treeMem);
        }
        ArrayList<DynamicObject> updateMemberList = new ArrayList(newMemberList.size());
        for (DynamicObject newMember : newMemberList) {
            realId = (Long)realIdMap.get(newMember.getLong("parent.id"));
            if (realId != null) {
                parent = BusinessDataServiceHelper.newDynamicObject((String)metadata);
                parent.set("id", (Object)realId);
                newMember.set("parent", (Object)parent);
            }
            updateMemberList.add(newMember);
        }
        updateMemberList = updateMemberList.stream().sorted(Comparator.comparingInt(v -> v.getInt("level"))).collect(Collectors.toList());
        return updateMemberList;
    }

    private void refreshMember() {
        this.setBtnVissible();
        this.forceRefreshTree();
    }

    private void forceRefreshTree() {
        String tFocusDimNode;
        String[] tFocusDimNodes;
        if (EmptyUtil.isEmpty((Object)this.getTreeListView())) {
            return;
        }
        TreeNode tRefreshTreeNode = this.getTreeModel().getRoot();
        TreeView treeview = (TreeView)this.getControl("treeview");
        if (treeview.getTreeState().getFocusNodeId() != null && (tFocusDimNodes = (tFocusDimNode = treeview.getTreeState().getFocusNodeId()).split("/")).length > 1) {
            tRefreshTreeNode.setChildren(null);
            this.getTreeListView().getTreeView().queryTreeNodeChildren(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
            tRefreshTreeNode = tRefreshTreeNode.getTreeNode(tFocusDimNodes[0] + "/" + tFocusDimNodes[1], 99);
        }
        tRefreshTreeNode.setChildren(null);
        this.getTreeListView().getTreeView().treeNodeClick(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
        this.getPageCache().put(CACHE_FORCE_REFRESH_TREE_FLAG, Boolean.TRUE.toString());
    }

    private void refreshTree() {
        if (EmptyUtil.isEmpty((Object)this.getTreeListView())) {
            return;
        }
        TreeNode tRefreshTreeNode = this.getTreeModel().getRoot();
        tRefreshTreeNode.setChildren(null);
        this.getTreeListView().getTreeView().queryTreeNodeChildren(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
        List rootChildren = tRefreshTreeNode.getChildren();
        if (rootChildren != null && rootChildren.size() > 0) {
            tRefreshTreeNode = (TreeNode)rootChildren.get(0);
        }
        this.getTreeListView().getTreeView().treeNodeClick(tRefreshTreeNode.getParentid(), tRefreshTreeNode.getId());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "addDimCloseBack": {
                this.refreshTree();
                break;
            }
            case "refreshMemberCloseBack": 
            case "refreshMemberCloseBackSysImport": {
                this.refreshMemberNew(evt);
                break;
            }
            case "batchaddperiod": {
                if (EmptyUtil.isEmpty((Object)evt.getReturnData())) break;
                Pair returnData = (Pair)evt.getReturnData();
                if (((Boolean)returnData.getLeft()).booleanValue()) {
                    this.getView().showSuccessNotification((String)returnData.getRight());
                } else {
                    this.getView().showTipNotification((String)returnData.getRight());
                }
                this.refreshMember();
                break;
            }
            case "editdimclose": {
                this.forceRefreshTree();
            }
            case "memberAsyncImportCallBack": {
                this.afterMemberAsyncImport(evt);
                break;
            }
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        boolean nodeChange;
        String forceRefreshTreeFlag = this.getPageCache().get(CACHE_FORCE_REFRESH_TREE_FLAG);
        if (Boolean.TRUE.toString().equals(forceRefreshTreeFlag)) {
            this.getPageCache().remove(CACHE_FORCE_REFRESH_TREE_FLAG);
            return;
        }
        super.refreshNode(e);
        TreeView treeview = (TreeView)this.getControl("treeview");
        TreeView.TreeState state = treeview.getTreeState();
        Map focusNode = state.getFocusNode();
        if (focusNode == null) {
            this.setBtnVissible();
            return;
        }
        boolean nodeEmpty = CollectionUtils.isEmpty((Collection)e.getChildNodes());
        boolean bl = nodeChange = !e.getNodeId().toString().equals(focusNode.get("id").toString());
        if (nodeChange || nodeEmpty) {
            this.dimInfo = this.getDimManagerInfo();
            String dimensionId = e.getNodeId().toString();
            if (!this.getTreeModel().getRoot().getId().equals(dimensionId)) {
                this.dimInfo.setDimension(this.getDimensionId(dimensionId.substring(dimensionId.indexOf("/") + 1, dimensionId.indexOf("#"))));
            } else {
                DimManagerInfo tDimManagerInfo = new DimManagerInfo();
                if (this.dimInfo.getModel() != null) {
                    tDimManagerInfo.setModel(this.dimInfo.getModel().getId());
                }
                this.dimInfo = tDimManagerInfo;
            }
            this.cacheDimManagerInfo();
            List treeFilter = this.getTreeListView().getTreeModel().getTreeFilter();
            if (CollectionUtils.isEmpty((Collection)treeFilter)) {
                QFilter tQFilter = new QFilter("bodysystem", "=", (Object)Long.valueOf(this.dimInfo.getModel().getId()));
                DimensionInfo dimension = this.dimInfo.getDimension();
                if (Objects.nonNull(dimension)) {
                    tQFilter.and(new QFilter("dimension", "=", (Object)Long.valueOf(dimension.getId())));
                }
                treeFilter.add(tQFilter);
            }
        }
    }

    private String getDimensionId(String nodeNumber) {
        this.dimInfo = this.getDimManagerInfo();
        DynamicObject tDimension = this.queryDimension(this.dimInfo.getModel().getId(), nodeNumber);
        String tDimensionId = tDimension != null ? tDimension.getString("id") : "";
        return tDimensionId;
    }

    private DynamicObject queryDimension(String bodySystemId, String nodeNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("bodysystem.id", "=", (Object)Long.valueOf(bodySystemId)));
        filters.add(new QFilter("number", "=", (Object)nodeNumber));
        String field = "id,number,name";
        return QueryServiceHelper.queryOne((String)"fpm_dimension", (String)field, (QFilter[])filters.toArray(new QFilter[0]));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        this.dimInfo = this.getDimManagerInfo();
        TreeView treeview = (TreeView)this.getControl("treeview");
        if (treeview == null) {
            return;
        }
        String dimensionId = "";
        Map focusNode = treeview.getTreeState().getFocusNode();
        if (focusNode == null) {
            TreeNode tRefreshTreeNode = this.getTreeModel().getRoot();
            List rootChildren = tRefreshTreeNode.getChildren();
            if (rootChildren != null && rootChildren.size() > 0) {
                tRefreshTreeNode = (TreeNode)rootChildren.get(0);
                dimensionId = tRefreshTreeNode.getId();
            }
        } else {
            dimensionId = treeview.getTreeState().getFocusNode().get("id").toString();
        }
        String rootId = this.getTreeModel().getRoot().getId();
        if (!rootId.equals(dimensionId)) {
            if (!dimensionId.contains("#")) {
                return;
            }
            this.dimInfo.setDimension(this.getDimensionId(dimensionId.substring(dimensionId.indexOf("/") + 1, dimensionId.indexOf("#"))));
        } else {
            DimManagerInfo tDimManagerInfo = new DimManagerInfo();
            if (this.dimInfo.getModel() != null) {
                tDimManagerInfo.setModel(this.dimInfo.getModel().getId());
            }
            this.dimInfo = tDimManagerInfo;
        }
        this.cacheDimManagerInfo();
        if (this.dimInfo.getDimension() != null) {
            List columns = args.getListColumns();
            ArrayList showColumns = new ArrayList(10);
            DimensionInfo dimension = this.dimInfo.getDimension();
            String number = this.dimInfo.getDimension().getNumber();
            String memberFrom = dimension.getMemberFrom();
            Pair<String[], String[]> fieldByDimensionNumber = StringUtils.isEmpty((CharSequence)memberFrom) ? MemberManagerListHelper.getFieldByDimensionNumber(number) : (DimMemberFromEnum.BASE_INFO == DimMemberFromEnum.valueOf((String)dimension.getMemberFrom()) && DimsionEnums.CUSTOM == DimsionEnums.getDimsionByNumber((String)number) ? MemberManagerListHelper.getOtherBaseInfoFieldPair() : MemberManagerListHelper.getFieldByDimensionNumber(number));
            List<Object> properties = Arrays.asList((Object[])fieldByDimensionNumber.getRight());
            columns.forEach(item -> {
                if (properties.contains(item.getListFieldKey())) {
                    showColumns.add(item);
                }
                if ("sortcode".equals(item.getListFieldKey())) {
                    showColumns.add(item);
                }
            });
            args.setListColumns(showColumns);
        }
        this.setBtnVissible();
    }

    private void cacheDimManagerInfo() {
        this.getPageCache().put("dimInfo", SerializationUtils.serializeToBase64((Object)this.dimInfo));
    }

    private DimManagerInfo getDimManagerInfo() {
        if (this.dimInfo != null) {
            return this.dimInfo;
        }
        String dimInfo1 = this.getPageCache().get("dimInfo");
        DimManagerInfo tDimManagerInfo = dimInfo1 != null ? (DimManagerInfo)SerializationUtils.deSerializeFromBase64((String)dimInfo1) : new DimManagerInfo();
        String modelId = this.getPageCache().get("bodysystem");
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            tDimManagerInfo.setModel(modelId);
        }
        return tDimManagerInfo;
    }

    private Pair<String, Long[]> getSelectMemberId(boolean isContainSon) {
        ArrayList<Long> selectMems = new ArrayList<Long>(0);
        BillList tBillList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection tSelectedRows = tBillList.getSelectedRows();
        String selectParentId = "0";
        if (tSelectedRows != null && tSelectedRows.size() > 0) {
            selectParentId = tSelectedRows.get(0).getPrimaryKeyValue().toString();
            long selectMemId = Long.parseLong(selectParentId);
            selectMems.add(selectMemId);
            return Pair.of((Object)selectParentId, (Object)selectMems.toArray(new Long[0]));
        }
        return Pair.of((Object)selectParentId, (Object)selectMems.toArray(new Long[0]));
    }

    private void setMemberId() {
        String parentId;
        this.dimInfo = this.getDimManagerInfo();
        Pair<String, Long[]> selectMemberId = this.getSelectMemberId(false);
        Long[] selectMemberIdArr = (Long[])selectMemberId.getRight();
        if (selectMemberIdArr.length > 0 && !"0".equals(parentId = (String)selectMemberId.getLeft())) {
            this.dimInfo.setMember(String.valueOf(selectMemberIdArr[0]));
        }
    }

    private void setBtnVissible() {
        IFormView iFormView = this.getView();
        if (iFormView instanceof ListView && !Objects.equals(((ListView)iFormView).getBillFormId(), "fpm_membersubject")) {
            this.getView().setVisible(Boolean.FALSE, MemberManagerListProp.ALLBTNKEYS);
            this.getView().setVisible(Boolean.FALSE, (String[])Arrays.stream(MemberManagerListProp.ALLBTNKEYS).map(v -> "sep_" + v).toArray(String[]::new));
        } else {
            this.getView().setVisible(Boolean.FALSE, MemberManagerListProp.SUBJECTKEYS);
            this.getView().setVisible(Boolean.FALSE, (String[])Arrays.stream(MemberManagerListProp.SUBJECTKEYS).map(v -> "sep_" + v).toArray(String[]::new));
        }
        if (Objects.nonNull(this.dimInfo) && Objects.nonNull(this.dimInfo.getDimension())) {
            DimensionInfo dimension = this.dimInfo.getDimension();
            DimsionEnums dimsionEnums = DimsionEnums.getDimsionByNumber((String)dimension.getNumber());
            String number = this.dimInfo.getDimension().getNumber();
            String memberFrom = dimension.getMemberFrom();
            String[] showButtons = StringUtils.isEmpty((CharSequence)memberFrom) ? (String[])MemberManagerListHelper.getFieldByDimensionNumber(dimension.getNumber()).getLeft() : (DimMemberFromEnum.BASE_INFO == DimMemberFromEnum.valueOf((String)dimension.getMemberFrom()) && DimsionEnums.CUSTOM == DimsionEnums.getDimsionByNumber((String)number) ? (String[])MemberManagerListHelper.getOtherBaseInfoFieldPair().getLeft() : (String[])MemberManagerListHelper.getFieldByDimensionNumber(dimension.getNumber()).getLeft());
            this.getView().setVisible(Boolean.TRUE, showButtons);
            List<String> showSeq = Arrays.stream(showButtons).map(v -> "sep_" + v).collect(Collectors.toList());
            showSeq.remove(0);
            this.getView().setVisible(Boolean.TRUE, showSeq.toArray(new String[0]));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        DynamicObject tFpmMember = TmcDataServiceHelper.loadSingle((Object)e.getParameter().getPkId(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
        DimsionEnums dimtype = DimsionEnums.getDimsionByNumber((String)tFpmMember.getString("dimtype"));
        e.getParameter().setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"DimensionManagerList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), dimtype.getName()));
        if (DimsionEnums.SUBJECT.getNumber().equals(dimtype.getNumber())) {
            e.getParameter().setFormId(dimtype.getMetadata());
        }
        e.getParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshMemberCloseBack"));
    }

    private String getSelectDimName() {
        String dimensionNumber = this.dimInfo.getDimension().getNumber();
        DimsionEnums dimEnums = DimsionEnums.getDimsionByNumber((String)dimensionNumber);
        return dimEnums.getMetadata();
    }

    private void syncSummaryConfigIfNeed() {
        this.dimInfo = this.getDimManagerInfo();
        if (EmptyUtil.isEmpty((Object)this.dimInfo)) {
            return;
        }
        ModelInfo model = this.dimInfo.getModel();
        if (EmptyUtil.isEmpty((Object)model)) {
            return;
        }
        String modelId = model.getId();
        if (EmptyUtil.isEmpty((String)modelId)) {
            return;
        }
        DimensionInfo dimension = this.dimInfo.getDimension();
        if (EmptyUtil.isEmpty((Object)dimension)) {
            return;
        }
        if (!Objects.equals(dimension.getNumber(), DimsionEnums.ORG.getNumber())) {
            return;
        }
        Long systemId = Long.valueOf(modelId);
        DynamicObject sumConfig = FpmDataServiceHelper.loadSingle((String)"fpm_summaryconfig", (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)systemId).and("enable", "=", (Object)"1")});
        if (EmptyUtil.isNoEmpty((DynamicObject)sumConfig)) {
            String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0b\u5b58\u5728\u53ef\u7528\u72b6\u6001\u7684\u6c47\u603b\u53c2\u6570\u8bb0\u5f55\u3010%1$s\u3011\uff0c\u8bf7\u786e\u8ba4\u672c\u6b21\u65b0\u589e\u7f16\u62a5\u4e3b\u4f53\u65b0\u6210\u5458\u540e\uff0c\u662f\u5426\u9700\u8981\u8054\u52a8\u66f4\u65b0\u6c47\u603b\u53c2\u6570\u4e2d\u7f16\u62a5\u4e3b\u4f53\u6811\u4fe1\u606f\uff1f", (String)"MemberManagerListPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), sumConfig.getString("name"));
            this.getView().showConfirm(message, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("syncsumconfig"));
            return;
        }
    }

    private void memberAsyncImport(TreeDataSelectedReturnData treeDataSelectedReturnData) {
        this.dimInfo = this.getDimManagerInfo();
        String memberKey = this.dimInfo.getDimension().getNumber();
        String modelId = this.dimInfo.getModel().getId();
        DimsionEnums dimEnums = DimsionEnums.getDimsionByNumber((String)memberKey);
        JobFormInfo asyncImportJob = this.getMemberAsyncImportJob(treeDataSelectedReturnData, Long.valueOf(this.dimInfo.getDimension().getId()), dimEnums, Long.valueOf(modelId));
        JobForm.dispatch((JobFormInfo)asyncImportJob, (IFormView)this.getView());
    }

    private JobFormInfo getMemberAsyncImportJob(TreeDataSelectedReturnData treeDataSelectedReturnData, Long dimId, DimsionEnums dimsionEnums, Long systemId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname(DimMemberImportTask.class.getName());
        jobInfo.setName(ResManager.loadKDString((String)"\u7cfb\u7edf\u5bfc\u5165\u8c03\u5ea6\u4efb\u52a1", (String)"MemberManagerListPlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setCanStop(Boolean.valueOf(false));
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u7cfb\u7edf\u5bfc\u5165\u8c03\u5ea6\u4efb\u52a1", (String)"MemberManagerListPlugin_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(GlobalIdUtil.genStringId());
        HashMap<String, Object> params = new HashMap<String, Object>(8, 1.0f);
        params.put("dimId", dimId);
        params.put("dimNumber", dimsionEnums.getNumber());
        params.put("treeDataSelectedReturnDataJson", JSON.toJSONString((Object)treeDataSelectedReturnData));
        params.put("systemId", systemId);
        params.put("pageId", this.getView().getPageId());
        params.put("appId", this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo();
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName(ReportImportDataClickTask.class.getName());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "memberAsyncImportCallBack");
        jobFormInfo.setCloseCallBack(closeCallBack);
        return jobFormInfo;
    }

    private void afterMemberAsyncImport(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (!(returnData instanceof Map) && !(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        Object taskInfoObj = result.get("taskinfo");
        if (EmptyUtil.isEmpty(taskInfoObj)) {
            return;
        }
        String taskInfoStr = (String)taskInfoObj;
        if (EmptyUtil.isEmpty((String)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        String data = taskInfo.getData();
        Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        boolean success = (Boolean)mapData.get("success");
        if (!success) {
            List errorMessages = (List)mapData.get("errorMessages");
            if (CollectionUtils.isNotEmpty((Collection)errorMessages)) {
                this.getView().showMessage(errorMessages.stream().reduce((a, b) -> a + "\n" + b).orElse(""));
            }
            return;
        }
        this.refreshMember();
        this.syncSummaryConfigIfNeed();
    }

    private void setDimension() {
        if (Objects.isNull(this.dimInfo.getDimension())) {
            TreeNode root = this.getTreeModel().getRoot();
            TreeView treeview = (TreeView)this.getControl("treeview");
            String dimensionId = treeview.getTreeState().getFocusNode().get("id").toString();
            IFormView iFormView = this.getView();
            if (iFormView instanceof ListView && Objects.equals(((ListView)iFormView).getBillFormId(), "fpm_membersubject") && StringUtils.equals((CharSequence)root.getId(), (CharSequence)dimensionId)) {
                this.dimInfo.setDimension(this.getDimensionId(DimsionEnums.SUBJECT.getNumber()));
                return;
            }
            if (dimensionId.contains("/") && dimensionId.contains("#")) {
                this.dimInfo.setDimension(this.getDimensionId(dimensionId.substring(dimensionId.indexOf("/") + 1, dimensionId.indexOf("#"))));
            }
        }
    }
}

