/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MetricMemberDataTypeEnum;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.enums.MetricMemberUseTypeEnum;
import org.apache.commons.collections.MapUtils;

public class MetricMemberEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"computeformula"});
    }

    public void initialize() {
        super.initialize();
        FieldEdit fieldEdit = (FieldEdit)this.getControl("metrictype");
        fieldEdit.setMustInput(true);
        FieldEdit metricUse = (FieldEdit)this.getControl("metricuse");
        metricUse.setMustInput(true);
        FieldEdit dataType = (FieldEdit)this.getControl("metricdatatype");
        dataType.setMustInput(true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getAndSetSysId();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status) {
            this.handleMetricUseComboList();
            this.handleMetricDataType();
            this.handleFormulaMustInput();
            this.getModel().setValue("metricdatatype", (Object)MetricMemberDataTypeEnum.MONEY.getValue());
            this.getModel().setValue("dimtype", (Object)DimsionEnums.METRIC.getNumber());
        }
        if (OperationStatus.EDIT == status) {
            boolean enable = BaseEnableEnum.ENABLE.getValue().equals(this.getModel().getValue("enable"));
            if (enable) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap1"});
            } else {
                Boolean isPreset = (Boolean)this.getModel().getValue("preset");
                if (isPreset.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap1"});
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        boolean valueEqual = Objects.equals(newValue, oldValue = changeSet[0].getOldValue());
        if (valueEqual) {
            return;
        }
        switch (key) {
            case "metrictype": {
                this.handleMetricUseComboList();
                this.handleMetricDataType();
                this.handleFormulaMustInput();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "computeformula": {
                DynamicObject systemObject = (DynamicObject)this.getModel().getValue("bodysystem");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("model", systemObject.getPkValue());
                params.put("expression", this.getModel().getValue("computeformulavalue_tag"));
                params.put("expressiondesc", this.getModel().getValue("computeformula"));
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("fpm_valueformulaconfig");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "computeformula"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u7f16\u8f91", (String)"MetricMemberEdit_00", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                formShowParameter.setCustomParams(params);
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "computeformula": {
                this.handleValueFormulaCallback(closedCallBackEvent);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(this.getModel().getDataChanged());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject sys = (DynamicObject)this.getModel().getValue("bodysystem");
            QFilter filter = new QFilter("bodysystem", "=", sys.getPkValue());
            filter.and(new QFilter("preset", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("dimtype", "=", (Object)DimsionEnums.METRIC.getNumber()));
            int count = TmcDataServiceHelper.count((String)"fpm_member", (QFilter[])new QFilter[]{filter});
            if (count >= 20) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5ea6\u91cf\u53ca\u6307\u6807\u8bb0\u5f55\u5931\u8d25\u3002\u5f53\u524d\u4f53\u7cfb\u4e0b\u975e\u9884\u7f6e\u6307\u6807\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc720\u4e2a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"MetricMemberEdit_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private boolean getAndSetSysId() {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            String metricNumber = parentView.getPageCache().get("MetricNumber");
            this.getModel().setValue("number", (Object)metricNumber);
            String modelId = parentView.getPageCache().get("bodysystem.id");
            if (modelId == null) {
                return true;
            }
            if (modelId.contains("[")) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            this.getModel().setValue("bodysystem", (Object)modelId);
            DynamicObject[] metricDim = BusinessDataServiceHelper.load((String)"fpm_dimension", (String)"id", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)Long.valueOf(modelId)), new QFilter("basedata", "=", (Object)DimsionEnums.METRIC.getNumber())});
            this.getModel().setValue("dimension", metricDim[0].getPkValue());
        }
        return false;
    }

    private void handleMetricUseComboList() {
        ComboEdit metricUse = (ComboEdit)this.getControl("metricuse");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        comboItems.add(MetricMemberUseTypeEnum.convertCombo((MetricMemberUseTypeEnum)MetricMemberUseTypeEnum.SELECT));
        comboItems.add(MetricMemberUseTypeEnum.convertCombo((MetricMemberUseTypeEnum)MetricMemberUseTypeEnum.ANALYSE));
        metricUse.setComboItems(comboItems);
        MetricMemberTypeEnum memberType = this.getMetricMemberTypeEnum();
        if (memberType == null) {
            return;
        }
        if (MetricMemberTypeEnum.BASE == memberType) {
            comboItems.clear();
            comboItems.add(MetricMemberUseTypeEnum.convertCombo((MetricMemberUseTypeEnum)MetricMemberUseTypeEnum.ANALYSE));
            metricUse.setComboItems(comboItems);
        } else if (MetricMemberTypeEnum.ANALYSE == memberType) {
            comboItems.clear();
            comboItems.add(MetricMemberUseTypeEnum.convertCombo((MetricMemberUseTypeEnum)MetricMemberUseTypeEnum.SELECT));
            metricUse.setComboItems(comboItems);
        }
    }

    private MetricMemberTypeEnum getMetricMemberTypeEnum() {
        return MetricMemberTypeEnum.getEnumByCode((String)String.valueOf(this.getModel().getValue("metrictype")));
    }

    private void handleMetricDataType() {
        ComboEdit metricUse = (ComboEdit)this.getControl("metricdatatype");
        MetricMemberTypeEnum memberType = this.getMetricMemberTypeEnum();
        if (memberType == null) {
            return;
        }
        if (MetricMemberTypeEnum.BASE == memberType) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            comboItems.add(MetricMemberDataTypeEnum.convertCombo((MetricMemberDataTypeEnum)MetricMemberDataTypeEnum.MONEY));
            metricUse.setComboItems(comboItems);
            this.getView().updateView("metricdatatype");
            this.getModel().setValue("metricdatatype", (Object)MetricMemberDataTypeEnum.MONEY.getValue());
            this.getView().updateView("metricdatatype");
        } else if (MetricMemberTypeEnum.ANALYSE == memberType) {
            ArrayList comboItems = new ArrayList(MetricMemberDataTypeEnum.convertComboList());
            metricUse.setComboItems(comboItems);
            this.getView().updateView("metricdatatype");
            this.getModel().setValue("metricdatatype", (Object)MetricMemberDataTypeEnum.MONEY.getValue());
            this.getView().updateView("metricdatatype");
        }
    }

    private void handleValueFormulaCallback(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (MapUtils.isEmpty((Map)returnData)) {
            return;
        }
        this.getModel().setValue("computeformula", returnData.get("expressiondesc"));
        this.getModel().setValue("computeformulavalue_tag", returnData.get("expression"));
    }

    private void handleFormulaMustInput() {
        FieldEdit fieldEdit = (FieldEdit)this.getControl("computeformula");
        if (this.getMetricMemberTypeEnum() == MetricMemberTypeEnum.ANALYSE) {
            fieldEdit.setMustInput(true);
        } else {
            this.getModel().setValue("computeformula", (Object)"");
            this.getModel().setValue("computeformulavalue_tag", (Object)"");
            fieldEdit.setMustInput(false);
        }
    }
}

