/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dimmanager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.helper.ModelHelper;

public class SubjectMemberTreePlugin
extends StandardTreeListPlugin {
    private static final String CUSTOMFILTER = "customfilter";
    private static final String FIELDNAME = "FieldName";
    private static final String VALUE = "Value";

    public void initialize() {
        super.initialize();
        this.rebuildTree();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List<QFilter> cachedFilter;
        super.filterContainerInit(args);
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isF7Open = lsp.isLookUp();
        Iterator it = args.getFilterContainerInitEvent().getCommonFilterColumns().iterator();
        String bodySysId = null;
        String enable = null;
        String flow = null;
        String mark = null;
        while (it.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)it.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.equals("bodysysmanage.name")) {
                List authModelId = ModelHelper.getAuthModelId();
                if (!authModelId.isEmpty()) {
                    bodySysId = ((Long)authModelId.get(0)).toString();
                    commonFilterColumn.setDefaultValue(bodySysId);
                    commonFilterColumn.setComboItems(this.initModelItemsList());
                    commonFilterColumn.addSetFilterListeners(event -> {
                        List f7Filters = event.getQFilters();
                        f7Filters.clear();
                        f7Filters.add(ModelHelper.getAuthQFilter());
                    });
                    this.getTreeListView().focusRootNode();
                    continue;
                }
                commonFilterColumn.setComboItems(new ArrayList(0));
                continue;
            }
            if (fieldName.equals("flow")) {
                commonFilterColumn.setDefaultValue(null);
                continue;
            }
            if (!fieldName.equals("enable")) continue;
            enable = "1";
            commonFilterColumn.setDefaultValue(enable);
        }
        if (isF7Open) {
            // empty if block
        }
        if (CollectionUtils.isEmpty(cachedFilter = this.getCacheTreeFilter(false))) {
            this.setCacheTreeFilter(bodySysId, enable, flow, mark);
            this.refreshTree();
        }
    }

    private void rebuildTree() {
        ITreeListView treeListView = this.getTreeListView();
        ITreeModel treeModel = treeListView.getTreeModel();
        List filters = treeModel.getTreeFilter();
        filters.clear();
        filters.add(this.getTreeAndListFilter());
        treeModel.getRoot().setText(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"SubjectMemberTreePlugin_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private void refreshTree() {
        ITreeModel treeModel = this.getTreeModel();
        if (treeModel != null) {
            List filters = treeModel.getTreeFilter();
            filters.clear();
            filters.addAll(this.getCacheTreeFilter(true));
        }
        this.getTreeListView().refreshTreeView();
    }

    private List<ComboItem> initModelItemsList() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        DynamicObject[] authModelData = null;
        QFilter authQFilter = ModelHelper.getAuthQFilter();
        DynamicObject[] ids = TmcDataServiceHelper.load((String)"fpm_bodysysmanage", (String)"id", (QFilter[])new QFilter[]{authQFilter});
        if (ids.length > 0) {
            List idList = Stream.of(ids).map(e -> e.get("id")).collect(Collectors.toList());
            authModelData = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_bodysysmanage"));
        }
        if (authModelData != null && authModelData.length > 0) {
            for (DynamicObject model : authModelData) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(model.getString("name")));
                item.setValue(model.getString("id"));
                items.add(item);
            }
        }
        return items;
    }

    private List<QFilter> getCacheTreeFilter(boolean flag) {
        String mark;
        String enable;
        String flow;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        String sysBodyId = this.getView().getPageCache().get("cache_subjectmember_bodysysmanager");
        if (null != sysBodyId) {
            if ("empty".equals(sysBodyId)) {
                filters.add(new QFilter("id", "=", (Object)0));
            } else {
                filters.add(new QFilter("bodysysmanage", "=", (Object)Long.valueOf(sysBodyId)));
            }
        }
        if (null != (flow = this.getView().getPageCache().get("cache_flow")) && !flow.isEmpty()) {
            filters.add(new QFilter("flow", "=", (Object)flow));
        }
        if ((enable = this.getView().getPageCache().get("cache_enable")) != null && !enable.isEmpty()) {
            filters.add(new QFilter("enable", "=", (Object)enable));
        }
        if (null != (mark = this.getView().getPageCache().get("cache_mark")) && !mark.isEmpty()) {
            filters.add(new QFilter("beginorendmark", "=", (Object)mark));
        }
        if (flag) {
            filters.add(new QFilter("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber()));
        }
        return filters;
    }

    private QFilter getTreeAndListFilter() {
        List<QFilter> filters = this.getCacheTreeFilter(true);
        QFilter filter = filters.get(0);
        for (int i = 1; i < filters.size(); ++i) {
            filter.and(filters.get(i));
        }
        return filter;
    }

    private void setCacheTreeFilter(String bodySysId, String enable, String flow, String mark) {
        if (null != bodySysId && !bodySysId.isEmpty()) {
            this.getView().getPageCache().put("cache_subjectmember_bodysysmanager", bodySysId);
        } else {
            this.getView().getPageCache().put("cache_subjectmember_bodysysmanager", "empty");
        }
        if (null != enable && !enable.isEmpty()) {
            this.getView().getPageCache().put("cache_enable", enable);
        } else {
            this.getView().getPageCache().remove("cache_enable");
        }
        if (null != flow && !flow.isEmpty()) {
            this.getView().getPageCache().put("cache_flow", flow);
        } else {
            this.getView().getPageCache().remove("cache_flow");
        }
        if (null != mark && null != flow && !flow.isEmpty()) {
            this.getView().getPageCache().put("cache_mark", mark);
        } else {
            this.getView().getPageCache().remove("cache_mark");
        }
    }
}

