/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.dync;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.tmc.fpm.formplugin.dync.DynBillMutexLock;

public abstract class AbstractTmcDynBillPlugin
extends AbstractFormPlugin {
    public static final String KEY_BILLID = "billId";
    private static final String CONFIRMCALLBACK_KEY_MUTX = "mutxCallBack";
    protected static final String MUTEX_GROUP_ID = "default_netctrl";

    public void afterCreateNewData(EventObject e) {
        this.recordOrRequireMutex();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void setBillId(String formId) {
        this.getPageCache().put(KEY_BILLID, formId);
    }

    private void recordOrRequireMutex() {
        boolean needLock;
        boolean needMutexLock = ((Object)((Object)this)).getClass().isAnnotationPresent(DynBillMutexLock.class);
        if (!needMutexLock) {
            return;
        }
        DynBillMutexLock lockAnnotation = ((Object)((Object)this)).getClass().getAnnotation(DynBillMutexLock.class);
        String lockEntityName = lockAnnotation.entityName();
        String lockIdCacheKey = lockAnnotation.lockId();
        String lockId = null;
        if (StringUtils.isNotEmpty((CharSequence)lockIdCacheKey)) {
            String lockIdKey = lockIdCacheKey.replaceAll("[{}]", "");
            lockId = this.getPageCache().get(lockIdKey);
        }
        if (StringUtils.isEmpty(lockId)) {
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isSuccess = true;
        String mutexEntityKey = (String)customParams.get("MUTEX_ENTITY_KEY");
        String mutexOperationKey = (String)customParams.get("MUTEX_OPER_KEY");
        String mutexObjId = (String)customParams.get("MUTEX_OBJ_ID");
        boolean bl = needLock = (StringUtils.isBlank((CharSequence)mutexObjId) || StringUtils.isBlank((CharSequence)mutexOperationKey) || StringUtils.isBlank((CharSequence)mutexEntityKey)) && StringUtils.isNotBlank((CharSequence)lockId);
        if (needLock) {
            try {
                MutexLockInfo lockInfo = new MutexLockInfo();
                lockInfo.setGroupId(MUTEX_GROUP_ID);
                lockInfo.setEntityNumber(lockEntityName);
                lockInfo.setDataObjId(lockId);
                lockInfo.setOperationKey("modify");
                lockInfo.setCallSource("default");
                lockInfo.setStrict(true);
                isSuccess = MutexHelper.requireMutex4BillController((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errMsg);
            }
            catch (Exception e) {
                isSuccess = false;
            }
        }
        if (!isSuccess) {
            this.doAction();
            this.doActionWithObjId(lockId);
        }
    }

    protected void doAction() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMCALLBACK_KEY_MUTX, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5360\u7528\uff0c\u6b64\u9875\u9762\u5c06\u5173\u95ed\u9000\u51fa\u3002", (String)"AbstractTmcDynBillPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, confirmCallBacks);
    }

    protected void doActionWithObjId(String lockId) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRMCALLBACK_KEY_MUTX.equals(callBackId)) {
            this.getView().close();
        }
    }
}

