/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.execbiasanalys;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.CheckSubLimitType;
import kd.tmc.fpm.business.domain.enums.SourceBillType;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.business.spread.export.excel.impl.ExecBiasPlanFormsExportImpl;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.formplugin.common.FpmFilterBaseList;

public class ReportExecBiasAnalysList
extends FpmFilterBaseList
implements IReportVerifyView {
    private static final Log logger = LogFactory.getLog(ReportExecBiasAnalysList.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (operateKey) {
                case "exportexcel": {
                    this.exportSumPlanData();
                }
            }
        }
    }

    private void exportSumPlanData() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List selectedIdList = selectedRows.stream().map(c -> (Long)c.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] execBiasAnalyS = TmcDataServiceHelper.load((Object[])selectedIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_execbiasanalys"));
        HashMap<Long, SumPlanHeader> reportHeaderMap = new HashMap<Long, SumPlanHeader>(1);
        Long systemId = null;
        for (DynamicObject execBiasAnaly : execBiasAnalyS) {
            String sourceBillTypeVal = execBiasAnaly.getString("sourcebilltype");
            SourceBillType sourceBillType = SourceBillType.getStatusByVal((String)sourceBillTypeVal);
            if (sourceBillType == SourceBillType.SUMPLAN) {
                Long reportId = execBiasAnaly.getLong(String.join((CharSequence)".", "sourcebill", "id"));
                DynamicObject sumPlan = TmcDataServiceHelper.loadSingle((Object)reportId, (String)"fpm_reportplansum");
                SumPlanHeader sumPlanHeader = this.getSumPlanHeader(sumPlan);
                reportHeaderMap.put(execBiasAnaly.getLong("id"), sumPlanHeader);
            }
            systemId = (Long)execBiasAnaly.getDynamicObject("bodysys").getPkValue();
        }
        try {
            ExecBiasPlanFormsExportImpl exportExcel = new ExecBiasPlanFormsExportImpl(new HashSet(selectedIdList), systemId, null, reportHeaderMap);
            Tuple exportResult = exportExcel.export();
            if (((Boolean)exportResult.item1).booleanValue()) {
                this.getView().download((String)exportResult.item2);
            } else {
                this.getView().showErrorNotification((String)exportResult.item2);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private SumPlanHeader getSumPlanHeader(DynamicObject sumPlan) {
        Long systemId = (Long)sumPlan.getDynamicObject("bodysys").getPkValue();
        Long reportOrgId = (Long)sumPlan.getDynamicObject("reportorg").getPkValue();
        SumPlanHeader sumPlanHeader = new SumPlanHeader();
        sumPlanHeader.setDataStatus(SumPlanHeader.DATA_STATUS_INNER_CANCEL_BEFORE);
        Long reportTypeId = (Long)sumPlan.getDynamicObject("reporttype").getPkValue();
        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId);
        if (EmptyUtil.isNoEmpty((Long)reportTypeId)) {
            qFilter = qFilter.and(reportTypeProp, "=", (Object)reportTypeId);
        }
        qFilter = qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection loads = QueryServiceHelper.query((String)"fpm_summaryconfig", (String)"id", (QFilter[])new QFilter[]{qFilter});
        List sumPlanParamConfigList = ConverterUtils.convert(SumPlanParamConfig.class, (Collection)loads, (boolean)true, (String)"fpm_summaryconfig");
        boolean showlimit = false;
        if (!EmptyUtil.isEmpty((Collection)sumPlanParamConfigList)) {
            SumPlanParamConfig sumPlanParamConfig = (SumPlanParamConfig)sumPlanParamConfigList.get(0);
            List configInfoList = sumPlanParamConfig.getConfigInfoList();
            for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
                CheckSubLimitType checkSubLimitType;
                if (!reportOrgId.equals(sumPlanParamConfigInfo.getOrgMemberId()) || CheckSubLimitType.SUM_AND_CHECK_MAIN_LIMIT != (checkSubLimitType = sumPlanParamConfigInfo.getCheckSubLimitType())) continue;
                showlimit = true;
                break;
            }
            String planStatus = sumPlan.getString("planstatus");
            if (ReportPlanStatusEnum.EFFECTIVE.getValue().equals(planStatus)) {
                showlimit = false;
            }
        }
        sumPlanHeader.setShowApprovedAmt(Boolean.valueOf(showlimit));
        return sumPlanHeader;
    }

    public void showVerifyResultDialog(Map<String, String> customShowParameter) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        this.getView().showForm(parameter);
    }

    public void showErrMessage(List<String> list) {
    }

    public void showSuccessMessage(String s) {
    }

    @Override
    protected String getAuthEntityName() {
        return "fpm_execbiasanalys";
    }

    @Override
    protected String getBodySystemProp() {
        return "bodysys";
    }

    @Override
    protected String getReportOrgProp() {
        return "reportorg";
    }

    @Override
    protected void customSearchClickFilter(List<Map<String, List<Object>>> customFilterList) {
        super.customSearchClickFilter(customFilterList);
        IPageCache pageCache = this.getPageCache();
        for (Map<String, List<Object>> map : customFilterList) {
            Date endDate;
            String fieldName = map.get("FieldName").size() > 0 ? map.get("FieldName").get(0).toString() : "";
            List<Object> selectValue = map.get("Value");
            if (!fieldName.startsWith("declarestartdate")) continue;
            pageCache.put("tipFlag", "false");
            if (selectValue.size() <= 1) continue;
            Object startDateStr = selectValue.get(0);
            Object endDateStr = selectValue.get(1);
            Date startDate = DateUtils.stringToDate((String)((String)startDateStr), (String)"yyyy-MM-dd");
            int diffDays = DateUtils.getDiffDays((Date)startDate, (Date)(endDate = DateUtils.stringToDate((String)((String)endDateStr), (String)"yyyy-MM-dd")));
            if (diffDays <= 365) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u5f00\u59cb\u65e5\u671f\u81ea\u5b9a\u4e49\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7365\u5929\u3002", (String)"ReportPlanList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            pageCache.put("tipFlag", "true");
            return;
        }
    }

    @Override
    protected boolean authSystemManager() {
        return true;
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        List<Long> authMemberOrgIds = this.getAuthMemberOrgIds();
        qFilters.add(new QFilter("reportorg", "in", authMemberOrgIds));
        if (this.getPageCache().get("tipFlag") != null && "true".equals(this.getPageCache().get("tipFlag"))) {
            qFilters.add(new QFilter("1", "!=", (Object)1));
        }
    }
}

