/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.execbiasanalys;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.CheckSubLimitType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.SourceBillType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.report.MetricHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.controller.IExecBiasAnalysManageController;
import kd.tmc.fpm.business.mvc.controller.impl.ExecBiasAnalysManageController;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.view.IExecBiasAnalysManageView;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.CellFormulaCmdChain;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.chain.RowAndColVisibleCmdChain;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.command.generator.UpdateCellInfoGenerator;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.export.excel.impl.ExecBiasPlanFormsExportImpl;
import kd.tmc.fpm.business.spread.update.CellValueUpdateFactory;
import kd.tmc.fpm.business.spread.update.bean.CellUpdateResult;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.resource.FpmBizResource;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.FormulaCell;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.utils.report.SheetUtils;

public class ReportExecBiasAnalysPlugin
extends AbstractSpreadPlugin
implements IExecBiasAnalysManageView,
IReportVerifyView {
    private static final Log logger = LogFactory.getLog(ReportExecBiasAnalysPlugin.class);
    private IExecBiasAnalysManageController execBiasAnalysManageController;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refreshreport", "refreshimg", "openfilter"});
        String mapperInfoStr = this.getView().getPageCache().get("page_dim_mapping_cache");
        String sysId = this.getView().getPageCache().get("system_id_cache");
        if (EmptyUtil.isNoEmpty((String)mapperInfoStr)) {
            Map mapperInfo = (Map)FpmSerializeUtil.deserialize((String)mapperInfoStr, Map.class);
            Set entries = mapperInfo.entrySet();
            for (Map.Entry entry : entries) {
                BasedataEdit pageDim = (BasedataEdit)this.getControl((String)entry.getKey());
                pageDim.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    TemplateDim templateDim = (TemplateDim)entry.getValue();
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    QFilter filter = new QFilter("bodysystem", "=", (Object)Optional.ofNullable(sysId).map(Long::valueOf).orElseGet(() -> 0L));
                    filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
                    filter.and("id", "in", (Object)templateDim.getMemberScope());
                    showParameter.getListFilterParameter().setFilter(filter);
                    showParameter.setShowTitle(false);
                    showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"ReportExecBiasAnalysPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
                });
            }
        }
        this.filterControlInit();
        this.reportOrgRegisterListener();
        this.reportTypeRegisterListener();
        this.reportPeriodRegisterListener();
        this.sourceBillRegisterListener();
        this.metricRegisterListener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String currModelId = parentView.getPageCache().get("currModelId");
            if (EmptyUtil.isEmpty((String)currModelId)) {
                return;
            }
            this.getModel().setValue("bodysys", (Object)Long.parseLong(currModelId));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap2"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSpreadJSComponent();
        Long reportId = this.getModel().getDataEntity().getLong(String.join((CharSequence)".", "sourcebill", "id"));
        if (EmptyUtil.isEmpty((Long)reportId)) {
            return;
        }
        this.loadReport(reportId);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        this.btnRule();
        String status = (String)this.getModel().getValue("billstatus");
        SheetUtils.lockSheet(this.getSpreadCommandInvoker(), () -> !Objects.equals(status, BillStatus.STAGE.getNumber()));
    }

    private void initSpreadJSComponent() {
        DynamicObject templateDy;
        String templateType;
        DynamicObject report = null;
        String sourceBillTypeVal = this.getModel().getDataEntity().getString("sourcebilltype");
        Long reportId = this.getModel().getDataEntity().getLong(String.join((CharSequence)".", "sourcebill", "id"));
        if (EmptyUtil.isNoEmpty((String)sourceBillTypeVal) && EmptyUtil.isNoEmpty((Long)reportId)) {
            SourceBillType sourceBillType = SourceBillType.getStatusByVal((String)sourceBillTypeVal);
            if (sourceBillType == SourceBillType.SUMPLAN) {
                DynamicObject sumReport = TmcDataServiceHelper.loadSingle((String)"fpm_reportplansum", (String)"originalreportids", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
                String[] originalIds = sumReport.getString("originalreportids").split(",");
                reportId = Long.parseLong(originalIds[0]);
            }
            report = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"templatebak", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        }
        ArrayList<ContextMenuItemsEnum> extraMenuItems = new ArrayList<ContextMenuItemsEnum>(1);
        if (report != null && EmptyUtil.isNoEmpty((String)(templateType = (templateDy = report.getDynamicObject("templatebak")).getString("templatetype"))) && templateType.equals(TemplateTypeEnum.DETAIL.getValue())) {
            extraMenuItems.add(ContextMenuItemsEnum.DELETEROWS);
            extraMenuItems.add(ContextMenuItemsEnum.DELETECOMMENT);
            extraMenuItems.add(ContextMenuItemsEnum.EDITCOMMENT);
        }
        ISpreadCommand spreadCommand = new InitialToolbarAndRightKeyItemGenerator(extraMenuItems).generatorChain(this.getSpreadCommandInvoker());
        spreadCommand.execCommand();
    }

    protected IExecBiasAnalysManageController getOrCreateReportController() {
        if (null == this.execBiasAnalysManageController) {
            this.execBiasAnalysManageController = new ExecBiasAnalysManageController((IExecBiasAnalysManageView)this);
        }
        return this.execBiasAnalysManageController;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        SourceBillType sourceBillType = this.getSourceBillType();
        Long systemId = (Long)this.getModel().getDataEntity().getDynamicObject("bodysys").getPkValue();
        long reportId = this.getModel().getDataEntity().getLong(String.join((CharSequence)".", "sourcebill", "id"));
        switch (key) {
            case "reportorg": {
                this.getModel().setValue("reportperiod", null);
                break;
            }
            case "sourcebill": {
                this.sourceBillChange(newValue);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
                break;
            }
            case "pagedim1": 
            case "pagedim2": 
            case "pagedim3": 
            case "exec_bias_col": {
                this.getOrCreateReportController().save((Long)this.getModel().getDataEntity().getPkValue());
                if (sourceBillType == SourceBillType.REPORT) {
                    this.getOrCreateReportController().loadReport(reportId, this.getPageDimMemberIds(), this.getView().getPageId());
                    this.rowAndColVisible();
                } else {
                    this.getOrCreateReportController().loadSumReport(reportId, systemId);
                    this.sumReportRowAndColVisible();
                }
                this.hideRowByMeta();
                break;
            }
            case "innerstatus": {
                if (sourceBillType == SourceBillType.SUMPLAN) {
                    this.getOrCreateReportController().loadSumReport(reportId, systemId);
                    this.sumReportRowAndColVisible();
                }
                this.hideRowByMeta();
                break;
            }
        }
    }

    private SourceBillType getSourceBillType() {
        String sourceBillTypeVal = this.getModel().getDataEntity().getString("sourcebilltype");
        return SourceBillType.getStatusByVal((String)sourceBillTypeVal);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "refreshreport": 
            case "refreshimg": {
                this.setRowAndColVisible();
                break;
            }
            case "openfilter": {
                Label label = (Label)this.getView().getControl("openfilter");
                String openFilter = this.getView().getPageCache().get("open_filter");
                String open = ResManager.loadKDString((String)"\u5c55\u5f00\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                String close = ResManager.loadKDString((String)"\u6536\u8d77\u8fc7\u6ee4", (String)"ReportPlanSumPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
                if (EmptyUtil.isEmpty((String)openFilter) || open.equals(openFilter)) {
                    openFilter = close;
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
                } else {
                    openFilter = open;
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
                }
                label.setText(openFilter);
                this.getView().getPageCache().put("open_filter", openFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        String sourceBillTypeVal = this.getModel().getDataEntity().getString("sourcebilltype");
        SourceBillType sourceBillType = SourceBillType.getStatusByVal((String)sourceBillTypeVal);
        switch (opKey) {
            case "save": {
                args.getOperationResult().setShowMessage(false);
                this.getOrCreateReportController().save((Long)this.getModel().getDataEntity().getPkValue());
                this.setRowAndColVisible();
                break;
            }
            case "submit": {
                args.getOperationResult().setShowMessage(false);
                this.getOrCreateReportController().submit((Long)this.getModel().getDataEntity().getPkValue());
                this.setRowAndColVisible();
                break;
            }
            case "deleteexec": {
                args.getOperationResult().setShowMessage(false);
                this.getOrCreateReportController().delete((Long)this.getModel().getDataEntity().getPkValue());
                OperationResult result = TmcOperateServiceHelper.execOperate((String)"delete", (String)"fpm_execbiasanalys", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) break;
                this.getView().close();
                break;
            }
            case "exportexcel": {
                Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
                if (EmptyUtil.isEmpty((Long)pkId)) {
                    return;
                }
                Long systemId = this.getModel().getDataEntity().getLong(String.join((CharSequence)".", "bodysys", "id"));
                HashMap<Long, SumPlanHeader> reportHeaderMap = new HashMap<Long, SumPlanHeader>(1);
                if (sourceBillType == SourceBillType.SUMPLAN) {
                    SumPlanHeader sumPlanHeader = this.getReferIndex(true);
                    reportHeaderMap.put(pkId, sumPlanHeader);
                }
                ExecBiasPlanFormsExportImpl exportExcel = new ExecBiasPlanFormsExportImpl(Collections.singleton(pkId), systemId, this.getMetricHeader(), reportHeaderMap);
                Tuple exportResult = exportExcel.export();
                if (((Boolean)exportResult.item1).booleanValue()) {
                    this.getView().download((String)exportResult.item2);
                    break;
                }
                this.showErrMessage(Collections.singletonList(exportResult.item2));
                break;
            }
            case "showemptyrow": {
                this.controlEmptyRow(true, this.getSpreadCommandInvoker(), this.getCellDataSource().getAllEmptyValRows());
                break;
            }
            case "hideemptyrow": {
                this.controlEmptyRow(false, this.getSpreadCommandInvoker(), this.getCellDataSource().getAllEmptyValRows());
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
        String status = (String)this.getModel().getValue("billstatus");
        SheetUtils.lockSheet(this.getSpreadCommandInvoker(), () -> !Objects.equals(status, BillStatus.STAGE.getNumber()));
    }

    private void setRowAndColVisible() {
        String sourceBillTypeVal = this.getModel().getDataEntity().getString("sourcebilltype");
        SourceBillType sourceBillType = SourceBillType.getStatusByVal((String)sourceBillTypeVal);
        if (sourceBillType == SourceBillType.REPORT) {
            this.rowAndColVisible();
        } else {
            this.sumReportRowAndColVisible();
        }
        this.hideRowByMeta();
    }

    private void sourceBillChange(Object newValue) {
        if (EmptyUtil.isEmpty((Object)newValue)) {
            this.clearAttachInfo();
            return;
        }
        Long reportId = (Long)((DynamicObject)newValue).getPkValue();
        this.loadReport(reportId);
        this.updateAttachInfo(reportId);
    }

    private void clearAttachInfo() {
        this.getModel().setValue("name", null);
        this.getModel().setValue("exratetable", null);
        this.getModel().setValue("exchangeratedate", null);
        this.getModel().setValue("reportid", null);
        this.getModel().setValue("amountunit", null);
        this.getModel().setValue("declarestartdate", null);
        this.getModel().setValue("declaredeadline", null);
    }

    private void updateAttachInfo(Long reportId) {
        String sourceBillTypeVal = this.getModel().getDataEntity().getString("sourcebilltype");
        SourceBillType sourceBillType = SourceBillType.getStatusByVal((String)sourceBillTypeVal);
        if (sourceBillType == null) {
            return;
        }
        this.getModel().setValue("reportid", (Object)reportId);
        DynamicObject reportDO = TmcDataServiceHelper.loadSingle((Object)reportId, (String)sourceBillType.getValue());
        if (EmptyUtil.isNoEmpty((DynamicObject)reportDO)) {
            DynamicObject templateDO;
            this.getModel().setValue("name", (Object)reportDO.getString("name"));
            this.getModel().setValue("exratetable", reportDO.getDynamicObject("exratetable").getPkValue());
            this.getModel().setValue("exchangeratedate", (Object)reportDO.getDate("exchangeratedate"));
            if (sourceBillType == SourceBillType.REPORT) {
                templateDO = reportDO.getDynamicObject("templatebak");
            } else {
                String originalReportIdStr = reportDO.getString("originalreportids");
                String[] originalReportIds = originalReportIdStr.split(",");
                DynamicObject report = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"templatebak", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(originalReportIds[0]))});
                templateDO = report.getDynamicObject("templatebak");
            }
            this.getModel().setValue("amountunit", (Object)templateDO.getString("amountunit"));
            this.getModel().setValue("declarestartdate", (Object)reportDO.getDate("declarestartdate"));
            this.getModel().setValue("declaredeadline", (Object)reportDO.getDate("declaredeadline"));
        }
    }

    private void loadReport(Long reportId) {
        String sourceBillTypeVal = this.getModel().getDataEntity().getString("sourcebilltype");
        SourceBillType sourceBillType = SourceBillType.getStatusByVal((String)sourceBillTypeVal);
        Long systemId = (Long)this.getModel().getDataEntity().getDynamicObject("bodysys").getPkValue();
        if (SourceBillType.REPORT == sourceBillType) {
            this.getOrCreateReportController().loadReport(reportId.longValue(), systemId);
        } else {
            this.getOrCreateReportController().loadSumReport(reportId.longValue(), systemId);
            this.initColFilter(reportId);
        }
        this.setRowAndColVisible();
    }

    private void initColFilter(Long reportId) {
        String sign;
        DynamicObjectCollection loads;
        List sumPlanParamConfigList;
        DynamicObject sumPlan = QueryServiceHelper.queryOne((String)"fpm_reportplansum", (String)String.join((CharSequence)",", "offsetornot", "planstatus"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"innerstatus", (Object)"1");
        Long systemId = (Long)this.getModel().getDataEntity().getDynamicObject("bodysys").getPkValue();
        Long reportTypeId = (Long)this.getModel().getDataEntity().getDynamicObject("reporttype").getPkValue();
        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId);
        if (EmptyUtil.isNoEmpty((Long)reportTypeId)) {
            qFilter = qFilter.and(reportTypeProp, "=", (Object)reportTypeId);
        }
        if (EmptyUtil.isNoEmpty((Object)(sumPlanParamConfigList = ConverterUtils.convert(SumPlanParamConfig.class, (Collection)(loads = QueryServiceHelper.query((String)"fpm_summaryconfig", (String)"id", (QFilter[])new QFilter[]{qFilter = qFilter.and("enable", "=", (Object)"1")})), (boolean)true, (String)"fpm_summaryconfig")))) {
            boolean showlimit = false;
            SumPlanParamConfig sumPlanParamConfig = (SumPlanParamConfig)sumPlanParamConfigList.get(0);
            Long reportOrgId = (Long)this.getModel().getDataEntity().getDynamicObject("reportorg").getPkValue();
            List configInfoList = sumPlanParamConfig.getConfigInfoList();
            for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
                CheckSubLimitType checkSubLimitType;
                if (!reportOrgId.equals(sumPlanParamConfigInfo.getOrgMemberId()) || CheckSubLimitType.SUM_AND_CHECK_MAIN_LIMIT != (checkSubLimitType = sumPlanParamConfigInfo.getCheckSubLimitType())) continue;
                showlimit = true;
                break;
            }
            String planStatus = sumPlan.getString("planstatus");
            if (ReportPlanStatusEnum.EFFECTIVE.getValue().equals(planStatus)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"showlimit", (Object)"0");
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"showlimit", (Object)(showlimit ? "1" : "0"));
            }
        }
        if (EmptyUtil.isNoEmpty((String)(sign = this.getCache().get("org_field_name")))) {
            DynamicObject reportorg = (DynamicObject)this.getModel().getValue("reportorg");
            this.getView().getModel().setValue(sign, (Object)reportorg.getLong("id"));
        }
        this.getModel().setDataChanged(false);
    }

    private void filterControlInit() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_col_01", "filter_col_02", "filter_col_03", "filter_row_01", "filter_row_02", "queryreport"});
        String managerJson = this.getView().getPageCache().get("execbiasanalys_reportdata_manager_cache");
        if (EmptyUtil.isEmpty((String)managerJson)) {
            return;
        }
        ReportDataManagerV2 reportDataManager = (ReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        if (reportTemplate.getTemplateType() == TemplateType.DETAIL) {
            return;
        }
        Long systemId = reportTemplate.getSystemId();
        List filterDimList = reportTemplate.getAllTemplateDim().stream().sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        int colFilterIndex = 1;
        int rowFilterIndex = 1;
        for (TemplateDim templateDim : filterDimList) {
            if (!templateDim.isFilterDim()) continue;
            String controlKey = "";
            if (templateDim.getLocation() == DimLocation.COL) {
                controlKey = String.format("filter_col_0%s", colFilterIndex++);
            } else {
                if (templateDim.getLocation() != DimLocation.ROW) continue;
                controlKey = String.format("filter_row_0%s", rowFilterIndex++);
            }
            if (!templateDim.isFilterDim()) continue;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{controlKey});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"queryreport"});
            BasedataEdit filterDim = (BasedataEdit)this.getControl(controlKey);
            filterDim.setCaption(new LocaleString(templateDim.getDimensionName() + "\uff1a"));
            filterDim.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("bodysystem", "=", (Object)systemId);
                filter.and("dimtype", "=", (Object)templateDim.getDimType().getNumber());
                filter.and("dimension", "=", (Object)templateDim.getDimensionId());
                if (templateDim.getDimType() == DimensionType.PERIOD) {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "in", (Object)templateDim.getMemberScope())});
                    List idList = query.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(idList)) {
                        filter.and("id", "in", (Object)templateDim.getMemberScope());
                    } else {
                        filter.and("id", "in", idList);
                    }
                } else {
                    filter.and("id", "in", (Object)templateDim.getMemberScope());
                }
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setShowTitle(false);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"ReportExecBiasAnalysPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), templateDim.getDimensionName()));
            });
        }
    }

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void refreshBook(Book book) {
        if (null == book) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u5236\u8868\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u52a0\u8f7d\u9884\u89c8\u3002", (String)"ReportExecBiasAnalysPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(msg));
            return;
        }
        int maxRow = Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class)).map(o -> o).orElseGet(() -> 0);
        int maxCol = Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class)).map(o -> o).orElseGet(() -> 0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(this.getSpreadCommandInvoker(), book);
        spreadCommand.execCommand();
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", book.getSheet().getRows().stream().max(Integer::compareTo).get());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", book.getSheet().getCols().stream().max(Integer::compareTo).get());
    }

    private List<Long> getPageDimMemberIds() {
        Long pageDimId3;
        Long pageDimId2;
        ArrayList<Long> pageDimMemberIds = new ArrayList<Long>(2);
        Long pageDimId1 = Optional.ofNullable((DynamicObject)this.getView().getModel().getValue("pagedim1")).map(num -> Long.valueOf(num.getPkValue().toString())).orElseGet(() -> null);
        if (pageDimId1 != null) {
            pageDimMemberIds.add(pageDimId1);
        }
        if ((pageDimId2 = Optional.ofNullable((DynamicObject)this.getView().getModel().getValue("pagedim2")).map(num -> Long.valueOf(num.getPkValue().toString())).orElseGet(() -> null)) != null) {
            pageDimMemberIds.add(pageDimId2);
        }
        if ((pageDimId3 = Optional.ofNullable((DynamicObject)this.getView().getModel().getValue("pagedim3")).map(num -> Long.valueOf(num.getPkValue().toString())).orElseGet(() -> null)) != null) {
            pageDimMemberIds.add(pageDimId3);
        }
        return pageDimMemberIds;
    }

    public void updateCell(List<Cell> cells) {
        ISpreadCommand spreadCommand = new UpdateCellInfoGenerator(false, true, 0, 0, true).generatorChain(this.getSpreadCommandInvoker(), cells);
        spreadCommand.execCommand();
    }

    public void cellFormulaUpdate(List<FormulaCell> formulaCells) {
        new CellFormulaCmdChain(this.getSpreadCommandInvoker(), null, formulaCells).execCommand();
    }

    public void cellValueUpdate(List<CellValueEvent> events) {
        super.cellValueUpdate(events);
        int maxRow = (Integer)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class);
        int maxCol = (Integer)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class);
        CellDataSource cellDataSource = this.getCellDataSource();
        ArrayList<CellUpdateResult> cellUpdateResults = new ArrayList<CellUpdateResult>(events.size());
        for (CellValueEvent event : events) {
            CacheCell originCell = cellDataSource.getCell(event.getCell().getRow(), event.getCell().getCol());
            if (originCell == null) {
                maxRow = Math.max(event.getCell().getRow(), maxRow);
                maxCol = Math.max(event.getCell().getCol(), maxCol);
                continue;
            }
            CellTypeEnum cellType = originCell.getCellType();
            if (cellType == CellTypeEnum.F7WIDGET || CellTypeEnum.DOWNBOXWIDGET == cellType || CellTypeEnum.MUTITYPEWIDGET == cellType || originCell.isSummary()) continue;
            try {
                CellUpdateResult updateCellInfo = null;
                updateCellInfo = CellValueUpdateFactory.createCellValueUpdateInstance((CellValueEvent)event, (Cell)originCell).update();
                cellUpdateResults.add(updateCellInfo);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        List<String> failureMsgs = cellUpdateResults.stream().filter(Objects::nonNull).map(CellUpdateResult::getErrMsg).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        this.showErrMessage(failureMsgs);
        List updateCells = cellUpdateResults.stream().filter(Objects::nonNull).map(CellUpdateResult::getCell).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateCells)) {
            this.getOrCreateReportController().updateReportData(updateCells);
        }
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", (Object)maxRow);
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", (Object)maxCol);
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void refreshPageDim(List<ReportCalcVal> reportCalcVals, boolean isChange, ReportTemplate reportTemplate) {
        HashMap<String, TemplateDim> mapper = new HashMap<String, TemplateDim>(16);
        List pageDimList = reportTemplate.getPageDimList();
        int count = 1;
        for (int i = 0; i < pageDimList.size(); ++i) {
            TemplateDim templateDim = (TemplateDim)pageDimList.get(i);
            String pageDimSign = String.format("pagedim%s", count++);
            mapper.put(pageDimSign, templateDim);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"pagedim1", "pagedim2", "pagedim3"});
        block1: for (ReportCalcVal reportCalcVal : reportCalcVals) {
            Long id = Long.valueOf(reportCalcVal.getValue().toString());
            Set entrys = mapper.entrySet();
            for (Map.Entry entry : entrys) {
                String sign = (String)entry.getKey();
                List ids = ((TemplateDim)entry.getValue()).getMemberScope();
                if (!ids.contains(id)) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{sign});
                BasedataEdit control = (BasedataEdit)this.getControl(sign);
                control.setCaption(new LocaleString(((TemplateDim)entry.getValue()).getDimensionName()));
                if (ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"ReportExecBiasAnalysPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]).equals(reportCalcVal.getDimensionName())) {
                    this.getCache().put("org_field_name", sign);
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)sign, (Object)id);
                continue block1;
            }
        }
        this.getView().getPageCache().put("page_dim_mapping_cache", FpmSerializeUtil.serialize(mapper));
        this.getView().getPageCache().put("system_id_cache", reportTemplate.getSystemId().toString());
    }

    public void refreshMetric(ReportTemplate reportTemplate) {
        List metricIds = reportTemplate.getMetricTplDim().getMemberScope();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exec_bias_col", (Object)metricIds.toArray());
        this.getModel().setDataChanged(false);
    }

    public SumPlanHeader getReferIndex(boolean needApprovedAmt) {
        SumPlanHeader sumPlanHeader = new SumPlanHeader();
        String innerstatus = (String)this.getModel().getValue("innerstatus");
        if (EmptyUtil.isNoEmpty((String)innerstatus)) {
            sumPlanHeader.setDataStatus(Integer.parseInt(innerstatus));
        }
        if (needApprovedAmt) {
            sumPlanHeader.setShowApprovedAmt((Boolean)this.getModel().getValue("showlimit"));
        }
        DynamicObjectCollection execBiasIndS = (DynamicObjectCollection)this.getModel().getValue("exec_bias_col");
        List memberIds = execBiasIndS.stream().map(c -> c.getLong("fbasedataid.id")).collect(Collectors.toList());
        sumPlanHeader.setMetricMemberIds(memberIds);
        sumPlanHeader.setPageDimMemberIds(this.getPageDimMemberIds());
        return sumPlanHeader;
    }

    public MetricHeader getMetricHeader() {
        MetricHeader metricHeader = new MetricHeader();
        DynamicObjectCollection execBiasIndS = (DynamicObjectCollection)this.getModel().getValue("exec_bias_col");
        List memberIds = execBiasIndS.stream().map(c -> c.getLong("fbasedataid.id")).collect(Collectors.toList());
        metricHeader.setMetricMemberIds(memberIds);
        return metricHeader;
    }

    public void showVerifyResultDialog(Map<String, String> customShowParameter) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fpm_reportrulechecknotify");
        parameter.getCustomParams().putAll(customShowParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dataverify"));
        this.getView().showForm(parameter);
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportExecBiasAnalysPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    private void reportOrgRegisterListener() {
        BasedataEdit reportOrg;
        if (this.getModel().getProperty("reportorg") != null && (reportOrg = (BasedataEdit)this.getControl("reportorg")) != null) {
            reportOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject bodySys = this.getModel().getDataEntity().getDynamicObject("bodysys");
                if (EmptyUtil.isNoEmpty((DynamicObject)bodySys)) {
                    long orgId = Long.parseLong(bodySys.getPkValue().toString());
                    List qFilters = showParameter.getListFilterParameter().getQFilters();
                    qFilters.add(new QFilter("bodysystem", "=", (Object)orgId));
                    showParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"ReportExecBiasAnalysPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                } else {
                    this.switchPromiser("bodysys");
                    beforeF7SelectEvent.setCancel(true);
                }
            });
        }
    }

    private void switchPromiser(String propertyName) {
        switch (propertyName) {
            case "bodysys": {
                this.getView().showTipNotification(new FpmBizResource().getTipBodySysShort());
                return;
            }
            case "reporttype": {
                this.getView().showTipNotification(new FpmBizResource().getTipReportTypeShort());
                return;
            }
            case "reportorgreportperiod": {
                this.getView().showTipNotification(new FpmBizResource().getTipReportOrgPeriodShort());
                return;
            }
        }
    }

    private void reportTypeRegisterListener() {
        BasedataEdit reportType;
        if (this.getModel().getProperty("reporttype") != null && (reportType = (BasedataEdit)this.getControl("reporttype")) != null) {
            reportType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject bodySys = this.getModel().getDataEntity().getDynamicObject("bodysys");
                if (EmptyUtil.isNoEmpty((DynamicObject)bodySys)) {
                    DynamicObjectCollection reportTypeEntry = bodySys.getDynamicObjectCollection("applyrereportentry");
                    List pkIds = reportTypeEntry.stream().filter(c -> "enable".equals(c.getString("rereporttypestatus"))).map(x -> x.getLong("rerporttype.id")).collect(Collectors.toList());
                    List qFilters = showParameter.getListFilterParameter().getQFilters();
                    qFilters.add(new QFilter("id", "in", pkIds));
                } else {
                    this.switchPromiser("bodysys");
                    beforeF7SelectEvent.setCancel(true);
                }
            });
        }
    }

    private void reportPeriodRegisterListener() {
        BasedataEdit reportPeriod;
        if (this.getModel().getProperty("reportperiod") != null && (reportPeriod = (BasedataEdit)this.getControl("reportperiod")) != null) {
            reportPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject reportType = this.getModel().getDataEntity().getDynamicObject("reporttype");
                if (EmptyUtil.isNoEmpty((DynamicObject)reportType)) {
                    DynamicObject bodySys = this.getModel().getDataEntity().getDynamicObject("bodysys");
                    Long bodySysId = bodySys.getLong("id");
                    List qFilters = showParameter.getListFilterParameter().getQFilters();
                    qFilters.add(new QFilter("bodysystem", "=", (Object)bodySysId));
                    long reportTypeId = Long.parseLong(reportType.getPkValue().toString());
                    qFilters.add(new QFilter("reporttype", "=", (Object)reportTypeId));
                    qFilters.add(new QFilter("periodtype", "=", (Object)reportType.getString("orgreportcycle")));
                    showParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u62a5\u671f\u95f4", (String)"ReportExecBiasAnalysPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                } else {
                    this.switchPromiser("reporttype");
                    beforeF7SelectEvent.setCancel(true);
                }
            });
        }
    }

    private void sourceBillRegisterListener() {
        BasedataEdit sourceBill;
        if (this.getModel().getProperty("sourcebill") != null && (sourceBill = (BasedataEdit)this.getControl("sourcebill")) != null) {
            sourceBill.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.setShowApproved(false);
                showParameter.setShowUsed(false);
                DynamicObject bodySys = this.getModel().getDataEntity().getDynamicObject("bodysys");
                DynamicObject reportOrg = this.getModel().getDataEntity().getDynamicObject("reportorg");
                DynamicObject reportPeriod = this.getModel().getDataEntity().getDynamicObject("reportperiod");
                String sourceBillType = this.getModel().getDataEntity().getString("sourcebilltype");
                if (EmptyUtil.isEmpty((DynamicObject)bodySys) || EmptyUtil.isEmpty((DynamicObject)reportOrg) || EmptyUtil.isEmpty((DynamicObject)reportPeriod)) {
                    this.switchPromiser("reportorgreportperiod");
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("bodysys", "=", (Object)Long.parseLong(bodySys.getPkValue().toString())));
                qFilters.add(new QFilter("reportorg", "=", (Object)Long.parseLong(reportOrg.getPkValue().toString())));
                qFilters.add(new QFilter("reportperiod", "=", (Object)Long.parseLong(reportPeriod.getPkValue().toString())));
                qFilters.add(new QFilter("planstatus", "=", (Object)ReportStatus.ENABLE.getVal()));
                qFilters.add(new QFilter("isexecbiasanalys", "=", (Object)"0"));
                if (SourceBillType.REPORT.getValue().equals(sourceBillType)) {
                    QFilter templateQFilter = new QFilter("model", "=", (Object)Long.parseLong(bodySys.getPkValue().toString()));
                    templateQFilter.and("ismaintable", "=", (Object)"1");
                    templateQFilter.and("templateuses", "=", (Object)TemplateUsesEnum.PLANING.getValue());
                    List templateIds = QueryServiceHelper.queryPrimaryKeys((String)"fpm_template_bak", (QFilter[])new QFilter[]{templateQFilter}, null, (int)-1);
                    qFilters.add(new QFilter("templatebak", "in", (Object)templateIds));
                }
            });
        }
    }

    private void metricRegisterListener() {
        BasedataEdit execBias;
        String sysId = this.getView().getPageCache().get("system_id_cache");
        if (this.getModel().getProperty("exec_bias_col") != null && (execBias = (BasedataEdit)this.getControl("exec_bias_col")) != null) {
            execBias.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("bodysystem", "=", (Object)Optional.ofNullable(sysId).map(Long::valueOf).orElseGet(() -> 0L));
                filter.and("dimtype", "=", (Object)DimensionType.METRIC.getNumber());
                filter.and("metrictype", "in", Arrays.asList("BASE", "ANALYSE"));
                filter.and("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setShowTitle(false);
                showParameter.setCaption(ResManager.loadKDString((String)"\u5ea6\u91cf\u6307\u6807", (String)"ReportExecBiasAnalysPlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            });
        }
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    private void rowAndColVisible() {
        String managerJson = this.getView().getPageCache().get("execbiasanalys_reportdata_manager_cache");
        ReportDataManagerV2 reportDataManager = (ReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        List currRowDimValList = meta.getRowDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        List colDimList = reportTemplate.getColDimList().stream().filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        List rowDimList = reportTemplate.getRowDimList().stream().filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        DynamicObjectCollection firstColIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_col_01");
        DynamicObjectCollection secondColIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_col_02");
        DynamicObjectCollection secondColIdListTree = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_col_03");
        DynamicObjectCollection firstRowIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_row_01");
        DynamicObjectCollection secondRowIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_row_02");
        ArrayList needHideColList = new ArrayList(16);
        ArrayList needHideRowList = new ArrayList(16);
        if (!(CollectionUtils.isEmpty((Collection)firstColIdList) && CollectionUtils.isEmpty((Collection)secondColIdList) && CollectionUtils.isEmpty((Collection)secondColIdListTree))) {
            int firstColDimMaxRow = currColDimValList.stream().filter(item -> Objects.equals(((TemplateDim)colDimList.get(1)).getDimensionId(), item.getDimensionId())).mapToInt(ReportCalcVal::getRow).max().orElse(0);
            int secondColDimMaxRow = colDimList.size() > 2 ? currColDimValList.stream().filter(item -> Objects.equals(((TemplateDim)colDimList.get(2)).getDimensionId(), item.getDimensionId())).mapToInt(ReportCalcVal::getRow).max().orElse(0) : 0;
            int thirdColDimMaxRow = colDimList.size() > 3 ? currColDimValList.stream().filter(item -> Objects.equals(((TemplateDim)colDimList.get(3)).getDimensionId(), item.getDimensionId())).mapToInt(ReportCalcVal::getRow).max().orElse(0) : 0;
            Set firstColDimMemberIdSet = firstColIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set secondColDimMemberIdSet = secondColIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set thirdColDimMemberIdSet = secondColIdListTree.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            List needHideList = currColDimValList.stream().filter(item -> item.getValue() != null && (!CollectionUtils.isEmpty((Collection)firstColDimMemberIdSet) && !firstColDimMemberIdSet.contains(item.getValue()) && firstColDimMaxRow == item.getRow() && ((TemplateDim)colDimList.get(1)).getDimensionId().equals(item.getDimensionId()) || !CollectionUtils.isEmpty((Collection)secondColDimMemberIdSet) && !secondColDimMemberIdSet.contains(item.getValue()) && secondColDimMaxRow == item.getRow() && ((TemplateDim)colDimList.get(2)).getDimensionId().equals(item.getDimensionId()) || !CollectionUtils.isEmpty((Collection)thirdColDimMemberIdSet) && !thirdColDimMemberIdSet.contains(item.getValue()) && thirdColDimMaxRow == item.getRow() && ((TemplateDim)colDimList.get(3)).getDimensionId().equals(item.getDimensionId()))).collect(Collectors.toList());
            HashSet<Integer> needHideColSet = new HashSet<Integer>(16);
            for (ReportCalcVal reportCalcVal : needHideList) {
                needHideColSet.add(reportCalcVal.getCol());
                for (int i = 1; i < reportCalcVal.getColSpan(); ++i) {
                    needHideColSet.add(reportCalcVal.getCol() + i);
                }
            }
            needHideColList = new ArrayList(needHideColSet);
        }
        if (!CollectionUtils.isEmpty((Collection)firstRowIdList) || !CollectionUtils.isEmpty((Collection)secondRowIdList)) {
            Set firstRowDimMemberIdSet = firstRowIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set secondRowDimMemberIdSet = secondRowIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            List needHideList = currRowDimValList.stream().filter(item -> item.getValue() != null && (!CollectionUtils.isEmpty((Collection)firstRowDimMemberIdSet) && !firstRowDimMemberIdSet.contains(item.getValue()) && ((TemplateDim)rowDimList.get(0)).getDimensionId().equals(item.getDimensionId()) || !CollectionUtils.isEmpty((Collection)secondRowDimMemberIdSet) && !secondRowDimMemberIdSet.contains(item.getValue()) && ((TemplateDim)rowDimList.get(1)).getDimensionId().equals(item.getDimensionId()))).collect(Collectors.toList());
            HashSet<Integer> needHidRowSet = new HashSet<Integer>(16);
            for (ReportCalcVal reportCalcVal : needHideList) {
                needHidRowSet.add(reportCalcVal.getRow());
                for (int i = 1; i < reportCalcVal.getRowSpan(); ++i) {
                    needHidRowSet.add(reportCalcVal.getRow() + i);
                }
            }
            needHideRowList = new ArrayList(needHidRowSet);
        }
        String hideColsStr = this.getPageCache().get("HIDECOLS");
        String hideRowsStr = this.getPageCache().get("HIDEROWS");
        if (!StringUtils.isEmpty((Object)hideColsStr) || !StringUtils.isEmpty((Object)hideRowsStr)) {
            List colS = new ArrayList(16);
            if (!StringUtils.isEmpty((Object)hideColsStr)) {
                colS = JSONArray.parseArray((String)hideColsStr, Integer.class);
            }
            List rowS = new ArrayList(16);
            if (!StringUtils.isEmpty((Object)hideRowsStr)) {
                rowS = JSONArray.parseArray((String)hideRowsStr, Integer.class);
            }
            RowAndColVisibleCmdChain showSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), rowS, colS, Boolean.valueOf(true));
            showSpreadCommand.execCommand();
        }
        if (!CollectionUtils.isEmpty(needHideRowList) || !CollectionUtils.isEmpty(needHideColList)) {
            RowAndColVisibleCmdChain hideSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), needHideRowList, needHideColList, Boolean.valueOf(false));
            hideSpreadCommand.execCommand();
            this.getPageCache().put("HIDECOLS", JSON.toJSONString(needHideColList));
            this.getPageCache().put("HIDEROWS", JSON.toJSONString(needHideRowList));
        }
    }

    private void sumReportRowAndColVisible() {
        String managerJson = this.getView().getPageCache().get("execbiasanalys_reportdata_manager_cache");
        ReportDataManagerV2 reportDataManager = (ReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        List currColDimValList = meta.getColDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        List currRowDimValList = meta.getRowDimTree().getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
        List colDimList = reportTemplate.getColDimList().stream().filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        List rowDimList = reportTemplate.getRowDimList().stream().filter(item -> !item.isViDim()).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        DynamicObjectCollection firstColIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_col_01");
        DynamicObjectCollection secondColIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_col_02");
        DynamicObjectCollection secondColIdListTree = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_col_03");
        DynamicObjectCollection firstRowIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_row_01");
        DynamicObjectCollection secondRowIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("filter_row_02");
        ArrayList needHideColList = new ArrayList(16);
        ArrayList needHideRowList = new ArrayList(16);
        List planMetricIds = reportTemplate.getMetrics().stream().filter(c -> c.getMetricType() == TemplateMetricType.PLANAMT).map(x -> x.getMetricId()).collect(Collectors.toList());
        List originalMetricIds = reportTemplate.getMetrics().stream().filter(c -> c.getMetricType() == TemplateMetricType.ORIGINALPLANAMT || c.getMetricType() == TemplateMetricType.REPORTPLANAMT).map(x -> x.getMetricId()).collect(Collectors.toList());
        Boolean showLimit = (Boolean)this.getModel().getValue("showlimit");
        List approvedColList = currColDimValList.stream().filter(item -> showLimit == false && originalMetricIds.contains(item.getValue())).map(ReportCalcVal::getCol).collect(Collectors.toList());
        List planAmtColList = currColDimValList.stream().filter(item -> showLimit != false && planMetricIds.contains(item.getValue())).map(ReportCalcVal::getCol).collect(Collectors.toList());
        Optional<Integer> metricMaxRowOptional = currColDimValList.stream().filter(ReportCalcVal::isMetric).map(ReportCalcVal::getRow).max(Integer::compareTo);
        Integer metricMaxRow = 0;
        if (metricMaxRowOptional.isPresent()) {
            metricMaxRow = metricMaxRowOptional.get();
        }
        if (!(CollectionUtils.isEmpty((Collection)firstColIdList) && CollectionUtils.isEmpty((Collection)secondColIdList) && CollectionUtils.isEmpty(approvedColList) && CollectionUtils.isEmpty(planAmtColList) && CollectionUtils.isEmpty((Collection)secondColIdListTree))) {
            int firstColDimMaxRow = currColDimValList.stream().filter(item -> Objects.equals(((TemplateDim)colDimList.get(1)).getDimensionId(), item.getDimensionId())).mapToInt(ReportCalcVal::getRow).max().orElse(0);
            int secondColDimMaxRow = colDimList.size() > 2 ? currColDimValList.stream().filter(item -> Objects.equals(((TemplateDim)colDimList.get(2)).getDimensionId(), item.getDimensionId())).mapToInt(ReportCalcVal::getRow).max().orElse(0) : 0;
            int thirdColDimMaxRow = colDimList.size() > 3 ? currColDimValList.stream().filter(item -> Objects.equals(((TemplateDim)colDimList.get(3)).getDimensionId(), item.getDimensionId())).mapToInt(ReportCalcVal::getRow).max().orElse(0) : 0;
            Set firstColDimMemberIdSet = firstColIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set secondColDimMemberIdSet = secondColIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set thirdColDimMemberIdSet = secondColIdListTree.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Integer finalMetricMaxRow = metricMaxRow;
            List needHideList = currColDimValList.stream().filter(item -> item.getValue() != null && (!CollectionUtils.isEmpty((Collection)firstColDimMemberIdSet) && !firstColDimMemberIdSet.contains(item.getValue()) && firstColDimMaxRow == item.getRow() && ((TemplateDim)colDimList.get(1)).getDimensionId().equals(item.getDimensionId()) || !CollectionUtils.isEmpty((Collection)secondColDimMemberIdSet) && !secondColDimMemberIdSet.contains(item.getValue()) && secondColDimMaxRow == item.getRow() && ((TemplateDim)colDimList.get(2)).getDimensionId().equals(item.getDimensionId()) || !CollectionUtils.isEmpty((Collection)thirdColDimMemberIdSet) && !thirdColDimMemberIdSet.contains(item.getValue()) && thirdColDimMaxRow == item.getRow() && ((TemplateDim)colDimList.get(2)).getDimensionId().equals(item.getDimensionId()) || approvedColList != null && approvedColList.contains(item.getCol()) && item.getRow() == finalMetricMaxRow.intValue()) || planAmtColList != null && planAmtColList.contains(item.getCol()) && item.getRow() == finalMetricMaxRow.intValue()).collect(Collectors.toList());
            HashSet<Integer> needHideColSet = new HashSet<Integer>(needHideList.size());
            for (ReportCalcVal reportCalcVal : needHideList) {
                needHideColSet.add(reportCalcVal.getCol());
                for (int i = 1; i < reportCalcVal.getColSpan(); ++i) {
                    needHideColSet.add(reportCalcVal.getCol() + i);
                }
            }
            needHideColList = new ArrayList(needHideColSet);
        }
        if (!CollectionUtils.isEmpty((Collection)firstRowIdList) || !CollectionUtils.isEmpty((Collection)secondRowIdList)) {
            Set firstRowDimMemberIdSet = firstRowIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set secondRowDimMemberIdSet = secondRowIdList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            List needHideList = currRowDimValList.stream().filter(item -> item.getValue() != null && (!CollectionUtils.isEmpty((Collection)firstRowDimMemberIdSet) && !firstRowDimMemberIdSet.contains(item.getValue()) && ((TemplateDim)rowDimList.get(0)).getDimensionId().equals(item.getDimensionId()) || !CollectionUtils.isEmpty((Collection)secondRowDimMemberIdSet) && !secondRowDimMemberIdSet.contains(item.getValue()) && ((TemplateDim)rowDimList.get(1)).getDimensionId().equals(item.getDimensionId()))).collect(Collectors.toList());
            HashSet<Integer> needHidRowSet = new HashSet<Integer>(needHideList.size());
            for (ReportCalcVal reportCalcVal : needHideList) {
                needHidRowSet.add(reportCalcVal.getRow());
                for (int i = 1; i < reportCalcVal.getRowSpan(); ++i) {
                    needHidRowSet.add(reportCalcVal.getRow() + i);
                }
            }
            needHideRowList = new ArrayList(needHidRowSet);
        }
        String hideColsStr = this.getPageCache().get("HIDECOLS");
        String hideRowsStr = this.getPageCache().get("HIDEROWS");
        if (!StringUtils.isEmpty((Object)hideColsStr) || !StringUtils.isEmpty((Object)hideRowsStr)) {
            List colS = new ArrayList(16);
            if (!StringUtils.isEmpty((Object)hideColsStr)) {
                colS = JSONArray.parseArray((String)hideColsStr, Integer.class);
            }
            List rowS = new ArrayList(16);
            if (!StringUtils.isEmpty((Object)hideRowsStr)) {
                rowS = JSONArray.parseArray((String)hideRowsStr, Integer.class);
            }
            RowAndColVisibleCmdChain showSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), rowS, colS, Boolean.TRUE);
            showSpreadCommand.execCommand();
        }
        if (!CollectionUtils.isEmpty(needHideRowList) || !CollectionUtils.isEmpty(needHideColList)) {
            RowAndColVisibleCmdChain hideSpreadCommand = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), needHideRowList, needHideColList, Boolean.FALSE);
            hideSpreadCommand.execCommand();
            this.getPageCache().put("HIDECOLS", JSON.toJSONString(needHideColList));
            this.getPageCache().put("HIDEROWS", JSON.toJSONString(needHideRowList));
        }
    }

    private void btnRule() {
        SpreadCommandInvoker spreadCommandInvoker = this.getSpreadCommandInvoker();
        Long billId = Long.valueOf(this.getModel().getValue("id").toString());
        DynamicObject reportDy = TmcDataServiceHelper.loadSingle((String)"fpm_execbiasanalys", (String)String.join((CharSequence)",", "billstatus"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        String billStatus = reportDy.getString("billstatus");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"submit"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"audit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"audit", "unaudit", "unsubmit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"submit", "save", "exportexcel"});
        } else if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            new LockSheetCmdChain(spreadCommandInvoker, Collections.singletonList("Sheet1"), true).execCommand();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"submit", "unaudit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"audit", "unsubmit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"audit", "submit", "unsubmit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"submit", "save"});
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            new LockSheetCmdChain(spreadCommandInvoker, Collections.singletonList("Sheet1"), true).execCommand();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"audit", "submit", "unsubmit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"unaudit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"audit", "unaudit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"submit", "save"});
        }
    }

    private void hideRowByMeta() {
        CacheCellMeta meta = this.getCellDataSource().getMeta();
        if (meta == null || CollectionUtils.isEmpty((Collection)meta.getHideRowSet())) {
            return;
        }
        RowAndColVisibleCmdChain rowAndColVisibleCmdChain = new RowAndColVisibleCmdChain(this.getSpreadCommandInvoker(), new ArrayList(meta.getHideRowSet()), null, Boolean.valueOf(false));
        rowAndColVisibleCmdChain.execCommand();
    }
}

