/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.InoutCollectApprovalStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectDataSourceEnum;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InoutCollectSearchHelper {
    public static void upSearch(DynamicObject dataEntity, IFormView view) {
        String dataSource = dataEntity.getString("datasource");
        if (!StringUtils.equals((CharSequence)dataSource, (CharSequence)InoutCollectDataSourceEnum.INTELLIGENT_COLLECT.getCode())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u975e\u667a\u80fd\u91c7\u96c6\uff0c\u65e0\u4e0a\u6e38\u5355\u636e\u3002", (String)"InoutCollectSearchHelper_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long sourceBillId = dataEntity.getLong("sourcebillid");
        String sourceBill = (String)dataEntity.getDynamicObject("sourcebill").getPkValue();
        if (EmptyUtil.isEmpty((Long)sourceBillId) || EmptyUtil.isEmpty((String)sourceBill)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u4e0a\u6e38\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"InoutCollectSearchHelper_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("fpm_linksubreport");
        showParameter.setCustomParam("param_from_link_search_child", (Object)Boolean.TRUE);
        showParameter.setCustomParam("FORM_ENTITY_NAME", (Object)sourceBill);
        showParameter.setCustomParam("SEARCH_ENTITY_NAME", (Object)sourceBill);
        showParameter.setCustomParam("ENTITY_IDS", Collections.singletonList(sourceBillId));
        showParameter.setCustomParam("LINK_SEARCH_SUB_PARAM", (Object)LinkSearchSubTypeEnum.LINK_SEARCH_INOUT_UP_SEARCH.getType().getName());
        String caption = ResManager.loadKDString((String)"(%s)\u4e0a\u67e5", (String)"InoutCollectSearchHelper_2", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dataEntity.getString("billno")});
        showParameter.setCaption(caption);
        view.showForm(showParameter);
    }

    public static void upSearch(Object pkValue, IFormView view) {
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"fpm_inoutcollect");
        InoutCollectSearchHelper.upSearch(dynamicObject, view);
    }

    public static void upSearch(IListView view) {
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows) || selectedRows.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InoutCollectSearchHelper_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        InoutCollectSearchHelper.upSearch(listSelectedRow.getPrimaryKeyValue(), (IFormView)view);
    }

    public static void downSearch(DynamicObject dataEntity, IFormView view) {
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u7684\u8ba1\u5212\u7f16\u5236\u6570\u636e\u3002", (String)"InoutCollectSearchHelper_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List pkList = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getLong("entry_relateplanreportid")).distinct().collect(Collectors.toList());
        showParameter.setFormId("fpm_linksubreport");
        showParameter.setCustomParam("param_from_link_search_child", (Object)Boolean.TRUE);
        showParameter.setCustomParam("FORM_ENTITY_NAME", (Object)"fpm_reportplan");
        showParameter.setCustomParam("SEARCH_ENTITY_NAME", (Object)"fpm_report");
        showParameter.setCustomParam("LIST_ENTITY_NAME", (Object)"fpm_report");
        showParameter.setCustomParam("ENTITY_IDS", pkList);
        showParameter.setCustomParam("LIST_FORM_ID", (Object)"bos_treelist");
        showParameter.setCustomParam("LINK_SEARCH_SUB_PARAM", (Object)LinkSearchSubTypeEnum.LINK_SEARCH_REPORT_PLAN.getType().getName());
        String caption = ResManager.loadKDString((String)"(%s)\u4e0b\u67e5\u8ba1\u5212\u7f16\u5236", (String)"InoutCollectSearchHelper_5", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dataEntity.getString("billno")});
        showParameter.setCaption(caption);
        view.showForm(showParameter);
    }

    public static void downSearch(Object pkValue, IFormView view) {
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"fpm_inoutcollect");
        InoutCollectSearchHelper.downSearch(dynamicObject, view);
    }

    public static void downSearch(IListView view) {
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows) || selectedRows.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InoutCollectSearchHelper_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        InoutCollectSearchHelper.downSearch(listSelectedRow.getPrimaryKeyValue(), (IFormView)view);
    }

    public static void approvalRecord(IFormView view, DynamicObject inoutBill) {
        String approvalStatus = inoutBill.getString("approvalstatus");
        if (StringUtils.equals((CharSequence)approvalStatus, (CharSequence)InoutCollectApprovalStatusEnum.NOT_APPROVAL.getCode())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u62a5\u6279", (String)"InoutCollectSearchHelper_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List<Long> pkList = Collections.singletonList(inoutBill.getLong("approvalbillid"));
        showParameter.setFormId("fpm_linksubreport");
        showParameter.setCustomParam("param_from_link_search_child", (Object)Boolean.TRUE);
        showParameter.setCustomParam("FORM_ENTITY_NAME", (Object)"fpm_approvaldispose");
        showParameter.setCustomParam("SEARCH_ENTITY_NAME", (Object)"fpm_approvaldispose");
        showParameter.setCustomParam("ENTITY_IDS", pkList);
        showParameter.setCustomParam("LINK_SEARCH_SUB_PARAM", (Object)LinkSearchSubTypeEnum.LINK_SEARCH_APPROVAL.getType().getName());
        String caption = ResManager.loadKDString((String)"(%s)\u4e0b\u67e5\u62a5\u6279\u5355", (String)"InoutCollectSearchHelper_8", (String)"tmc-fpm-formplugin", (Object[])new Object[]{inoutBill.getString("billno")});
        showParameter.setCaption(caption);
        view.showForm(showParameter);
    }

    public static void approvalRecord(IListView view) {
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (selectedRows.size() != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InoutCollectSearchHelper_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectFields = String.join((CharSequence)",", "id", "billno", "approvalstatus", "approvalbillid");
        DynamicObject inoutBill = TmcDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"fpm_inoutcollect", (String)selectFields);
        InoutCollectSearchHelper.approvalRecord((IFormView)view, inoutBill);
    }

    public static void viewGeneratedRecord(IFormView view, DynamicObject dynamicObject) {
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_inoutcollect", (String)"id", (QFilter[])new QFilter[]{new QFilter("crontemplateid", "=", dynamicObject.getPkValue())});
        if (load == null || load.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u6570\u636e", (String)"InoutCollectSearchHelper_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        String caption = ResManager.loadKDString((String)"\u6a21\u677f(%s)\u8054\u67e5\u5df2\u751f\u6210\u8bb0\u5f55", (String)"InoutCollectSearchHelper_10", (String)"tmc-fpm-formplugin", (Object[])new Object[]{dynamicObject.getString("billno")});
        view.showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_inoutcollect").searchFormNumber("fpm_inoutcollect").searchIds(Arrays.stream(load).map(DataEntityBase::getPkValue).collect(Collectors.toList())).listForm("fpm_inoutcollect").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_INOUT_RECORD).caption(caption).build()));
    }
}

