/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.task.ReportImportDataClickTask;
import kd.tmc.fpm.business.task.result.TaskResult;

public class JobFormInfoHelper {
    public static final String TRACE_ID_KEY = "traceId";

    public static void dispatch(JobFormInfoParam jobFormInfoParam) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(jobFormInfoParam.getFormView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(jobFormInfoParam.getJobType());
        jobInfo.setTaskClassname(jobFormInfoParam.getTaskClassName());
        jobInfo.setName(jobFormInfoParam.getName());
        jobInfo.setCanStop(Boolean.valueOf(jobFormInfoParam.isCanStop()));
        jobInfo.setRunByUserId(jobFormInfoParam.getRunByUserId().longValue());
        jobInfo.setRunByOrgId(jobFormInfoParam.getRunByOrgId().longValue());
        jobInfo.setRunByLang(jobFormInfoParam.getRunByLang());
        jobInfo.setCaption(jobFormInfoParam.getCaption());
        jobInfo.setParams(jobFormInfoParam.getParams());
        JobFormInfo jobFormInfo = new JobFormInfo();
        jobFormInfo.setJobInfo(jobInfo);
        if (Objects.nonNull(jobFormInfoParam.getJobInfoConsumer())) {
            jobFormInfoParam.getJobInfoConsumer().accept(jobInfo);
        }
        jobFormInfo.setCanBackground(jobFormInfoParam.isCanBackGround());
        jobFormInfo.setCanStop(jobFormInfoParam.isCanStop());
        jobFormInfo.setClickClassName(jobFormInfoParam.getClickClassName());
        jobFormInfo.setCloseCallBack(jobFormInfoParam.getCloseCallBack());
        Consumer<JobFormInfo> jobFormInfoConsumer = jobFormInfoParam.getJobFormInfoConsumer();
        if (Objects.nonNull(jobFormInfoConsumer)) {
            jobFormInfoConsumer.accept(jobFormInfo);
        }
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)jobFormInfoParam.getFormView());
    }

    public static TaskResult parseTaskResult(Object returnData) {
        if (!(returnData instanceof Map)) {
            return null;
        }
        Map result = (Map)returnData;
        Object taskInfoObj = result.get("taskinfo");
        if (EmptyUtil.isEmpty(taskInfoObj)) {
            return null;
        }
        String taskInfoStr = (String)taskInfoObj;
        if (EmptyUtil.isEmpty((String)taskInfoStr)) {
            return null;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return null;
        }
        String data = taskInfo.getData();
        Map mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        TaskResult taskResult = new TaskResult();
        for (Map.Entry entry : mapData.entrySet()) {
            if (Objects.equals(entry.getKey(), "success")) {
                taskResult.setSuccess(((Boolean)entry.getValue()).booleanValue());
                continue;
            }
            if (Objects.equals("errorMessage", entry.getKey())) {
                taskResult.addErrorMessage((String)entry.getValue());
                continue;
            }
            taskResult.addResultInfo((String)entry.getKey(), entry.getValue());
        }
        return taskResult;
    }

    public static JobFormInfoParam getJobFormInfoParam() {
        return new JobFormInfoParam();
    }

    public static class JobFormInfoParam {
        private String appId;
        private JobType jobType = JobType.REALTIME;
        private String taskClassName;
        private String name;
        private Long runByUserId = Long.parseLong(RequestContext.get().getUserId());
        private Long runByOrgId = RequestContext.get().getOrgId();
        private Lang runByLang = Lang.get();
        private String caption;
        private String id = UUID.randomUUID().toString();
        private final Map<String, Object> params = new HashMap<String, Object>(16);
        private boolean canBackGround = true;
        private boolean canStop = false;
        private String clickClassName = ReportImportDataClickTask.class.getName();
        private CloseCallBack closeCallBack;
        private IFormView formView;
        private Consumer<JobInfo> jobInfoConsumer;
        private Consumer<JobFormInfo> jobFormInfoConsumer;

        public JobFormInfoParam() {
            this.addParam(JobFormInfoHelper.TRACE_ID_KEY, RequestContext.get().getTraceId());
        }

        public JobFormInfoParam setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public JobFormInfoParam setJobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public JobFormInfoParam setTaskClassName(String taskClassName) {
            this.taskClassName = taskClassName;
            return this;
        }

        public JobFormInfoParam setName(String name) {
            this.name = name;
            return this;
        }

        public JobFormInfoParam setRunByUserId(Long runByUserId) {
            this.runByUserId = runByUserId;
            return this;
        }

        public JobFormInfoParam setRunByOrgId(Long runByOrgId) {
            this.runByOrgId = runByOrgId;
            return this;
        }

        public JobFormInfoParam setRunByLang(Lang runByLang) {
            this.runByLang = runByLang;
            return this;
        }

        public JobFormInfoParam setCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public JobFormInfoParam setId(String id) {
            this.id = id;
            return this;
        }

        public final JobFormInfoParam addParam(String key, Object value) {
            this.params.put(key, value);
            return this;
        }

        public JobFormInfoParam setCanBackGround(boolean canBackGround) {
            this.canBackGround = canBackGround;
            return this;
        }

        public JobFormInfoParam setCanStop(boolean canStop) {
            this.canStop = canStop;
            return this;
        }

        public JobFormInfoParam setClickClassName(String clickClassName) {
            this.clickClassName = clickClassName;
            return this;
        }

        public JobFormInfoParam setCloseCallBack(CloseCallBack closeCallBack) {
            this.closeCallBack = closeCallBack;
            return this;
        }

        public JobFormInfoParam setFormView(IFormView formView) {
            this.formView = formView;
            if (EmptyUtil.isEmpty((String)this.appId)) {
                this.appId = formView.getFormShowParameter().getServiceAppId();
            }
            this.params.putIfAbsent("pageId", formView.getPageId());
            return this;
        }

        public JobFormInfoParam setJobInfoConsumer(Consumer<JobInfo> jobInfoConsumer) {
            this.jobInfoConsumer = jobInfoConsumer;
            return this;
        }

        public JobFormInfoParam setJobFormInfoConsumer(Consumer<JobFormInfo> jobFormInfoConsumer) {
            this.jobFormInfoConsumer = jobFormInfoConsumer;
            return this;
        }

        public String getAppId() {
            return this.appId;
        }

        public JobType getJobType() {
            return this.jobType;
        }

        public String getTaskClassName() {
            return this.taskClassName;
        }

        public String getName() {
            return this.name;
        }

        public Long getRunByUserId() {
            return this.runByUserId;
        }

        public Long getRunByOrgId() {
            return this.runByOrgId;
        }

        public Lang getRunByLang() {
            return this.runByLang;
        }

        public String getCaption() {
            return this.caption;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public boolean isCanBackGround() {
            return this.canBackGround;
        }

        public boolean isCanStop() {
            return this.canStop;
        }

        public String getClickClassName() {
            return this.clickClassName;
        }

        public CloseCallBack getCloseCallBack() {
            return this.closeCallBack;
        }

        public IFormView getFormView() {
            return this.formView;
        }

        public Consumer<JobInfo> getJobInfoConsumer() {
            return this.jobInfoConsumer;
        }

        public Consumer<JobFormInfo> getJobFormInfoConsumer() {
            return this.jobFormInfoConsumer;
        }
    }
}

