/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.helper;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.formplugin.domain.dimension.MemberSortVO;

public class MemberSortHelper {
    public static List<MemberSortVO> getChildMemberSortVO(DynamicObjectCollection dynamicObjectCollection, MemberSortVO memberSortVO) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return new ArrayList<MemberSortVO>(0);
        }
        ArrayList<MemberSortVO> childMemberSortVOList = new ArrayList<MemberSortVO>(10);
        Long parentId = memberSortVO.getMemberId();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String currNewSortCode;
            long currMemberId = dynamicObject.getLong("id");
            if (parentId.longValue() != dynamicObject.getLong("parent") || parentId == currMemberId) continue;
            String currOldSortCode = dynamicObject.getString("sortcode");
            if (EmptyUtil.isNoEmpty((String)currOldSortCode)) {
                String pattern = "^" + memberSortVO.getOldSortCode();
                Pattern regex = Pattern.compile(pattern);
                Matcher matcher = regex.matcher(currOldSortCode);
                currNewSortCode = matcher.replaceAll(memberSortVO.getNewSortCode());
            } else {
                currNewSortCode = MemberSortHelper.genSortCode(memberSortVO.getNewSortCode(), dynamicObject);
            }
            MemberSortVO currMemberSortVO = new MemberSortVO(currMemberId, currOldSortCode, currNewSortCode);
            childMemberSortVOList.add(currMemberSortVO);
            childMemberSortVOList.addAll(MemberSortHelper.getChildMemberSortVO(dynamicObjectCollection, currMemberSortVO));
        }
        return childMemberSortVOList;
    }

    public static String getNewSortCodeCurrentLevel(String oldSortCode, int level, int newSort) {
        String newSortCode;
        CharSequence[] sortCodeArr = oldSortCode.split("!");
        sortCodeArr[level - 1] = newSortCode = MemberSortHelper.formatSortCode(newSort);
        return String.join((CharSequence)"!", sortCodeArr);
    }

    public static boolean isValidate(String sortCode, int level) {
        String[] sortCodeArr = sortCode.split("!");
        return sortCodeArr.length == level;
    }

    public static String formatSortCode(int newSort) {
        return String.format("%04d", newSort);
    }

    public static String genSortCode(String parentSortCode, DynamicObject dynamicObject) {
        String number = dynamicObject.getString("number");
        String sortCode = "Z" + number.substring(1);
        if (EmptyUtil.isEmpty((String)parentSortCode)) {
            return sortCode;
        }
        return String.join((CharSequence)"!", parentSortCode, sortCode);
    }

    public static void updateSortCodeIfParentChange(DynamicObject memberObj) {
        DynamicObject currentParentFromDb;
        String newSortCode;
        String dimType = memberObj.getString("dimtype");
        if (!DimsionEnums.SUBJECT.getNumber().equals(dimType) && !DimsionEnums.ORG.getNumber().equals(dimType)) {
            return;
        }
        Object pkValue = memberObj.getPkValue();
        String selectFields = String.join((CharSequence)",", "level", "sortcode", "longnumber", "id", "parent");
        DynamicObject memberFormDb = QueryServiceHelper.queryOne((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        if (memberFormDb == null) {
            return;
        }
        DynamicObject parentCurrentObj = memberObj.getDynamicObject("parent");
        long parentCurrentId = parentCurrentObj == null ? 0L : parentCurrentObj.getLong("id");
        long parentPreviousId = memberFormDb.getLong("parent");
        String longNumber = memberFormDb.getString("longnumber");
        if (Objects.equals(parentCurrentId, parentPreviousId)) {
            return;
        }
        String memberSortCode = memberFormDb.getString("sortcode");
        String[] split = memberSortCode.split("!");
        String lastSortCode = "ZZZZ";
        ArrayList<MemberSortVO> memberSortVOList = new ArrayList<MemberSortVO>(10);
        if (parentCurrentId == 0L) {
            newSortCode = lastSortCode;
        } else if (parentPreviousId == 0L) {
            currentParentFromDb = QueryServiceHelper.queryOne((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentCurrentId)});
            String sortCodeParent = currentParentFromDb.getString("sortcode");
            newSortCode = String.join((CharSequence)"!", sortCodeParent, lastSortCode);
        } else {
            currentParentFromDb = QueryServiceHelper.queryOne((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentCurrentId)});
            String sortCodeNewParent = currentParentFromDb.getString("sortcode");
            newSortCode = String.join((CharSequence)"!", sortCodeNewParent, lastSortCode);
        }
        QFilter longFilter = new QFilter("longnumber", "like", (Object)(longNumber + "!" + "%")).and(new QFilter("id", "!=", pkValue));
        DynamicObjectCollection childrenMemberObjColl = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{longFilter});
        MemberSortVO memberSortVO = new MemberSortVO((Long)pkValue, memberSortCode, newSortCode);
        memberSortVOList.add(memberSortVO);
        memberSortVOList.addAll(MemberSortHelper.getChildMemberSortVO(childrenMemberObjColl, memberSortVO));
        memberSortVOList.sort(Comparator.comparing(MemberSortVO::getMemberId));
        new DataSaveServiceImpl().updateAndCheckResult(() -> "update t_fpm_member set fsortcode=? where fid=?", memberSortVOList, (a, b) -> {
            b.add(a.getNewSortCode());
            b.add(a.getMemberId());
        });
    }
}

