/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.index;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.common.bean.UserAuthModel;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.utils.CollectionBuildUtil;
import kd.tmc.fpm.utils.system.DefaultModelHelper;

public class ReportProgressManagerPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SEARCH_BODY_SYS = "bodysys";
    private static final String SEARCH_REPORT_PERIOD = "reportperiod";
    private static final String LABEL_TOTAL_COUNT = "totalcount";
    private static final String LABEL_STAGE_PERCENT = "stagepercent";
    private static final String LABEL_STAGE_COUNT = "stagecount";
    private static final String LABEL_COMMITTED_PERCENT = "committedpercent";
    private static final String LABEL_COMMITTED_COUNT = "committedcount";
    private static final String LABEL_AUDITED_PERCENT = "auditedpercent";
    private static final String LABEL_AUDITED_COUNT = "auditedcount";
    private static final String LABEL_EFFECTED_PERCENT = "effectedpercent";
    private static final String LABEL_EFFECTED_COUNT = "effectedcount";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit modelBE = (BasedataEdit)this.getControl(SEARCH_BODY_SYS);
        modelBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl(SEARCH_REPORT_PERIOD);
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long systemId = DefaultModelHelper.getAnalysisReportDefaultSystemId(this.getView().getFormShowParameter().getAppId(), "fpm_report_process");
        if (EmptyUtil.isEmpty((Long)systemId)) {
            return;
        }
        this.setReportPeriod(systemId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initViewAndData();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        UserAuthModel authScopeModel = ModelHelper.getAuthScopeModelWithCheckManager((String)appId, (String)"fpm_report_process");
        switch (key) {
            case "bodysys": {
                QFilter bodySysQFilter = new QFilter("id", "in", (Object)authScopeModel.getSystemIds());
                bodySysQFilter.and(new QFilter("enable", "=", (Object)"1"));
                param.getListFilterParameter().setFilter(bodySysQFilter);
                break;
            }
            case "reportperiod": {
                Object value = this.getModel().getValue(SEARCH_BODY_SYS);
                if (Objects.isNull(value)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ReportProgressManagerPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject system = this.getModel().getDataEntity().getDynamicObject(SEARCH_BODY_SYS);
                QFilter filter = new QFilter("bodysystem", "=", system.getPkValue()).and("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber());
                DynamicObjectCollection dynamicObjectCollection = (system = TmcDataServiceHelper.loadSingle((Object)system.getPkValue(), (String)"fpm_bodysysmanage")).getDynamicObjectCollection("applyrereportentry");
                if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                    return;
                }
                List reportTypeIdList = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("rerporttype")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(reportTypeIdList)) {
                    return;
                }
                DynamicObject[] load = TmcDataServiceHelper.load((Object[])reportTypeIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_orgreporttype"));
                Map reportTypeMap = Arrays.stream(load).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
                String selectFields = String.join((CharSequence)",", "id", "reporttype.id", "periodtype");
                DynamicObject[] periodArr = TmcDataServiceHelper.load((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{filter});
                List periodMemberIdList = Arrays.stream(periodArr).filter(dy -> {
                    String periodType;
                    Long reportTypeId = dy.getLong("reporttype.id");
                    DynamicObject dynamicObject = (DynamicObject)reportTypeMap.get(reportTypeId);
                    if (Objects.isNull(dynamicObject)) {
                        return false;
                    }
                    if (!Objects.equals(dynamicObject.getString("orgreportcycle"), OrgReportTypeCycleEnum.YEAR.getValue()) && Objects.equals(dy.getString("periodtype"), "Y")) {
                        return false;
                    }
                    String detailType = dynamicObject.getString("orgreporttype");
                    return !Objects.nonNull(detailType) || !Objects.equals(periodType = dy.getString("periodtype"), detailType);
                }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                param.getListFilterParameter().setFilter(filter.and("id", "in", periodMemberIdList));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData changedata = e.getChangeSet()[0];
        Object newValue = changedata.getNewValue();
        switch (name) {
            case "bodysys": {
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    return;
                }
                this.getModel().setValue(SEARCH_REPORT_PERIOD, null);
                long systemId = ((DynamicObject)newValue).getLong("id");
                this.setReportPeriod(systemId);
                DefaultModelHelper.save(systemId);
                break;
            }
            case "reportperiod": {
                this.initViewAndData();
                break;
            }
        }
    }

    private void setReportPeriod(Long authModelId) {
        DynamicObject[] dynamicObjects;
        this.getModel().setValue(SEARCH_BODY_SYS, (Object)authModelId);
        DynamicObject authModelDatum = TmcDataServiceHelper.loadSingle((Object)authModelId, (String)"fpm_bodysysmanage");
        DynamicObjectCollection dynamicObjectCollection = authModelDatum.getDynamicObjectCollection("applyrereportentry");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        List reportTypeIdList = dynamicObjectCollection.stream().filter(dy -> Objects.equals(dy.getString("rereporttypestatus"), "enable")).map(dy -> dy.getDynamicObject("rerporttype")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(reportTypeIdList)) {
            return;
        }
        DynamicObject[] load = TmcDataServiceHelper.load((Object[])reportTypeIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_orgreporttype"));
        List dynamicObjectList = Arrays.stream(load).sorted(Comparator.comparing(dy -> this.reportTypeScore(dy.getString("orgreportcycle")))).collect(Collectors.toList());
        Date currentDate = new Date();
        DynamicObject reportTypeDy = (DynamicObject)dynamicObjectList.get(0);
        QFilter qFilter = new QFilter("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber()).and("bodysystem", "=", authModelDatum.getPkValue()).and("reporttype", "=", reportTypeDy.getPkValue()).and("startdate", "<=", (Object)currentDate).and("enddate", ">", (Object)currentDate);
        if (!Objects.equals(reportTypeDy.getString("orgreportcycle"), OrgReportTypeCycleEnum.YEAR.getValue())) {
            qFilter.and("periodtype", "!=", (Object)OrgReportTypeCycleEnum.YEAR.getValue());
        }
        if (Objects.isNull(dynamicObjects = TmcDataServiceHelper.load((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"startdate")) || dynamicObjects.length == 0) {
            return;
        }
        this.getModel().setValue(SEARCH_REPORT_PERIOD, dynamicObjects[0].getPkValue());
    }

    private int reportTypeScore(String reportCycle) {
        if (Objects.equals(OrgReportTypeCycleEnum.MONTH.getValue(), reportCycle)) {
            return 0;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.WEEK.getValue(), reportCycle)) {
            return 1;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.DAY.getValue(), reportCycle)) {
            return 3;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.QUARTER.getValue(), reportCycle)) {
            return 4;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.HALFYEAR.getValue(), reportCycle)) {
            return 5;
        }
        if (Objects.equals(OrgReportTypeCycleEnum.YEAR.getValue(), reportCycle)) {
            return 6;
        }
        return 100;
    }

    private void initViewAndData() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"datapanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpanel"});
        if (this.validateSearchParam()) {
            this.initializeReportProgressPieChart();
            this.getView().setVisible(Boolean.TRUE, new String[]{"datapanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultpanel"});
        }
    }

    private void initializeReportProgressPieChart() {
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue(SEARCH_BODY_SYS);
        DynamicObject reportPeriod = (DynamicObject)this.getModel().getValue(SEARCH_REPORT_PERIOD);
        Map<String, List<DynamicObject>> groupByStatusByCondition = this.getReportProgressGroupByStatusByCondition(bodySys.getPkValue(), reportPeriod.getPkValue());
        List stageList = groupByStatusByCondition.getOrDefault(ReportProcessStatus.SAVE.getValue(), Collections.emptyList());
        List committedList = groupByStatusByCondition.getOrDefault(ReportProcessStatus.SUBMIT.getValue(), Collections.emptyList());
        List auditedList = groupByStatusByCondition.getOrDefault(ReportProcessStatus.AUDIT.getValue(), Collections.emptyList());
        List auditedNotEffectiveList = Collections.emptyList();
        List auditedAndEffectiveList = Collections.emptyList();
        Map<String, List<DynamicObject>> listMap = auditedList.stream().collect(Collectors.groupingBy(dy -> dy.getString("planstatus")));
        if (Objects.nonNull(listMap)) {
            auditedNotEffectiveList = listMap.getOrDefault(ReportPlanStatusEnum.INEFFECTIVE.getValue(), new ArrayList(0));
            auditedNotEffectiveList.addAll(listMap.getOrDefault(ReportPlanStatusEnum.REPORTING.getValue(), new ArrayList(0)));
            auditedNotEffectiveList.addAll(listMap.getOrDefault(ReportPlanStatusEnum.BEBACK.getValue(), new ArrayList(0)));
            auditedAndEffectiveList = listMap.getOrDefault(ReportPlanStatusEnum.EFFECTIVE.getValue(), new ArrayList(0));
        }
        List collect = groupByStatusByCondition.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        int totalCount = collect.size();
        int stageCount = stageList.size();
        int committedCount = committedList.size();
        int auditNotEffectiveCount = auditedNotEffectiveList.size();
        int auditedAndEffectiveCount = auditedAndEffectiveList.size();
        this.setCount(totalCount, stageCount, committedCount, auditNotEffectiveCount, auditedAndEffectiveCount);
        PieChart chart = (PieChart)this.getControl("piechartap");
        this.initPieChart(chart);
        PieSeries pieSeries = chart.createPieSeries("reportProgress");
        this.initPieSeries(pieSeries);
        pieSeries.setData(new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u6682\u5b58", (String)"ReportProgressManagerPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), (Number)stageCount), new ItemValue(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"ReportProgressManagerPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), (Number)committedCount), new ItemValue(ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u751f\u6548", (String)"ReportProgressManagerPlugin_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), (Number)auditNotEffectiveCount), new ItemValue(ResManager.loadKDString((String)"\u5df2\u751f\u6548", (String)"ReportProgressManagerPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), (Number)auditedAndEffectiveCount)});
        this.getView().updateView("piechartap");
    }

    private void setCount(int totalCount, int stageCount, int committedCount, int auditNotEffectiveCount, int auditedAndEffectiveCount) {
        Percent percent = new Percent(totalCount).addItemPortion(LABEL_STAGE_PERCENT, stageCount).addItemPortion(LABEL_COMMITTED_PERCENT, committedCount).addItemPortion(LABEL_AUDITED_PERCENT, auditNotEffectiveCount).addItemPortion(LABEL_EFFECTED_PERCENT, auditedAndEffectiveCount);
        percent.calculate();
        this.setLabelText(LABEL_TOTAL_COUNT, String.valueOf(totalCount));
        this.setLabelText(LABEL_STAGE_PERCENT, this.getPercentStringValueFormat(percent.getPercent(LABEL_STAGE_PERCENT)));
        this.setLabelText(LABEL_STAGE_COUNT, String.valueOf(stageCount));
        this.setLabelText(LABEL_COMMITTED_PERCENT, this.getPercentStringValueFormat(percent.getPercent(LABEL_COMMITTED_PERCENT)));
        this.setLabelText(LABEL_COMMITTED_COUNT, String.valueOf(committedCount));
        this.setLabelText(LABEL_AUDITED_PERCENT, this.getPercentStringValueFormat(percent.getPercent(LABEL_AUDITED_PERCENT)));
        this.setLabelText(LABEL_AUDITED_COUNT, String.valueOf(auditNotEffectiveCount));
        this.setLabelText(LABEL_EFFECTED_PERCENT, this.getPercentStringValueFormat(percent.getPercent(LABEL_EFFECTED_PERCENT)));
        this.setLabelText(LABEL_EFFECTED_COUNT, String.valueOf(auditedAndEffectiveCount));
    }

    private String getPercentStringValueFormat(BigDecimal value) {
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            return "0%";
        }
        if (BigDecimal.ONE.compareTo(value) == 0) {
            return "100%";
        }
        return String.format("%.2f", value.multiply(new BigDecimal("100"))) + "%";
    }

    private static BigDecimal getDoubleProportionForScale(int total, int value, int scale) {
        BigDecimal totalCount = new BigDecimal(total + "");
        if (BigDecimal.ZERO.compareTo(totalCount) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal count = new BigDecimal(value + "");
        return count.divide(totalCount, scale, RoundingMode.HALF_UP);
    }

    private void setLabelText(String labelName, String labelValue) {
        Label label = (Label)this.getControl(labelName);
        label.setText(labelValue);
    }

    private void initPieSeries(PieSeries pieSeries) {
        pieSeries.setPropValue("color", (Object)CollectionBuildUtil.arraylist((Object[])new Object[]{"#276ff5", "#3dccc0", "#99d92b", "#45cdff"}));
        pieSeries.setPropValue("radius", (Object)CollectionBuildUtil.arraylist((Object[])new Object[]{"75%", "55%"}));
        pieSeries.setPropValue("center", (Object)CollectionBuildUtil.arraylist((Object[])new Object[]{"50%", "50%"}));
        pieSeries.setPropValue("itemStyle", (Object)CollectionBuildUtil.map((String)"normal", (Object)CollectionBuildUtil.map().kv("borderColor", (Object)"#fff").kv("borderWidth", (Object)5)));
        pieSeries.setPropValue("label", (Object)CollectionBuildUtil.map((String)"normal", (Object)CollectionBuildUtil.map((String)"show", (Object)false)));
    }

    private void initPieChart(PieChart chart) {
        chart.setShowTooltip(false);
        chart.setShowLegend(false);
        chart.clearData();
        chart.setTitlePropValue("text", (Object)"{val|}");
        chart.setTitlePropValue("top", (Object)"center");
        chart.setTitlePropValue("left", (Object)"center");
        chart.setTitlePropValue("textStyle", (Object)CollectionBuildUtil.map().kv("rich", (Object)CollectionBuildUtil.map().kv("val", (Object)CollectionBuildUtil.map().kv("fontSize", (Object)16).kv("fontWeight", (Object)"bolder").kv("color", (Object)"#000"))));
    }

    private Map<String, List<DynamicObject>> getReportProgressGroupByStatusByCondition(Object bodySys, Object reportPeriod) {
        DynamicObjectCollection queryResult;
        String appId = this.getView().getFormShowParameter().getAppId();
        QFilter qFilter = new QFilter(SEARCH_BODY_SYS, "=", bodySys).and(new QFilter(SEARCH_REPORT_PERIOD, "=", reportPeriod)).and(new QFilter("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber()));
        UserAuthModel authScopeModel = ModelHelper.getAuthScopeModel((String)appId, (String)"fpm_report_process");
        if (!authScopeModel.isHasAllOrgPerm()) {
            qFilter.and(new QFilter("reportorg", "in", (Object)authScopeModel.getOrgIds()));
        }
        if (CollectionUtils.isEmpty((Collection)(queryResult = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "id", "billstatus", "planstatus"), (QFilter[])new QFilter[]{qFilter})))) {
            return Collections.emptyMap();
        }
        return queryResult.stream().collect(Collectors.groupingBy(dy -> dy.getString("billstatus")));
    }

    private boolean validateSearchParam() {
        return Objects.nonNull(this.getModel().getValue(SEARCH_BODY_SYS)) && Objects.nonNull(this.getModel().getValue(SEARCH_REPORT_PERIOD));
    }

    static class Percent {
        private Integer total;
        private Map<String, Integer> itemPortion;
        private Map<String, BigDecimal> itemPercent;
        private Set<String> zeroItem;

        public Percent(Integer total) {
            this.total = total;
            this.itemPortion = new HashMap<String, Integer>(8);
            this.itemPercent = new HashMap<String, BigDecimal>(8);
            this.zeroItem = new HashSet<String>(8);
        }

        public Percent addItemPortion(String key, Integer portion) {
            if (portion == 0) {
                this.zeroItem.add(key);
                return this;
            }
            this.itemPortion.putIfAbsent(key, portion);
            return this;
        }

        public void calculate() {
            this.zeroItem.forEach(k -> this.itemPercent.putIfAbsent((String)k, BigDecimal.ZERO));
            BigDecimal remain = BigDecimal.ONE;
            int count = 0;
            for (Map.Entry<String, Integer> entry : this.itemPortion.entrySet()) {
                String key = entry.getKey();
                Integer portion = entry.getValue();
                if (count == this.itemPortion.size() - 1) {
                    this.itemPercent.putIfAbsent(key, remain);
                    break;
                }
                BigDecimal percent = ReportProgressManagerPlugin.getDoubleProportionForScale(this.total, portion, 4);
                this.itemPercent.putIfAbsent(key, percent);
                remain = remain.subtract(percent);
                ++count;
            }
        }

        public BigDecimal getPercent(String key) {
            return this.itemPercent.getOrDefault(key, BigDecimal.ZERO);
        }
    }
}

