/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inoutpool;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.bill.TmcBaseBillList;
import kd.tmc.fpm.common.enums.InoutCycleEnum;
import kd.tmc.fpm.formplugin.helper.CronGenerateHelper;
import kd.tmc.fpm.formplugin.helper.InoutCollectSearchHelper;

public class CronPlanTemplateList
extends TmcBaseBillList {
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        String orgName = String.join((CharSequence)".", "applyorg", "name");
        if (orgName.contains(fieldName)) {
            Long userPK = Long.valueOf(RequestContext.get().getUserId());
            String appId = this.getView().getFormShowParameter().getAppId();
            if (EmptyUtil.isNoEmpty((String)appId)) {
                List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
                args.getQFilters().add(new QFilter("id", "in", (Object)orgIdList));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "generatecollbill": {
                this.openGenerateViewOrGenerateBill(args);
                break;
            }
            case "viewgeneratedrecord": {
                this.linkSearchInoutRecord();
                args.setCancel(true);
                break;
            }
        }
    }

    protected String getPrimaryOrgId() {
        return String.join((CharSequence)".", "applyorg", "id");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "generatecollbill": {
                this.generateCollectBill(closedCallBackEvent);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Calendar calendar = Calendar.getInstance();
                DynamicObjectCollection data = super.getData(start, limit);
                for (DynamicObject dynamicObject : data) {
                    Date date = CronPlanTemplateList.this.getGenerateStartExpectDate(dynamicObject);
                    if (date == null) {
                        return data;
                    }
                    Date firstDate = dynamicObject.getDate("firstexpectdate");
                    calendar.setTime(firstDate);
                    int day = calendar.get(5);
                    Date currentDate = DateUtils.getCurrentDate();
                    AtomicReference<Date> currentDateRef = new AtomicReference<Date>(currentDate);
                    if (date.compareTo(firstDate) >= 0) {
                        firstDate = date;
                        calendar.setTime(firstDate);
                        calendar.add(5, 1);
                        if (date.after(currentDate)) {
                            currentDateRef.set(calendar.getTime());
                        }
                    }
                    String inoutCycle = dynamicObject.getString("inoutcycle");
                    InoutCycleEnum inoutCycleEnum = InoutCycleEnum.getByCode((String)inoutCycle);
                    int repeatCount = dynamicObject.getInt("repeatcycle");
                    Date expireDate = dynamicObject.getDate("expiredate");
                    InoutCycleEnum.InoutCycleDay inoutCycleDay = new InoutCycleEnum.InoutCycleDay(inoutCycleEnum, day, repeatCount);
                    String[] futureThreeExpectDate = new String[3];
                    for (int i = 0; i < futureThreeExpectDate.length; ++i) {
                        Date expectDate;
                        firstDate = expectDate = inoutCycleDay.getExpectDate(firstDate, currentDateRef, calendar);
                        if (expireDate != null && !expireDate.after(expectDate)) continue;
                        futureThreeExpectDate[i] = simpleDateFormat.format(expectDate);
                    }
                    dynamicObject.set("futurethreeexpectdate", (Object)Arrays.stream(futureThreeExpectDate).filter(StringUtils::isNotEmpty).collect(Collectors.joining(",")));
                }
                return data;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "generatecollbill": {
                CronGenerateHelper.showMessage(this.getView(), args.getOperationResult());
            }
        }
    }

    private void openGenerateViewOrGenerateBill(BeforeDoOperationEventArgs args) {
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)this.getPageCache().get("GENERATE_OPEN_VIEW"), (CharSequence)"Y")) {
            this.showGenerateView();
            args.setCancel(true);
            return;
        }
        this.getPageCache().remove("GENERATE_OPEN_VIEW");
    }

    private void linkSearchInoutRecord() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Set ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (ids.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u5355\u636e\u8bb0\u5f55\u3002", (String)"CronPlanTemplateList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
        String selectFields = String.join((CharSequence)",", "id", "name", "billno");
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"fpm_cronplanmaintain", (String)selectFields);
        InoutCollectSearchHelper.viewGeneratedRecord(this.getView(), dynamicObject);
    }

    private void generateCollectBill(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (!DynamicObject.class.isInstance(returnData)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)returnData;
        int days = dynamicObject.getInt("futuredays");
        this.getPageCache().put("GENERATE_OPEN_VIEW", "Y");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("GENERATE_OPERATOR_VARIABLE_DAYS", days + "");
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        List objectList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", objectList).and("enable", "=", (Object)"1");
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_cronplanmaintain", (String)"id", (QFilter[])new QFilter[]{filter});
        String templateIdStr = Arrays.stream(load).map(DataEntityBase::getPkValue).filter(EmptyUtil::isNoEmpty).map(String::valueOf).collect(Collectors.joining(","));
        operateOption.setVariableValue("GENERATE_OPERATOR_VARIABLE_TEMPLATE_ID", templateIdStr);
        this.getView().invokeOperation("generatecollbill", operateOption);
    }

    private Date getGenerateStartExpectDate(DynamicObject dy) {
        Date recentRecordDate = dy.getDate("recentrecordexpectdate");
        if (recentRecordDate != null) {
            return recentRecordDate;
        }
        return dy.getDate("firstexpectdate");
    }

    private void showGenerateView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_cronplangenerate");
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Set selectIds = selectedRows.stream().map(listSelectedRow -> listSelectedRow.getPrimaryKeyValue()).collect(Collectors.toSet());
        String applyOrgIdField = String.join((CharSequence)".", "applyorg", "id");
        String selectFields = String.join((CharSequence)",", "id", applyOrgIdField);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_cronplanmaintain", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", selectIds)});
        String applyOrgIdStr = Arrays.stream(load).map(dynamicObject -> dynamicObject.getString(applyOrgIdField)).filter(EmptyUtil::isNoEmpty).collect(Collectors.joining(","));
        showParameter.getCustomParams().put("APPLY_ORG", applyOrgIdStr);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "generatecollbill"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u751f\u6210\u6536\u652f\u8ba1\u5212\u91c7\u96c6\u5355", (String)"CronPlanTemplateList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }
}

