/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inoutpool;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.fpm.common.enums.InoutCollectApplyStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectApprovalStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectDataSourceEnum;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.common.property.InOutPlanCollectProp;
import kd.tmc.fpm.formplugin.helper.F7ListenerHelper;
import kd.tmc.fpm.formplugin.helper.InoutCollectSearchHelper;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InOutPlanCollectEdit
extends AbstractTmcBillEdit {
    private static final String BOS_ORG_FUND = "fisbankroll";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
        this.initEntryRelateReportHyperLink();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "upsearch": {
                InoutCollectSearchHelper.upSearch(this.getModel().getDataEntity(), this.getView());
                break;
            }
            case "downsearch": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                dataEntity.set("entryentity", (Object)this.getModel().getEntryEntity("entryentity"));
                InoutCollectSearchHelper.downSearch(this.getModel().getDataEntity(), this.getView());
                break;
            }
            case "approvalrecord": {
                InoutCollectSearchHelper.approvalRecord(this.getView(), this.getModel().getDataEntity());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection entryEntity;
        List relateReportIds;
        DynamicObject fundOrg;
        super.beforeBindData(e);
        this.setExpectDateDefault();
        DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("applyorg");
        Object applyOrgId = RequestContext.get().getOrgId();
        if (Objects.nonNull(applyOrg)) {
            applyOrgId = applyOrg.getPkValue();
        }
        String selectFields = String.join((CharSequence)",", "id", BOS_ORG_FUND);
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)applyOrgId, (String)"bos_org", (String)selectFields);
        boolean isFundOrg = dynamicObject.getBoolean(BOS_ORG_FUND);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"applyorg", (Object)applyOrgId);
        DynamicObject applyUser = (DynamicObject)this.getModel().getValue("applyuser");
        if (Objects.isNull(applyUser)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"applyuser", (Object)RequestContext.get().getCurrUserId());
        }
        if (Objects.isNull(fundOrg = (DynamicObject)this.getModel().getValue("fundorg"))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"fundorg", (Object)(isFundOrg ? applyOrgId : Long.valueOf(0L)));
        }
        if (CollectionUtils.isNotEmpty(relateReportIds = (entryEntity = (DynamicObjectCollection)this.getModel().getValue("entryentity")).stream().map(dy -> dy.getLong("entry_relateplanreportid")).collect(Collectors.toList()))) {
            DynamicObject[] relateReportDyArr = BusinessDataServiceHelper.load((String)"fpm_report", (String)String.join((CharSequence)",", "id", "billno", "reportperiod"), (QFilter[])new QFilter("id", "in", relateReportIds).toArray());
            Map reportIdAndBillNoMap = Arrays.stream(relateReportDyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject relateReportDy = (DynamicObject)reportIdAndBillNoMap.get(((DynamicObject)entryEntity.get(i)).getLong("entry_relateplanreportid"));
                String reportBillNo = Objects.nonNull(relateReportDy) ? relateReportDy.getString("billno") : null;
                DynamicObject reportPeriodDy = Objects.nonNull(relateReportDy) ? relateReportDy.getDynamicObject("reportperiod") : null;
                this.getModel().initValue("entry_relatereportno", (Object)reportBillNo, i);
                this.getModel().initValue("entry_relatereportperiod", (Object)reportPeriodDy, i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (property.getName()) {
            case "expectcashamount": {
                this.setCurrentPlanAmountDefault(e);
                break;
            }
            case "inoutdirection": {
                this.getModel().setValue("fundpurpose", null);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (EmptyUtil.isEmpty((Object)pkValue)) {
            return;
        }
        this.disableFieldByDataSource();
        this.disableFieldAfterLinkSearch(this.getView().getFormShowParameter());
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        BillModel model = (BillModel)e.getSource();
        this.cleanDataIfCopy(model);
        model.setValue("createdate", (Object)DateUtils.getCurrentDate());
        model.setValue("approvalstatus", (Object)InoutCollectApprovalStatusEnum.NOT_APPROVAL.getCode());
        model.setValue("applystatus", (Object)InoutCollectApplyStatusEnum.NOT_APPLY.getCode());
        model.setValue("datasource", (Object)InoutCollectDataSourceEnum.HAND_NEW.getCode());
        DynamicObject bosUser = TmcDataServiceHelper.newDynamicObject((String)"bos_user");
        bosUser.set("id", (Object)RequestContext.get().getCurrUserId());
        model.setValue("applyuser", (Object)bosUser);
    }

    private void cleanDataIfCopy(BillModel model) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = parentView.getPageCache();
        if (!StringUtils.equals((CharSequence)pageCache.get("FROM_COPY"), (CharSequence)"FROM_COPY")) {
            return;
        }
        pageCache.remove("FROM_COPY");
        DynamicObject dataEntity = model.getDataEntity();
        for (String field : InOutPlanCollectProp.CLEAN_FIELD_FROM_COPY) {
            dataEntity.set(field, null);
        }
        dataEntity.getDynamicObjectCollection("entryentity").clear();
    }

    private void disableFieldByDataSource() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String dataSource = dataEntity.getString("datasource");
        Set fields = (Set)InOutPlanCollectProp.DATASOURCE_BUSINESS_FIELD_NOT_EMPTY_DISABLE_MAP.get(dataSource);
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return;
        }
        List<String> collect = fields.stream().filter(str -> EmptyUtil.isNoEmpty((Object)dataEntity.get(str))).collect(Collectors.toList());
        this.getView().setEnable(Boolean.FALSE, collect.toArray(new String[0]));
    }

    private void setExpectDateDefault() {
        DateEdit expectDateEdit = (DateEdit)this.getView().getControl("expectdate");
        DateEdit currentPlanDateEdit = (DateEdit)this.getView().getControl("currentplandate");
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        Date currentDate = DateUtils.getCurrentDate();
        if (operationStatus == OperationStatus.ADDNEW) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"expectdate", (Object)currentDate);
            expectDateEdit.setMinDate(currentDate);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currentplandate", (Object)currentDate);
            currentPlanDateEdit.setMinDate(currentDate);
            return;
        }
        Date expectDate = this.getModel().getDataEntity().getDate("expectdate");
        Date minDate = expectDate != null && expectDate.before(currentDate) ? expectDate : currentDate;
        expectDateEdit.setMinDate(minDate);
        Date currentPlanDate = this.getModel().getDataEntity().getDate("currentplandate");
        minDate = currentPlanDate != null && currentPlanDate.before(currentDate) ? expectDate : currentDate;
        currentPlanDateEdit.setMinDate(minDate);
    }

    private void setCurrentPlanAmountDefault(PropertyChangedArgs e) {
        BigDecimal bigDecimal = this.getModel().getDataEntity().getBigDecimal("currentplanamount");
        if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) != 0) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        this.getModel().setValue("currentplanamount", newValue);
    }

    private void initF7() {
        for (String field : InOutPlanCollectProp.F7_FIELDS) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(field);
            basedataEdit.addBeforeF7SelectListener(F7ListenerHelper.inoutPollBeforeF7SelectListener(this.getModel(), this.getView()));
        }
    }

    public void disableFieldAfterLinkSearch(FormShowParameter formShowParameter) {
        Boolean isFormLinkSearchChild = (Boolean)formShowParameter.getCustomParam("param_from_link_search_child");
        if (isFormLinkSearchChild == null || !isFormLinkSearchChild.booleanValue()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
    }

    private void initEntryRelateReportHyperLink() {
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        entryEntity.addHyperClickListener(hyperLinkClickEvent -> {
            Long relateReportId = (Long)this.getModel().getValue("entry_relateplanreportid", hyperLinkClickEvent.getRowIndex());
            this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_reportplan").searchFormNumber("fpm_report").listForm("fpm_report").listFormId("bos_treelist").searchIds(Collections.singletonList(relateReportId)).linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_REPORT_PLAN).linkSearch(true).caption(ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u5236\u8868\u8054\u67e5", (String)"InOutPlanCollectEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).build()));
        });
    }
}

