/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inoutpool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.fpm.business.opservice.inoutpool.CronPlanCollectGenerateBillService;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectApplyStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectApprovalStatusEnum;
import kd.tmc.fpm.formplugin.helper.CronGenerateHelper;
import kd.tmc.fpm.formplugin.helper.InoutCollectSearchHelper;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class InOutPlanCollectList
extends AbstractTmcBillBaseList
implements BeforeBindDataListener {
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        super.beforeBindData((EventObject)beforeBindDataEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new BillListDataProvider()));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new BillListDataProvider());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sourceApp = (String)this.getView().getFormShowParameter().getCustomParam("sourceApp");
        if (Objects.equals(sourceApp, "tr")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_intelligentcollect", "bar_viewcollectlog"});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        if (this.getPageCache().get("init") == null) {
            this.getPageCache().put("init", "true");
            this.initFilterItem(args);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "intelligentcollect": {
                this.intelligentCollect(args);
                break;
            }
            case "crongenerate": {
                this.showView(operateKey, "fpm_cronplangenerate", ResManager.loadKDString((String)"\u751f\u6210\u6536\u652f\u8ba1\u5212\u91c7\u96c6\u5355", (String)"InOutPlanCollectList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "abandon": {
                this.needAbandonAndShowForm();
                break;
            }
            case "copy": {
                this.getPageCache().put("FROM_COPY", "FROM_COPY");
                break;
            }
            case "approvalrecord": {
                InoutCollectSearchHelper.approvalRecord((IListView)this.getView());
                break;
            }
            case "upsearch": {
                InoutCollectSearchHelper.upSearch((IListView)this.getView());
                break;
            }
            case "downsearch": {
                InoutCollectSearchHelper.downSearch((IListView)this.getView());
                break;
            }
            case "viewcollectlog": {
                this.openCollectLog();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (!StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_approval")) {
            return;
        }
        evt.setCancel(true);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("batchop_batchsize", String.valueOf(Integer.MAX_VALUE));
        this.getView().invokeOperation("approval", operateOption);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        LinkSearchSubFormHelper.removeListFilterContainerFilters(formShowParameter, e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        LinkSearchSubFormHelper.hideControl(this.getView(), "filtercontainerap", "bar_new", "bar_submit", "bar_audit", "bar_generatebill", "bar_del", "bar_approval", "bar_linksearch", "baritemap");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "crongenerate": {
                this.doGenerateCollectBill(closedCallBackEvent);
                break;
            }
            case "abandon": {
                this.abandonBill(closedCallBackEvent);
            }
        }
    }

    private void openCollectLog() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("fpm_collectlog");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void needAbandonAndShowForm() {
        DynamicObject[] load = this.getSelectedInoutCollectBills();
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6536\u652f\u8ba1\u5212\u91c7\u96c6\u5355", (String)"InOutPlanCollectList_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        int count = 0;
        for (DynamicObject dynamicObject : load) {
            if (!this.canAbandon(dynamicObject)) {
                sb.append("\u201c").append(dynamicObject.getString("billno")).append("\u201d").append(",");
                continue;
            }
            ++count;
        }
        if (count == 0) {
            sb.deleteCharAt(sb.length() - 1);
            sb.append(ResManager.loadKDString((String)"\u5e9f\u5f03\u5931\u8d25\u3002\u4ec5\u652f\u6301\u672a\u5e9f\u5f03\u3001\u5df2\u5ba1\u6838\u4e14\u672a\u7533\u62a5\u7684\u5355\u636e\u3002\u8bf7\u786e\u8ba4\u3002", (String)"InOutPlanCollectList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            this.getView().showTipNotification(sb.toString());
            return;
        }
        this.showView("abandon", "fpm_abandonreason", ResManager.loadKDString((String)"\u586b\u5199\u5e9f\u5f03\u539f\u56e0", (String)"InOutPlanCollectList_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject[] getSelectedInoutCollectBills() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Set pkSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        String selectFields = String.join((CharSequence)",", "abandonstatus", "abandonreason", "applystatus", "billstatus", "billno", "approvalstatus");
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_inoutcollect", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", pkSet)});
        return load;
    }

    private boolean canAbandon(DynamicObject dynamicObject) {
        if (dynamicObject.getBoolean("abandonstatus")) {
            return false;
        }
        String billStatus = dynamicObject.getString("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDITED.getCode())) {
            return false;
        }
        String approvalStatus = dynamicObject.getString("approvalstatus");
        if (StringUtils.equals((CharSequence)approvalStatus, (CharSequence)InoutCollectApprovalStatusEnum.APPROVED.getCode())) {
            return false;
        }
        String applyStatus = dynamicObject.getString("applystatus");
        return !StringUtils.equals((CharSequence)applyStatus, (CharSequence)InoutCollectApplyStatusEnum.APPLIED.getCode());
    }

    private void abandonBill(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof DynamicObject) {
            DynamicObject abandonReasonDy = (DynamicObject)returnData;
            String reason = abandonReasonDy.getString("abandonreason");
            DynamicObject[] inoutCollectBills = this.getSelectedInoutCollectBills();
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6536\u652f\u8ba1\u5212\u91c7\u96c6\u5355", (String)"InOutPlanCollectList_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            ArrayList<DynamicObject> abandonList = new ArrayList<DynamicObject>(inoutCollectBills.length);
            for (int i = 0; i < inoutCollectBills.length; ++i) {
                DynamicObject dynamicObject = inoutCollectBills[i];
                if (!this.canAbandon(dynamicObject)) {
                    sb.append("\u201c").append(dynamicObject.getString("billno")).append("\u201d").append(",");
                    continue;
                }
                dynamicObject.set("abandonstatus", (Object)"1");
                dynamicObject.set("abandonreason", (Object)reason);
                abandonList.add(dynamicObject);
            }
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_inoutcollect", (DynamicObject[])abandonList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().invokeOperation("refresh");
                if (abandonList.size() != inoutCollectBills.length) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append(ResManager.loadKDString((String)"\u5e9f\u5f03\u5931\u8d25\u3002\u4ec5\u652f\u6301\u672a\u5e9f\u5f03\u3001\u5df2\u5ba1\u6838\u4e14\u672a\u7533\u62a5\u7684\u5355\u636e\u3002\u8bf7\u786e\u8ba4\u3002", (String)"InOutPlanCollectList_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                    this.getView().showTipNotification(sb.toString());
                }
            }
        }
    }

    private void doGenerateCollectBill(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (!DynamicObject.class.isInstance(returnData)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)returnData;
        int days = dynamicObject.getInt("futuredays");
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("applyorgrange");
        Set applyOrgRange = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("applyorg", "in", applyOrgRange).and("enable", "=", (Object)"1");
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_cronplanmaintain", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (load == null || load.length == 0) {
            String applyOrgNames = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getString("name")).collect(Collectors.joining(","));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u6a21\u677f\u3002", (String)"InOutPlanCollectList_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), applyOrgNames));
            return;
        }
        String templateIdStr = Arrays.stream(load).map(DataEntityBase::getPkValue).filter(EmptyUtil::isNoEmpty).map(String::valueOf).collect(Collectors.joining(","));
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("GENERATE_OPERATOR_VARIABLE_DAYS", days + "");
        operateOption.setVariableValue("GENERATE_OPERATOR_VARIABLE_TEMPLATE_ID", templateIdStr);
        this.doGenerateBill(operateOption);
        this.getView().invokeOperation("refresh");
    }

    private void doGenerateBill(OperateOption operateOption) {
        CronPlanCollectGenerateBillService cronPlanCollectGenerateBillService = new CronPlanCollectGenerateBillService();
        cronPlanCollectGenerateBillService.setOperationResult(new OperationResult());
        cronPlanCollectGenerateBillService.setOperationVariable(operateOption.getVariables());
        cronPlanCollectGenerateBillService.process(null);
        CronGenerateHelper.showMessage(this.getView(), cronPlanCollectGenerateBillService.getOperationResult());
    }

    private void showView(String key, String formId, String caption) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.setCaption(caption);
        this.getView().showForm(showParameter);
    }

    private void intelligentCollect(BeforeDoOperationEventArgs args) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_execsmartcollect");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "intelligentcollect"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u667a\u80fd\u91c7\u96c6", (String)"InOutPlanCollectList_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        args.setCancel(true);
    }

    private void initFilterItem(FilterContainerInitArgs args) {
    }

    public static class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection allRows = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)allRows)) {
                return allRows;
            }
            List<String> rowIds = allRows.stream().map(item -> Long.valueOf(item.getLong("id")).toString()).collect(Collectors.toList());
            Map<Long, List<Long>> inoutIdMap = this.getInoutIdKeyReportIdMap(rowIds);
            Map<Long, String> inoutIdReportPeriodMap = this.getReportIdKeyPeriodMap(rowIds, inoutIdMap);
            if (MapUtils.isEmpty(inoutIdMap) || MapUtils.isEmpty(inoutIdReportPeriodMap)) {
                return allRows;
            }
            for (DynamicObject row : allRows) {
                List<Long> rowRelReportIds;
                long entryId;
                boolean hasEntry = row.getDataEntityType().getProperties().containsKey((Object)"entryentity.id");
                if (!hasEntry || (entryId = row.getLong("entryentity.id")) <= 0L) continue;
                if (!row.getDataEntityType().getProperties().containsKey((Object)"entryentity.list_relperiod")) {
                    TextProp reportPeriodCol = new TextProp();
                    reportPeriodCol.setName("entryentity.list_relperiod");
                    row.getDataEntityType().getProperties().add((Object)reportPeriodCol);
                }
                if (!CollectionUtils.isNotEmpty(rowRelReportIds = inoutIdMap.get(entryId))) continue;
                List periodName = rowRelReportIds.stream().map(inoutIdReportPeriodMap::get).collect(Collectors.toList());
                row.set("entryentity.list_relperiod", (Object)String.join((CharSequence)",", periodName));
            }
            return allRows;
        }

        private Map<Long, String> getReportIdKeyPeriodMap(List<String> rowIds, Map<Long, List<Long>> inoutIdMap) {
            String id = "fid";
            String name = "fname";
            HashMap<Long, String> inoutIdReportPeriodMap = new HashMap<Long, String>(rowIds.size());
            List reportIds = inoutIdMap.values().stream().flatMap(Collection::stream).map(Object::toString).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(reportIds)) {
                return inoutIdReportPeriodMap;
            }
            String reportQuerySql = "select a.fid, b.fname from t_fpm_report a,t_fpm_member_l b where a.freportperiod = b.fid and b.flocaleid = 'zh_CN' and a.fid in (" + String.join((CharSequence)",", reportIds) + ");";
            try (DataSet queryDataSet = DB.queryDataSet((String)"selectReportPeriod", (DBRoute)DBRouteConst.TMC, (String)reportQuerySql, (Object[])new Object[0]);){
                for (Row row : queryDataSet) {
                    Long reportId = row.getLong("fid");
                    inoutIdReportPeriodMap.putIfAbsent(reportId, row.getString("fname"));
                }
            }
            return inoutIdReportPeriodMap;
        }

        private Map<Long, List<Long>> getInoutIdKeyReportIdMap(List<String> rowIds) {
            String id = "fentryid";
            String reportId = "frelateplanreportid";
            String inoutQuerySql = "select fentryid, frelateplanreportid from t_fpm_collectrelatereport where fid in (" + String.join((CharSequence)",", rowIds) + ");";
            HashMap<Long, List<Long>> inoutIdMap = new HashMap<Long, List<Long>>(rowIds.size());
            try (DataSet queryDataSet = DB.queryDataSet((String)"selectRelReportId", (DBRoute)DBRouteConst.TMC, (String)inoutQuerySql, (Object[])new Object[0]);){
                for (Row row : queryDataSet) {
                    Long inoutId = row.getLong("fentryid");
                    List reportIds = inoutIdMap.computeIfAbsent(inoutId, v -> new ArrayList());
                    reportIds.add(row.getLong("frelateplanreportid"));
                }
            }
            return inoutIdMap;
        }
    }
}

