/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inspection;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BillStatusEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.enums.InspectionTargetType;
import kd.tmc.fpm.business.domain.enums.InspectionType;
import kd.tmc.fpm.business.domain.model.inspection.ControlRepairInfo;
import kd.tmc.fpm.business.domain.model.inspection.header.RepairHeader;
import kd.tmc.fpm.business.mvc.controller.impl.InspectionController;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.formplugin.domain.inspection.ErrorInfo;

public class ErrorBizBillInfoPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
IFpmFormView {
    public void showErrMessage(List<String> errMessageList) {
        this.getView().showMessage(String.join((CharSequence)";", errMessageList));
    }

    public void showSuccessMessage(String successMessage) {
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDataEntry();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"btn_repair"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "dorepair": {
                this.doRepair();
                break;
            }
        }
    }

    private void doRepair() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (Objects.isNull(selectRows) || selectRows.length == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4fee\u590d\u3002", (String)"ErrorBizBillInfoPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            return;
        }
        RepairHeader header = new RepairHeader();
        header.setInspectionLogId((Long)this.getModel().getValue("inspectlogid"));
        header.setInspectionConfigId((Long)this.getModel().getValue("inspectconfigid"));
        header.setInspectionType((InspectionType)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("inspecttype")), InspectionType.class));
        header.setInspectionScope((InspectionScope)ITypeEnum.getByNumber((String)((String)this.getModel().getValue("inspectscope")), InspectionScope.class));
        ControlRepairInfo controlRepairInfo = null;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i : selectRows) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            InspectionRepairResult repairResult = (InspectionRepairResult)ITypeEnum.getByNumber((String)entry.getString("repairresult"), InspectionRepairResult.class);
            if (EmptyUtil.isEmpty((Object)repairResult) || repairResult.isRepaired()) continue;
            String inspectTarget = entry.getString("inspectiontarget");
            if (controlRepairInfo == null) {
                controlRepairInfo = new ControlRepairInfo((InspectionTargetType)ITypeEnum.getByNumber((String)inspectTarget, InspectionTargetType.class));
                controlRepairInfo.setEntityType((String)entry.getDynamicObject("bizbill").getPkValue());
                controlRepairInfo.setLogDetailEntryId(Long.valueOf(entry.getLong("originentryid")));
                controlRepairInfo.setInspectionTargetType(InspectionTargetType.getByCode((String)inspectTarget));
                header.addControlRepairInfo(controlRepairInfo);
            }
            Long entryId = entry.getLong("originentryid");
            Long billId = entry.getLong("bizbillid");
            ControlRepairInfo.LogBillInfo logBillInfo = new ControlRepairInfo.LogBillInfo(entryId, billId);
            controlRepairInfo.addLogBillInfo(logBillInfo);
            controlRepairInfo.setLogDetailEntryId(Long.valueOf(entry.getLong("resultdetailentryid")));
        }
        if (controlRepairInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u90fd\u5df2\u4fee\u590d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ErrorBizBillInfoPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        new InspectionController((IFpmFormView)this).repair(header);
        this.getView().returnDataToParent((Object)Boolean.TRUE);
        this.getView().close();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject clickEntryDO = (DynamicObject)entryEntity.get(hyperLinkClickEvent.getRowIndex());
        DynamicObject bizBillDO = clickEntryDO.getDynamicObject("bizbill");
        long billId = clickEntryDO.getLong("bizbillid");
        String entityType = bizBillDO.getString("number");
        BaseShowParameter showParameter = new BaseShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        showParameter.setAppId(appId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(entityType);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void initDataEntry() {
        JSONArray jsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("errorInfoList");
        String inspectionTarget = (String)this.getView().getFormShowParameter().getCustomParam("inspectionTarget");
        Long matchRuleId = (Long)this.getView().getFormShowParameter().getCustomParam("matchRuleId");
        Long systemId = (Long)this.getView().getFormShowParameter().getCustomParam("systemId");
        if (jsonArray == null) {
            return;
        }
        DynamicObject orgDim = TmcDataServiceHelper.loadSingle((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "basedata", "bodysystem"), (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId), new QFilter("basedata", "=", (Object)"Org")});
        DynamicObject matchRule = TmcDataServiceHelper.loadSingle((Object)matchRuleId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_matchrule"));
        DynamicObjectCollection dynamicObjectCollection = matchRule.getDynamicObjectCollection("entryentity");
        DynamicObject bizBill = matchRule.getDynamicObject("businessbill");
        String orgFiledName = "";
        for (DynamicObject matchRuleMappingEntry : dynamicObjectCollection) {
            Long dimensionId = matchRuleMappingEntry.getLong(String.join((CharSequence)".", "entry_dimensiondetail", "id"));
            if (!Objects.equals(orgDim.getPkValue(), dimensionId)) continue;
            orgFiledName = matchRuleMappingEntry.getString(String.join((CharSequence)".", "entry_businessbillfield"));
        }
        this.getModel().setValue("inspectlogid", this.getView().getFormShowParameter().getCustomParam("inspectlogid"));
        this.getModel().setValue("inspectconfigid", this.getView().getFormShowParameter().getCustomParam("inspectconfigid"));
        this.getModel().setValue("inspecttype", this.getView().getFormShowParameter().getCustomParam("inspecttype"));
        this.getModel().setValue("inspectscope", this.getView().getFormShowParameter().getCustomParam("inspectscope"));
        List errorInfoList = JSONObject.parseArray((String)JSON.toJSONString((Object)jsonArray), ErrorInfo.class);
        Set billIds = errorInfoList.stream().map(ErrorInfo::getBillId).collect(Collectors.toSet());
        String entityType = bizBill.getString("number");
        DynamicObject[] billDOList = TmcDataServiceHelper.load((String)entityType, (String)String.join((CharSequence)",", "id", orgFiledName, "billstatus"), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        Map<Long, DynamicObject> billDOMap = Arrays.stream(billDOList).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), v -> v, (k1, k2) -> k1));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        BillStatusProp billStatusProp = (BillStatusProp)EntityMetadataCache.getDataEntityType((String)entityType).getProperties().get((Object)"billstatus");
        BillStatusEdit billstatus = (BillStatusEdit)this.getControl("billstatus");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(billStatusProp.getStatusItems().size());
        for (BillStatusProp.StatusItemPro statusItem : billStatusProp.getStatusItems()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(statusItem.getStatusKey());
            comboItem.setCaption(statusItem.getStatusName());
            items.add(comboItem);
        }
        billstatus.setComboItems(items);
        for (ErrorInfo errorInfo : errorInfoList) {
            DynamicObject dynamicObject2 = entryEntity.addNew();
            dynamicObject2.set("resultdetailentryid", (Object)errorInfo.getResultEntryId());
            dynamicObject2.set("bizbill", (Object)bizBill);
            dynamicObject2.set("bizbillno", (Object)errorInfo.getBillNo());
            dynamicObject2.set("bizbillid", (Object)errorInfo.getBillId());
            dynamicObject2.set("originentryid", (Object)errorInfo.getEntryId());
            dynamicObject2.set("repairresult", (Object)errorInfo.getRepairResult());
            dynamicObject2.set("inspectiontarget", (Object)inspectionTarget);
            if (!billDOMap.containsKey(errorInfo.getBillId())) continue;
            DynamicObject billDO = billDOMap.get(errorInfo.getBillId());
            dynamicObject2.set("billstatus", (Object)billDO.getString("billstatus"));
            dynamicObject2.set("bizdutyorg", (Object)billDO.getString(orgFiledName + ".name"));
        }
    }
}

