/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inspection;

import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.enums.InspectionExecTypeEnum;
import kd.tmc.fpm.common.enums.InspectionScopeEnum;
import kd.tmc.fpm.common.enums.InspectionTypeEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;
import org.apache.commons.collections.CollectionUtils;

public class ExecuteInspectionPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        final DynamicObject model = (DynamicObject)this.getModel().getValue("exec_bodysystem");
        BasedataEdit periodScope = (BasedataEdit)this.getControl("exec_period_scope");
        periodScope.addBeforeF7SelectListener((BeforeF7SelectListener)new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter filter = new QFilter("bodysystem", "=", model.getPkValue());
                QFilter reportTypeQFilter = ExecuteInspectionPlugin.this.getMultiReportTypeQFilter();
                if (reportTypeQFilter != null) {
                    filter.and(reportTypeQFilter);
                }
                return 1.qFilterResultBuilder().qFilter(filter).build();
            }
        });
        BasedataEdit orgScope = (BasedataEdit)this.getControl("exec_org_scope");
        orgScope.addBeforeF7SelectListener((BeforeF7SelectListener)new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter filter = new QFilter("bodysystem", "=", model.getPkValue()).and(ModelHelper.getOrgAuthFilter((String)ExecuteInspectionPlugin.this.getView().getFormShowParameter().getAppId(), (String)"fpm_inspection_config"));
                return 2.qFilterResultBuilder().qFilter(filter).build();
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initModel();
        this.initView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opKey;
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "ok": {
                if (!this.checkTimeNonNull()) {
                    evt.setCancel(true);
                    break;
                }
                if (this.checkTimeRange()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5de1\u68c0\u6700\u591a\u652f\u6301\u4e09\u4e2a\u6708\uff0c\u5373\u5f00\u59cb\u65e5\u671f\u622a\u6b62\u65e5\u671f\u4e0d\u5141\u8bb8\u8d85\u51fa\u4e09\u4e2a\u6708\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExecuteInspectionPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    private boolean checkTimeNonNull() {
        DynamicObjectCollection value;
        Object option = this.getModel().getValue("exectype");
        if (InspectionExecTypeEnum.BY_DATE.getValue().equals(option)) {
            if (Objects.isNull(this.getModel().getValue("startdate")) || Objects.isNull(this.getModel().getValue("enddate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de1\u68c0\u65e5\u671f\u8303\u56f4\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExecuteInspectionPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (InspectionExecTypeEnum.BY_PERIOD.getValue().equals(option) && CollectionUtils.isEmpty((Collection)(value = (DynamicObjectCollection)this.getModel().getValue("exec_period_scope")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de1\u68c0\u671f\u95f4\u8303\u56f4\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExecuteInspectionPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "ok": {
                this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
                this.getView().close();
                break;
            }
        }
    }

    private void initView() {
        IFormView view = this.getView();
        Object inspectionConfigId = view.getFormShowParameter().getCustomParam("inspectionConfigId");
        DynamicObject inspectionConfig = FpmDataServiceHelper.loadSingle((String)"fpm_inspection_config", (QFilter[])new QFilter[]{new QFilter("id", "=", inspectionConfigId)});
        if (inspectionConfig == null) {
            return;
        }
        String inspectionType = inspectionConfig.getString("inspectiontype");
        String inspectionScope = inspectionConfig.getString("inspectionscope");
        if (Objects.equals(inspectionType, InspectionTypeEnum.EXEC_RECORD_INSPECTION.getValue()) && Objects.equals(inspectionScope, InspectionScopeEnum.BILL_INSPECTION.getValue())) {
            this.getModel().setValue("exectype", (Object)InspectionExecTypeEnum.BY_DATE.getValue());
        } else {
            this.getModel().setValue("exectype", (Object)InspectionExecTypeEnum.BY_PERIOD.getValue());
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bydate"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"byperiod"});
        }
        this.resetTimeRange();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "exectype": {
                this.resetTimeRange();
                break;
            }
        }
    }

    private boolean checkTimeRange() {
        LocalDate endLocalDate;
        if (!InspectionExecTypeEnum.BY_DATE.getValue().equals(this.getModel().getValue("exectype"))) {
            return true;
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        LocalDate startLocalDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Period between = Period.between(startLocalDate, endLocalDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        return between.getMonths() < 3 || between.getMonths() == 3 && between.getDays() == 0;
    }

    private void resetTimeRange() {
        Object value = this.getModel().getValue("exectype");
        Date current = new Date();
        if (Objects.equals(InspectionExecTypeEnum.BY_DATE.getValue(), value)) {
            Date lastMonth = DateUtils.getLastMonth((Date)current, (int)1);
            this.getModel().setValue("startdate", (Object)lastMonth);
            this.getModel().setValue("enddate", (Object)current);
        } else if (Objects.equals(InspectionExecTypeEnum.BY_PERIOD.getValue(), value)) {
            DynamicObject[] ids;
            DynamicObject model = (DynamicObject)this.getModel().getValue("exec_bodysystem");
            QFilter qFilter = new QFilter("bodysystem", "=", model.getPkValue());
            qFilter.and("dimtype", "=", (Object)DimensionType.PERIOD.getNumber());
            qFilter.and("startdate", "<=", (Object)current);
            qFilter.and("enddate", ">=", (Object)current);
            QFilter reportTypeQFilter = this.getMultiReportTypeQFilter();
            if (reportTypeQFilter != null) {
                qFilter.and(reportTypeQFilter);
            }
            if ((ids = TmcDataServiceHelper.load((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{qFilter})).length > 0) {
                this.getModel().setValue("exec_period_scope", (Object)Arrays.stream(ids).map(dynamicObject -> dynamicObject.get("id")).toArray());
            }
        }
    }

    private Long getSystemIdFromParent() {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            String modelId = parentView.getPageCache().get("INSPECTION_CONFIG_MODEL_CACHE_KEY");
            if (modelId == null) {
                return null;
            }
            if (modelId.contains("[")) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            return Long.parseLong(modelId);
        }
        return null;
    }

    private void initModel() {
        DynamicObject model = FpmDataServiceHelper.getBodySystemByCache((Long)this.getSystemIdFromParent());
        this.getModel().setValue("exec_bodysystem", (Object)model);
        Object[] reportTypeIds = model.getDynamicObjectCollection("applyrereportentry").stream().filter(o -> "enable".equals(o.getString("rereporttypestatus"))).map(o -> o.getDynamicObject("rerporttype").getPkValue()).toArray();
        this.getModel().setValue("exec_reporttypes", (Object)reportTypeIds);
    }

    private QFilter getMultiReportTypeQFilter() {
        DynamicObjectCollection reportTypeColl = (DynamicObjectCollection)this.getModel().getValue("exec_reporttypes");
        if (reportTypeColl == null || reportTypeColl.size() == 0) {
            return null;
        }
        QFilter reportTypeQFilter = null;
        for (DynamicObject reportType : reportTypeColl) {
            if (reportTypeQFilter == null) {
                reportTypeQFilter = this.getReportTypeQFilter(reportType.getDynamicObject("fbasedataid"));
                continue;
            }
            reportTypeQFilter.or(this.getReportTypeQFilter(reportType.getDynamicObject("fbasedataid")));
        }
        return reportTypeQFilter;
    }

    private QFilter getReportTypeQFilter(DynamicObject reportType) {
        QFilter filter = new QFilter("reporttype", "=", reportType.getPkValue());
        if (PeriodType.MONTH_WEEK.getNumber().equals(reportType.getString("orgreportcycle"))) {
            filter.and("periodtype", "in", (Object)new Object[]{PeriodType.MONTH_WEEK.getNumber(), PeriodType.YEAR_WEEK.getNumber()});
        } else {
            filter.and("periodtype", "in", (Object)new Object[]{reportType.getString("orgreportcycle")});
        }
        return filter;
    }
}

