/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inspection;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.formplugin.domain.inspection.BillInfo;

public class InspectBillInfoPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(InspectBillInfoPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDataEntry();
    }

    private void initDataEntry() {
        JSONArray billInfoJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("billInfo");
        List billInfoList = JSONObject.parseArray((String)JSON.toJSONString((Object)billInfoJsonArray), BillInfo.class);
        if (EmptyUtil.isEmpty((Collection)billInfoList)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        for (BillInfo billInfo : billInfoList) {
            String bizBIllSelectFields = String.join((CharSequence)",", "id", "billno");
            String entityType = billInfo.getEntityType();
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityType, (String)bizBIllSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", billInfo.getBillFailedMap().keySet())});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
                logger.info("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{},\u4e1a\u52a1\u5355\u636eid\uff1a{}\u90fd\u5df2\u5220\u9664", (Object)entityType, billInfo.getBillFailedMap().keySet());
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billInfo.getEntityType());
            for (DynamicObject dy : query) {
                DynamicObject entry = entryEntity.addNew();
                DynamicObject bosEB = TmcDataServiceHelper.newDynamicObject((String)"bos_entityobject");
                bosEB.set("id", (Object)billInfo.getEntityType());
                bosEB.set("number", (Object)billInfo.getEntityType());
                bosEB.set("name", (Object)dataEntityType.getDisplayName().getLocaleValue());
                entry.set("entitytype", (Object)bosEB);
                entry.set("bizbillno", (Object)dy.getString("billno"));
                long billId = dy.getLong("id");
                entry.set("bizbillid", (Object)billId);
                entry.set("failedreason", (Object)billInfo.getBillFailedMap().get(billId));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject clickEntryDO = (DynamicObject)entryEntity.get(hyperLinkClickEvent.getRowIndex());
        DynamicObject bizBillDO = clickEntryDO.getDynamicObject("entitytype");
        long billId = clickEntryDO.getLong("bizbillid");
        String entityType = bizBillDO.getString("number");
        BaseShowParameter showParameter = new BaseShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        showParameter.setAppId(appId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(entityType);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

