/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.inspection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;
import kd.tmc.fbp.formplugin.bd.TmcBaseDataEdit;
import kd.tmc.fpm.common.enums.InspectionRuleConditionEnum;
import kd.tmc.fpm.common.enums.InspectionScopeEnum;
import kd.tmc.fpm.common.enums.InspectionTypeEnum;
import kd.tmc.fpm.common.enums.MatchRuleFetchPurposeEnum;
import kd.tmc.fpm.common.property.ExecuteTimeProp;
import kd.tmc.fpm.common.property.InspectionConfigProp;
import org.apache.commons.collections.CollectionUtils;

public class InspectionConfigEdit
extends TmcBaseDataEdit {
    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getSystemIdFromParent();
        this.resetInspectionType();
        this.changeInspectionScopeDownBox();
        this.changeInspectionInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setButtonVisible();
        this.lockFieldIfPreset();
        DynamicObject execTime = this.getExecTime();
        this.fillEntryIfNeed(execTime);
        this.initInspectRuleConfig(execTime);
        this.getView().updateView("entry_preoccupation");
        this.getView().updateView("entry_actualoccupation");
    }

    private void fillEntryIfNeed(DynamicObject execTime) {
        if (execTime == null) {
            return;
        }
        DynamicObjectCollection preOccupyEntryEntity = this.getModel().getEntryEntity("entry_preoccupation");
        if (CollectionUtils.isNotEmpty((Collection)preOccupyEntryEntity)) {
            for (DynamicObject dynamicObject : preOccupyEntryEntity) {
                DynamicObject billObj = dynamicObject.getDynamicObject("entry_preocp_obj");
                if (billObj == null) continue;
                dynamicObject.set("entry_preocp_linkactbill", (Object)this.getLinkActBillsByBizObj(billObj, execTime));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"entry_preocp_ispcnclpre", "entry_preocp_inspectpre", "entry_preocp_isprlspre", "entry_actocp_inspectact", "entry_actocp_ispcnclact", "entry_actocp_isprlsact", "btn_queryexectime"});
        this.addItemClickListeners(new String[]{"tbmain"});
        this.initF7();
    }

    private void initF7() {
        this.initPreoccupationBillF7Model();
        this.initActualOccupationBillF7Model();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "queryexectime": {
                this.queryAndShowExecTime();
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "entry_preocp_inspectpre": 
            case "entry_preocp_ispcnclpre": 
            case "entry_preocp_isprlspre": 
            case "entry_actocp_inspectact": 
            case "entry_actocp_ispcnclact": 
            case "entry_actocp_isprlsact": {
                this.showAbnormalConditionConfigForm(key);
                break;
            }
        }
    }

    private void queryAndShowExecTime() {
        DynamicObject execTime = this.getExecTime();
        if (execTime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u63a7\u5236\u6267\u884c\u65f6\u673a\u914d\u7f6e\u8bb0\u5f55\u3002", (String)"InspectionConfigEdit_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setAppId("fpm");
        showParameter.setFormId("fpm_executetime");
        showParameter.setPkId(execTime.get("id"));
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("pageType", (Object)"view");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        DynamicObject execTime = this.getExecTime();
        switch (name) {
            case "inspectiontype": {
                this.changeInspectionScopeDownBox();
                break;
            }
            case "inspectionscope": {
                this.changeInspectionInfo();
                this.initInspectRuleConfig(execTime);
                break;
            }
            case "entry_preocp_inspectpre": 
            case "entry_preocp_ispcnclpre": 
            case "entry_preocp_isprlspre": 
            case "entry_actocp_inspectact": 
            case "entry_actocp_ispcnclact": 
            case "entry_actocp_isprlsact": {
                this.cleanTagIfEmpty(e);
                break;
            }
            case "entry_actocp_obj": {
                this.findMatchRule(e);
                break;
            }
            case "entry_preocp_obj": {
                this.findMatchRule(e);
                this.findLinkActBill(e, execTime);
                break;
            }
        }
    }

    private void findLinkActBill(PropertyChangedArgs e, DynamicObject execTime) {
        ChangeData[] changeSet = e.getChangeSet();
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            Object newValue = changeData.getNewValue();
            int entryCurrentRowIndex = changeData.getRowIndex();
            if (newValue == null || execTime == null) {
                this.getModel().setValue("entry_preocp_linkactbill", null, entryCurrentRowIndex);
            } else {
                DynamicObject billObj = (DynamicObject)newValue;
                this.getModel().setValue("entry_preocp_linkactbill", (Object)this.getLinkActBillsByBizObj(billObj, execTime), entryCurrentRowIndex);
            }
        }
    }

    private DynamicObjectCollection getLinkActBillsByBizObj(DynamicObject bizObj, DynamicObject execTime) {
        DynamicObjectCollection execTimePreEntry = execTime.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : execTimePreEntry) {
            if (EmptyUtil.isEmpty((DynamicObject)entry) || EmptyUtil.isEmpty((Object)entry.get("entry_businessbill")) || !Objects.equals(entry.getDynamicObject("entry_businessbill").getString("number"), bizObj.getString("number"))) continue;
            return entry.getDynamicObjectCollection("entry_actualbusinessbill");
        }
        return null;
    }

    private void findMatchRule(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (Objects.nonNull(changeSet) && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            Object newValue = changeData.getNewValue();
            String name = e.getProperty().getName();
            String entryName = (String)InspectionConfigProp.OPERATOR_FIELD_TO_ENTRY_ENTITY_MAP.get(name);
            String matchRuleProp = (String)InspectionConfigProp.ENTRY_MATCH_RULE_MAP.get(entryName);
            String linkEntityProp = (String)InspectionConfigProp.ENTRY_LINK_ENTITY_MAP.get(entryName);
            int entryCurrentRowIndex = changeData.getRowIndex();
            if (EmptyUtil.isEmpty((Object)newValue)) {
                this.getModel().setValue(matchRuleProp, null, entryCurrentRowIndex);
                this.getModel().setValue(linkEntityProp, (Object)"", entryCurrentRowIndex);
            } else {
                DynamicObject billObj = (DynamicObject)newValue;
                String billNumber = billObj.getString("number");
                DynamicObject matchRuleByBizObj = this.getMatchRuleByBizObj(billObj);
                if (matchRuleByBizObj != null) {
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
                    Map allEntities = dataEntityType.getAllEntities();
                    this.getModel().setValue(matchRuleProp, (Object)matchRuleByBizObj, entryCurrentRowIndex);
                    this.getModel().setValue(linkEntityProp, (Object)((EntityType)allEntities.get(matchRuleByBizObj.getString("linkentity"))).getDisplayName(), entryCurrentRowIndex);
                }
            }
        }
    }

    private DynamicObject getMatchRuleByBizObj(DynamicObject bizObj) {
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
        String billNumber = bizObj.getString("number");
        QFilter qFilter = new QFilter("bodysys", "=", bodySys.getPkValue()).and("businessbill", "=", (Object)billNumber);
        String selectFields = String.join((CharSequence)",", "id", "modifytime", "enable", "name", "number", "abnormalcondition", "linkentity");
        String orderBy = "enable desc,modifytime desc";
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_matchrule", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)orderBy);
        if (dynamicObjects.length != 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    private void cleanTagIfEmpty(PropertyChangedArgs e) {
        ChangeData changeData;
        String newValue;
        ChangeData[] changeSet = e.getChangeSet();
        if (Objects.nonNull(changeSet) && changeSet.length > 0 && EmptyUtil.isEmpty((String)(newValue = (String)(changeData = changeSet[0]).getNewValue()))) {
            String name = e.getProperty().getName();
            String tagProp = (String)InspectionConfigProp.OPERATOR_NAME_TAG_MAP.get(name);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex((String)InspectionConfigProp.OPERATOR_FIELD_TO_ENTRY_ENTITY_MAP.get(name));
            this.getModel().setValue(tagProp, (Object)"", entryCurrentRowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "entry_preocp_inspectpre": 
            case "entry_preocp_ispcnclpre": 
            case "entry_preocp_isprlspre": 
            case "entry_actocp_inspectact": 
            case "entry_actocp_ispcnclact": 
            case "entry_actocp_isprlsact": {
                this.receiveExpressionSet(closedCallBackEvent);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "save": {
                this.checkBeforeSave();
                break;
            }
        }
    }

    private void checkBeforeSave() {
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
        Object inspectType = this.getModel().getValue("inspectiontype");
        Object inspectScope = this.getModel().getValue("inspectionscope");
        Object number = this.getModel().getValue("number");
        QFilter qFilter = new QFilter("bodysys", "=", bodySys.getPkValue());
        qFilter.and(new QFilter("inspectiontype", "=", inspectType));
        qFilter.and(new QFilter("inspectionscope", "=", inspectScope));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("number", "!=", number));
        String selectFields = String.join((CharSequence)",", "id", "name", "number");
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_inspection_config", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        String enable = (String)this.getModel().getValue("enable");
        if (Objects.nonNull(dynamicObjects) && dynamicObjects.length > 0 && "1".equals(enable)) {
            DynamicObject dynamicObject = dynamicObjects[0];
            InspectionTypeEnum inspectionTypeEnum = InspectionTypeEnum.getByValue((String)((String)inspectType));
            InspectionScopeEnum inspectionScopeEnum = InspectionScopeEnum.getByValue((String)((String)inspectScope));
            String detailMessage = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58\u8bb0\u5f55\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u201c\u7981\u7528\u201d\uff0c\u539f\u56e0\u672c\u4f53\u7cfb\u5df2\u5b58\u5728\u53ef\u7528\u72b6\u6001\u7684\u5de1\u68c0\u7c7b\u578b\u4e3a\u3010%1$s\u3011\u4e14\u68c0\u67e5\u8303\u56f4\u4e3a\u3010%2$s\u3011\u7684\u6570\u636e\u5de1\u68c0\u914d\u7f6e\u9879\u3010%3$s %4$s\u3011\u3002", (String)"InspectionConfigEdit_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), inspectionTypeEnum.getName(), inspectionScopeEnum.getName(), dynamicObject.getString("name"), dynamicObject.getString("number"));
            this.getView().showTipNotification(detailMessage);
            this.getModel().setValue("enable", (Object)"0");
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        String entryName = (String)InspectionConfigProp.OPERATOR_FIELD_TO_ENTRY_ENTITY_MAP.get(actionId);
        if (EmptyUtil.isEmpty((String)entryName)) {
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        String expression = (String)returnData;
        InspectionRuleConditionEnum conditionEnum = InspectionRuleConditionEnum.getByFieldName((String)actionId);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)expression)) {
            this.getModel().setValue(conditionEnum.getRealField(), (Object)"", entryCurrentRowIndex);
            return;
        }
        this.getModel().setValue(conditionEnum.getTagField(), (Object)expression, entryCurrentRowIndex);
        CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)expression, CRCondition.class);
        String description = "";
        if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
            description = filterObj.getExprTran();
        }
        boolean filterConditionEmpty = Objects.isNull(filterObj.getFilterCondition()) || CollectionUtils.isEmpty((Collection)filterObj.getFilterCondition().getFilterRow());
        boolean expressionEmpty = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filterObj.getExpression());
        if (filterConditionEmpty && expressionEmpty) {
            this.getModel().setValue(conditionEnum.getTagField(), (Object)"", entryCurrentRowIndex);
        }
        if (description.length() > 1000) {
            description = description.substring(0, 999);
        }
        this.getModel().setValue(conditionEnum.getField(), (Object)description, entryCurrentRowIndex);
    }

    private void getSystemIdFromParent() {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            String modelId = parentView.getPageCache().get("INSPECTION_CONFIG_MODEL_CACHE_KEY");
            if (modelId == null) {
                return;
            }
            if (modelId.contains("[")) {
                String[] modelIdArr = modelId.replace("[", "").replace("]", "").split(",");
                modelId = modelIdArr[0].trim();
            }
            this.getModel().setValue("bodysys", (Object)modelId);
        }
    }

    private void lockFieldIfPreset() {
        Boolean isPreset = (Boolean)this.getModel().getValue("systempreset");
        if (isPreset.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"inspectionscope"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"inspectiontype"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"handletype"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
        }
    }

    private void setButtonVisible() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String enable = (String)this.getModel().getValue("enable");
        if ("1".equals(enable)) {
            this.getView().setVisible(Boolean.valueOf(status == OperationStatus.ADDNEW), new String[]{"bar_save"});
            this.setFieldEnable(status == OperationStatus.ADDNEW);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
            this.setFieldEnable(true);
        }
    }

    private void setFieldEnable(boolean fieldEnable) {
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"actual_add"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"pre_add"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"actual_del"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"pre_del"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"inspectionscope"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"inspectiontype"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"handletype"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"name"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"comment"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"notifiedstaffs"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"entry_preoccupation"});
        this.getView().setEnable(Boolean.valueOf(fieldEnable), new String[]{"entry_actualoccupation"});
    }

    private void resetInspectionType() {
        ComboEdit inspectType = (ComboEdit)this.getControl("inspectiontype");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        comboItemList.add(new ComboItem(new LocaleString(InspectionTypeEnum.EXEC_RECORD_INSPECTION.getName()), InspectionTypeEnum.EXEC_RECORD_INSPECTION.getValue()));
        inspectType.setComboItems(comboItemList);
    }

    private void changeInspectionScopeDownBox() {
        Object inspectType = this.getModel().getValue("inspectiontype");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        if (Objects.equals(inspectType, InspectionTypeEnum.EXEC_CONSISTENCY_INSPECTION.getValue())) {
            comboItemList.add(new ComboItem(new LocaleString(InspectionScopeEnum.REPORT_INSPECTION.getName()), InspectionScopeEnum.REPORT_INSPECTION.getValue()));
        } else if (Objects.equals(inspectType, InspectionTypeEnum.EXEC_RECORD_INSPECTION.getValue())) {
            comboItemList.add(new ComboItem(new LocaleString(InspectionScopeEnum.BILL_INSPECTION.getName()), InspectionScopeEnum.BILL_INSPECTION.getValue()));
        }
        ComboEdit inspectionScope = (ComboEdit)this.getControl("inspectionscope");
        inspectionScope.setComboItems(comboItemList);
    }

    private void changeInspectionInfo() {
        Object inspectType = this.getModel().getValue("inspectiontype");
        Object inspectScope = this.getModel().getValue("inspectionscope");
        if (Objects.isNull(inspectScope) || Objects.isNull(inspectType)) {
            return;
        }
        String info = null;
        if (Objects.equals(inspectType, InspectionTypeEnum.EXEC_RECORD_INSPECTION.getValue())) {
            if (Objects.equals(inspectScope, InspectionScopeEnum.BILL_INSPECTION.getValue())) {
                info = ResManager.loadKDString((String)"\u68c0\u67e5\u7b26\u5408\u6761\u4ef6\u7684\u4e1a\u52a1\u5355\u636e\u5728\u8d44\u91d1\u8ba1\u5212\u4e2d\u662f\u5426\u5b58\u5728\u76f8\u5173\u7684\u9884\u5360\u3001\u5b9e\u5360\u6267\u884c\u8bb0\u5f55\u3002", (String)"InspectionConfigEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            } else if (Objects.equals(inspectScope, InspectionScopeEnum.BILL_NOT_EXIST.getValue())) {
                info = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u800c\u5173\u8054\u6267\u884c\u8bb0\u5f55\u4ecd\u5b58\u5728\u672a\u91ca\u653e\u7684\u9884\u5360\u6216\u5b9e\u5360\u989d\u5ea6\u3002", (String)"InspectionConfigEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            }
        } else if (Objects.equals(inspectType, InspectionTypeEnum.EXEC_CONSISTENCY_INSPECTION.getValue()) && Objects.equals(inspectScope, InspectionScopeEnum.REPORT_INSPECTION.getValue())) {
            info = ResManager.loadKDString((String)"1\u3001\u6309\u7167\u7ef4\u5ea6\u7ec4\u5408\u68c0\u67e5\u6267\u884c\u8bb0\u5f55\u7d2f\u8ba1\u6267\u884c\u989d\u5ea6\u4e0e\u8ba1\u5212\u8868\u5185\u7684\u9884\u5360\u3001\u5b9e\u9645\u6267\u884c\u6570\u662f\u5426\u6709\u5dee\u5f02\uff1b2\u3001\u68c0\u67e5\u4e0a\u7ea7\u8ba1\u5212\u79d1\u76ee\u3001\u4e0a\u7ea7\u6c47\u603b\u5c42\u7ea7\u4e2d\u7684\u5b9e\u5360\u548c\u9884\u5360\u6570\u636e\u662f\u5426\u4e0e\u4e0b\u7ea7\u7d2f\u52a0\u76f8\u7b49\u3002", (String)"InspectionConfigEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"inspectioninfo", info);
    }

    private void initInspectRuleConfig(DynamicObject execTime) {
        if (execTime == null) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW) {
            return;
        }
        Object inspectType = this.getModel().getValue("inspectiontype");
        Object inspectScope = this.getModel().getValue("inspectionscope");
        if (!Objects.equals(inspectType, InspectionTypeEnum.EXEC_RECORD_INSPECTION.getValue()) || !Objects.equals(inspectScope, InspectionScopeEnum.BILL_INSPECTION.getValue())) {
            return;
        }
        this.fillEntryByExecTimeConfig("entry_preoccupation", "entryentity", execTime);
        this.fillEntryByExecTimeConfig("entry_actualoccupation", "entryentity_actual", execTime);
    }

    private void fillEntryByExecTimeConfig(String inspectionEntry, String execTimeEntry, DynamicObject execTime) {
        DynamicObjectCollection execTimePreEntry = execTime.getDynamicObjectCollection(execTimeEntry);
        this.getModel().deleteEntryData(inspectionEntry);
        String execTimeBillObjProp = (String)ExecuteTimeProp.ENTRY_ENTITY_BUSINESS_BILL_MAP.get(execTimeEntry);
        String inspectionBillObjProp = (String)InspectionConfigProp.ENTRY_BUSINESS_OBJ_MAP.get(inspectionEntry);
        String matchRuleProp = (String)InspectionConfigProp.ENTRY_MATCH_RULE_MAP.get(inspectionEntry);
        String linkEntityProp = (String)InspectionConfigProp.ENTRY_LINK_ENTITY_MAP.get(inspectionEntry);
        DynamicObjectCollection inspectionEntryColl = this.getModel().getEntryEntity(inspectionEntry);
        for (DynamicObject entry : execTimePreEntry) {
            if (EmptyUtil.isEmpty((DynamicObject)entry) || EmptyUtil.isEmpty((Object)entry.get(execTimeBillObjProp))) continue;
            DynamicObject dynamicObject = inspectionEntryColl.addNew();
            DynamicObject bizObj = entry.getDynamicObject(execTimeBillObjProp);
            dynamicObject.set(inspectionBillObjProp, (Object)bizObj);
            DynamicObject matchRuleByBizObj = this.getMatchRuleByBizObj(bizObj);
            if (matchRuleByBizObj == null) continue;
            dynamicObject.set(matchRuleProp, (Object)matchRuleByBizObj);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObj.getString("number"));
            Map allEntities = dataEntityType.getAllEntities();
            dynamicObject.set(linkEntityProp, (Object)((EntityType)allEntities.get(matchRuleByBizObj.getString("linkentity"))).getDisplayName());
            if (!"entry_preoccupation".equals(inspectionEntry)) continue;
            dynamicObject.set("entry_preocp_linkactbill", (Object)this.getLinkActBillsByBizObj(bizObj, execTime));
        }
    }

    private void initActualOccupationBillF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("entry_actocp_obj");
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<Object> objectList = this.getMatchRuledBusinessBillIdList(bodySys, obj -> true);
            QFilter businessBillFilter = new QFilter("id", "in", objectList);
            showParameter.getListFilterParameter().setFilter(businessBillFilter);
        });
    }

    private void initPreoccupationBillF7Model() {
        BasedataEdit modelBE = (BasedataEdit)this.getControl("entry_preocp_obj");
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
        modelBE.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (Objects.isNull(bodySys)) {
                this.showBodySysNotification();
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<Object> objectList = this.getMatchRuledBusinessBillIdList(bodySys, obj -> true);
            QFilter businessBillFilter = new QFilter("id", "in", objectList);
            showParameter.getListFilterParameter().setFilter(businessBillFilter);
        });
    }

    private List<Object> getMatchRuledBusinessBillIdList(DynamicObject bodySys, Predicate<Object> filter) {
        if (Objects.isNull(bodySys)) {
            return new ArrayList<Object>(2);
        }
        String selectFields = String.join((CharSequence)",", "id", "businessbill");
        QFilter qFilter = new QFilter("bodysys", "=", bodySys.getPkValue()).and(new QFilter("enable", "=", (Object)"1")).and("fetchpurpose", "=", (Object)MatchRuleFetchPurposeEnum.EXECUTE_CONTROL.getCode());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"fpm_matchrule", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getDynamicObject("businessbill").getPkValue()).filter(filter).collect(Collectors.toList());
    }

    private void showAbnormalConditionConfigForm(String name) {
        String entryName = (String)InspectionConfigProp.OPERATOR_FIELD_TO_ENTRY_ENTITY_MAP.get(name);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
        DynamicObject currentObj = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        DynamicObject billObj = currentObj.getDynamicObject((String)InspectionConfigProp.ENTRY_BUSINESS_OBJ_MAP.get(entryName));
        if (billObj == null) {
            return;
        }
        String businessBill = billObj.getString("number");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)businessBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"MatchRuleEdit_9", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        InspectionRuleConditionEnum conditionEnum = InspectionRuleConditionEnum.getByFieldName((String)name);
        this.cacheBillFields(businessBill, conditionEnum);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_abnormal_condition");
        String conditionJson = (String)this.getModel().getValue(conditionEnum.getTagField());
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", businessBill);
        showParameter.getCustomParams().put("treenodes", this.getPageCache().get(conditionEnum.getRealField()));
        showParameter.setCustomParam("non_fields", (Object)this.getPageCache().get(conditionEnum.getNotFoundStrKey()));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)businessBill);
        Map allEntities = dataEntityType.getAllEntities();
        Set entities = allEntities.entrySet().stream().filter(entry -> !(entry.getValue() instanceof EntryType)).map(Map.Entry::getKey).collect(Collectors.toSet());
        showParameter.getCustomParams().put("SELECTABLE_ENTRY_ENTITY", entities);
        String funcsXML = this.getPageCache().get(conditionEnum.getFunctionTypes());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put(conditionEnum.getFunctionTypes(), funcsXML);
        }
        showParameter.getCustomParams().put(conditionEnum.getFunctionTypes(), funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, conditionEnum.getField()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(conditionEnum.getFormCaption());
        if (conditionEnum.isHideAdvancePanel()) {
            showParameter.getCustomParams().put("SHOW_ADVANCE_PANEL", Boolean.FALSE);
        }
        this.getView().showForm(showParameter);
    }

    private void cacheBillFields(String billResource, InspectionRuleConditionEnum conditionEnum) {
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)billResource);
        if (srcMainET == null) {
            this.getPageCache().put(conditionEnum.getRealField(), "");
            return;
        }
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)srcMainET);
        option.setReadEntryEntity(false);
        option.setExprType(ExpressionType.Condition);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        String toJson = SerializationUtils.toJsonString((Object)tree);
        this.getPageCache().put(conditionEnum.getRealField(), toJson);
        String nonFdStr = this.getPageCache().get(conditionEnum.getNotFoundStrKey());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nonFdStr)) {
            this.getPageCache().put(conditionEnum.getNotFoundStrKey(), SerializationUtils.toJsonString((Object)result.getNonFields()));
            return;
        }
        Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
        nonSet.addAll(result.getNonFields());
        this.getPageCache().put(conditionEnum.getNotFoundStrKey(), SerializationUtils.toJsonString((Object)nonSet));
    }

    private DynamicObject getExecTime() {
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("bodysys");
        if (bodySys == null) {
            return null;
        }
        QFilter qFilter = new QFilter("bodysys", "=", bodySys.getPkValue());
        String selectProps = String.join((CharSequence)",", "id", String.join((CharSequence)".", "entryentity", "entry_businessbill"), String.join((CharSequence)".", "entryentity", "entry_actualbusinessbill"), String.join((CharSequence)".", "entryentity_actual", "entry_aclbusinessbill"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"fpm_executetime", (String)selectProps, (QFilter[])new QFilter[]{qFilter}, (String)"modifytime");
        if (load.length == 0) {
            return null;
        }
        return load[0];
    }

    private void showBodySysNotification() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u672c\u4fe1\u606f>\u4f53\u7cfb\u3002", (String)"ExecuteTimeEdit_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
    }
}

