/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.message;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class MessageInformPluginEdit
extends AbstractBasePlugIn {
    private static final String RADIOGROUPFIELD = "radiogroupfield";
    private static final String USERGROUP = "usergroup";
    private static final String USER = "user";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initUserGroup();
        this.initUser();
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (BTNOK.equals(key)) {
            this.executeMessage();
        }
    }

    private void executeMessage() {
        DynamicObject user;
        HashSet<Object> ids = new HashSet<Object>(16);
        String radName = (String)this.getModel().getValue(RADIOGROUPFIELD);
        if ("1".equals(radName)) {
            user = (DynamicObject)this.getModel().getValue(USERGROUP);
            if (null == user) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u7ec4", (String)"MessageInformPluginEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "=", user.getPkValue())}, null);
            Set userFieldList = queryResult.stream().map(e -> e.getLong("entryentity.userfield")).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(userFieldList)) {
                ids.addAll(userFieldList);
            }
        } else {
            user = (DynamicObject)this.getModel().getValue(USER);
            if (null == user) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237", (String)"MessageInformPluginEdit_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                return;
            }
            ids.add(user.getLong("id"));
        }
        String reportPeriod = (String)this.getView().getFormShowParameter().getCustomParam("reportperiod");
        String declareDeadline = (String)this.getView().getFormShowParameter().getCustomParam("declaredeadline");
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("reportperiod", reportPeriod);
        param.put("declaredeadline", declareDeadline);
        param.put("messageids", SerializationUtils.toJsonString(ids));
        param.put("isSelect", "true");
        this.getView().returnDataToParent(param);
        this.getView().close();
    }

    private void initUserGroup() {
        BasedataEdit userGroup = (BasedataEdit)this.getControl(USERGROUP);
        userGroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("grouptype", "like", (Object)"%,2,%");
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private void initUser() {
        BasedataEdit userGroup = (BasedataEdit)this.getControl(USER);
        userGroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }
}

