/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.query.BalanceResult;
import kd.tmc.fpm.business.domain.model.query.BalanceResultInfo;
import kd.tmc.fpm.business.domain.model.query.BalanceResultMainInfo;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ControlRepository;
import kd.tmc.fpm.business.mvc.service.IControlBizService;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.QueryDetailParam;
import kd.tmc.fpm.business.mvc.service.impl.ControlBizService;
import kd.tmc.fpm.business.mvc.service.impl.ControlContextFillBackPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ControlExecuteParamPostProcessorImpl;
import kd.tmc.fpm.business.mvc.service.impl.MatchFieldRelateMergeKeyPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ReportOrgEnableDatePostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.SubjectCheckPostProcessorImpl;
import kd.tmc.fpm.business.service.rpc.helper.GenerateControlExecLogParamHelper;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.common.utils.DateTimeUtil;

public class QueryBalancePluginEdit
extends AbstractBasePlugIn {
    private static final String PARAM_PK_VALUE = "PARAM_PK_VALUE";
    private static final String PARAM_ENTITY_NUMBER = "PARAM_ENTITY_NUMBER";
    private IControlRepository controlRepository = new ControlRepository();
    private IControlBizService bizService = new ControlBizService();
    private static final Log logger = LogFactory.getLog(QueryBalancePluginEdit.class);
    private static final Map<String, BalanceResultInfo.DimensionAndDetailType> CONFIG_MAP;

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry_entryentity");
        entryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                int row = evt.getRow();
                if (row < 0) {
                    return;
                }
                DynamicObjectCollection entryEntity = QueryBalancePluginEdit.this.getModel().getEntryEntity("entry_entryentity");
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
                QueryBalancePluginEdit.this.queryDetail(dynamicObject);
            }
        });
        this.addItemClickListeners(new String[]{"refresh"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.queryData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "refresh": {
                this.queryData();
            }
        }
    }

    private void queryData() {
        this.getModel().deleteEntryData("entry_entryentity");
        this.getModel().deleteEntryData("detail_entryentity");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object pkValue = formShowParameter.getCustomParam(PARAM_PK_VALUE);
        String entityName = (String)formShowParameter.getCustomParam(PARAM_ENTITY_NUMBER);
        DynamicObject billDynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entityName);
        this.queryData(billDynamicObject);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry_entryentity");
        entryGrid.entryRowClick(Integer.valueOf(0));
    }

    private void queryData(DynamicObject billDynamicObject) {
        ControlContext controlContext = new ControlContext();
        controlContext.addControlExecuteParamPostProcessor((IControlExecuteParamPostProcessor)new ControlContextFillBackPostProcessor());
        controlContext.addControlExecuteParamPostProcessor((IControlExecuteParamPostProcessor)new MatchFieldRelateMergeKeyPostProcessor());
        controlContext.addControlExecuteParamPostProcessor((IControlExecuteParamPostProcessor)new ControlExecuteParamPostProcessorImpl());
        controlContext.addControlExecuteParamPostProcessor((IControlExecuteParamPostProcessor)new SubjectCheckPostProcessorImpl());
        controlContext.addControlExecuteParamPostProcessor((IControlExecuteParamPostProcessor)new ReportOrgEnableDatePostProcessor());
        controlContext.setPlanExecuteOpType(PlanExecuteOpType.WRITE);
        List paramDTOList = GenerateControlExecLogParamHelper.generatePlanExecuteRecordParamsOfWrite((DynamicObject[])new DynamicObject[]{billDynamicObject}, (ControlContext)controlContext);
        if (CollectionUtils.isEmpty((Collection)paramDTOList)) {
            logger.info("\u8c03\u7528GenerateControlExecLogParamHelper.generatePlanExecuteRecordParamsOfWrite\u8fdb\u884c\u53c2\u6570\u8f6c\u6362\u540e\uff0c\u8fc7\u6ee4\u8c03\u4f8b\u5916\u6761\u4ef6\uff0c\u53c2\u6570\u4e3a\u7a7a");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u6cd5\u5339\u914d\u5230\u53ef\u7528\u7684\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u53ca\u7f16\u62a5\u4e3b\u4f53\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u5f55\u5165\u4fe1\u606f\u6216\u524d\u5f80\u201c\u8d44\u91d1\u8ba1\u5212\u201d>\u201c\u8ba1\u5212\u4f53\u7cfb\u201d>\u201c\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u201d\u8fdb\u884c\u76f8\u5173\u8bbe\u7f6e\u3002", (String)"QueryBalancePluginEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        BalanceResult balanceResult = this.bizService.queryBalance(controlContext, paramDTOList, CONFIG_MAP.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("entry_")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        logger.info("\u67e5\u8be2\u7ed3\u679c:{}", (Object)balanceResult);
        if (!balanceResult.isQuerySuccess().booleanValue()) {
            this.getView().showTipNotification(balanceResult.getErrorMessage());
            return;
        }
        Set<String> fieldSet = this.getNotVisibleFieldSet(true);
        this.setValue(balanceResult.getBalanceResultInfoList(), "entry_", prefix -> true, fieldSet);
    }

    private void setValue(List<BalanceResultInfo> balanceResultInfoList, String prefix, Predicate<String> isMain, Set<String> fieldSet) {
        logger.info("\u7ed3\u679c\u96c6:{},\u5206\u5f55\u524d\u7f00\uff1a{}\uff0c\u662f\u5426\u4e3b\u8868:{}", new Object[]{balanceResultInfoList, prefix, isMain.test(prefix)});
        if (CollectionUtils.isEmpty(balanceResultInfoList)) {
            return;
        }
        IDataModel model = this.getModel();
        int[] addRowArr = model.batchCreateNewEntryRow(this.getFieldByPrefix("entry_entryentity", prefix), balanceResultInfoList.size());
        int index = 0;
        for (BalanceResultInfo balanceResultInfo : balanceResultInfoList) {
            model.setValue(this.getFieldByPrefix("entry_dataid", prefix), (Object)balanceResultInfo.getReportDataId(), addRowArr[index]);
            model.setValue(this.getFieldByPrefix("entry_reportid", prefix), (Object)balanceResultInfo.getReportId(), addRowArr[index]);
            if (isMain.test(prefix) && balanceResultInfo instanceof BalanceResultMainInfo) {
                BalanceResultMainInfo balanceResultMainInfo = (BalanceResultMainInfo)balanceResultInfo;
                model.setValue("entry_bodysys", (Object)balanceResultMainInfo.getSystemId(), addRowArr[index]);
                model.setValue("entry_periodstrategy", (Object)balanceResultMainInfo.getPeriodControlStrategy(), addRowArr[index]);
                model.setValue("entry_controlintensity", (Object)balanceResultMainInfo.getControlIntensity(), addRowArr[index]);
                model.setValue("entry_controlcoefficient", (Object)balanceResultMainInfo.getControlCoefficient(), addRowArr[index]);
                model.setValue("entry_detailcontrolbasis", (Object)balanceResultMainInfo.getDetailControlBasis(), addRowArr[index]);
                model.setValue("entry_amtunit", (Object)balanceResultMainInfo.getAmtUnit(), addRowArr[index]);
            }
            model.setValue(this.getFieldByPrefix("entry_planamt", prefix), (Object)balanceResultInfo.getPlanAmt(), addRowArr[index]);
            model.setValue(this.getFieldByPrefix("entry_lockamt", prefix), (Object)balanceResultInfo.getLockAmt(), addRowArr[index]);
            model.setValue(this.getFieldByPrefix("entry_realamt", prefix), (Object)balanceResultInfo.getFactAmt(), addRowArr[index]);
            model.setValue(this.getFieldByPrefix("entry_availableamt", prefix), (Object)balanceResultInfo.getPlanAmt().subtract(balanceResultInfo.getLockAmt()).subtract(balanceResultInfo.getFactAmt()), addRowArr[index]);
            Map dimensionValueMap = balanceResultInfo.getDimensionValueMap();
            for (Map.Entry entry : dimensionValueMap.entrySet()) {
                Object opType;
                String fieldName = (String)entry.getKey();
                Object value = entry.getValue();
                if (EmptyUtil.isEmpty(value)) continue;
                if (fieldName.equals("detail_opusername") && Objects.isNull(opType = model.getValue("detail_opusertype", addRowArr[index]))) {
                    model.setValue("detail_opusertype", dimensionValueMap.get("detail_opusertype"), addRowArr[index]);
                }
                fieldSet.remove(fieldName);
                if (value instanceof BalanceResultInfo.DimValue) {
                    BalanceResultInfo.DimValue dimValue = (BalanceResultInfo.DimValue)value;
                    model.setValue(fieldName, dimValue.getValue(), addRowArr[index]);
                    BasedataEdit control = (BasedataEdit)this.getControl(fieldName);
                    control.setCaption(new LocaleString(dimValue.getName()));
                    continue;
                }
                if (fieldName.startsWith("detail_detailext")) {
                    Object dimensionName = balanceResultInfo.getDimensionNameMap().get(fieldName);
                    if (Objects.nonNull(dimensionName)) {
                        ((TextEdit)this.getControl(fieldName)).setCaption(new LocaleString(dimensionName.toString()));
                    }
                    if (value instanceof Date) {
                        value = DateTimeUtil.formatDate((Date)((Date)value));
                    }
                }
                model.setValue(fieldName, value, addRowArr[index]);
            }
            ++index;
        }
        if (!CollectionUtils.isEmpty(fieldSet)) {
            logger.info("\u9690\u85cf\u4e3a\u7a7a\u7684\u5b57\u6bb5\u5217:{}", fieldSet);
            this.getView().setVisible(Boolean.FALSE, fieldSet.toArray(new String[0]));
        }
    }

    private String getFieldByPrefix(String defaultField, String prefix) {
        if (defaultField.startsWith(prefix)) {
            return defaultField;
        }
        return defaultField.replace("entry_", prefix);
    }

    private Set<String> getNotVisibleFieldSet(boolean isMain) {
        if (isMain) {
            return Collections.emptySet();
        }
        Set<String> fieldSet = CONFIG_MAP.keySet().stream().filter(fieldName -> fieldName.startsWith("detail_")).collect(Collectors.toSet());
        fieldSet.add("detail_extmem1");
        fieldSet.add("detail_extmem2");
        fieldSet.add("detail_extmem3");
        return fieldSet;
    }

    private void queryDetail(DynamicObject dynamicObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        Long systemId = (Long)dynamicObject.getDynamicObject("entry_bodysys").getPkValue();
        Map queryBalanceMappingWithoutEntry = DimensionMappingHelper.getQueryBalanceExtraMappingWithoutEntry((Long)systemId);
        QueryDetailParam queryDetailParam = QueryDetailParam.builder().reportId(Long.valueOf(dynamicObject.getLong("entry_reportid"))).reportDataId((Object)dynamicObject.getLong("entry_dataid")).systemId((Object)systemId).dimensionValMap(CONFIG_MAP.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("entry_")).collect(Collectors.toMap(Map.Entry::getValue, entry -> dynamicObject.getDynamicObject((String)entry.getKey()).getPkValue()))).configMap(CONFIG_MAP.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("detail_")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).build();
        for (Map.Entry extraMappingEntry : queryBalanceMappingWithoutEntry.entrySet()) {
            String dimType = (String)extraMappingEntry.getKey();
            String controlName = (String)extraMappingEntry.getValue();
            queryDetailParam.getConfigMap().put(controlName, new BalanceResultInfo.DimensionAndDetailType(DetailDimType.getDimsionByNumber((String)dimType)));
        }
        logger.info("\u660e\u7ec6\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)queryDetailParam);
        BalanceResult balanceResult = this.bizService.queryBalanceDetail(queryDetailParam);
        logger.info("\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)balanceResult);
        this.getModel().deleteEntryData("detail_entryentity");
        if (!balanceResult.isQuerySuccess().booleanValue()) {
            this.getView().showTipNotification(balanceResult.getErrorMessage());
            return;
        }
        List balanceResultInfoList = balanceResult.getBalanceResultInfoList();
        if (CollectionUtils.isEmpty((Collection)balanceResultInfoList)) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
        Set<String> notVisibleFieldSet = this.getNotVisibleFieldSet(false);
        notVisibleFieldSet.addAll(queryBalanceMappingWithoutEntry.values());
        this.getView().setVisible(Boolean.TRUE, notVisibleFieldSet.toArray(new String[0]));
        this.setValue(balanceResultInfoList, "detail_", prefix -> false, notVisibleFieldSet);
    }

    static {
        HashMap<String, BalanceResultInfo.DimensionAndDetailType> dimensionAndDetailTypeMap = new HashMap<String, BalanceResultInfo.DimensionAndDetailType>(16);
        dimensionAndDetailTypeMap.put("entry_orgmem", new BalanceResultInfo.DimensionAndDetailType(DimensionType.ORG));
        dimensionAndDetailTypeMap.put("entry_currencymem", new BalanceResultInfo.DimensionAndDetailType(DimensionType.CURRENCY));
        dimensionAndDetailTypeMap.put("entry_subjectmem", new BalanceResultInfo.DimensionAndDetailType(DimensionType.SUBJECTS));
        dimensionAndDetailTypeMap.put("entry_periodmem", new BalanceResultInfo.DimensionAndDetailType(DimensionType.PERIOD));
        dimensionAndDetailTypeMap.put("detail_settletypemem", new BalanceResultInfo.DimensionAndDetailType(DimensionType.SETTLEMENT_TYPE));
        dimensionAndDetailTypeMap.put("detail_subjectmem", new BalanceResultInfo.DimensionAndDetailType(DimensionType.SUBJECTS));
        dimensionAndDetailTypeMap.put("detail_companymem", new BalanceResultInfo.DimensionAndDetailType(DimensionType.COMPANY));
        dimensionAndDetailTypeMap.put("detail_extmem1", new BalanceResultInfo.DimensionAndDetailType(DimensionType.CUSTOM));
        dimensionAndDetailTypeMap.put("detail_extmem2", new BalanceResultInfo.DimensionAndDetailType(DimensionType.CUSTOM));
        dimensionAndDetailTypeMap.put("detail_extmem3", new BalanceResultInfo.DimensionAndDetailType(DimensionType.CUSTOM));
        dimensionAndDetailTypeMap.put("detail_opusertype", new BalanceResultInfo.DimensionAndDetailType(DetailDimType.CONNTERPARTY_TYPE));
        dimensionAndDetailTypeMap.put("detail_opusername", new BalanceResultInfo.DimensionAndDetailType(DetailDimType.COUNTERPARTY_NAME));
        dimensionAndDetailTypeMap.put("detail_bankcate", new BalanceResultInfo.DimensionAndDetailType(DetailDimType.BANK_CATE));
        dimensionAndDetailTypeMap.put("detail_businesspartner", new BalanceResultInfo.DimensionAndDetailType(DetailDimType.BUSINESS_PARTNER));
        dimensionAndDetailTypeMap.put("detail_contractno", new BalanceResultInfo.DimensionAndDetailType(DetailDimType.CONTRACT_NO));
        dimensionAndDetailTypeMap.put("detail_contractname", new BalanceResultInfo.DimensionAndDetailType(DetailDimType.CONTRACT_NAME));
        dimensionAndDetailTypeMap.put("detail_plandate", new BalanceResultInfo.DimensionAndDetailType(DetailDimType.PLAN_DATE));
        dimensionAndDetailTypeMap.put("detail_bankaccount", new BalanceResultInfo.DimensionAndDetailType(DetailDimType.BANK_ACCOUNT));
        CONFIG_MAP = Collections.unmodifiableMap(dimensionAndDetailTypeMap);
    }
}

