/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InternalOffsetStateType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.controller.IAnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AnalysisReportManageController;
import kd.tmc.fpm.business.mvc.view.IAnalysisReportManageView;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.business.spread.command.generator.ReportInitializationGenerator;
import kd.tmc.fpm.business.spread.export.excel.impl.FundPosFormsExportImpl;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.widget.ContextMenuItemsEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.utils.system.DefaultModelHelper;
import org.apache.commons.lang3.StringUtils;

public class FundPositionTableReportPlugin
extends AbstractSpreadPlugin
implements IAnalysisReportManageView,
SearchListener {
    private static final Log logger = LogFactory.getLog(FundPositionTableReportPlugin.class);
    private IAnalysisReportManageController controller;

    public void search(SearchEvent searchEvent) {
        AnalysisHeader header;
        ReportQueryParam reportQueryParam = searchEvent.getRepotParam();
        boolean success = this.getAnalysisHeader(reportQueryParam, header = new AnalysisHeader());
        if (!success) {
            return;
        }
        this.getOrCreateReportController().loadAnalysisReport(AnalysisReportType.POSITION, header);
        this.getModel().setValue("exratetable", (Object)header.getExchangeRateTableId());
        this.getModel().setValue("exchangeratedate", (Object)header.getExchangeRateDate());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap", "exportexcel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"print"});
    }

    public void initialize() {
        super.initialize();
        this.initF7Widget();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportFilter custFilterCont = (ReportFilter)this.getControl("reportfilterap");
        custFilterCont.addSearchListener((SearchListener)this);
        this.handleCustomDimension();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("exportexcel".equals(opKey)) {
            AnalysisHeader header = new AnalysisHeader();
            boolean success = this.getAnalysisHeader(null, header);
            if (!success) {
                return;
            }
            FundPosFormsExportImpl exportExcel = new FundPosFormsExportImpl(header);
            Tuple exportResult = exportExcel.export();
            if (((Boolean)exportResult.item1).booleanValue()) {
                this.getView().download((String)exportResult.item2);
            } else {
                this.showErrMessage(Collections.singletonList(exportResult.item2));
            }
        } else if ("refresh".equals(opKey)) {
            ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
            control.search();
        } else if ("print".equals(opKey)) {
            this.getSpreadCommandInvoker().print();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList<ContextMenuItemsEnum> hideItems = new ArrayList<ContextMenuItemsEnum>(4);
        hideItems.add(ContextMenuItemsEnum.PASTEALL);
        hideItems.add(ContextMenuItemsEnum.CLEARCONTENTS);
        new InitialToolbarAndRightKeyItemGenerator(null, hideItems).generatorChain(this.getSpreadCommandInvoker()).execCommand();
        Long systemId = DefaultModelHelper.getAnalysisReportDefaultSystemId(this.getView().getFormShowParameter().getAppId(), "fpm_fundpositiontable");
        if (EmptyUtil.isNoEmpty((Long)systemId)) {
            this.initBodySystem(systemId);
        }
        this.handleCustomDimension();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changedata = e.getChangeSet()[0];
        Object newValue = changedata.getNewValue();
        switch (propName) {
            case "bodysystem": {
                if (newValue == null) {
                    return;
                }
                this.getModel().setValue("reporttype", null);
                this.getModel().setValue("period", null);
                this.getModel().setValue("org", null);
                this.getModel().setValue("flow", (Object)FlowEnum.NONLIMIT.getValue());
                this.getModel().setValue("subjects", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("company", null);
                this.getModel().setValue("settlementmethod", null);
                this.getModel().setValue("containdetailreporttype", (Object)false);
                DynamicObject bodysystem = (DynamicObject)newValue;
                this.initBodySystem(bodysystem.getPkValue());
                this.getModel().setValue("custommember1", null);
                this.getModel().setValue("custommember2", null);
                this.getModel().setValue("custommember3", null);
                this.handleCustomDimension();
                DefaultModelHelper.save((Long)bodysystem.getPkValue());
                break;
            }
            case "reporttype": {
                if (newValue == null) {
                    return;
                }
                DynamicObject reportType = (DynamicObject)newValue;
                String detailReportType = reportType.getString("orgreporttype");
                this.getView().setEnable(Boolean.valueOf(EmptyUtil.isNotEmpty((CharSequence)detailReportType)), new String[]{"containdetailreporttype"});
                this.getModel().setValue("containdetailreporttype", (Object)Boolean.FALSE);
                this.getModel().setValue("period", null);
                break;
            }
            case "flow": {
                if (FlowEnum.NONLIMIT.getValue().equals(newValue)) break;
                DynamicObjectCollection subjectList = new DynamicObjectCollection();
                DynamicObjectCollection subjects = (DynamicObjectCollection)this.getModel().getValue("subjects");
                for (DynamicObject subject : subjects) {
                    if (!subject.getString("fbasedataid.flow").equals(newValue)) continue;
                    subjectList.add((Object)subject);
                }
                if (subjectList.size() < 1) {
                    subjectList = null;
                }
                this.getModel().setValue("subjects", (Object)subjectList);
                break;
            }
            case "amountunit": {
                ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
                control.addSearchListener((SearchListener)this);
                control.search();
                break;
            }
        }
    }

    public void refreshBook(Book book) {
        if (null == book) {
            String err = ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u5b9a\u5236\u6a21\u677f\u6570\u636e\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"TemplateManageBasePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(err));
            return;
        }
        int maxRow = Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxrow", Integer.class)).map(o -> o).orElseGet(() -> 0);
        int maxCol = Optional.ofNullable(FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"maxcol", Integer.class)).map(o -> o).orElseGet(() -> 0);
        List maxRows = Sheet.generateIntegerNumByScope((Integer)maxRow);
        List maxCols = Sheet.generateIntegerNumByScope((Integer)maxCol);
        SpreadCommandInvoker invoker = this.getSpreadCommandInvoker();
        ISpreadCommand spreadCommand = new ReportInitializationGenerator(maxRows, maxCols).generatorChain(this.getSpreadCommandInvoker(), book);
        spreadCommand.appendTailCommand((AbsSpreadCommand)new LockSheetCmdChain(invoker, Collections.singletonList("Sheet1"), true));
        spreadCommand.execCommand();
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxrow", book.getSheet().getRows().stream().max(Integer::compareTo).get());
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"maxcol", book.getSheet().getCols().stream().max(Integer::compareTo).get());
    }

    public void refreshAnalysisBook(Book book) {
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"ReportPlanPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMessage) {
        if (null != successMessage) {
            this.getView().showSuccessNotification(successMessage);
        }
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void initAnalysisTpl(ReportTemplate template) {
    }

    private IAnalysisReportManageController getOrCreateReportController() {
        if (null == this.controller) {
            this.controller = new AnalysisReportManageController((IAnalysisReportManageView)this);
        }
        return this.controller;
    }

    protected String getSpreadKey() {
        return "spreadap";
    }

    public void rebuildSpreadJs(String json) {
        this.getSpreadCommandInvoker().rebuildSpread(json);
    }

    private void initF7Widget() {
        IDataModel model = this.getModel();
        String errTip1 = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"FundPositionTableReportPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        String errTip2 = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7f16\u62a5\u7c7b\u578b\u3002", (String)"FundPositionTableReportPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        BasedataEdit bodysystemEdit = (BasedataEdit)this.getControl("bodysystem");
        bodysystemEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter systemAuthFilter = ModelHelper.getSystemAuthWithCheckManagerFilter((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_fundpositiontable");
            showParameter.getListFilterParameter().setFilter(systemAuthFilter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit reportTypeEdit = (BasedataEdit)this.getControl("reporttype");
        reportTypeEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            List rerporttypeids = bodysystem.getDynamicObjectCollection("applyrereportentry").stream().map(o -> o.getDynamicObject("rerporttype").getPkValue()).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", rerporttypeids);
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("period");
        periodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject reporttype = (DynamicObject)model.getValue("reporttype");
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            if (reporttype == null) {
                throw new KDBizException(errTip2);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue()).and("reporttype", "=", reporttype.getPkValue());
            String periodType = reporttype.getString("orgreportcycle");
            if (PeriodType.MONTH_WEEK.getNumber().equals(periodType)) {
                filter.and("periodtype", "in", (Object)new Object[]{PeriodType.YEAR.getNumber(), PeriodType.MONTH_WEEK.getNumber(), PeriodType.YEAR_WEEK.getNumber()});
            } else {
                filter.and("periodtype", "in", (Object)new Object[]{periodType});
            }
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            filter.and(ModelHelper.getOrgAuthWithCheckManagerFilter((String)appId, (String)"fpm_fundpositiontable"));
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit subjectsEdit = (BasedataEdit)this.getControl("subjects");
        subjectsEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String flow = (String)model.getValue("flow");
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            filter.and("flow", "!=", (Object)FlowEnum.BALANCE.getValue());
            if (!FlowEnum.NONLIMIT.getValue().equals(flow)) {
                filter.and("flow", "=", (Object)flow);
            }
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit currencyEdit = (BasedataEdit)this.getControl("currency");
        currencyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit reportCurrencyEdit = (BasedataEdit)this.getControl("reportcurrency");
        reportCurrencyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit companyEdit = (BasedataEdit)this.getControl("company");
        companyEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        BasedataEdit settlementmethodEdit = (BasedataEdit)this.getControl("settlementmethod");
        settlementmethodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject bodysystem = (DynamicObject)model.getValue("bodysystem");
            if (bodysystem == null) {
                throw new KDBizException(errTip1);
            }
            QFilter filter = new QFilter("bodysystem", "=", bodysystem.getPkValue());
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setShowTitle(false);
        });
        MulBasedataEdit fundPositionEdit = (MulBasedataEdit)this.getControl("fundpositionacct");
        fundPositionEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"fpm", (String)"fpm_report", (String)"47150e89000000ac");
            if (CollectionUtils.isEmpty((Collection)orgIds)) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String sql1 = "select fdataid from t_bd_accountbanks_U where fuseorgid in (" + StringUtils.join((Object[])orgIds.toArray(), (String)",") + ");";
            List dataIdList = (List)DB.query((DBRoute)DBRouteConst.SYS, (String)sql1, resultSet -> {
                ArrayList<Long> haveCount = new ArrayList<Long>(100);
                while (resultSet.next()) {
                    haveCount.add(resultSet.getLong(1));
                }
                return haveCount;
            });
            if (CollectionUtils.isEmpty((Collection)dataIdList)) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter filter2 = new QFilter("id", "in", (Object)dataIdList);
            QFilter filter1 = new QFilter("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().getQFilters().add(filter1);
            showParameter.getListFilterParameter().getQFilters().add(filter2);
            showParameter.setCustomParam("isclearcorefilter", (Object)"false");
            showParameter.setCaption(ResManager.loadKDString((String)"\u5934\u5bf8\u8d26\u6237", (String)"FundPositionTableReportPlugin_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            showParameter.setShowTitle(false);
            logger.info(String.format("\u5934\u5bf8\u6761\u4ef6: %s", orgIds.toString()));
        });
    }

    private void initBodySystem(Object pkValue) {
        String prop = String.join((CharSequence)",", "id", "applyrereportentry.rereporttypestatus", "applyrereportentry.rerporttype.id", "applyrereportentry.rerporttype.orgreportcycle", "currency.id");
        DynamicObjectCollection bodySystem = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        if (CollectionUtils.isEmpty((Collection)bodySystem)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)bodySystem.get(0);
        long bodySysPk = dynamicObject.getLong("id");
        this.getModel().setValue("bodysystem", (Object)bodySysPk);
        QFilter memberFilter = new QFilter("bodysystem", "=", (Object)bodySysPk).and("number", "!=", (Object)DimensionType.PERIOD.getNumber());
        DynamicObjectCollection dimtypes = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,number,name", (QFilter[])new QFilter[]{memberFilter}, (String)"id");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"company", "settlementmethod"});
        boolean companyVisible = false;
        boolean settlementVisible = false;
        for (DynamicObject dimtype : dimtypes) {
            String number = dimtype.getString("number");
            if (DimensionType.COMPANY.getNumber().equals(number)) {
                companyVisible = true;
                continue;
            }
            if (DimensionType.SETTLEMENT_TYPE.getNumber().equals(number)) {
                settlementVisible = true;
                continue;
            }
            if (!companyVisible || !settlementVisible) continue;
            break;
        }
        this.getView().setVisible(Boolean.valueOf(companyVisible), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(settlementVisible), new String[]{"settlementmethod"});
        Optional<DynamicObject> reportTypeOptional = bodySystem.stream().filter(item -> "enable".equals(item.getString("applyrereportentry.rereporttypestatus"))).findFirst();
        if (reportTypeOptional.isPresent()) {
            DynamicObject reportTypeObj = reportTypeOptional.get();
            long reportTypeId = reportTypeObj.getLong("applyrereportentry.rerporttype.id");
            String periodType = reportTypeObj.getString("applyrereportentry.rerporttype.orgreportcycle");
            this.getModel().setValue("reporttype", (Object)reportTypeId);
            QFilter filter = new QFilter("bodysystem", "=", (Object)bodySysPk).and("reporttype", "=", (Object)reportTypeId);
            filter.and("periodtype", "=", (Object)periodType);
            filter.and("startdate", "<=", (Object)new Date());
            DynamicObjectCollection periodMems = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"longnumber desc");
            if (!CollectionUtils.isEmpty((Collection)periodMems)) {
                this.getModel().setValue("period", (Object)new Long[]{((DynamicObject)periodMems.get(0)).getLong("id")});
            }
        }
        QFilter qFilter = new QFilter("sourceid", "=", (Object)dynamicObject.getLong("currency.id"));
        qFilter.and(new QFilter("bodysystem", "=", (Object)bodySysPk));
        qFilter.and(new QFilter("dimtype", "=", (Object)DimensionType.CURRENCY.getNumber()));
        DynamicObject targetCurrency = QueryServiceHelper.queryOne((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{qFilter});
        this.getModel().setValue("reportcurrency", (Object)Optional.ofNullable(targetCurrency).map(o -> o.getLong("id")).orElseGet(() -> null));
    }

    private boolean getAnalysisHeader(ReportQueryParam reportQueryParam, AnalysisHeader header) {
        DynamicObjectCollection companys;
        DynamicObjectCollection currencys;
        if (Objects.isNull(reportQueryParam)) {
            reportQueryParam = ReportCacheManager.getInstance().getCache().getReportQueryParam(this.getView().getPageId());
        }
        Map<String, Object> filterItemMap = reportQueryParam.getFilter().getFilterItems().stream().filter(o -> o.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, o -> o.getValue(), (a, b) -> a));
        DynamicObject bodysystem = (DynamicObject)filterItemMap.get("bodysystem");
        DynamicObjectCollection fundPositions = (DynamicObjectCollection)filterItemMap.get("fundpositionacct");
        DynamicObject reporttype = (DynamicObject)filterItemMap.get("reporttype");
        DynamicObjectCollection periods = (DynamicObjectCollection)filterItemMap.get("period");
        DynamicObject reportcurrency = (DynamicObject)filterItemMap.get("reportcurrency");
        if (bodysystem == null || fundPositions == null || reporttype == null || periods == null || reportcurrency == null) {
            String err = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"FundPositionTableReportPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            this.showErrMessage(Collections.singletonList(err));
            return false;
        }
        String state = null != filterItemMap.get("internaloffsetstate") ? filterItemMap.get("internaloffsetstate").toString() : InternalOffsetStateType.BEFOREOFFSET.getNumber();
        header.setInternalOffsetState(state);
        Long systemId = bodysystem.getLong("id");
        header.setBodySystemId(systemId);
        header.setReportTypeId(Long.valueOf(reporttype.getLong("id")));
        List periodIds = periods.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        header.setPeriodId(periodIds);
        boolean isContainDeatilReport = (Boolean)filterItemMap.get("containdetailreporttype");
        header.setContainDetailReportType(isContainDeatilReport);
        DynamicObjectCollection mainReports = (DynamicObjectCollection)filterItemMap.get("org");
        if (Objects.nonNull(mainReports)) {
            List mainReportIds = mainReports.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setOrg(mainReportIds);
        }
        String flow = (String)filterItemMap.get("flow");
        header.setFlow(flow);
        DynamicObjectCollection planAccts = (DynamicObjectCollection)filterItemMap.get("subjects");
        if (Objects.nonNull(planAccts)) {
            List subjectsIds = planAccts.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setSubjects(subjectsIds);
        }
        if (Objects.nonNull(currencys = (DynamicObjectCollection)filterItemMap.get("currency"))) {
            List currencyIds = currencys.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setCurrency(currencyIds);
        }
        header.setReportCurrency(Long.valueOf(reportcurrency.getLong("id")));
        if (Objects.nonNull(fundPositions)) {
            List fundPositionIds = fundPositions.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setFundPositionAcctIds(fundPositionIds);
        }
        if (Objects.nonNull(companys = (DynamicObjectCollection)filterItemMap.get("company"))) {
            List companyIds = companys.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setCompany(companyIds);
        }
        boolean displaycurrency = (Boolean)filterItemMap.get("displaycurrency");
        header.setDisplaycurrency(displaycurrency);
        DynamicObjectCollection settlementmethods = (DynamicObjectCollection)filterItemMap.get("settlementmethod");
        if (Objects.nonNull(settlementmethods)) {
            List settlementmethodIds = settlementmethods.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            header.setSettlementMethod(settlementmethodIds);
        }
        HashMap<String, List<Long>> customMember = new HashMap<String, List<Long>>(8);
        header.setCustomDimension(customMember);
        String amountunit = (String)this.getModel().getValue("amountunit");
        header.setAmountUnit(AmountUnit.getByNumber((String)amountunit));
        Object custom1 = filterItemMap.get("custommember1");
        Object custom2 = filterItemMap.get("custommember2");
        Object custom3 = filterItemMap.get("custommember3");
        if (Objects.isNull(custom1) && Objects.isNull(custom2) && Objects.isNull(custom3)) {
            return true;
        }
        this.handleCustomHeader(customMember, (DynamicObjectCollection)filterItemMap.get("custommember1"));
        this.handleCustomHeader(customMember, (DynamicObjectCollection)filterItemMap.get("custommember2"));
        this.handleCustomHeader(customMember, (DynamicObjectCollection)filterItemMap.get("custommember3"));
        return true;
    }

    private void handleCustomHeader(Map<String, List<Long>> customMember, DynamicObjectCollection custom) {
        if (!CollectionUtils.isEmpty((Collection)custom)) {
            DynamicObject dimension = (DynamicObject)((DynamicObject)custom.get(0)).get("dimension");
            List memberIds = custom.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            customMember.put(dimension.getString("number"), memberIds);
        }
    }

    private void handleCustomDimension() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"custommember1", "custommember2", "custommember3"});
        DynamicObject bodysystem = (DynamicObject)this.getModel().getValue("bodysystem");
        if (bodysystem == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        String selectProp = "id,number,basedata,name,memberfrom,relbasedata";
        DynamicObjectCollection customDimension = QueryServiceHelper.query((String)"fpm_dimension", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", bodysystem.getPkValue()), new QFilter("basedata", "=", (Object)DimsionEnums.CUSTOM.getNumber())});
        if (CollectionUtils.isEmpty((Collection)customDimension)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"custommember1", "custommember2", "custommember3"});
            return;
        }
        int index = 1;
        for (DynamicObject dimension : customDimension) {
            String customName = "custommember" + index;
            String name = dimension.getString("name");
            String dimType = dimension.getString("basedata");
            Long dimId = dimension.getLong("id");
            BasedataEdit mulBasedataEdit = (BasedataEdit)this.getControl(customName);
            mulBasedataEdit.setCaption(new LocaleString(name));
            mulBasedataEdit.addBeforeF7SelectListener(item -> {
                ListShowParameter showParameter = (ListShowParameter)item.getFormShowParameter();
                QFilter qFilter = new QFilter("dimension", "=", dimId).and("dimtype", "=", (Object)dimType).and("bodysystem", "=", bodysystem.getPkValue()).and("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            });
            ++index;
        }
        for (int i = index; i < 4; ++i) {
            String customName = "custommember" + i;
            this.getView().setVisible(Boolean.FALSE, new String[]{customName});
            this.getModel().setValue(customName, null);
        }
    }
}

