/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.factory.LinkSearchSubParamFactory;
import kd.tmc.fpm.common.param.LinkSearchSubParam;

public class LinkSubReportEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final Log LOGGER = LogFactory.getLog(LinkSubReportEdit.class);
    private Map<String, String> childPageIds = new HashMap<String, String>();
    private LinkSearchSubParam linkSearchSubParam;

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAllList();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String entityNumber = closedCallBackEvent.getActionId();
        String pageId = this.getPageId(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            this.closePage(entityNumber);
        }
    }

    private void showAllList() {
        this.childPageIds.clear();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String searchEntity = (String)formShowParameter.getCustomParam("SEARCH_ENTITY_NAME");
        List<?> ids = this.getListParam("ENTITY_IDS");
        LOGGER.info("\u67e5\u8be2\u5b9e\u4f53\u7f16\u7801\uff1a{}\uff0c\u5b9e\u4f53id\u96c6\u5408\uff1a{}", (Object)searchEntity, ids);
        String selectProperties = "id,name,billno";
        if ("fpm_report".equals(searchEntity)) {
            selectProperties = selectProperties + ",templatebak.name,templatebak.billno";
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)searchEntity, (String)selectProperties, (QFilter[])new QFilter("id", "in", ids).toArray());
        List<DynamicObject> dynamicObjectList = Arrays.asList(load);
        LinkSearchSubParam linkSearchSubParam = this.getLinkSearchSubParam();
        if (linkSearchSubParam.showFormList(dynamicObjectList.size())) {
            LOGGER.info("\u6253\u5f00\u5217\u8868\u3002\u3002\u3002");
            this.showListForm(dynamicObjectList);
            this.putPageIds(this.childPageIds);
            return;
        }
        this.showFrom(dynamicObjectList);
        this.putPageIds(this.childPageIds);
    }

    private void showListForm(List<DynamicObject> dynamicObjectList) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("LIST_ENTITY_NAME");
        ListShowParameter listShowParameter = this.createListFormShowParameter(entityNumber, dynamicObjectList);
        if (listShowParameter != null) {
            this.getView().showForm((FormShowParameter)listShowParameter);
            this.childPageIds.put(entityNumber, listShowParameter.getPageId());
        }
    }

    private ListShowParameter createListFormShowParameter(String entityNumber, List<DynamicObject> dynamicObjectList) {
        LinkSearchSubParam linkSearchSubParam = this.getLinkSearchSubParam();
        String caption = linkSearchSubParam.getListFormCaption();
        ListShowParameter listShowParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listShowParameter.setBillFormId(entityNumber);
        listShowParameter.setFormId(this.getFormId());
        listShowParameter.setCustomParam("param_from_link_search_child", this.getView().getFormShowParameter().getCustomParam("param_from_link_search_child"));
        listShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        listFilterParameter.setFilter(new QFilter("id", "in", (Object)dynamicObjectList.stream().map(DataEntityBase::getPkValue).toArray()));
        listShowParameter.setListFilterParameter(listFilterParameter);
        listShowParameter.getOpenStyle().setTargetKey("tabap");
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        listShowParameter.setCaption(this.getCaptionOrDefault(caption, () -> EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName().toString()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
        return listShowParameter;
    }

    private String getFormId() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("LIST_FORM_ID");
        if (EmptyUtil.isEmpty((String)formId)) {
            return "bos_list";
        }
        return formId;
    }

    private void showFrom(List<DynamicObject> dynamicObjectList) {
        LinkSearchSubParam linkSearchSubParam = this.getLinkSearchSubParam();
        String showFormEntityName = (String)this.getView().getFormShowParameter().getCustomParam("FORM_ENTITY_NAME");
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjectList) {
            FormShowParameter showParameter;
            stringBuilder.delete(0, stringBuilder.length());
            String entityNumber = dynamicObject.getDataEntityType().getName();
            String cacheKey = stringBuilder.append(entityNumber).append('_').append(dynamicObject.getPkValue()).toString();
            String formCaption = linkSearchSubParam.getFormCaption(dynamicObject);
            String pageId = this.getPageId(cacheKey);
            if (StringUtils.isNotBlank((CharSequence)pageId) || (showParameter = this.createFormShowParameter(showFormEntityName, entityNumber, cacheKey, dynamicObject, formCaption)) == null) continue;
            this.getView().showForm(showParameter);
            this.childPageIds.put(cacheKey, showParameter.getPageId());
        }
    }

    private FormShowParameter createFormShowParameter(String showFormEntityName, String entityNumber, String cacheKey, DynamicObject dynamicObject, String formCaption) {
        FormShowParameter showParameter = new FormShowParameter();
        if (this.linkSearchSubParam.showBillModel() == LinkSearchSubParam.BillModel.BILL) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(dynamicObject.getPkValue());
            showParameter = billShowParameter;
        }
        showParameter.setAppId("fpm");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.setFormId(showFormEntityName);
        showParameter.setCustomParam("report_id", dynamicObject.getPkValue());
        showParameter.setCustomParam("transParamFilterInfo", this.getView().getFormShowParameter().getCustomParam("transParamFilterInfo"));
        showParameter.setCustomParam("param_from_link_search_child", this.getView().getFormShowParameter().getCustomParam("param_from_link_search_child"));
        showParameter.setCaption(this.getCaptionOrDefault(formCaption, () -> EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName().toString()));
        showParameter.getOpenStyle().setTargetKey("tabap");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, cacheKey);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setHasRight(true);
        this.linkSearchSubParam.customFormShowParameter(showParameter);
        return showParameter;
    }

    private String getCaptionOrDefault(String formCaption, Supplier<String> defaultCaption) {
        if (EmptyUtil.isEmpty((String)formCaption)) {
            return defaultCaption.get();
        }
        return formCaption;
    }

    private String getPageId(String cacheKey) {
        Map<String, String> pageIds = this.getPageIds();
        return pageIds.get(cacheKey);
    }

    private void closePage(String cacheKey) {
        Map<String, String> pageIds = this.getPageIds();
        if (pageIds.containsKey(cacheKey)) {
            pageIds.remove(cacheKey);
        }
        if (pageIds.isEmpty()) {
            this.getView().close();
        } else {
            this.putPageIds(pageIds);
        }
    }

    private void putPageIds(Map<String, String> childPageIds) {
        this.getPageCache().put("pageids", SerializationUtils.toJsonString(childPageIds));
    }

    private Map<String, String> getPageIds() {
        String cacheValue = this.getPageCache().get("pageids");
        return StringUtils.isBlank((CharSequence)cacheValue) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
    }

    private LinkSearchSubParam getLinkSearchSubParam() {
        if (Objects.isNull(this.linkSearchSubParam)) {
            String className = (String)this.getView().getFormShowParameter().getCustomParam("LINK_SEARCH_SUB_PARAM");
            this.linkSearchSubParam = LinkSearchSubParamFactory.getLinkSearchSubReportParam((String)className);
        }
        if (Objects.isNull(this.linkSearchSubParam)) {
            String errorMessage = ResManager.loadKDString((String)"\u83b7\u53d6\u8054\u67e5\u5b50\u8868\u53c2\u6570\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u8054\u67e5\u5b50\u8868\u53c2\u6570\u5b9e\u73b0\u7c7b\u53c2\u6570\u3002", (String)"LinkSubReportEdit_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMessage);
        }
        return this.linkSearchSubParam;
    }

    private List<?> getListParam(String key) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam(key);
        if (!JSONArray.class.isInstance(customParam)) {
            String errorMessage = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\uff0c\u4f20\u5165\u53c2\u6570\u4e0d\u662fJSONArray\u5b9e\u4f8b\u3002", (String)"LinkSubReportEdit_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMessage);
        }
        JSONArray jsonArray = (JSONArray)customParam;
        ArrayList<Map> list = new ArrayList<Map>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object o = jsonArray.get(i);
            if (!(o instanceof JSONObject)) {
                return jsonArray;
            }
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Map map = (Map)jsonObject.toJavaObject(Map.class);
            list.add(map);
        }
        return list;
    }
}

