/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ExecRecordShowTypeEnum;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.report.LimitRecordDTO;
import kd.tmc.fpm.business.domain.model.report.LinkExecRecordParamDTO;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.controller.IReportLinkExecRecordManageController;
import kd.tmc.fpm.business.mvc.controller.impl.ReportLinkExecRecordManageController;
import kd.tmc.fpm.business.mvc.view.IReportLinkExecRecordView;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.enums.LinkSearchSubTypeEnum;
import kd.tmc.fpm.common.property.ReportLinkExecRecordProp;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ReportLinkExecRecordPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
SearchListener,
RowClickEventListener,
IReportLinkExecRecordView {
    private IReportLinkExecRecordManageController iReportLinkExecRecordManageController;
    private Map<String, List<DynamicObject>> dimTypeAndDimMap;
    private Map<Long, List<Long>> dimId2MemberMap;

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName;
        switch (fieldName = hyperLinkClickEvent.getFieldName()) {
            case "limit_billnohyperlink": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("limit_entry");
                DynamicObject clickEntryDO = (DynamicObject)entryEntity.get(hyperLinkClickEvent.getRowIndex());
                DynamicObject reportDO = clickEntryDO.getDynamicObject("limit_billno");
                String reportType = clickEntryDO.getString("limit_report_type");
                this.showReport(reportType, (Long)reportDO.getPkValue());
                break;
            }
            case "exec_bizbillcode": {
                ReportList execRecordReportList = (ReportList)this.getControl("reportllistap");
                DynamicObject execRecordData = execRecordReportList.getReportModel().getRowData(hyperLinkClickEvent.getRowIndex());
                Long execBizBillId = execRecordData.getLong("exec_bizbillid");
                String execBizType = execRecordData.getDynamicObject("exec_billbiztype").getString("number");
                this.showBillForm(execBizType, execBizBillId);
                break;
            }
            case "detail_bizbillcode": {
                ReportList detailReportList = (ReportList)this.getControl("reportlistap");
                DynamicObject rowData = detailReportList.getReportModel().getRowData(hyperLinkClickEvent.getRowIndex());
                Long bizBillId = rowData.getLong("detail_bizbillid");
                String bizType = rowData.getDynamicObject("detail_billbiztype").getString("number");
                this.showBillForm(bizType, bizBillId);
                break;
            }
            case "detail_billno": {
                this.showExecPlan(hyperLinkClickEvent);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit periodField = (MulBasedataEdit)this.getControl("period");
        periodField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit orgField = (MulBasedataEdit)this.getControl("org");
        orgField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit subjectFiled = (MulBasedataEdit)this.getControl("subjects");
        subjectFiled.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit currencyField = (MulBasedataEdit)this.getControl("currency");
        currencyField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit companyField = (MulBasedataEdit)this.getControl("company");
        companyField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit settlementField = (MulBasedataEdit)this.getControl("settlement");
        settlementField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit customDim1Field = (MulBasedataEdit)this.getControl("custom1");
        customDim1Field.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit customDim2Field = (MulBasedataEdit)this.getControl("custom2");
        customDim2Field.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit customDim3Field = (MulBasedataEdit)this.getControl("custom3");
        customDim3Field.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid limitEntryGrid = (EntryGrid)this.getControl("limit_entry");
        limitEntryGrid.addRowClickListener((RowClickEventListener)this);
        limitEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        ReportList execRecordReportList = (ReportList)this.getControl("reportllistap");
        ReportList detailRecordReportList = (ReportList)this.getControl("reportlistap");
        execRecordReportList.addHyperClickListener((HyperLinkClickListener)this);
        detailRecordReportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        ReportFilter custFilterCont = (ReportFilter)this.getControl("reportfilterap");
        custFilterCont.addSearchListener((SearchListener)this);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
    }

    public void afterCreateNewData(EventObject e) {
        String planQueryScope;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.isNull(formShowParameter.getParentPageId()) || Objects.isNull(formShowParameter.getCustomParams()) || formShowParameter.getCustomParams().size() <= 1) {
            return;
        }
        Long systemId = (Long)formShowParameter.getCustomParam("bodysystem");
        this.getModel().setValue("bodysystem", (Object)systemId);
        this.getModel().setValue("reporttype", formShowParameter.getCustomParam("reporttype"));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"bodysystem", "reporttype"});
        List<Long> periodList = (List<Long>)formShowParameter.getCustomParam("period");
        if (CollectionUtils.isEmpty((Collection)periodList)) {
            periodList = this.getDimValByFormParam(this.getDimIdByDimType(systemId, DimensionType.PERIOD).get(0));
        }
        this.getModel().setValue("period", (Object)periodList.toArray(new Long[0]));
        List<Long> reportOrgList = (List<Long>)formShowParameter.getCustomParam("org");
        if (CollectionUtils.isEmpty((Collection)reportOrgList)) {
            reportOrgList = this.getDimValByFormParam(this.getDimIdByDimType(systemId, DimensionType.ORG).get(0));
        }
        this.getModel().setValue("org", (Object)reportOrgList.toArray(new Long[0]));
        List<Long> subjectValList = this.getDimValByFormParam(this.getDimIdByDimType(systemId, DimensionType.SUBJECTS).get(0));
        this.getModel().setValue("subjects", (Object)subjectValList.toArray(new Long[0]));
        List<Long> currencyValList = this.getDimValByFormParam(this.getDimIdByDimType(systemId, DimensionType.CURRENCY).get(0));
        this.getModel().setValue("currency", (Object)currencyValList.toArray(new Long[0]));
        Boolean companyVisibleFlag = Boolean.FALSE;
        List<DynamicObject> companyDimDyList = this.getDimInfoByDimType(systemId, DimensionType.COMPANY);
        if (EmptyUtil.isNoEmpty(companyDimDyList)) {
            List<Long> companyValList = this.getDimValByFormParam(companyDimDyList.get(0).getLong("id"));
            this.getModel().setValue("company", (Object)companyValList.toArray(new Long[0]));
            BasedataEdit customFilterDim = (BasedataEdit)this.getControl("company");
            customFilterDim.setCaption(new LocaleString(companyDimDyList.get(0).getString("name")));
            companyVisibleFlag = Boolean.TRUE;
        }
        this.getView().setVisible(companyVisibleFlag, new String[]{"company"});
        Boolean settlementVisibleFlag = Boolean.FALSE;
        List<DynamicObject> settlementDimDyList = this.getDimInfoByDimType(systemId, DimensionType.SETTLEMENT_TYPE);
        if (EmptyUtil.isNoEmpty(settlementDimDyList)) {
            List<Long> settlementValList = this.getDimValByFormParam(settlementDimDyList.get(0).getLong("id"));
            this.getModel().setValue("settlement", (Object)settlementValList.toArray(new Long[0]));
            BasedataEdit customFilterDim = (BasedataEdit)this.getControl("settlement");
            customFilterDim.setCaption(new LocaleString(settlementDimDyList.get(0).getString("name")));
            settlementVisibleFlag = Boolean.TRUE;
        }
        this.getView().setVisible(settlementVisibleFlag, new String[]{"settlement"});
        this.getView().setVisible(Boolean.FALSE, ReportLinkExecRecordProp.CUSTOM_DIM_FIELDS.toArray(new String[0]));
        List<DynamicObject> customDimDOList = this.getDimInfoByDimType(systemId, DimensionType.CUSTOM);
        if (EmptyUtil.isNoEmpty(customDimDOList)) {
            for (int i = 0; i < customDimDOList.size() && i < ReportLinkExecRecordProp.CUSTOM_DIM_FIELDS.size(); ++i) {
                Long customDimId = customDimDOList.get(i).getLong("id");
                String customDimFieldKey = (String)ReportLinkExecRecordProp.CUSTOM_DIM_FIELDS.get(i);
                this.getView().setVisible(Boolean.TRUE, new String[]{customDimFieldKey});
                List<Long> dimValList = this.getDimValByFormParam(customDimId);
                this.getModel().setValue(customDimFieldKey, (Object)dimValList.toArray(new Long[0]));
                BasedataEdit customFilterDim = (BasedataEdit)this.getControl(customDimFieldKey);
                customFilterDim.setCaption(new LocaleString(customDimDOList.get(i).getString("name")));
                this.getPageCache().put(customDimFieldKey, String.valueOf(customDimId));
                this.getPageCache().put("limit_" + customDimFieldKey, String.valueOf(customDimId));
            }
        }
        if (EmptyUtil.isNoEmpty((String)(planQueryScope = (String)formShowParameter.getCustomParam("planqueryscope")))) {
            this.getModel().setValue("planqueryscope", (Object)planQueryScope);
        }
        ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
        control.search();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "period": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimensionType.PERIOD);
                break;
            }
            case "org": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimensionType.ORG);
                break;
            }
            case "subjects": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimensionType.SUBJECTS);
                break;
            }
            case "currency": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimensionType.CURRENCY);
                break;
            }
            case "company": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimensionType.COMPANY);
                break;
            }
            case "settlement": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimensionType.SETTLEMENT_TYPE);
                break;
            }
            case "custom1": 
            case "custom2": 
            case "custom3": {
                this.initMultipleListFilterVal4F7Select(beforeF7SelectEvent, DimensionType.CUSTOM);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "flow": {
                this.getModel().setValue("subjects", null);
                break;
            }
        }
    }

    protected IReportLinkExecRecordManageController getOrCreateReportController() {
        if (null == this.iReportLinkExecRecordManageController) {
            this.iReportLinkExecRecordManageController = new ReportLinkExecRecordManageController((IReportLinkExecRecordView)this);
        }
        return this.iReportLinkExecRecordManageController;
    }

    public void search(SearchEvent searchEvent) {
        ReportQueryParam reportQueryParam = searchEvent.getRepotParam();
        if (ReportLinkExecRecordPlugin.isQueryExecRecord(reportQueryParam)) {
            List<Long> reportDataIds = this.getSelectedReportDataIds();
            reportQueryParam.getCustomParam().put("reportdataids", reportDataIds);
            return;
        }
        Pair<String, LinkExecRecordParamDTO> buildPair = ReportLinkExecRecordPlugin.buildQueryParam(reportQueryParam);
        if (EmptyUtil.isNoEmpty((String)((String)buildPair.getLeft()))) {
            this.getView().showErrorNotification((String)buildPair.getLeft());
            return;
        }
        this.setCustomDimQueryParam(reportQueryParam, (LinkExecRecordParamDTO)buildPair.getValue());
        Long reportId = (Long)this.getView().getFormShowParameter().getCustomParam("reportId");
        if (EmptyUtil.isNoEmpty((Long)reportId)) {
            ((LinkExecRecordParamDTO)buildPair.getValue()).setReportId(reportId);
        }
        this.clearEntryData();
        this.getOrCreateReportController().loadLimitRecords((LinkExecRecordParamDTO)buildPair.getValue());
        this.selectAllLimitEntryRow();
        this.afterSelectLimitEntryRow(true, reportQueryParam);
    }

    public void initializeLimitEntry(List<LimitRecordDTO> limitRecordDTOList, LinkExecRecordParamDTO queryParam) {
        boolean detailPlanQueryScope;
        Map linkExecDetailMappingWithoutEntry = DimensionMappingHelper.getLinkExecDetailMappingWithoutEntry((Long)queryParam.getBodySystemId());
        boolean bl = detailPlanQueryScope = TemplateType.DETAIL == queryParam.getPlanQueryScope();
        if (CollectionUtils.isEmpty(limitRecordDTOList)) {
            this.setLimitEntryCustomDimFieldVisible(queryParam.getBodySystemId());
            this.setLimitEntryDetailPlanFieldVisible(detailPlanQueryScope, queryParam.getBodySystemId(), linkExecDetailMappingWithoutEntry);
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow("limit_entry", limitRecordDTOList.size());
        Set reportIdSet = limitRecordDTOList.stream().map(ReportData::getReportId).collect(Collectors.toSet());
        HashMap<Long, String> reportBillNOMap = new HashMap<Long, String>(reportIdSet.size());
        HashMap<Long, String> reportTypeMap = new HashMap<Long, String>(reportIdSet.size());
        String selectedFields = String.join((CharSequence)",", "billno", "id", "reportplantype");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_report", (String)selectedFields, (QFilter[])new QFilter[]{new QFilter("id", "in", reportIdSet)});
        Set sumReportIdSet = query.stream().filter(dynamicObject -> ReportPlanType.SUMPLAN.getNumber().equals(dynamicObject.getString("reportplantype"))).map(dynamicObject -> dynamicObject.getLong("id") + "").collect(Collectors.toSet());
        DynamicObjectCollection sumRecordQuery = QueryServiceHelper.query((String)"fpm_reportplansum", (String)String.join((CharSequence)",", "billno", "originalreportids"), (QFilter[])new QFilter[]{new QFilter("originalreportids", "in", sumReportIdSet)});
        Map<String, String> sumRecordNumberMap = sumRecordQuery.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("originalreportids"), dynamicObject -> dynamicObject.getString("billno"), (k1, k2) -> k1));
        Map<Long, DynamicObject> reportDOMap = query.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), v -> v, (k1, k2) -> k1));
        for (Long reportId : reportIdSet) {
            DynamicObject reportDO = reportDOMap.get(reportId);
            if (reportDO == null) continue;
            String reportType = reportDO.getString("reportplantype");
            reportTypeMap.put(reportId, reportType);
            String billNo = ReportPlanType.SUMPLAN.getNumber().equals(reportType) ? sumRecordNumberMap.get(reportId + "") : reportDO.getString("billno");
            reportBillNOMap.put(reportId, billNo);
        }
        for (int i = 0; i < limitRecordDTOList.size(); ++i) {
            LimitRecordDTO recordDTO = limitRecordDTOList.get(i);
            this.getModel().setValue("limit_org", DimensionInfoHelper.getMainDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.ORG), rows[i]);
            this.getModel().setValue("limit_period", DimensionInfoHelper.getMainDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.PERIOD), rows[i]);
            this.getModel().setValue("limit_subject", DimensionInfoHelper.getMainDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.SUBJECTS), rows[i]);
            this.getModel().setValue("limit_currency", DimensionInfoHelper.getMainDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.CURRENCY), rows[i]);
            this.getModel().setValue("limit_company", DimensionInfoHelper.getMainDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.COMPANY), rows[i]);
            this.getModel().setValue("limit_settlement", DimensionInfoHelper.getMainDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.SETTLEMENT_TYPE), rows[i]);
            this.getModel().setValue("limit_custom1", (Object)this.getCustomDimValByRecordDTO(recordDTO, "limit_custom1"), rows[i]);
            this.getModel().setValue("limit_custom2", (Object)this.getCustomDimValByRecordDTO(recordDTO, "limit_custom2"), rows[i]);
            this.getModel().setValue("limit_custom3", (Object)this.getCustomDimValByRecordDTO(recordDTO, "limit_custom3"), rows[i]);
            this.getModel().setValue("limit_planamt", (Object)recordDTO.getPlanAmt(), rows[i]);
            this.getModel().setValue("limit_lockamt", (Object)recordDTO.getLockAmt(), rows[i]);
            this.getModel().setValue("limit_actamt", (Object)recordDTO.getActAmt(), rows[i]);
            this.getModel().setValue("limit_useamt", (Object)recordDTO.getUseAmt(), rows[i]);
            this.getModel().setValue("limit_reportdataid", (Object)recordDTO.getId(), rows[i]);
            this.getModel().setValue("limit_billno", (Object)recordDTO.getReportId(), rows[i]);
            this.getModel().setValue("limit_billnohyperlink", reportBillNOMap.get(recordDTO.getReportId()), rows[i]);
            this.getModel().setValue("limit_report_type", reportTypeMap.get(recordDTO.getReportId()), rows[i]);
            this.getModel().setValue("limit_amtbase", (Object)recordDTO.getLimitCurrencyId(), rows[i]);
            if (!detailPlanQueryScope) continue;
            Object opUserTypeVal = DimensionInfoHelper.getDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.DETAILDIM, (DetailDimType)DetailDimType.CONNTERPARTY_TYPE);
            this.getModel().setValue("limit_opusertype", opUserTypeVal, rows[i]);
            if (EmptyUtil.isNoEmpty((Object)opUserTypeVal)) {
                this.getModel().setValue("limit_opusername", DimensionInfoHelper.getDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.DETAILDIM, (DetailDimType)DetailDimType.COUNTERPARTY_NAME), rows[i]);
            }
            for (Map.Entry mappingEntry : linkExecDetailMappingWithoutEntry.entrySet()) {
                String dimType = (String)mappingEntry.getKey();
                String controlName = (String)mappingEntry.getValue();
                DetailDimType detailDimType = DetailDimType.getDimsionByNumber((String)dimType);
                if (Arrays.asList(DetailDimType.COUNTERPARTY_NAME, DetailDimType.CONNTERPARTY_TYPE).contains(detailDimType)) continue;
                Object value = controlName.startsWith("limit_detailext") ? DimensionInfoHelper.getDimValDisplayName((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.DETAILDIM, (DetailDimType)detailDimType) : DimensionInfoHelper.getDimVal((List)recordDTO.getDimList(), (List)recordDTO.getDimValList(), (DimensionType)DimensionType.DETAILDIM, (DetailDimType)detailDimType);
                this.getModel().setValue(controlName, value, rows[i]);
            }
        }
        this.setLimitEntryCustomDimFieldVisible(queryParam.getBodySystemId());
        this.setLimitEntryDetailPlanFieldVisible(detailPlanQueryScope, queryParam.getBodySystemId(), linkExecDetailMappingWithoutEntry);
        this.getView().setEnable(Boolean.FALSE, new String[]{"limit_entry"});
    }

    private void showExecPlan(HyperLinkClickEvent hyperLinkClickEvent) {
        ReportList detailReportList = (ReportList)this.getControl("reportlistap");
        DynamicObject rowData = detailReportList.getReportModel().getRowData(hyperLinkClickEvent.getRowIndex());
        Long execPlanId = rowData.getLong("detail_execplanid");
        this.showBillForm("fpm_executeplan", execPlanId);
    }

    private void showBillForm(String bizType, Long bizId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        showParameter.setAppId(appId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(bizType);
        showParameter.setPkId((Object)bizId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showReport(String reportType, long reportId) {
        if (ReportPlanType.REPORTPLAN.getNumber().equals(reportType)) {
            this.showReportPlan(reportId);
        } else {
            this.showReportPlanSum(reportId);
        }
    }

    private void showReportPlanSum(long reportId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setAppId(appId);
        showParameter.setStatus(OperationStatus.VIEW);
        String originReportIds = reportId + "";
        DynamicObject query = QueryServiceHelper.queryOne((String)"fpm_reportplansum", (String)"id", (QFilter[])new QFilter[]{new QFilter("originalreportids", "=", (Object)originReportIds)});
        showParameter.setPkId((Object)query.getLong("id"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u6c47\u603b\u7f16\u62a5\u5904\u7406\u5355\u636e", (String)"ReportPlanSumShowUtil_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("fpm_reportplansum");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showReportPlan(long reportId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setAppId(appId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPkId((Object)reportId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("fpm_report");
        showParameter.setCustomParam("custom_caption", (Object)ResManager.loadKDString((String)"\u8054\u67e5\u8ba1\u5212\u7f16\u5236\u5355\u636e", (String)"ReportPlanSumPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        showParameter.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u8ba1\u5212\u7f16\u5236\u5355\u636e", (String)"ReportPlanSumPlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long systemId = (Long)this.getView().getFormShowParameter().getCustomParam("bodysystem");
        this.setLimitEntryCustomDimFieldVisible(systemId);
        this.selectAllLimitEntryRow();
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.afterSelectLimitEntryRow(false, this.getQueryParam());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "linkexecdetail": {
                this.dealLinkExecDetailOp();
                break;
            }
            case "againsearch": {
                ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
                control.search();
                break;
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        this.getModel().setValue("queryexecrecord", (Object)Boolean.FALSE);
    }

    private void selectAllLimitEntryRow() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("limit_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        int[] rows = IntStream.range(0, entryEntity.size()).toArray();
        EntryGrid entryGrid = (EntryGrid)this.getControl("limit_entry");
        entryGrid.selectRows(rows, 0);
    }

    private void afterSelectLimitEntryRow(boolean isSearchInvoke, ReportQueryParam reportQueryParam) {
        List<Long> reportDataIds = this.getSelectedReportDataIds();
        this.clearEntryDataByShowType(ReportLinkExecRecordPlugin.getExecRecordShowType(reportQueryParam));
        if (isSearchInvoke) {
            reportQueryParam.getFilter().getFilterItem("queryexecrecord").setValue((Object)Boolean.TRUE);
            reportQueryParam.getCustomParam().put("reportdataids", reportDataIds);
            return;
        }
        this.getModel().setValue("queryexecrecord", (Object)Boolean.TRUE);
        ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
        control.search();
    }

    private List<Long> getDimIdByDimType(Long systemId, DimensionType dimType) {
        List<DynamicObject> dimArr = this.getDimInfoByDimType(systemId, dimType);
        return dimArr.stream().map(dim -> dim.getLong("id")).collect(Collectors.toList());
    }

    private List<DynamicObject> getDimInfoByDimType(Long systemId, DimensionType dimType) {
        if (null == this.dimTypeAndDimMap) {
            QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId);
            DynamicObjectCollection dimDyColl = QueryServiceHelper.query((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "name", "basedata"), (QFilter[])qFilter.toArray());
            this.dimTypeAndDimMap = new HashMap<String, List<DynamicObject>>(8, 1.0f);
            dimDyColl.stream().forEach(dy -> {
                List dimDyList = this.dimTypeAndDimMap.computeIfAbsent(dy.getString("basedata"), key -> new ArrayList(1));
                dimDyList.add(dy);
            });
        }
        return this.dimTypeAndDimMap.getOrDefault(dimType.getNumber(), new ArrayList(0));
    }

    private List<Long> getDimValByFormParam(Long dimId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List selectedRowDimList = (List)formShowParameter.getCustomParam("selectedRowDimList");
        List<Long> dimValList = selectedRowDimList.stream().map(Map::values).flatMap(Collection::stream).map(jsonObject -> (ReportCalcVal)jsonObject.toJavaObject(ReportCalcVal.class)).filter(obj -> dimId.compareTo(obj.getDimensionId()) == 0).map(obj -> (Long)obj.getValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dimValList)) {
            List selectedColDimList = (List)formShowParameter.getCustomParam("selectedColDimList");
            dimValList = selectedColDimList.stream().map(Map::values).flatMap(Collection::stream).map(jsonObject -> (ReportCalcVal)jsonObject.toJavaObject(ReportCalcVal.class)).filter(obj -> dimId.compareTo(obj.getDimensionId()) == 0).map(obj -> (Long)obj.getValue()).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(dimValList)) {
            List pageDimMemberIds = (List)formShowParameter.getCustomParam("pageDimMemberIds");
            List reportOrgList = (List)formShowParameter.getCustomParam("org");
            HashSet reportOrgSet = Objects.isNull(reportOrgList) ? new HashSet(0) : new HashSet(reportOrgList);
            pageDimMemberIds.removeIf(reportOrgSet::contains);
            if (Objects.isNull(this.dimId2MemberMap)) {
                DynamicObjectCollection pageMemberDyColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "dimension.id"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pageDimMemberIds)});
                this.dimId2MemberMap = new HashMap<Long, List<Long>>(4, 1.0f);
                pageMemberDyColl.forEach(dy -> {
                    List memberIds = this.dimId2MemberMap.computeIfAbsent(dy.getLong("dimension.id"), val -> new LinkedList());
                    memberIds.add(dy.getLong("id"));
                });
            }
            if (this.dimId2MemberMap.containsKey(dimId)) {
                dimValList.addAll((Collection<Long>)this.dimId2MemberMap.get(dimId));
            }
        }
        return dimValList;
    }

    private void initMultipleListFilterVal4F7Select(BeforeF7SelectEvent beforeF7SelectEvent, DimensionType dimensionType) {
        String flow;
        Long systemId = (Long)this.getView().getFormShowParameter().getCustomParam("bodysystem");
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)dimensionType.getNumber());
        if (dimensionType == DimensionType.CUSTOM) {
            String fieldKey = beforeF7SelectEvent.getProperty().getName();
            Long customDimId = Long.valueOf(this.getPageCache().get(fieldKey));
            qFilter.and("dimension", "=", (Object)customDimId);
        }
        if (dimensionType == DimensionType.SUBJECTS && Objects.nonNull(flow = (String)this.getModel().getValue("flow")) && !Objects.equals(FlowEnum.NONLIMIT.getValue(), flow)) {
            qFilter.and("flow", "=", (Object)flow);
        }
        if (dimensionType == DimensionType.PERIOD) {
            DynamicObject reportTypeDy = (DynamicObject)this.getModel().getValue("reporttype");
            qFilter.and("reporttype", "=", reportTypeDy.getPkValue());
            String periodType = reportTypeDy.getString("orgreportcycle");
            if (PeriodType.MONTH_WEEK.getNumber().equals(periodType)) {
                qFilter.and("periodtype", "in", (Object)new Object[]{PeriodType.MONTH_WEEK.getNumber(), PeriodType.YEAR_WEEK.getNumber()});
            } else {
                qFilter.and("periodtype", "in", (Object)new Object[]{periodType});
            }
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public static ExecRecordShowTypeEnum getExecRecordShowType(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        String execRecordShowType = filterInfo.getString("showtype");
        return (ExecRecordShowTypeEnum)ITypeEnum.getByNumber((String)execRecordShowType, ExecRecordShowTypeEnum.class);
    }

    public static Pair<String, LinkExecRecordParamDTO> buildQueryParam(ReportQueryParam reportQueryParam) {
        Object settlementDyColl;
        Object companyDyColl;
        Object currencyDyColl;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        LinkExecRecordParamDTO queryParam = new LinkExecRecordParamDTO();
        FilterItemInfo systemFilterItem = filterInfo.getFilterItem("bodysystem");
        queryParam.setBodySystemId(Long.valueOf(((DynamicObject)systemFilterItem.getValue()).getLong("id")));
        FilterItemInfo reportTypeFilterItem = filterInfo.getFilterItem("reporttype");
        DynamicObject reportTypeDy = (DynamicObject)reportTypeFilterItem.getValue();
        queryParam.setReportTypeId(Long.valueOf(reportTypeDy.getLong("id")));
        FilterItemInfo periodFilterItem = filterInfo.getFilterItem("period");
        FilterItemInfo orgFilterItem = filterInfo.getFilterItem("org");
        if (Objects.isNull(periodFilterItem.getValue()) || Objects.isNull(orgFilterItem.getValue())) {
            return Pair.of((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"ReportLinkExecRecordPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), null);
        }
        List periodIds = ((DynamicObjectCollection)periodFilterItem.getValue()).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        queryParam.setPeriodIds(periodIds);
        List orgIds = ((DynamicObjectCollection)orgFilterItem.getValue()).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        queryParam.setOrgIds(orgIds);
        String flow = filterInfo.getFilterItem("flow").getString();
        flow = EmptyUtil.isEmpty((String)flow) ? FlowType.NONLIMIT.getNumber() : flow;
        queryParam.setFlow(flow);
        Object subjectDyColl = filterInfo.getFilterItem("subjects").getValue();
        if (Objects.nonNull(subjectDyColl)) {
            List subjectIds = ((DynamicObjectCollection)subjectDyColl).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            queryParam.setSubjectIds(subjectIds);
        }
        if (Objects.nonNull(currencyDyColl = filterInfo.getFilterItem("currency").getValue())) {
            List currencyIds = ((DynamicObjectCollection)currencyDyColl).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            queryParam.setCurrencyIds(currencyIds);
        }
        if (Objects.nonNull(companyDyColl = filterInfo.getFilterItem("company").getValue())) {
            List companyIds = ((DynamicObjectCollection)companyDyColl).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            queryParam.setCompanyIds(companyIds);
        }
        if (Objects.nonNull(settlementDyColl = filterInfo.getFilterItem("settlement").getValue())) {
            List settlementIds = ((DynamicObjectCollection)settlementDyColl).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            queryParam.setSettlementMethodIds(settlementIds);
        }
        String amountUnitNumber = filterInfo.getString("amountunit");
        queryParam.setAmountUnit(AmountUnit.getByNumber((String)amountUnitNumber));
        String planQueryScope = filterInfo.getString("planqueryscope");
        queryParam.setPlanQueryScope(TemplateType.getByNumber((String)planQueryScope));
        queryParam.setExecRecordShowType(ReportLinkExecRecordPlugin.getExecRecordShowType(reportQueryParam));
        return Pair.of(null, (Object)queryParam);
    }

    private Long getCustomDimValByRecordDTO(LimitRecordDTO recordDTO, String customField) {
        String customDimIdStr = this.getPageCache().get(customField);
        if (EmptyUtil.isEmpty((String)customDimIdStr)) {
            return null;
        }
        Long customDimId = Long.valueOf(customDimIdStr);
        OptionalInt dimValIdxOpt = IntStream.range(0, recordDTO.getDimList().size()).filter(idx -> DimensionType.CUSTOM == ((TemplateDim)recordDTO.getDimList().get(idx)).getDimType()).filter(idx -> customDimId.compareTo(((TemplateDim)recordDTO.getDimList().get(idx)).getDimensionId()) == 0).findAny();
        return dimValIdxOpt.isPresent() ? (Long)recordDTO.getDimValList().get(dimValIdxOpt.getAsInt()) : null;
    }

    private void clearEntryData() {
        this.getModel().deleteEntryData("limit_entry");
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "flexpanelap3"});
    }

    private void clearEntryDataByShowType(ExecRecordShowTypeEnum showType) {
        if (ExecRecordShowTypeEnum.BUSINESS_BILL_SUM == showType) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
        }
        if (ExecRecordShowTypeEnum.EXEC_RECORD_DETAIL == showType) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3"});
        }
    }

    public static boolean isQueryExecRecord(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        FilterItemInfo queryExecRecordFilterItem = filterInfo.getFilterItem("queryexecrecord");
        return queryExecRecordFilterItem.getBoolean();
    }

    private List<Long> getSelectedReportDataIds() {
        EntryGrid limitEntryGrid = (EntryGrid)this.getControl("limit_entry");
        int[] selectedRows = limitEntryGrid.getSelectRows();
        ArrayList<Long> reportDataIds = new ArrayList<Long>(selectedRows.length);
        for (int row : selectedRows) {
            Long reportDataId = (Long)limitEntryGrid.getModel().getValue("limit_reportdataid", row);
            reportDataIds.add(reportDataId);
        }
        return reportDataIds;
    }

    private void dealLinkExecDetailOp() {
        ReportList reportList = (ReportList)this.getControl("reportllistap");
        int[] rows = reportList.getEntryState().getSelectedRows();
        DynamicObject rowData = reportList.getReportModel().getRowData(rows[0]);
        Long bizBillId = rowData.getLong("exec_bizbillid");
        Long reportDataId = rowData.getLong("exec_reportdataid");
        Long bodySystemId = ((DynamicObject)this.getModel().getValue("bodysystem")).getLong("id");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)bodySystemId).and("deleteflag", "=", (Object)"0").and("bizbillid", "=", (Object)bizBillId).and(String.join((CharSequence)".", "hold_entryentity", "hold_reportdataid"), "=", (Object)reportDataId);
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"fpm_executeplan", (QFilter[])qFilter.toArray(), null, (int)-1);
        String assocBizBillIdsStr = rowData.getString("exec_assocbizbillid");
        List assocBizBillExecPlanPks = Collections.emptyList();
        if (EmptyUtil.isNoEmpty((String)assocBizBillIdsStr)) {
            String[] assocBizBillIdStrArr = assocBizBillIdsStr.split(";");
            List assocBizBillIds = Arrays.stream(assocBizBillIdStrArr).map(Long::valueOf).collect(Collectors.toList());
            QFilter assocBillQFilter = new QFilter("bodysys", "=", (Object)bodySystemId).and("deleteflag", "=", (Object)"0").and("bizbillid", "in", assocBizBillIds);
            assocBizBillExecPlanPks = QueryServiceHelper.queryPrimaryKeys((String)"fpm_executeplan", (QFilter[])assocBillQFilter.toArray(), null, (int)-1);
        }
        if (EmptyUtil.isNoEmpty((Object)pks) || EmptyUtil.isNoEmpty(assocBizBillExecPlanPks)) {
            pks.addAll(assocBizBillExecPlanPks);
            this.getView().showForm(LinkSearchSubFormHelper.createLinkSearchFormShow(LinkSearchSubFormHelper.LinkSearchFormParam.builder().formId("fpm_executeplan").searchFormNumber("fpm_executeplan").listFormId("bos_list").searchIds(pks).listForm("fpm_executeplan").linkSearchSubTypeEnum(LinkSearchSubTypeEnum.LINK_SEARCH_LIST_SHOW_DEFAULT).linkSearch(true).caption(ResManager.loadKDString((String)"\u8054\u67e5\u6267\u884c\u8bb0\u5f55\u660e\u7ec6", (String)"ReportPlanSumShowUtil_5", (String)"tmc-fpm-formplugin", (Object[])new Object[0])).build()));
        }
    }

    private void setLimitEntryDetailPlanFieldVisible(boolean isShow, Long bodySystemId, Map<String, String> linkExecDetailMappingWithoutEntry) {
        DynamicObjectCollection detailDims;
        this.getView().setVisible(Boolean.FALSE, linkExecDetailMappingWithoutEntry.values().toArray(new String[0]));
        if (isShow && EmptyUtil.isNoEmpty((DynamicObjectCollection)(detailDims = QueryServiceHelper.query((String)"fpm_detailplanfields", (String)String.join((CharSequence)",", "detaildimtype", "name"), (QFilter[])new QFilter("bodysys", "=", (Object)bodySystemId).and("isshow", "=", (Object)Boolean.TRUE).toArray())))) {
            detailDims.forEach(detailDim -> {
                String curDetailField = (String)linkExecDetailMappingWithoutEntry.get(detailDim.getString("detaildimtype"));
                if (EmptyUtil.isEmpty((String)curDetailField)) {
                    curDetailField = (String)linkExecDetailMappingWithoutEntry.get(detailDim.getString("detaildimtype").toLowerCase());
                }
                if (EmptyUtil.isEmpty((String)curDetailField)) {
                    return;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{curDetailField});
                EntryGrid grid = (EntryGrid)this.getControl("limit_entry");
                grid.setColumnProperty(curDetailField, "header", (Object)new LocaleString(detailDim.getString("name")));
            });
        }
    }

    private void setLimitEntryCustomDimFieldVisible(Long bodySystemId) {
        List<DynamicObject> settlementDimDyList;
        EntryGrid grid;
        for (String customDimFieldKey : ReportLinkExecRecordProp.CUSTOM_DIM_FIELDS) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"limit_" + customDimFieldKey});
        }
        List<DynamicObject> customDimDOList = this.getDimInfoByDimType(bodySystemId, DimensionType.CUSTOM);
        if (EmptyUtil.isNoEmpty(customDimDOList)) {
            for (int i = 0; i < customDimDOList.size() && i < ReportLinkExecRecordProp.CUSTOM_DIM_FIELDS.size(); ++i) {
                String customDimFieldKey = "limit_" + (String)ReportLinkExecRecordProp.CUSTOM_DIM_FIELDS.get(i);
                this.getView().setVisible(Boolean.TRUE, new String[]{customDimFieldKey});
                grid = (EntryGrid)this.getControl("limit_entry");
                grid.setColumnProperty(customDimFieldKey, "header", (Object)new LocaleString(customDimDOList.get(i).getString("name")));
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"limit_company", "limit_settlement"});
        List<DynamicObject> companyDimDyList = this.getDimInfoByDimType(bodySystemId, DimensionType.COMPANY);
        if (EmptyUtil.isNoEmpty(companyDimDyList)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"limit_company"});
            EntryGrid grid2 = (EntryGrid)this.getControl("limit_entry");
            grid2.setColumnProperty("limit_company", "header", (Object)new LocaleString(companyDimDyList.get(0).getString("name")));
        }
        if (EmptyUtil.isNoEmpty(settlementDimDyList = this.getDimInfoByDimType(bodySystemId, DimensionType.SETTLEMENT_TYPE))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"limit_settlement"});
            grid = (EntryGrid)this.getControl("limit_entry");
            grid.setColumnProperty("limit_settlement", "header", (Object)new LocaleString(settlementDimDyList.get(0).getString("name")));
        }
    }

    private void setCustomDimQueryParam(ReportQueryParam reportQueryParam, LinkExecRecordParamDTO queryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        HashMap customDimMemberMap = new HashMap(4, 1.0f);
        for (String customDimField : ReportLinkExecRecordProp.CUSTOM_DIM_FIELDS) {
            DynamicObjectCollection customDimValDyColl = (DynamicObjectCollection)filterInfo.getFilterItem(customDimField).getValue();
            if (EmptyUtil.isEmpty((DynamicObjectCollection)customDimValDyColl)) continue;
            List customDimValList = customDimValDyColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            Long customDimId = Long.valueOf(this.getPageCache().get(customDimField));
            customDimMemberMap.put(customDimId, customDimValList);
        }
        queryParam.setCustomDimension(customDimMemberMap);
    }

    public void showErrMessage(List<String> list) {
    }

    public void showSuccessMessage(String s) {
    }
}

