/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.formplugin.common.FpmFilterBaseList;
import org.apache.commons.collections.CollectionUtils;

public class ReportPlanManageFilterPlugin
extends FpmFilterBaseList {
    private static final String MODELID = "currModelId";

    @Override
    protected String getBodySystemProp() {
        return "bodysys";
    }

    @Override
    protected String getReportOrgProp() {
        return "reportorg";
    }

    @Override
    protected String getAuthEntityName() {
        return "fpm_report_process";
    }

    @Override
    protected void initFilterItem(FilterContainerInitArgs args) {
        super.initFilterItem(args);
    }

    @Override
    protected void initReportOrgFilter(CommonFilterColumn commonFilterColumn) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        comboItems.addAll(this.getOrgComboItem());
        commonFilterColumn.setDefaultValue("");
        commonFilterColumn.setComboItems(comboItems);
    }

    @Override
    protected boolean authSystemManager() {
        return true;
    }

    private Set<DimMember> getAllChildren(DimMember treeNode) {
        HashSet<DimMember> allChildren = new HashSet<DimMember>(10);
        this.getChildMember(treeNode, allChildren);
        return allChildren;
    }

    private void getChildMember(DimMember member, Set<DimMember> allChildren) {
        if (member != null && member.getChildren() != null) {
            allChildren.addAll(member.getChildren());
            for (DimMember child : member.getChildren()) {
                this.getChildMember(child, allChildren);
            }
        }
    }

    private Set<ComboItem> getOrgComboItem() {
        String appId = this.getView().getFormShowParameter().getAppId();
        List<Long> authMemberOrgIds = this.getAuthMemberOrgIds();
        String currModelId = this.getPageCache().get(MODELID);
        HashSet<ComboItem> comboItems = new HashSet<ComboItem>(16);
        if (null == currModelId) {
            return comboItems;
        }
        List<DimMember> dimMembers = this.loadOrgWithAllChild(authMemberOrgIds, Long.parseLong(currModelId));
        for (DimMember member : dimMembers) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(member.getName()));
            item.setValue(member.getId().toString());
            comboItems.add(item);
        }
        return comboItems;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String currModelId = this.getPageCache().get(MODELID);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("reportorg")) {
            QFilter systemFilter = currModelId != null && !StringUtils.isEmpty((Object)currModelId) ? new QFilter("bodysystem", "=", (Object)Long.valueOf(currModelId)) : new QFilter("bodysystem", "=", (Object)-1);
            Set<ComboItem> orgComboItem = this.getOrgComboItem();
            if (CollectionUtils.isNotEmpty(orgComboItem)) {
                ArrayList<QFilter> finallyQFilterList = new ArrayList<QFilter>(2);
                finallyQFilterList.add(new QFilter("id", "in", orgComboItem.stream().map(e -> Long.valueOf(e.getValue())).collect(Collectors.toSet())));
                finallyQFilterList.add(new QFilter("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()));
                finallyQFilterList.add(new QFilter("enable", "=", (Object)"1"));
                finallyQFilterList.add(systemFilter);
                args.getQfilters().clear();
                args.getQfilters().addAll(finallyQFilterList);
            }
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("viewtype"), "f7") || Objects.equals(this.getView().getFormShowParameter().getCustomParam("param_from_link_search_child"), true)) {
            return;
        }
        List qFilters = setFilterEvent.getQFilters();
        Set<ComboItem> orgComboItem = this.getOrgComboItem();
        qFilters.add(new QFilter("reportorg", "in", orgComboItem.stream().map(e -> Long.valueOf(e.getValue())).collect(Collectors.toSet())));
    }
}

