/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.tree.AbstractTmcTreeList;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.mvc.controller.IFundSystemController;
import kd.tmc.fpm.business.mvc.controller.impl.IFundSystemControllerImpl;
import kd.tmc.fpm.business.spread.export.excel.impl.ReportPlanFormsExportImpl;
import kd.tmc.fpm.common.bean.UserAuthModel;
import kd.tmc.fpm.common.helper.FpmHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.formplugin.helper.LinkSearchSubFormHelper;
import kd.tmc.fpm.utils.system.DefaultModelHelper;
import org.apache.commons.collections.CollectionUtils;

public class ReportTreeList
extends AbstractTmcTreeList {
    private static final Log logger = LogFactory.getLog(ReportTreeList.class);
    private static final String CACHE_KEY_PAGETYPE = "pageType";
    private static final String CACHE_KEY_TREE_INFO = "treeInfo:%s";
    private static final String CACHE_KEY_DIMENSION_ORG = "orgDimensionCache";
    public static final String COMMA = ",";
    private IFundSystemController fundSystemController;
    protected static final TmcTreeNodeTypeProp NODE_TYPE = new TmcTreeNodeTypeProp("type", TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    protected static final TmcTreeNodeTypeProp NODE_YEAR_TYPE = new TmcTreeNodeTypeProp("yearType", NODE_TYPE, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    protected static final TmcTreeNodeTypeProp NODE_REPORT_PERIOD_TYPE = new TmcTreeNodeTypeProp("reportPeriodType", NODE_YEAR_TYPE, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    protected static final TmcTreeNodeTypeProp NODE_REPORT_ORG_TYPE = new TmcTreeNodeTypeProp("periodOrg", NODE_REPORT_PERIOD_TYPE, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    protected static final TmcTreeNodeTypeProp NODE_REPORT_ORG_LEAF_TYPE = new TmcTreeNodeTypeProp("orgLeaf", NODE_REPORT_ORG_TYPE, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    protected static final TmcTreeNodeTypeProp NODE_REPORT_TYPE = new TmcTreeNodeTypeProp("reportType", NODE_REPORT_ORG_TYPE, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    protected static final TmcTreeNodeTypeProp NODE_LEAF = new TmcTreeNodeTypeProp("leafNode", NODE_REPORT_TYPE, TmcTreeNodeTypeProp.LeafMode.LEAF);
    boolean isRefresh = false;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_PAGETYPE);
        this.getPageCache().put(CACHE_KEY_PAGETYPE, pageType);
        Boolean isFormLinkSearchChild = (Boolean)this.getView().getFormShowParameter().getCustomParam("param_from_link_search_child");
        if (Objects.nonNull(isFormLinkSearchChild) && isFormLinkSearchChild.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap", "submit", "audit", "baritemap", "baritemap3"});
            SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
            splitContainer.hidePanel(SplitDirection.left, true);
        }
        Boolean isVisible = (Boolean)this.getView().getFormShowParameter().getCustomParam("okBtnVisible");
        if (Objects.equals(false, isVisible)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        if (this.getTreeListView() == null) {
            logger.info("this.getTreeListView()==null return filterContainerAfterSearchClick");
            return;
        }
        FilterContainer tFilterContainer = (FilterContainer)this.getControl("filtercontainerap");
        List tQFilters = tFilterContainer.getContext().getClientQueryFilterParameter().getQFilters();
        this.setBodySystem(tQFilters);
        this.isRefresh = true;
        this.forceRefreshTree();
    }

    private void setBodySystem(List<QFilter> tQFilters) {
        ArrayList<String> qFilterStrList = new ArrayList<String>(tQFilters.size());
        QFilter qFilterByKey = FpmHelper.getQFilterByKey(tQFilters, (String)"bodysys.id");
        if (qFilterByKey != null) {
            String bodySys = qFilterByKey.getValue().toString();
            this.getPageCache().put("bodysystem", bodySys);
            if (this.isReportProgress() && NumberUtils.isNumber((Object)bodySys)) {
                Dimension dimension = this.getOrCreateSystemController().loadOrgDimensionBySystemId(Long.valueOf(bodySys));
                this.getPageCache().put(CACHE_KEY_DIMENSION_ORG, FpmSerializeUtil.serialize((Object)dimension));
            }
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            List modelId = ModelHelper.getSystemAuthScope((String)appId, (String)"fpm_report");
            tQFilters.add(new QFilter("bodysys.id", "in", (Object)modelId));
            this.getPageCache().remove("bodysystem");
        }
        for (QFilter tQFilter : tQFilters) {
            qFilterStrList.add(tQFilter.toSerializedString());
        }
        if (qFilterStrList.size() != 0) {
            this.getPageCache().put("qFilters", JSON.toJSONString(qFilterStrList));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "changedeclaretime": {
                FormOperate operate = (FormOperate)args.getSource();
                operate.getOption().setVariableValue("strictvalidation", String.valueOf(true));
                break;
            }
            case "refresh": {
                this.isRefresh = true;
                break;
            }
            case "exportexcel": {
                this.beforeExportexcel(args);
                break;
            }
        }
    }

    private void beforeExportexcel(BeforeDoOperationEventArgs args) {
        List<Long> selectedIdList;
        DynamicObjectCollection reports;
        Set periodIds;
        String errMsg = null;
        if (args.getListSelectedData().size() > 300) {
            errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4ec5\u652f\u6301\u5bfc\u51fa\u5c0f\u4e8e300\u6761\u7684\u7f16\u5236\u6570\u636e\u3002", (String)"ReportTreeList_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        if ((periodIds = (reports = QueryServiceHelper.query((String)"fpm_report", (String)"id,reportperiod.id", (QFilter[])new QFilter("id", "in", selectedIdList = this.getSelectedIdList()).toArray())).stream().filter(r -> r.getLong("reportperiod.id") > 0L).map(r -> r.getLong("reportperiod.id")).collect(Collectors.toSet())).size() > 1) {
            errMsg = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u5931\u8d25\u3002\u4ec5\u652f\u6301\u540c\u4e00\u7f16\u62a5\u671f\u95f4\u7684\u8d44\u91d1\u8ba1\u5212\u8868\u6279\u91cf\u5bfc\u51fa\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u6240\u9700\u5bfc\u51fa\u7684\u8303\u56f4\u3002", (String)"ReportTreeList_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isNoEmpty((String)errMsg)) {
            args.setCancel(true);
            this.getView().showErrorNotification(errMsg);
        }
    }

    private void forceRefreshTree() {
        this.getTreeModel().getRoot().setChildren(null);
        this.getTreeListView().getTreeView().queryTreeNodeChildren("", this.getTreeModel().getRoot().getId());
        this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        switch (event.getOperateKey()) {
            case "refresh": {
                this.isRefresh = true;
                this.forceRefreshTree();
                this.getTreeListView().refresh();
                break;
            }
            case "changedeclaretime": {
                if (!event.getOperationResult().isSuccess()) {
                    return;
                }
                this.changeDeclareTime();
                break;
            }
            case "exportexcel": {
                if (!event.getOperationResult().isSuccess()) {
                    return;
                }
                List<Long> selectedIdList = this.getSelectedIdList();
                IFormView view = this.getView();
                try {
                    ReportPlanFormsExportImpl exportExcel = new ReportPlanFormsExportImpl(new HashSet<Long>(selectedIdList));
                    Tuple exportResult = exportExcel.export();
                    if (((Boolean)exportResult.item1).booleanValue()) {
                        view.download((String)exportResult.item2);
                        break;
                    }
                    view.showErrorNotification((String)exportResult.item2);
                    break;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    private void changeDeclareTime() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] primaryKeys = selectedRows.getBillListSelectedRowCollection().getPrimaryKeyValues();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId(this.getView().getFormShowParameter().getAppId());
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("fpm_modifydeclaretime");
        showParameter.setCustomParam("modify_declare_time", (Object)primaryKeys);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closecallback_decalre_time"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (actionId.equals("closecallback_decalre_time") && Objects.equals(returnData = event.getReturnData(), "success")) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"ReportTreeList_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent e) {
        ListShowParameter formShowParameter;
        Boolean isFormLinkSearchChild;
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("reportplantype", "=", (Object)"reportplan"));
        if (this.isRefresh) {
            String reportPeriodStartDateProp = "reportperiod.startdate";
            String reportPeriodNameProp = "reportperiod.name";
            String templateNameProp = "template.name";
            HashSet<String> excludeProps = new HashSet<String>(Arrays.asList(reportPeriodStartDateProp, reportPeriodNameProp, templateNameProp));
            Optional<QFilter> first = qFilters.stream().filter(item -> !excludeProps.contains(item.getProperty())).filter(item -> item.getProperty().startsWith("reportperiod") || item.getProperty().startsWith("template")).findFirst();
            if (first.isPresent()) {
                QFilter qFilter = first.get();
                qFilters.remove(qFilter);
            }
        }
        String sysIdStr = this.getPageCache().get("bodysystem");
        QFilter qFilterByKey = FpmHelper.getQFilterByKey((List)qFilters, (String)"bodysys.id");
        if (qFilterByKey != null && StringUtils.isNotEmpty((CharSequence)sysIdStr) && NumberUtils.isNumber((Object)sysIdStr)) {
            qFilterByKey.__setValue((Object)Long.parseLong(sysIdStr));
        }
        if (Objects.nonNull(isFormLinkSearchChild = (Boolean)(formShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("param_from_link_search_child")) && isFormLinkSearchChild.booleanValue()) {
            Object source = e.getSource();
            if (source instanceof BillList) {
                ListFilterParameter listFilterParameter;
                FilterParameter queryFilterParameter;
                FilterParameter clientQueryFilterParameter;
                BillList billList = (BillList)source;
                ArrayList needRemoveList = new ArrayList();
                FilterParameter filterParameter = billList.getFilterParameter();
                if (CollectionUtils.isNotEmpty((Collection)filterParameter.getQFilters())) {
                    needRemoveList.addAll(filterParameter.getQFilters());
                }
                if (CollectionUtils.isNotEmpty((Collection)(clientQueryFilterParameter = billList.getClientQueryFilterParameter()).getQFilters())) {
                    needRemoveList.addAll(clientQueryFilterParameter.getQFilters());
                }
                if (CollectionUtils.isNotEmpty((Collection)(queryFilterParameter = billList.getQueryFilterParameter()).getQFilters())) {
                    needRemoveList.addAll(queryFilterParameter.getQFilters());
                }
                if (CollectionUtils.isNotEmpty((Collection)(listFilterParameter = formShowParameter.getListFilterParameter()).getQFilters())) {
                    needRemoveList.removeAll(listFilterParameter.getQFilters());
                }
                e.getQFilters().removeAll(needRemoveList);
            } else {
                ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
                Set collect = listFilterParameter.getQFilters().stream().map(QFilter::getProperty).collect(Collectors.toSet());
                qFilters.removeIf(next -> !collect.contains(next.getProperty()));
            }
        }
    }

    protected List<TmcTreeNodeTypeProp> getTreeNodeTypeList() {
        return Arrays.asList(NODE_TYPE, NODE_YEAR_TYPE, NODE_REPORT_PERIOD_TYPE, NODE_REPORT_ORG_TYPE, NODE_REPORT_TYPE, NODE_REPORT_ORG_LEAF_TYPE, NODE_LEAF);
    }

    protected List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp currNode) {
        UserAuthModel authScopeModel;
        String bodySys = this.getPageCache().get("bodysystem");
        String pageType = this.getPageCache().get(CACHE_KEY_PAGETYPE);
        Long bodySysId = 0L;
        if (!StringUtils.isEmpty((CharSequence)bodySys) && NumberUtils.isNumber((Object)bodySys)) {
            bodySysId = Long.parseLong(bodySys);
        }
        String qFiltersStr = this.getPageCache().get("qFilters");
        List qFilterStrList = JSONArray.parseArray((String)qFiltersStr, String.class);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if (qFilterStrList != null) {
            for (String qFilterStr : qFilterStrList) {
                QFilter qFilter = QFilter.fromSerializedString((String)qFilterStr);
                qFilters.add(qFilter);
            }
        }
        if (NumberUtils.equalsZero((Long)bodySysId)) {
            QFilter qFilterByKey = FpmHelper.getQFilterByKey(qFilters, (String)"bodysys.id");
            if (qFilterByKey != null) {
                Object value = qFilterByKey.getValue();
                if (value instanceof Collection) {
                    return new ArrayList<TmcTreeNodeRefProp>(16);
                }
                bodySys = qFilterByKey.getValue().toString();
                if (bodySys.contains("[")) {
                    String[] modelIdArr = bodySys.replace("[", "").replace("]", "").split(COMMA);
                    bodySys = modelIdArr[0].trim();
                }
                if (NumberUtils.isNumber((Object)bodySys)) {
                    this.getPageCache().put("bodysystem", bodySys);
                    bodySysId = Long.parseLong(bodySys);
                    if (this.isReportProgress() && NumberUtils.isNumber((Object)bodySys)) {
                        Dimension dimension = this.getOrCreateSystemController().loadOrgDimensionBySystemId(Long.valueOf(bodySys));
                        this.getPageCache().put(CACHE_KEY_DIMENSION_ORG, FpmSerializeUtil.serialize((Object)dimension));
                    }
                }
            }
            if (NumberUtils.equalsZero((Long)bodySysId) && (bodySysId = DefaultModelHelper.queryDefaultSystemId()) != null) {
                bodySys = bodySysId.toString();
                this.getPageCache().put("bodysystem", bodySysId.toString());
                if (this.isReportProgress() && NumberUtils.isNumber((Object)bodySys)) {
                    Dimension dimension = this.getOrCreateSystemController().loadOrgDimensionBySystemId(Long.valueOf(bodySys));
                    this.getPageCache().put(CACHE_KEY_DIMENSION_ORG, FpmSerializeUtil.serialize((Object)dimension));
                }
            }
        }
        QFilter baseQFilter = new QFilter("bodysys.id", "=", (Object)bodySysId);
        String reportPeriodNameProp = "reportperiod.name";
        String templateNameProp = "template.name";
        String reportPeriodTypeId = "reportperiod.reporttype";
        String reportPeriodId = "reportperiod.id";
        String reportId = "id";
        qFilters.removeIf(item -> item.getProperty().equals(reportPeriodNameProp) || item.getProperty().equals(templateNameProp) || item.getProperty().equals(reportPeriodTypeId) || item.getProperty().equals(reportPeriodId) || item.getProperty().equals(reportId));
        ArrayList<Long> orgIdList = new ArrayList(8);
        if ("write".equals(pageType) && !(authScopeModel = ModelHelper.getAuthScopeModel((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_report")).isHasAllOrgPerm()) {
            orgIdList = authScopeModel.getOrgIds();
            baseQFilter.and(new QFilter("reportorg", "in", orgIdList));
        }
        baseQFilter.and(new QFilter("reportplantype", "=", (Object)"reportplan"));
        qFilters.add(baseQFilter);
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        if (TmcTreeNodeTypeProp.ROOT.equals((Object)nodeType)) {
            return this.loadReportTypeByRoot(qFilters);
        }
        if (NODE_YEAR_TYPE.equals((Object)nodeType)) {
            return this.loadYearNodeByCurrentNode(currNode, qFilters, nodeType);
        }
        if (NODE_REPORT_PERIOD_TYPE.equals((Object)nodeType)) {
            return this.loadReportPeriodByCurrentNode(currNode, qFilters);
        }
        if (NODE_REPORT_ORG_TYPE.equals((Object)nodeType)) {
            return this.loadReportOrgByCurrentNode(currNode, qFilters, nodeType);
        }
        if (NODE_REPORT_ORG_LEAF_TYPE.equals((Object)nodeType)) {
            return this.loadOrgLeafByCurrentNode(currNode, qFilters, orgIdList, nodeType);
        }
        if (NODE_REPORT_TYPE.equals((Object)nodeType)) {
            return this.loadReportType(currNode, qFilters);
        }
        return new ArrayList<TmcTreeNodeRefProp>(16);
    }

    private List<TmcTreeNodeRefProp> loadReportPeriodByCurrentNode(TmcTreeNodeProp currNode, List<QFilter> qFilters) {
        ArrayList<TmcTreeNodeRefProp> modelList = new ArrayList<TmcTreeNodeRefProp>(16);
        String reportTypeId = (String)currNode.getParentRefEntityPkValue(NODE_YEAR_TYPE);
        if (reportTypeId == null || "null".equals(reportTypeId)) {
            return modelList;
        }
        int currentYear = DateUtils.getYear((Date)new Date(Long.parseLong(currNode.getRefEntityPkValue().toString())));
        qFilters.add(new QFilter("reportperiod.reporttype", "=", (Object)Long.valueOf(reportTypeId)));
        String selectFields = "reportperiod.id, reportperiod.name, reportperiod.startdate";
        DynamicObjectCollection reportPeriods = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (CollectionUtils.isEmpty((Collection)reportPeriods)) {
            return modelList;
        }
        List distinctResult = reportPeriods.stream().filter(this.distinctByKey(i -> i.get("reportperiod.id"))).sorted(Comparator.comparing(o -> ((DynamicObject)o).getDate("reportperiod.startdate")).reversed()).collect(Collectors.toList());
        for (DynamicObject reportPeriod : distinctResult) {
            int year = DateUtils.getYear((Date)reportPeriod.getDate("reportperiod.startdate"));
            if (!NumberUtils.equals((Integer)currentYear, (Integer)year)) continue;
            TmcTreeNodeRefProp tmcTreeNodeRefProp = new TmcTreeNodeRefProp();
            tmcTreeNodeRefProp.setNodeName(reportPeriod.getString("reportperiod.name"));
            tmcTreeNodeRefProp.setNodeType(NODE_REPORT_ORG_TYPE);
            tmcTreeNodeRefProp.setRefEntityPkValue(reportPeriod.get("reportperiod.id"));
            modelList.add(tmcTreeNodeRefProp);
        }
        return modelList;
    }

    private List<TmcTreeNodeRefProp> loadReportOrgByCurrentNode(TmcTreeNodeProp currNode, List<QFilter> defaultFilter, TmcTreeNodeTypeProp nodeType) {
        ArrayList<TmcTreeNodeRefProp> modelList = new ArrayList<TmcTreeNodeRefProp>(16);
        String reportPeriodId = (String)currNode.getParentRefEntityPkValue(nodeType);
        if (reportPeriodId == null || "null".equals(reportPeriodId)) {
            return modelList;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(defaultFilter);
        qFilters.add(new QFilter("reportperiod.id", "=", (Object)Long.valueOf(reportPeriodId)));
        DynamicObjectCollection reportOrgList = QueryServiceHelper.query((String)"fpm_report", (String)"reportorg.id, reportorg.name, reportorg.longnumber, reportorg.sortcode, reportorg.level", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (CollectionUtils.isEmpty((Collection)reportOrgList)) {
            return modelList;
        }
        List orgList = reportOrgList.stream().filter(this.distinctByKey(i -> i.get("reportorg.id"))).sorted(this.getReportOrgComparator()).collect(Collectors.toList());
        if (this.isReportProgress()) {
            String orgDimensionJson = this.getPageCache().get(CACHE_KEY_DIMENSION_ORG);
            Dimension dimension = (Dimension)FpmSerializeUtil.deserialize((String)orgDimensionJson, Dimension.class);
            List allDimMemberList = dimension.getAllDimMemberList();
            Integer minLevel = allDimMemberList.stream().min(Comparator.comparing(o -> o.getLevel())).map(item -> item.getLevel()).orElse(0);
            Map<Integer, List<DimMember>> collect = allDimMemberList.stream().collect(Collectors.groupingBy(o -> o.getLevel()));
            if (collect.size() <= 1) {
                for (DynamicObject org : orgList) {
                    TmcTreeNodeRefProp tmcTreeNodeRefProp = new TmcTreeNodeRefProp();
                    tmcTreeNodeRefProp.setNodeName(org.getString("reportorg.name"));
                    tmcTreeNodeRefProp.setNodeType(NODE_REPORT_TYPE);
                    tmcTreeNodeRefProp.setRefEntityPkValue(org.get("reportorg.id"));
                    modelList.add(tmcTreeNodeRefProp);
                }
            } else {
                List<DimMember> dimMembers = collect.get(minLevel);
                for (DimMember org : dimMembers) {
                    TmcTreeNodeRefProp tmcTreeNodeRefProp = new TmcTreeNodeRefProp();
                    tmcTreeNodeRefProp.setNodeName(org.getName());
                    tmcTreeNodeRefProp.setNodeType(NODE_REPORT_ORG_LEAF_TYPE);
                    tmcTreeNodeRefProp.setRefEntityPkValue((Object)org.getId());
                    modelList.add(tmcTreeNodeRefProp);
                }
            }
        } else {
            for (DynamicObject org : orgList) {
                TmcTreeNodeRefProp tmcTreeNodeRefProp = new TmcTreeNodeRefProp();
                tmcTreeNodeRefProp.setNodeName(org.getString("reportorg.name"));
                tmcTreeNodeRefProp.setNodeType(NODE_REPORT_TYPE);
                tmcTreeNodeRefProp.setRefEntityPkValue(org.get("reportorg.id"));
                modelList.add(tmcTreeNodeRefProp);
            }
        }
        return modelList;
    }

    private Comparator<DynamicObject> getReportOrgComparator() {
        return (o1, o2) -> {
            String sortCode2;
            String sortCode1 = EmptyUtil.isNoEmpty((String)o1.getString("reportorg.sortcode")) ? o1.getString("reportorg.sortcode") : o1.getString("reportorg.longnumber");
            int result = sortCode1.compareTo(sortCode2 = EmptyUtil.isNoEmpty((String)o2.getString("reportorg.sortcode")) ? o2.getString("reportorg.sortcode") : o2.getString("reportorg.longnumber"));
            if (!NumberUtils.equalsZero((Integer)result)) {
                return result;
            }
            return 0;
        };
    }

    private List<TmcTreeNodeRefProp> loadOrgLeafByCurrentNode(TmcTreeNodeProp currNode, List<QFilter> defaultFilter, List<Long> orgIdList, TmcTreeNodeTypeProp nodeType) {
        ArrayList<TmcTreeNodeRefProp> modelList = new ArrayList<TmcTreeNodeRefProp>(16);
        String reportPeriodId = (String)currNode.getParentRefEntityPkValue(NODE_REPORT_ORG_TYPE);
        if (reportPeriodId == null || "null".equals(reportPeriodId)) {
            return modelList;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(8);
        if (!CollectionUtils.isEmpty(orgIdList)) {
            orgIdSet.addAll(orgIdList);
        }
        String reportOrgId = (String)currNode.getRefEntityPkValue();
        String orgDimensionJson = this.getPageCache().get(CACHE_KEY_DIMENSION_ORG);
        if (StringUtils.isEmpty((CharSequence)orgDimensionJson)) {
            return modelList;
        }
        Dimension dimension = (Dimension)FpmSerializeUtil.deserialize((String)orgDimensionJson, Dimension.class);
        List allChildMember = dimension.getDimMemberById(Long.valueOf(reportOrgId)).getChildren();
        if (!CollectionUtils.isEmpty((Collection)allChildMember)) {
            allChildMember = allChildMember.stream().filter(item -> CollectionUtils.isEmpty((Collection)orgIdSet) || orgIdSet.contains(item.getId())).sorted(Comparator.comparing(DimMember::getSortCode)).collect(Collectors.toList());
            for (DimMember org : allChildMember) {
                TmcTreeNodeRefProp tmcTreeNodeRefProp = new TmcTreeNodeRefProp();
                tmcTreeNodeRefProp.setNodeName(org.getName());
                tmcTreeNodeRefProp.setNodeType(NODE_REPORT_ORG_LEAF_TYPE);
                tmcTreeNodeRefProp.setRefEntityPkValue((Object)org.getId());
                modelList.add(tmcTreeNodeRefProp);
            }
        }
        modelList.addAll(this.loadReportType(currNode, defaultFilter));
        return modelList;
    }

    private List<TmcTreeNodeRefProp> loadYearNodeByCurrentNode(TmcTreeNodeProp currNode, List<QFilter> qFilters, TmcTreeNodeTypeProp nodeType) {
        String bodySys;
        DynamicObjectCollection periodMembers;
        ArrayList<TmcTreeNodeRefProp> modelList = new ArrayList<TmcTreeNodeRefProp>(1);
        String reportTypeId = (String)currNode.getParentRefEntityPkValue(nodeType);
        if (reportTypeId == null || "null".equals(reportTypeId)) {
            return modelList;
        }
        ArrayList allFilters = new ArrayList(10);
        qFilters.forEach(item -> FpmHelper.getAllQFilterByKey((QFilter)item, (String)"reportperiod.startdate", (List)allFilters));
        int maxYear = Integer.MIN_VALUE;
        int minYear = Integer.MAX_VALUE;
        for (QFilter filter : allFilters) {
            maxYear = Math.max(DateUtils.getYear((Date)((Date)filter.getValue())), maxYear);
            minYear = Math.min(DateUtils.getYear((Date)((Date)filter.getValue())), minYear);
        }
        if (CollectionUtils.isEmpty(allFilters)) {
            maxYear = Integer.MAX_VALUE;
            minYear = Integer.MIN_VALUE;
        }
        if (CollectionUtils.isEmpty((Collection)(periodMembers = QueryServiceHelper.query((String)"fpm_member", (String)"id, startdate", (QFilter[])new QFilter[]{new QFilter("bodysystem.id", "=", (Object)Long.valueOf(bodySys = this.getPageCache().get("bodysystem"))), new QFilter("reporttype.id", "=", (Object)Long.valueOf(reportTypeId)), new QFilter("parent.id", "=", (Object)0L)})))) {
            return modelList;
        }
        List sortPeriodMembers = periodMembers.stream().sorted(Comparator.comparing(o -> ((DynamicObject)o).getDate("startdate")).reversed()).collect(Collectors.toList());
        for (DynamicObject periodMember : sortPeriodMembers) {
            Date date = periodMember.getDate("startdate");
            int year = DateUtils.getYear((Date)date);
            if (!NumberUtils.greaterEqualsThan((Integer)year, (Integer)minYear) || !NumberUtils.lessEqualsThan((Integer)year, (Integer)maxYear)) continue;
            TmcTreeNodeRefProp tmcTreeNodeRefProp = new TmcTreeNodeRefProp();
            tmcTreeNodeRefProp.setNodeName(String.format(ResManager.loadKDString((String)"%1$s\u5e74", (String)"ReportTreeList_4", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), year));
            tmcTreeNodeRefProp.setNodeType(NODE_REPORT_PERIOD_TYPE);
            tmcTreeNodeRefProp.setRefEntityPkValue((Object)date.getTime());
            modelList.add(tmcTreeNodeRefProp);
        }
        return modelList;
    }

    private List<TmcTreeNodeRefProp> loadReportType(TmcTreeNodeProp currNode, List<QFilter> qFilters) {
        ArrayList<TmcTreeNodeRefProp> modelList = new ArrayList<TmcTreeNodeRefProp>(16);
        String reportPeriodId = (String)currNode.getParentRefEntityPkValue(NODE_REPORT_ORG_TYPE);
        if (reportPeriodId == null || "null".equals(reportPeriodId)) {
            return modelList;
        }
        String reportOrgId = (String)currNode.getRefEntityPkValue();
        qFilters.add(new QFilter("reportperiod.id", "=", (Object)Long.valueOf(reportPeriodId)));
        qFilters.add(new QFilter("reportorg.id", "=", (Object)Long.valueOf(reportOrgId)));
        String selectFields = "id, name, templatebak.ismaintable";
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (CollectionUtils.isEmpty((Collection)reports)) {
            return modelList;
        }
        List reportList = reports.stream().sorted(Comparator.comparing(o -> ((DynamicObject)o).getBoolean("templatebak.ismaintable")).reversed()).collect(Collectors.toList());
        for (DynamicObject report : reportList) {
            TmcTreeNodeRefProp tmcTreeNodeRefProp = new TmcTreeNodeRefProp();
            tmcTreeNodeRefProp.setNodeName(report.getString("name"));
            tmcTreeNodeRefProp.setNodeType(NODE_LEAF);
            tmcTreeNodeRefProp.setRefEntityPkValue((Object)report.getLong("id"));
            modelList.add(tmcTreeNodeRefProp);
        }
        return modelList;
    }

    private List<TmcTreeNodeRefProp> loadReportTypeByRoot(List<QFilter> qFilters) {
        ArrayList<TmcTreeNodeRefProp> modelList = new ArrayList<TmcTreeNodeRefProp>(16);
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)COMMA, "id", "reportperiod.id"), (QFilter[])qFilters.toArray(new QFilter[0]));
        Set reportPeriodIds = reports.stream().filter(r -> r.getLong("reportperiod.id") > 0L).map(r -> r.getLong("reportperiod.id")).collect(Collectors.toSet());
        DynamicObjectCollection periodMembers = QueryServiceHelper.query((String)"fpm_member", (String)"reporttype.id, reporttype.name, reporttype.orgreportcycle, reporttype.createtime", (QFilter[])new QFilter("id", "in", reportPeriodIds).and("reporttype.id", ">", (Object)0L).toArray());
        List periodMemberSortByReportType = periodMembers.stream().collect(Collectors.toMap(p -> p.getLong("reporttype.id"), p -> p, (p1, p2) -> p1)).values().stream().sorted((o1, o2) -> {
            PeriodType type1 = PeriodType.getByNumber((String)o1.getString("reporttype.orgreportcycle"));
            PeriodType type2 = PeriodType.getByNumber((String)o2.getString("reporttype.orgreportcycle"));
            if (type1 == null || type2 == null) {
                return 0;
            }
            if (type1 == type2) {
                Date createTime1 = o1.getDate("reporttype.createtime");
                Date createTime2 = o2.getDate("reporttype.createtime");
                return createTime1.compareTo(createTime2);
            }
            return Integer.compare(type1.ordinal(), type2.ordinal());
        }).collect(Collectors.toList());
        for (DynamicObject periodMember : periodMemberSortByReportType) {
            TmcTreeNodeRefProp tmcTreeNodeRefProp = new TmcTreeNodeRefProp();
            tmcTreeNodeRefProp.setNodeName(periodMember.getString("reporttype.name"));
            tmcTreeNodeRefProp.setNodeType(NODE_YEAR_TYPE);
            tmcTreeNodeRefProp.setRefEntityPkValue(periodMember.get("reporttype.id"));
            modelList.add(tmcTreeNodeRefProp);
        }
        return modelList;
    }

    protected QFilter getBillListFilter(TmcTreeNodeProp currNode) {
        QFilter filter = null;
        Object refId = currNode.getRefEntityPkValue();
        if (refId == null || refId.equals("null")) {
            filter = new QFilter("1", "=", (Object)1);
        } else {
            TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
            if (NODE_YEAR_TYPE.equals((Object)nodeType)) {
                String reportTypeId = (String)currNode.getParentRefEntityPkValue(NODE_YEAR_TYPE);
                filter = new QFilter("reportperiod.reporttype", "=", (Object)Long.valueOf(reportTypeId));
            } else if (NODE_REPORT_PERIOD_TYPE.equals((Object)nodeType)) {
                String reportTypeId = (String)currNode.getParentRefEntityPkValue(NODE_YEAR_TYPE);
                filter = new QFilter("reportperiod.reporttype", "=", (Object)Long.valueOf(reportTypeId));
                if (EmptyUtil.isNoEmpty((Object)currNode.getRefEntityPkValue())) {
                    Date date = new Date(Long.parseLong(currNode.getRefEntityPkValue().toString()));
                    filter.and(new QFilter("reportperiod.startdate", ">=", (Object)DateUtils.getFirstYearDate((Date)date)));
                    filter.and(new QFilter("reportperiod.startdate", "<=", (Object)DateUtils.getLastYearDate((Date)date)));
                }
            } else if (NODE_REPORT_ORG_TYPE.equals((Object)nodeType)) {
                String reportTypeId = (String)currNode.getParentRefEntityPkValue(NODE_YEAR_TYPE);
                String reportPeriodId = (String)currNode.getRefEntityPkValue();
                filter = new QFilter("reportperiod.reporttype", "=", (Object)Long.valueOf(reportTypeId));
                filter.and(new QFilter("reportperiod.id", "=", (Object)Long.valueOf(reportPeriodId)));
            } else if (NODE_REPORT_TYPE.equals((Object)nodeType)) {
                String reportPeriodId = (String)currNode.getParentRefEntityPkValue(NODE_REPORT_ORG_TYPE);
                String reportOrgId = (String)currNode.getRefEntityPkValue();
                filter = new QFilter("reportperiod.id", "=", (Object)Long.valueOf(reportPeriodId));
                filter.and(new QFilter("reportorg.id", "=", (Object)Long.valueOf(reportOrgId)));
            } else if (NODE_REPORT_ORG_LEAF_TYPE.equals((Object)nodeType)) {
                String orgDimensionJson = this.getPageCache().get(CACHE_KEY_DIMENSION_ORG);
                Dimension dimension = (Dimension)FpmSerializeUtil.deserialize((String)orgDimensionJson, Dimension.class);
                String reportPeriodId = (String)currNode.getParentRefEntityPkValue(NODE_REPORT_ORG_TYPE);
                String reportOrgId = (String)currNode.getRefEntityPkValue();
                filter = new QFilter("reportperiod.id", "=", (Object)Long.valueOf(reportPeriodId));
                if (Objects.nonNull(dimension)) {
                    List childId = dimension.getDimMemberById(Long.valueOf(reportOrgId)).getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(childId)) {
                        childId.add(Long.valueOf(reportOrgId));
                        filter.and(new QFilter("reportorg.id", "in", childId));
                    } else {
                        filter.and(new QFilter("reportorg.id", "=", (Object)Long.valueOf(reportOrgId)));
                    }
                } else {
                    filter.and(new QFilter("reportorg.id", "=", (Object)Long.valueOf(reportOrgId)));
                }
            } else if (NODE_LEAF.equals((Object)nodeType)) {
                filter = new QFilter("id", "=", (Object)Long.valueOf((String)refId));
            }
        }
        logger.info(String.format("\u8fc7\u6ee4\u6761\u4ef6\uff0c%s", JSON.toJSONString((Object)filter)));
        return filter;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs event) {
        super.billListHyperLinkClick(event);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow selectRow = billList.getCurrentSelectedRowInfo();
        Long reportId = (Long)selectRow.getPrimaryKeyValue();
        FormShowParameter showParameter = new FormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        showParameter.setAppId(appId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("fpm_reportplan");
        showParameter.setCustomParam("report_id", (Object)reportId);
        showParameter.setCustomParam(CACHE_KEY_PAGETYPE, (Object)this.getPageCache().get(CACHE_KEY_PAGETYPE));
        Boolean fromLinkSearchChild = (Boolean)this.getView().getFormShowParameter().getCustomParam("param_from_link_search_child");
        if (Objects.nonNull(fromLinkSearchChild) && fromLinkSearchChild.booleanValue()) {
            DynamicObject childReportDy = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fpm_report", (String)String.join((CharSequence)COMMA, "id", "billno", "name"));
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("OperationStatus", OperationStatus.EDIT.name());
            LinkSearchSubFormHelper.showForm(this.getView(), childReportDy, "fpm_reportplan", customParams);
            event.setCancel(true);
            return;
        }
        showParameter.setCaption(selectRow.getBillNo());
        this.getView().showForm(showParameter);
        event.setCancel(true);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        List filters = e.getFilters();
        logger.info(String.format("\u8fc7\u6ee4\u6761\u4ef6\uff0c%s", JSON.toJSONString((Object)filters)));
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, Object> key) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> {
            Object mapKey = key.apply(t);
            if (null == mapKey) {
                return false;
            }
            return map.putIfAbsent(mapKey, Boolean.TRUE) == null;
        };
    }

    protected List<Long> getSelectedIdList() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        List<Long> idList = new ArrayList<Long>(selectedRows.size());
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReportTreeList_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        } else {
            for (ListSelectedRow listSelectedRowValue : selectedRows) {
                idList.add((Long)listSelectedRowValue.getPrimaryKeyValue());
            }
        }
        String property = System.getProperty("unit_test");
        if (EmptyUtil.isNoEmpty((String)property) && "tmc".equals(property) && this.getPageCache().getAll().containsKey("ids")) {
            idList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("ids"), List.class);
        }
        return idList;
    }

    public boolean isReportProgress() {
        String billFormId = ((IListView)this.getView()).getBillFormId();
        return Objects.nonNull(billFormId) && StringUtils.equals((CharSequence)"fpm_report_process", (CharSequence)billFormId);
    }

    protected IFundSystemController getOrCreateSystemController() {
        if (null == this.fundSystemController) {
            this.fundSystemController = new IFundSystemControllerImpl();
        }
        return this.fundSystemController;
    }
}

