/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.sumplan;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecordMore;
import kd.tmc.fpm.business.domain.model.sumplan.EvaluateAmtDetailParam;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.controller.IEvaluateAmtController;
import kd.tmc.fpm.business.mvc.controller.impl.EvaluateAmtControllerImpl;
import kd.tmc.fpm.business.mvc.service.dto.EvalDetailParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.WaitApprovedAmountAmtInfoResultDTO;
import kd.tmc.fpm.business.mvc.view.IEvaluateView;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.property.EvaluateAmtDetailProp;
import kd.tmc.fpm.common.utils.AmountUtil;

public class EvaluateAmtDetailPlugin
extends AbstractFormPlugin
implements IEvaluateView {
    private IEvaluateAmtController evaluateAmtController;
    private static final String ALERT_SUCCESS_MSG = "ALERT_SUCCESS_MSG";
    private static final String NEED_SAVE = "NEED_SAVE";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("main_entryentity");
        entryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                EntryGrid source = (EntryGrid)evt.getSource();
                int[] selectRows = source.getSelectRows();
                DynamicObjectCollection entryEntity = EvaluateAmtDetailPlugin.this.getModel().getEntryEntity("main_entryentity");
                ArrayList<EvalDetailParamDTO> paramDTOList = new ArrayList<EvalDetailParamDTO>(selectRows.length);
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRows[i]);
                    EvalDetailParamDTO paramDTO = new EvalDetailParamDTO();
                    paramDTO.setReportDataId(Long.valueOf(dynamicObject.getLong("main_reportdataid")));
                    paramDTO.setChildTemplateId(Long.valueOf(dynamicObject.getLong("childtemplateid")));
                    paramDTOList.add(paramDTO);
                }
                Long sumRecordId = (Long)EvaluateAmtDetailPlugin.this.getModel().getValue("sumreportid");
                Long sumReportDataId = (Long)EvaluateAmtDetailPlugin.this.getModel().getValue("sumapprovalid");
                String needSave = EvaluateAmtDetailPlugin.this.getPageCache().get(EvaluateAmtDetailPlugin.NEED_SAVE);
                if (EmptyUtil.isNoEmpty((String)needSave)) {
                    EvaluateAmtDetailPlugin.this.getPageCache().put(EvaluateAmtDetailPlugin.ALERT_SUCCESS_MSG, EvaluateAmtDetailPlugin.ALERT_SUCCESS_MSG);
                    EvaluateAmtDetailPlugin.this.getView().invokeOperation("save");
                }
                EvaluateAmtDetailPlugin.this.getOrCreate().loadWaitApprovedAmountDetailInfo(sumRecordId, sumReportDataId, paramDTOList);
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (EmptyUtil.isNoEmpty((Object)operationResult) && !operationResult.isSuccess()) {
            return;
        }
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                this.getOrCreate().save(this.getApprovedAmountRecord());
                break;
            }
            case "refresh": {
                this.initData(true);
                this.selectData();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "detail_evalamt": {
                this.upperSum(e);
            }
        }
    }

    public void initialize(ApprovedAmountRecordMore record) {
    }

    public void initializeSubEntry(List<WaitApprovedAmountAmtInfoResultDTO> waitApprovedAmountAmtInfoResultDTOList) {
        this.getModel().deleteEntryData("detail_entryentity");
        if (EmptyUtil.isEmpty(waitApprovedAmountAmtInfoResultDTOList)) {
            return;
        }
        HashMap<String, Boolean> visibleMap = new HashMap<String, Boolean>(8);
        int[] rows = this.getModel().batchCreateNewEntryRow("detail_entryentity", waitApprovedAmountAmtInfoResultDTOList.size());
        int index = 0;
        Map evaluateDetailMappingWithoutEntry = DimensionMappingHelper.getEvaluateDetailMappingWithoutEntry((Long)((Long)this.getModel().getValue("systemid")));
        for (WaitApprovedAmountAmtInfoResultDTO resultDTO : waitApprovedAmountAmtInfoResultDTOList) {
            ReportData reportData = resultDTO.getReportData();
            this.getModel().setValue("detail_dataid", (Object)reportData.getId(), rows[index]);
            this.getModel().setValue("detail_reportamt", (Object)this.getDefaultAmtUnitAmount(reportData.getReportPlanAmt(), reportData.getAmountUnit()), rows[index]);
            BigDecimal evaluateAmt = this.getDefaultAmtUnitAmount(resultDTO.getEvaluateAmt(), reportData.getAmountUnit());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"detail_evalamt", (Object)evaluateAmt, (int)rows[index]);
            this.getModel().setValue("detail_evaladjustreason", (Object)resultDTO.getEvalAdjustReason(), rows[index]);
            this.getModel().setValue("detail_planreportnumber", (Object)resultDTO.getReport().getNumber(), rows[index]);
            this.getModel().setValue("detail_planreportid", (Object)resultDTO.getReport().getId(), rows[index]);
            this.getModel().setValue("detail_amtunit", this.getModel().getValue("amtunit"), rows[index]);
            this.getModel().setValue("detail_originalevalamt", (Object)this.getDefaultAmtUnitAmount(resultDTO.getOriginalEvaluateAmt(), reportData.getAmountUnit()), rows[index]);
            this.getModel().setValue("detail_filluser", (Object)(EmptyUtil.isEmpty((Long)resultDTO.getFillUser()) ? Long.valueOf(RequestContext.get().getCurrUserId()) : resultDTO.getFillUser()), rows[index]);
            List dimList = reportData.getDimList();
            List dimValList = reportData.getDimValList();
            this.setEntryMemberField(rows[index], visibleMap, dimList, dimValList, evaluateDetailMappingWithoutEntry, resultDTO.getCustomDimSeqMap());
            ++index;
        }
        this.setVisible(visibleMap, evaluateDetailMappingWithoutEntry.values());
        this.getView().updateView("detail_entryentity");
    }

    public boolean isFromSearch() {
        return false;
    }

    public void showErrMessage(List<String> errMessageList) {
        this.getView().showMessage(errMessageList.stream().collect(Collectors.joining(";")));
    }

    public void showSuccessMessage(String successMessage) {
        this.getPageCache().remove(NEED_SAVE);
        if (EmptyUtil.isNoEmpty((String)this.getPageCache().get(ALERT_SUCCESS_MSG))) {
            this.getPageCache().remove(ALERT_SUCCESS_MSG);
            return;
        }
        this.getView().showSuccessNotification(successMessage);
    }

    private IEvaluateAmtController getOrCreate() {
        if (EmptyUtil.isEmpty((Object)this.evaluateAmtController)) {
            this.evaluateAmtController = new EvaluateAmtControllerImpl((IEvaluateView)this);
        }
        return this.evaluateAmtController;
    }

    private void setEntryMemberField(int index, Map<String, Boolean> visibleMap, List<TemplateDim> dimList, List<Object> dimValList, Map<String, String> fieldMap, Map<Long, Integer> customDimSeqMap) {
        for (int i = 0; i < dimList.size(); ++i) {
            String field;
            TemplateDim templateDim = dimList.get(i);
            Object val = this.format(dimValList.get(i));
            String number = templateDim.getDimType().getNumber();
            if (templateDim.getDimType() == DimensionType.DETAILDIM) {
                number = templateDim.getDetailDimType().getNumber();
            }
            if (templateDim.getDimType() == DimensionType.CUSTOM) {
                number = number + "_" + customDimSeqMap.get(templateDim.getDimensionId());
            }
            if (EmptyUtil.isEmpty((String)(field = fieldMap.get(number)))) {
                field = fieldMap.get(number.toUpperCase(Locale.ENGLISH));
            }
            if (EmptyUtil.isEmpty((String)field)) continue;
            visibleMap.putIfAbsent(field, Boolean.FALSE);
            if (EmptyUtil.isEmpty((Object)val) || !templateDim.isVisible() || templateDim.isViDim()) continue;
            if (templateDim.getDetailDimType() == DetailDimType.COUNTERPARTY_NAME) {
                TemplateDim tDim = dimList.stream().filter(td -> td.getDetailDimType() == DetailDimType.CONNTERPARTY_TYPE).findFirst().get();
                int idx = dimList.indexOf(tDim);
                Object obj = dimValList.get(idx);
                this.getModel().setValue("detail_opusertype", obj, index);
            }
            if (field.startsWith("detail_detailext")) {
                if (templateDim.getDetailDataType() == DetailDataType.BASEDATA) {
                    String baseDataType = templateDim.getBaseDataType();
                    BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)baseDataType);
                    String nameProperty = basedataEntityType.getNameProperty();
                    DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)val, (String)baseDataType, (String)nameProperty);
                    val = dynamicObject.getString(nameProperty);
                } else if (templateDim.getDetailDataType() == DetailDataType.AMOUNT) {
                    DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
                    val = decimalFormat.format(new BigDecimal(val == null ? "0" : val.toString()));
                }
                ((TextEdit)this.getControl(field)).setCaption(new LocaleString(templateDim.getDimensionName()));
            }
            if (templateDim.getDimType() == DimensionType.CUSTOM) {
                ((BasedataEdit)this.getControl(field)).setCaption(new LocaleString(templateDim.getDimensionName()));
            }
            this.getModel().setValue(field, val, index);
            Boolean visible = visibleMap.get(field);
            if (visible == null || visible.booleanValue()) continue;
            visibleMap.put(field, Boolean.TRUE);
        }
    }

    private Object format(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        if (Date.class.isInstance(obj)) {
            Date date = (Date)obj;
            return DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
        }
        return obj;
    }

    private ApprovedAmountRecord getApprovedAmountRecord() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        ApprovedAmountRecord record = new ApprovedAmountRecord();
        record.setSumPlanRecordId(Long.valueOf(dataEntity.getLong("sumreportid")));
        AmountUnit amountUnit = AmountUnit.getByNumber((String)dataEntity.getString("amtunit"));
        record.setAmountUnit(amountUnit);
        DynamicObjectCollection detailEntryEntity = dataEntity.getDynamicObjectCollection("detail_entryentity");
        DynamicObjectCollection mainEntryEntity = dataEntity.getDynamicObjectCollection("main_entryentity");
        ArrayList<ApprovedAmountAmtInfo> amountAmtInfoList = new ArrayList<ApprovedAmountAmtInfo>(1);
        ApprovedAmountAmtInfo amountAmtInfo = new ApprovedAmountAmtInfo();
        amountAmtInfo.setReportDataId(Long.valueOf(dataEntity.getLong("sumapprovalid")));
        amountAmtInfo.setReportDataIdStr(dataEntity.getString("sumreportdataids"));
        amountAmtInfo.setApprovedAmt(dataEntity.getBigDecimal("evalamt"));
        ArrayList<ApprovedAmountAmtDetailInfo> detailInfoList = new ArrayList<ApprovedAmountAmtDetailInfo>(detailEntryEntity.size());
        for (DynamicObject mainEntry : mainEntryEntity) {
            ApprovedAmountAmtDetailInfo mainInfo = new ApprovedAmountAmtDetailInfo();
            mainInfo.setApprovedAmt(mainEntry.getBigDecimal("main_evalamt"));
            mainInfo.setOriginalApprovedAmt(mainEntry.getBigDecimal("main_originalapprovalamt"));
            mainInfo.setReportDataId(Long.valueOf(mainEntry.getLong("main_reportdataid")));
            mainInfo.setReportId(Long.valueOf(mainEntry.getLong("main_planreportid")));
            mainInfo.setPlanReportNumber(mainEntry.getString("main_planreportnumber"));
            mainInfo.setFillUser(Long.valueOf(RequestContext.get().getCurrUserId()));
            mainInfo.setEvalDetail(Boolean.valueOf(false));
            AmountUnit mainInfoAmtUnit = AmountUnit.getByNumber((String)mainEntry.getString("main_amtunit"));
            mainInfo.setAmountUnit(mainInfoAmtUnit);
            detailInfoList.add(mainInfo);
        }
        for (DynamicObject detail : detailEntryEntity) {
            ApprovedAmountAmtDetailInfo detailInfo = new ApprovedAmountAmtDetailInfo();
            detailInfo.setEvalAdjustReason(detail.getString("detail_evaladjustreason"));
            detailInfo.setFillUser((Long)detail.getDynamicObject("detail_filluser").getPkValue());
            detailInfo.setApprovedAmt(detail.getBigDecimal("detail_evalamt"));
            detailInfo.setOriginalApprovedAmt(detail.getBigDecimal("detail_originalevalamt"));
            detailInfo.setReportDataId(Long.valueOf(detail.getLong("detail_dataid")));
            detailInfo.setPlanReportNumber(detail.getString("detail_planreportnumber"));
            detailInfo.setReportId(Long.valueOf(detail.getLong("detail_planreportid")));
            detailInfo.setEvalDetail(Boolean.valueOf(true));
            detailInfo.setApproved(true);
            AmountUnit detailInfoAmtUnit = AmountUnit.getByNumber((String)detail.getString("detail_amtunit"));
            detailInfo.setAmountUnit(detailInfoAmtUnit);
            detailInfoList.add(detailInfo);
        }
        amountAmtInfo.setAmtDetailInfoList(detailInfoList);
        amountAmtInfoList.add(amountAmtInfo);
        record.setAmountAmtInfoList(amountAmtInfoList);
        return record;
    }

    private void upperSum(PropertyChangedArgs e) {
        DynamicObjectCollection dynamicObjectCollection;
        DynamicObject evalEntry;
        Object[] changeSet = e.getChangeSet();
        if (EmptyUtil.isEmpty((Object[])changeSet)) {
            return;
        }
        Object changeData = changeSet[0];
        if (EmptyUtil.isEmpty((Object)changeData)) {
            return;
        }
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("detail_entryentity");
        int findIndex = this.findMainEntryRowForDetail(currentRowIndex, evalEntry = (DynamicObject)(dynamicObjectCollection = this.getModel().getEntryEntity("detail_entryentity")).get(currentRowIndex));
        if (findIndex == -1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u8f91\u7684\u660e\u7ec6\u586b\u62a5\u9879\u627e\u4e0d\u5230\u7ef4\u5ea6\u7ec4\u5408\u5bf9\u5e94\u7684\u4e3b\u8868\u6570\u636e\u3002", (String)"EvaluateAmtDetailPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection mainEntryEntity = this.getModel().getEntryEntity("main_entryentity");
        DynamicObject findOutDy = (DynamicObject)mainEntryEntity.get(findIndex);
        BigDecimal currentMainEvalAmt = findOutDy.getBigDecimal("main_evalamt");
        DynamicObject sourceCurrency = evalEntry.getDynamicObject("detail_currency");
        Long sourceCurrencyId = sourceCurrency.getLong("sourceid");
        String evalAmtUnit = evalEntry.getString("detail_amtunit");
        DynamicObject targetCurrency = (DynamicObject)this.getModel().getValue("currency");
        Long targetCurrencyId = targetCurrency.getLong("sourceid");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject rateTable = dataEntity.getDynamicObject("ratetable");
        Long rateTableId = (Long)rateTable.getPkValue();
        Date rateDate = dataEntity.getDate("ratedate");
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)rateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)rateDate);
        if (Objects.equals(sourceCurrencyId, targetCurrencyId)) {
            exchangeRate = BigDecimal.ONE;
        }
        if (exchangeRate == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u201c%1$s\u201d\u6ca1\u6709\u7ef4\u62a4\u6e90\u5e01\u79cd\u201c%2$s\u201d\u5230\u76ee\u6807\u5e01\u79cd\u201c%3$s\u201d\u7684\u6c47\u7387\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"EvaluateAmtDetailPlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), rateTable.getString("name"), sourceCurrency.getString("name"), targetCurrency.getString("name")));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"detail_evalamt", (Object)oldValue, (int)currentRowIndex);
            return;
        }
        this.getModel().setValue("main_evalamt", (Object)currentMainEvalAmt.subtract(oldValue).add(newValue), findIndex);
        BigDecimal evalAmt = (BigDecimal)this.getModel().getValue("evalamt");
        evalAmt = evalAmt == null ? BigDecimal.ZERO : evalAmt;
        this.getModel().setValue("evalamt", (Object)evalAmt.subtract(this.getRateChangedEvalAmount(oldValue, exchangeRate, evalAmtUnit)).add(this.getRateChangedEvalAmount(newValue, exchangeRate, evalAmtUnit)));
        this.getPageCache().put(NEED_SAVE, NEED_SAVE);
    }

    private int findMainEntryRowForDetail(int detailIndex, DynamicObject evalEntry) {
        DynamicObjectCollection mainEntryEntity = this.getModel().getEntryEntity("main_entryentity");
        if (EmptyUtil.isEmpty((DynamicObject)evalEntry)) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("detail_entryentity");
            evalEntry = (DynamicObject)dynamicObjectCollection.get(detailIndex);
        }
        int findIndex = -1;
        for (int i = 0; i < mainEntryEntity.size(); ++i) {
            DynamicObject dy = (DynamicObject)mainEntryEntity.get(i);
            boolean findOut = true;
            for (Map.Entry mainDimField : EvaluateAmtDetailProp.MAIN_DETAIL_ENTRY_OPTIONAL_DIM_FIELD_MAP.entrySet()) {
                String mainField = (String)mainDimField.getKey();
                String detailField = (String)mainDimField.getValue();
                DynamicObject mainDy = dy.getDynamicObject(mainField);
                DynamicObject detailDy = evalEntry.getDynamicObject(detailField);
                if (EmptyUtil.isEmpty((DynamicObject)mainDy)) continue;
                if (EmptyUtil.isNoEmpty((DynamicObject)mainDy) && EmptyUtil.isEmpty((DynamicObject)detailDy)) {
                    findOut = false;
                    break;
                }
                if (Objects.equals(mainDy.getPkValue(), detailDy.getPkValue())) continue;
                findOut = false;
                break;
            }
            if (!findOut) continue;
            findIndex = i;
            break;
        }
        return findIndex;
    }

    private void setVisible(Map<String, Boolean> visibleMap, Collection<String> fields) {
        for (String filed : fields) {
            if (Objects.equals(Boolean.TRUE, visibleMap.get(filed))) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{filed});
        }
    }

    private void setEntryValue(String prop, Object value, int index, Map<String, Boolean> visibleMap) {
        this.getModel().setValue(prop, value, index);
        visibleMap.putIfAbsent(prop, Boolean.FALSE);
        if (EmptyUtil.isNoEmpty((Object)value)) {
            visibleMap.put(prop, Boolean.TRUE);
        }
    }

    private BigDecimal getRateChangedEvalAmount(BigDecimal sourceAmt, BigDecimal exchangeRate, String sourceAmtUnit) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String targetAmtUnit = dataEntity.getString("amtunit");
        BigDecimal realSourceAmt = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceAmtUnit), (AmountUnitEnum)AmountUnitEnum.ONE, (BigDecimal)sourceAmt);
        BigDecimal rateChangedAmt = realSourceAmt.multiply(exchangeRate);
        return AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)AmountUnitEnum.get((String)targetAmtUnit), (BigDecimal)rateChangedAmt);
    }

    private void initData(boolean isFresh) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String jsonStr = (String)formShowParameter.getCustomParam(EvaluateAmtDetailParam.class.getName());
        if (Objects.isNull(jsonStr)) {
            return;
        }
        EvaluateAmtDetailParam evaluateAmtDetailParam = (EvaluateAmtDetailParam)SerializationUtils.fromJsonString((String)jsonStr, EvaluateAmtDetailParam.class);
        List detailInfoList = evaluateAmtDetailParam.getDetailInfoList();
        if (!isFresh) {
            this.getModel().setValue("sumreportid", (Object)evaluateAmtDetailParam.getSumRecordId());
            this.getModel().setValue("sumapprovalid", (Object)evaluateAmtDetailParam.getSumReportDataStoreId());
            this.getModel().setValue("sumreportdataids", (Object)evaluateAmtDetailParam.getSumReportDataIdStr());
            this.getModel().setValue("systemid", (Object)evaluateAmtDetailParam.getSystemId());
            this.getModel().setValue("currency", (Object)evaluateAmtDetailParam.getCurrencyId());
            this.getModel().setValue("ratetable", (Object)evaluateAmtDetailParam.getRateTableId());
            this.getModel().setValue("ratedate", (Object)evaluateAmtDetailParam.getRateDate());
            this.getModel().setValue("amtunit", (Object)evaluateAmtDetailParam.getSumAmtUnit());
            this.getModel().setValue("evalamt", (Object)evaluateAmtDetailParam.getEvalAmt());
        } else {
            this.updateInfo(detailInfoList);
        }
        this.getModel().deleteEntryData("main_entryentity");
        if (EmptyUtil.isEmpty((Collection)detailInfoList)) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow("main_entryentity", detailInfoList.size());
        int index = 0;
        HashMap<String, Boolean> visibleMap = new HashMap<String, Boolean>(16);
        for (EvaluateAmtDetailParam.DetailInfo detailInfo : detailInfoList) {
            this.getModel().setValue("main_reportdataid", (Object)detailInfo.getMainReportDataId(), rows[index]);
            this.setEntryValue("main_reportorg", detailInfo.getOrgMemberId(), rows[index], visibleMap);
            this.setEntryValue("main_subject", detailInfo.getSubjectId(), rows[index], visibleMap);
            this.setEntryValue("main_currency", detailInfo.getCurrencyId(), rows[index], visibleMap);
            this.setEntryValue("main_period", evaluateAmtDetailParam.getPeriodId(), rows[index], visibleMap);
            this.setEntryValue("main_company", detailInfo.getCompanyId(), rows[index], visibleMap);
            this.setEntryValue("main_settletype", detailInfo.getSettleTypeId(), rows[index], visibleMap);
            this.setEntryValue("main_extmem1id", detailInfo.getExtMem1Id(), rows[index], visibleMap);
            this.setEntryValue("main_extmem2id", detailInfo.getExtMem2Id(), rows[index], visibleMap);
            this.setEntryValue("main_extmem3id", detailInfo.getExtMem3Id(), rows[index], visibleMap);
            this.getModel().setValue("main_reportamt", (Object)detailInfo.getReportAmt(), rows[index]);
            this.getModel().setValue("main_evalamt", (Object)detailInfo.getEvalAmt(), rows[index]);
            this.getModel().setValue("main_originalapprovalamt", (Object)detailInfo.getOriginalEvalAmt(), rows[index]);
            this.getModel().setValue("childtemplateid", (Object)detailInfo.getChildTemplateId(), rows[index]);
            this.getModel().setValue("main_planreportid", (Object)detailInfo.getPlanReportId(), rows[index]);
            this.getModel().setValue("main_planreportnumber", (Object)detailInfo.getPlanReportNumber(), rows[index]);
            this.getModel().setValue("main_amtunit", (Object)evaluateAmtDetailParam.getSumAmtUnit());
            ++index;
        }
        this.setVisible(visibleMap, EvaluateAmtDetailProp.MAIN_ENTRY_DIM_TYPE_FIELD_MAP.values());
        this.setCustomDimFieldName4MainEntryEntity(visibleMap, rows);
    }

    private void updateInfo(List<EvaluateAmtDetailParam.DetailInfo> detailInfoList) {
        Map detailInfoMap = detailInfoList.stream().collect(Collectors.toMap(EvaluateAmtDetailParam.DetailInfo::getMainReportDataId, Function.identity()));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("main_entryentity");
        for (DynamicObject entry : entryEntity) {
            Long mainReportDataId = entry.getLong("main_reportdataid");
            EvaluateAmtDetailParam.DetailInfo detailInfo = (EvaluateAmtDetailParam.DetailInfo)detailInfoMap.get(mainReportDataId);
            if (!EmptyUtil.isNoEmpty((Object)detailInfo)) continue;
            detailInfo.setOriginalEvalAmt(entry.getBigDecimal("main_originalapprovalamt"));
            detailInfo.setEvalAmt(entry.getBigDecimal("main_evalamt"));
        }
    }

    private void selectData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("main_entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        int[] rows = new int[entryEntity.size()];
        for (int i = 0; i < entryEntity.size(); ++i) {
            rows[i] = i;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("main_entryentity");
        entryGrid.selectRows(rows, 0);
        entryGrid.entryRowClick(Integer.valueOf(0));
    }

    private void setCustomDimFieldName4MainEntryEntity(Map<String, Boolean> visibleMap, int[] rows) {
        List<String> customDimPropList = Arrays.asList("main_extmem1id", "main_extmem2id", "main_extmem3id");
        block0: for (String field : customDimPropList) {
            if (!Objects.equals(Boolean.TRUE, visibleMap.get(field))) continue;
            for (int idx : rows) {
                DynamicObject customMemberDy = (DynamicObject)this.getModel().getValue(field, idx);
                if (!EmptyUtil.isNoEmpty((DynamicObject)customMemberDy)) continue;
                String dimensionName = customMemberDy.getString("dimension.name");
                ((BasedataEdit)this.getControl(field)).setCaption(new LocaleString(dimensionName));
                continue block0;
            }
        }
    }

    private BigDecimal getDefaultAmtUnitAmount(BigDecimal sourceAmt, AmountUnit sourceAmtUnit) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String targetAmtUnit = dataEntity.getString("amtunit");
        AmountUnitEnum sourceAmtUnitEnum = AmountUnit.convert((AmountUnit)sourceAmtUnit);
        return AmountUtil.convert((AmountUnitEnum)sourceAmtUnitEnum, (AmountUnitEnum)AmountUnitEnum.get((String)targetAmtUnit), (BigDecimal)sourceAmt);
    }
}

