/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.suppplement;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.mvc.controller.IFundSystemController;
import kd.tmc.fpm.business.mvc.controller.impl.IFundSystemControllerImpl;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.property.SupplementBillProp;

public class SupplementBillImport
extends BatchImportPlugin {
    private IFundSystemController fundSystemController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        FundPlanSystem fundPlanSystem = this.getFundSystem(billdatas.get(0));
        Map<String, Dimension> dimensionMap = fundPlanSystem.getDimList().stream().filter(dimension -> !dimension.getDimType().isCustomDim()).collect(Collectors.toMap(Dimension::getNumber, Function.identity()));
        Map<String, Dimension> propCustomDimensionMap = this.getCustomDimensionMap(fundPlanSystem);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            String message = null;
            ImportBillData rowData = iterator.next();
            JSONObject data = rowData.getData();
            try {
                this.setMemberValue((Map<String, Object>)data, dimensionMap, propCustomDimensionMap);
            }
            catch (Exception exc) {
                message = exc.getMessage();
            }
            finally {
                if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
                logger.log(Integer.valueOf(rowData.getStartIndex()), message).fail();
                iterator.remove();
            }
        }
    }

    private Map<String, Dimension> getCustomDimensionMap(FundPlanSystem fundPlanSystem) {
        ICustomDimSeqService iCustomDimSeqService = (ICustomDimSeqService)FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        Map customDimSeqMap = iCustomDimSeqService.loadCustomDimSeqMap(fundPlanSystem.getId());
        List customDimensionList = fundPlanSystem.getDimList().stream().filter(dimension -> dimension.getDimType().isCustomDim()).collect(Collectors.toList());
        HashMap<String, Dimension> propCustomDimensionMap = new HashMap<String, Dimension>(3);
        for (Dimension dimension2 : customDimensionList) {
            Integer storeSeq = (Integer)customDimSeqMap.get(dimension2.getId());
            String prop = (String)CustomDimSeqServiceImpl.SUPPLEMENT_BILL_CUSTOM_PROP_MAP.get(storeSeq);
            propCustomDimensionMap.put(prop, dimension2);
        }
        return propCustomDimensionMap;
    }

    private FundPlanSystem getFundSystem(ImportBillData importBillData) {
        QFilter qFilter;
        Object filterValue;
        JSONObject jsonObject = importBillData.getData();
        Map system = (Map)jsonObject.get((Object)"system");
        if (system == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u5fc5\u8981\u5b57\u6bb5\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4f53\u7cfb", (String)"SupplementBillImport_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
        }
        Object importprop = system.get("importprop");
        if ("name".equals(importprop)) {
            filterValue = system.get("name");
            qFilter = new QFilter("name", "=", filterValue);
        } else {
            filterValue = system.get("number");
            qFilter = new QFilter("number", "=", filterValue);
        }
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_bodysysmanage", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        if (ids.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u6216\u540d\u79f0\u4e3a%s\u7684\u4f53\u7cfb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SupplementBillImport_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), filterValue));
        }
        return this.getOrCreateSystemController().loadSystem((Long)ids.get(0));
    }

    private void setMemberValue(Map<String, Object> importData, Map<String, Dimension> dimensionMap, Map<String, Dimension> propCustomDimensionMap) {
        Map orgMap = (Map)importData.get("reportorg");
        this.replaceNumberById(orgMap, dimensionMap.get(DimsionEnums.ORG.getNumber()));
        JSONArray jsonArray = (JSONArray)importData.get("entryentity");
        for (Object entryMember : jsonArray) {
            Map entryMap = (Map)entryMember;
            for (Map.Entry entry : SupplementBillProp.ENTRY_IMPORT_PROP_DIM_TYPE_MAP.entrySet()) {
                String prop = (String)entry.getKey();
                if (!entryMap.containsKey(prop)) continue;
                String dimensionNumber = (String)entry.getValue();
                Dimension dimension = dimensionMap.get(dimensionNumber);
                Map objectMap = (Map)entryMap.get(prop);
                this.replaceNumberById(objectMap, dimension);
            }
            for (String customProp : SupplementBillProp.CUSTOMER_LIST) {
                if (!entryMap.containsKey(customProp)) continue;
                Dimension dimension = propCustomDimensionMap.get(customProp);
                Map objectMap = (Map)entryMap.get(customProp);
                this.replaceNumberById(objectMap, dimension);
            }
        }
    }

    private void replaceNumberById(Map<String, Object> importData, Dimension dimension) {
        String filterValue;
        String importProp = (String)importData.get("importprop");
        if ("id".equals(importProp)) {
            return;
        }
        importData.put("importprop", "id");
        if ("name".equals(importProp)) {
            filterValue = (String)importData.get("name");
            Optional<DimMember> findByName = dimension.getAllDimMemberList().stream().filter(dimMember -> dimMember.getName().equals(filterValue)).findFirst();
            if (findByName.isPresent()) {
                DimMember dimMember2 = findByName.get();
                importData.put("id", dimMember2.getId());
                return;
            }
        } else {
            filterValue = (String)importData.get("number");
            Optional<DimMember> findByNumber = dimension.getAllDimMemberList().stream().filter(dimMember -> dimMember.getNumber().equals(filterValue)).findFirst();
            if (findByNumber.isPresent()) {
                DimMember dimMember3 = findByNumber.get();
                importData.put("id", dimMember3.getId());
                return;
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bf9\u5e94\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u7f16\u7801\u6216\u540d\u79f0\u4e3a%1$s\u7684%2$s\u6210\u5458\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"SupplementBillImport_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), filterValue, dimension.getName()));
    }

    private IFundSystemController getOrCreateSystemController() {
        if (null == this.fundSystemController) {
            this.fundSystemController = new IFundSystemControllerImpl();
        }
        return this.fundSystemController;
    }
}

